/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntitySandShot;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class EntityGuster
extends Monster {
    private static final EntityDataAccessor<Integer> LIFT_ENTITY = SynchedEntityData.defineId(EntityGuster.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntityGuster.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private LivingEntity liftedEntity;
    private int liftingTime = 0;
    private int maxLiftTime = 40;
    private int shootingTicks;
    public static final ResourceLocation RED_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/guster_red");
    public static final ResourceLocation SOUL_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/guster_soul");

    protected EntityGuster(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.GUSTER_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.GUSTER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.GUSTER_HURT.get();
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    public static boolean canGusterSpawn(EntityType animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean spawnBlock = worldIn.getBlockState(pos.below()).is(BlockTags.SAND);
        return spawnBlock && (!AMConfig.limitGusterSpawnsToWeather || worldIn.getLevelData() != null && (worldIn.getLevelData().isThundering() || worldIn.getLevelData().isRaining()) || EntityGuster.isBiomeNether(worldIn, pos));
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.gusterSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeGoal());
        this.goalSelector.addGoal(1, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 60, 1.0, 10, 7));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new GroundPathNavigatorWide((Mob)this, worldIn);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    public void doPush(Entity entityIn) {
        if (this.getLiftedEntity() == null && this.liftingTime >= 0 && !(entityIn instanceof EntityGuster)) {
            this.setLiftedEntity(entityIn.getId());
            this.maxLiftTime = 30 + this.random.nextInt(30);
        }
    }

    public boolean hasLiftedEntity() {
        return (Integer)this.entityData.get(LIFT_ENTITY) != 0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LIFT_ENTITY, (Object)0);
        builder.define(VARIANT, (Object)0);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_PROJECTILE)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.hurt(source, amount);
    }

    private void spit(LivingEntity target) {
        EntitySandShot sghot = new EntitySandShot(this.level(), this);
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.3333333333333333) - sghot.getY();
        double d2 = target.getZ() - this.getZ();
        float f = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2))) * 0.35f;
        sghot.shoot(d0, d1 + (double)f, d2, 1.0f, 10.0f);
        sghot.setVariant(this.getVariant());
        if (!this.isSilent()) {
            this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SAND_BREAK, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.level().addFreshEntity((Entity)sghot);
    }

    public double getEyeY() {
        return this.getY() + 1.0;
    }

    @Nullable
    public Entity getLiftedEntity() {
        if (!this.hasLiftedEntity()) {
            return null;
        }
        return this.level().getEntity(((Integer)this.entityData.get(LIFT_ENTITY)).intValue());
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (EntityGuster.isBiomeNether((LevelAccessor)worldIn, this.blockPosition())) {
            this.setVariant(2);
        } else if (EntityGuster.isBiomeRed((LevelAccessor)worldIn, this.blockPosition())) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        this.setAirSupply(this.getMaxAirSupply());
        this.setXRot(0.0f);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    private void setLiftedEntity(int p_175463_1_) {
        this.entityData.set(LIFT_ENTITY, (Object)p_175463_1_);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public void aiStep() {
        super.aiStep();
        Entity lifted = this.getLiftedEntity();
        if (lifted == null && !this.level().isClientSide && this.tickCount % 15 == 0) {
            List list = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate((double)0.8f));
            ItemEntity closestItem = null;
            for (int i = 0; i < list.size(); ++i) {
                ItemEntity entity = (ItemEntity)list.get(i);
                if (!entity.onGround() || closestItem != null && !(this.distanceTo((Entity)closestItem) > this.distanceTo((Entity)entity))) continue;
                closestItem = entity;
            }
            if (closestItem != null) {
                this.setLiftedEntity(closestItem.getId());
                this.maxLiftTime = 30 + this.random.nextInt(30);
            }
        }
        float f = (float)this.getY();
        if (this.isAlive()) {
            ParticleOptions type = this.getVariant() == 2 ? (ParticleOptions)AMParticleRegistry.GUSTER_SAND_SPIN_SOUL.get() : (this.getVariant() == 1 ? (ParticleOptions)AMParticleRegistry.GUSTER_SAND_SPIN_RED.get() : (ParticleOptions)AMParticleRegistry.GUSTER_SAND_SPIN.get());
            for (int j = 0; j < 4; ++j) {
                float f1 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.95f;
                float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.95f;
                this.level().addParticle(type, this.getX() + (double)f1, (double)f, this.getZ() + (double)f2, this.getX(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()) + (double)0.2f, this.getZ());
            }
        }
        if (lifted != null && this.liftingTime >= 0) {
            ++this.liftingTime;
            float resist = 1.0f;
            if (lifted instanceof LivingEntity) {
                resist = (float)Mth.clamp((double)(1.0 - ((LivingEntity)lifted).getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)), (double)0.0, (double)1.0);
            }
            float radius = 1.0f + (float)this.liftingTime * 0.05f;
            if (lifted instanceof ItemEntity) {
                radius = 0.2f + (float)this.liftingTime * 0.025f;
            }
            float angle = (float)this.liftingTime * -0.25f;
            double extraX = this.getX() + (double)(radius * Mth.sin((float)((float)Math.PI + angle)));
            double extraZ = this.getZ() + (double)(radius * Mth.cos((float)angle));
            double d0 = (extraX - lifted.getX()) * (double)resist;
            double d1 = (extraZ - lifted.getZ()) * (double)resist;
            lifted.setDeltaMovement(d0, 0.1 * (double)resist, d1);
            lifted.hasImpulse = true;
            if (this.liftingTime > this.maxLiftTime) {
                this.setLiftedEntity(0);
                this.liftingTime = -20;
                this.maxLiftTime = 30 + this.random.nextInt(30);
            }
        } else if (this.liftingTime < 0) {
            ++this.liftingTime;
        } else if (this.getTarget() != null && this.distanceTo((Entity)this.getTarget()) < this.getBbWidth() + 1.0f && !(this.getTarget() instanceof EntityGuster)) {
            this.setLiftedEntity(this.getTarget().getId());
            this.maxLiftTime = 30 + this.random.nextInt(30);
        }
        if (!this.level().isClientSide && this.shootingTicks >= 0) {
            if (this.shootingTicks <= 0) {
                if (this.getTarget() != null && (lifted == null || lifted.getId() != this.getTarget().getId()) && this.isAlive()) {
                    this.spit(this.getTarget());
                }
                this.shootingTicks = 40 + this.random.nextInt(40);
            } else {
                --this.shootingTicks;
            }
        }
        Vec3 vector3d = this.getDeltaMovement();
        if (!this.onGround() && vector3d.y < 0.0) {
            this.setDeltaMovement(vector3d.multiply(1.0, 0.6, 1.0));
        }
    }

    public boolean isGooglyEyes() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && s.toLowerCase().contains("tweester");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(compound.getInt("Variant"));
    }

    private static boolean isBiomeRed(LevelAccessor worldIn, BlockPos position) {
        return worldIn.getBiome(position).is(AMTagRegistry.SPAWNS_RED_GUSTERS);
    }

    private static boolean isBiomeNether(LevelAccessor worldIn, BlockPos position) {
        return worldIn.getBiome(position).is(AMTagRegistry.SPAWNS_SOUL_GUSTERS);
    }

    public static int getColorForVariant(int variant) {
        if (variant == 2) {
            return 5127475;
        }
        if (variant == 1) {
            return 13000999;
        }
        return 15975305;
    }

    private class MeleeGoal
    extends Goal {
        public boolean canUse() {
            return EntityGuster.this.getTarget() != null;
        }

        public void tick() {
            Entity thrownEntity = EntityGuster.this.getLiftedEntity();
            if (EntityGuster.this.getTarget() != null) {
                if (thrownEntity != null && thrownEntity.getId() == EntityGuster.this.getTarget().getId()) {
                    EntityGuster.this.getNavigation().stop();
                } else {
                    EntityGuster.this.getNavigation().moveTo((Entity)EntityGuster.this.getTarget(), 1.25);
                }
            }
        }
    }
}

