/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityGust
extends Entity {
    protected static final EntityDataAccessor<Boolean> VERTICAL = SynchedEntityData.defineId(EntityGust.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Float> X_DIR = SynchedEntityData.defineId(EntityGust.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> Y_DIR = SynchedEntityData.defineId(EntityGust.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> Z_DIR = SynchedEntityData.defineId(EntityGust.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private Entity pushedEntity = null;

    public EntityGust(EntityType p_i50162_1_, Level p_i50162_2_) {
        super(p_i50162_1_, p_i50162_2_);
    }

    public EntityGust(Level worldIn) {
        this((EntityType)AMEntityRegistry.GUST.get(), worldIn);
    }

    public void push(Entity entityIn) {
    }

    protected static float lerpRotation(float p_234614_0_, float p_234614_1_) {
        while (p_234614_1_ - p_234614_0_ < -180.0f) {
            p_234614_0_ -= 360.0f;
        }
        while (p_234614_1_ - p_234614_0_ >= 180.0f) {
            p_234614_0_ += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)p_234614_0_, (float)p_234614_1_);
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 300) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        for (int i = 0; i < 1 + this.random.nextInt(1); ++i) {
            this.level().addParticle((ParticleOptions)AMParticleRegistry.GUSTER_SAND_SPIN.get(), this.getX() + (double)(0.5f * (this.random.nextFloat() - 0.5f)), this.getY() + (double)(0.5f * (this.random.nextFloat() - 0.5f)), this.getZ() + (double)(0.5f * (this.random.nextFloat() - 0.5f)), this.getX(), this.getY() + 0.5, this.getZ());
        }
        Vec3 vector3d = new Vec3((double)((Float)this.entityData.get(X_DIR)).floatValue(), (double)((Float)this.entityData.get(Y_DIR)).floatValue(), (double)((Float)this.entityData.get(Z_DIR)).floatValue());
        HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS && this.tickCount > 4) {
            this.onImpact(raytraceresult);
        }
        List list = this.level().getEntitiesOfClass(Entity.class, this.getBoundingBox().inflate(0.1));
        if (this.pushedEntity != null && this.distanceTo(this.pushedEntity) > 2.0f) {
            this.pushedEntity = null;
        }
        double d0 = this.getX() + vector3d.x;
        double d1 = this.getY() + vector3d.y;
        double d2 = this.getZ() + vector3d.z;
        if (this.getY() > (double)this.level().getMaxBuildHeight()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.updateRotation();
        if (this.isInWaterOrBubble()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            this.setDeltaMovement(vector3d);
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.06f, 0.0));
            this.setPos(d0, d1, d2);
            if (this.pushedEntity != null) {
                this.pushedEntity.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.063, 0.0));
            }
            for (Entity e : list) {
                e.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.068, 0.0));
                if (e.getDeltaMovement().y < 0.0) {
                    e.setDeltaMovement(e.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                }
                e.fallDistance = 0.0f;
            }
        }
    }

    public void setGustDir(float x, float y, float z) {
        this.entityData.set(X_DIR, (Object)Float.valueOf(x));
        this.entityData.set(Y_DIR, (Object)Float.valueOf(y));
        this.entityData.set(Z_DIR, (Object)Float.valueOf(z));
    }

    public float getGustDir(int xyz) {
        return ((Float)this.entityData.get(xyz == 2 ? Z_DIR : (xyz == 1 ? Y_DIR : X_DIR))).floatValue();
    }

    protected void onEntityHit(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof EntityGust) {
            EntityGust other = (EntityGust)entity;
            double avgX = (other.getX() + this.getX()) / 2.0;
            double avgY = (other.getY() + this.getY()) / 2.0;
            double avgZ = (other.getZ() + this.getZ()) / 2.0;
            other.setPos(avgX, avgY, avgZ);
            other.setGustDir(other.getGustDir(0) + this.getGustDir(0), other.getGustDir(1) + this.getGustDir(1), other.getGustDir(2) + this.getGustDir(2));
            if (this.isAlive() && other.isAlive()) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else if (entity != null) {
            this.pushedEntity = entity;
        }
    }

    protected boolean canHitEntity(Entity p_230298_1_) {
        return !p_230298_1_.isSpectator();
    }

    protected void onHitBlock(BlockHitResult p_230299_1_) {
        if (p_230299_1_.getBlockPos() != null) {
            BlockPos pos = p_230299_1_.getBlockPos();
            if (this.level().isWaterAt(pos) && !this.level().isClientSide) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(VERTICAL, (Object)false);
        builder.define(X_DIR, (Object)Float.valueOf(0.0f));
        builder.define(Y_DIR, (Object)Float.valueOf(0.0f));
        builder.define(Z_DIR, (Object)Float.valueOf(0.0f));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean("VerticalTornado", this.getVertical());
        compound.putFloat("GustDirX", ((Float)this.entityData.get(X_DIR)).floatValue());
        compound.putFloat("GustDirY", ((Float)this.entityData.get(Y_DIR)).floatValue());
        compound.putFloat("GustDirZ", ((Float)this.entityData.get(Z_DIR)).floatValue());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(X_DIR, (Object)Float.valueOf(compound.getFloat("GustDirX")));
        this.entityData.set(Y_DIR, (Object)Float.valueOf(compound.getFloat("GustDirX")));
        this.entityData.set(Z_DIR, (Object)Float.valueOf(compound.getFloat("GustDirX")));
        this.setVertical(compound.getBoolean("VerticalTornado"));
    }

    public void setVertical(boolean vertical) {
        this.entityData.set(VERTICAL, (Object)vertical);
    }

    public boolean getVertical() {
        return (Boolean)this.entityData.get(VERTICAL);
    }

    protected void onImpact(HitResult result) {
        HitResult.Type raytraceresult$type = result.getType();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onEntityHit((EntityHitResult)result);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)result);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = Mth.sqrt((float)((float)(x * x + z * z)));
            this.setXRot((float)(Mth.atan2((double)y, (double)f) * 57.2957763671875));
            this.setYRot((float)(Mth.atan2((double)x, (double)z) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    protected void updateRotation() {
        Vec3 vector3d = this.getDeltaMovement();
        float f = Mth.sqrt((float)((float)(vector3d.x * vector3d.x + vector3d.z * vector3d.z)));
        this.setXRot(EntityGust.lerpRotation(this.xRotO, (float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875)));
        this.setYRot(EntityGust.lerpRotation(this.yRotO, (float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875)));
    }
}

