/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GrizzlyBearAIAprilFools;
import com.github.alexthe666.alexsmobs.entity.ai.GrizzlyBearAIBeehive;
import com.github.alexthe666.alexsmobs.entity.ai.GrizzlyBearAIFleeBees;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIFollowOwner;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAITempt;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityGrizzlyBear
extends TamableAnimal
implements NeutralMob,
IAnimatedEntity,
ITargetsDroppedItems,
IFollower {
    public static final Animation ANIMATION_MAUL = Animation.create((int)20);
    public static final Animation ANIMATION_SNIFF = Animation.create((int)12);
    public static final Animation ANIMATION_SWIPE_R = Animation.create((int)15);
    public static final Animation ANIMATION_SWIPE_L = Animation.create((int)20);
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.defineId(EntityGrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityGrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HONEYED = SynchedEntityData.defineId(EntityGrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.defineId(EntityGrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SNOWY = SynchedEntityData.defineId(EntityGrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> APRIL_FOOLS_MODE = SynchedEntityData.defineId(EntityGrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityGrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt angerLogic = TimeUtil.rangeOfSeconds((int)20, (int)39);
    public float prevStandProgress;
    public float prevSitProgress;
    public float standProgress;
    public float sitProgress;
    public int maxStandTime = 75;
    public boolean forcedSit = false;
    private int animationTick;
    private Animation currentAnimation;
    private int standingTime = 0;
    private int sittingTime = 0;
    private int maxSitTime = 75;
    private int eatingTime = 0;
    private int angerTime;
    private UUID angerTarget;
    private int honeyedTime;
    @Nullable
    private UUID salmonThrowerID = null;
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.of(AMTagRegistry.GORILLA_FOODSTUFFS);
    public int timeUntilNextFur = this.random.nextInt(24000) + 24000;
    protected static final EntityDimensions STANDING_SIZE = EntityDimensions.scalable((float)1.7f, (float)2.75f);
    private boolean recalcSize = false;
    private int snowTimer = 0;
    private boolean permSnow = false;

    protected EntityGrizzlyBear(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 55.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.6f).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.grizzlyBearSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && this.isTame() && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.hurt(source, amount);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.GRIZZLY_BEAR_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.GRIZZLY_BEAR_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.GRIZZLY_BEAR_DIE.get();
    }

    protected void dropFromLootTable(DamageSource damageSource, boolean hitByPlayer) {
        System.out.println("[GRIZZLY DEBUG] dropFromLootTable called! hitByPlayer=" + hitByPlayer);
        System.out.println("[GRIZZLY DEBUG] Loot table: " + String.valueOf(this.getLootTable()));
        super.dropFromLootTable(damageSource, hitByPlayer);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        if (this.hasPassenger(passenger)) {
            float sitAdd = -0.065f * this.sitProgress;
            float standAdd = -0.07f * this.standProgress;
            float radius = standAdd + sitAdd;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            passenger.setPos(this.getX() + extraX, this.getY() + (double)this.getBbHeight() * 0.75 + 0.0, this.getZ() + extraZ);
        }
    }

    public double getPassengersRidingOffset() {
        float f = Math.min(0.25f, this.walkAnimation.speed());
        float f1 = this.walkAnimation.position();
        float sitAdd = 0.01f * this.sitProgress;
        float standAdd = 0.07f * this.standProgress;
        return (double)this.getBbHeight() - 0.3 + (double)(0.12f * Mth.cos((float)(f1 * 0.7f)) * 0.7f * f) + (double)sitAdd + (double)standAdd;
    }

    public void playAmbientSound() {
        if (!this.isFreddy()) {
            super.playAmbientSound();
        }
    }

    protected float getWaterSlowDown() {
        return this.isVehicle() ? 0.9f : 0.98f;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(angerLogic.sample(this.random));
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.getMsgId() != null && source.getMsgId().equals("sting") || source.is(DamageTypes.IN_WALL) || super.isInvulnerableTo(source);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new TameableAIFollowOwner(this, 1.2, 5.0f, 2.0f, false));
        this.goalSelector.addGoal(3, (Goal)new GrizzlyBearAIAprilFools(this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal());
        this.goalSelector.addGoal(4, (Goal)new PanicGoal());
        this.goalSelector.addGoal(5, (Goal)new TameableAITempt((Animal)this, 1.1, TEMPTATION_ITEMS, false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new GrizzlyBearAIBeehive(this));
        this.goalSelector.addGoal(6, (Goal)new GrizzlyBearAIFleeBees(this, 14.0f, 1.0, 1.0));
        this.goalSelector.addGoal(6, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.75));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal());
        this.targetSelector.addGoal(4, new CreatureAITargetItems((PathfinderMob)this, false));
        this.targetSelector.addGoal(5, (Goal)new AttackPlayerGoal());
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((EntityGrizzlyBear)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Fox.class, false, (Predicate)null));
        this.targetSelector.addGoal(8, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Wolf.class, false, (Predicate)null));
        this.targetSelector.addGoal(7, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Honeyed", this.isHoneyed());
        compound.putBoolean("Snowy", this.isSnowy());
        compound.putBoolean("Standing", this.isStanding());
        compound.putBoolean("BearSitting", this.isSitting());
        compound.putBoolean("ForcedToSit", this.forcedSit);
        compound.putBoolean("SnowPerm", this.permSnow);
        compound.putInt("FurTime", this.timeUntilNextFur);
        compound.putInt("BearCommand", this.getCommand());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHoneyed(compound.getBoolean("Honeyed"));
        this.setSnowy(compound.getBoolean("Snowy"));
        this.setStanding(compound.getBoolean("Standing"));
        this.setOrderedToSit(compound.getBoolean("BearSitting"));
        this.setCommand(compound.getInt("BearCommand"));
        this.forcedSit = compound.getBoolean("ForcedToSit");
        this.permSnow = compound.getBoolean("SnowPerm");
        this.timeUntilNextFur = compound.getInt("FurTime");
    }

    public boolean isFood(ItemStack stack) {
        Item item = stack.getItem();
        return this.isTame() && stack.is(AMTagRegistry.GRIZZLY_BREEDABLES);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 67) {
            AlexsMobs.PROXY.onEntityStatus((Entity)this, id);
        } else if (id == 68) {
            AlexsMobs.PROXY.spawnSpecialParticle(0);
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.getPassengers()) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            return player;
        }
        return null;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        InteractionResult type = super.mobInteract(player, hand);
        if (item == Items.SNOW && !this.isSnowy() && !this.level().isClientSide) {
            this.usePlayerItem(player, hand, itemstack);
            this.permSnow = true;
            this.setSnowy(true);
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEvents.SNOW_PLACE, this.getSoundVolume(), this.getVoicePitch());
            return InteractionResult.SUCCESS;
        }
        if (item instanceof ShovelItem && this.isSnowy() && !this.level().isClientSide) {
            this.permSnow = false;
            if (!player.isCreative()) {
                itemstack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            this.setSnowy(false);
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEvents.SNOW_BREAK, this.getSoundVolume(), this.getVoicePitch());
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.isTame() && this.isOwnedBy((LivingEntity)player) && !this.isFood(itemstack)) {
            boolean sit;
            if (!player.isShiftKeyDown() && !this.isBaby()) {
                player.startRiding((Entity)this);
                return InteractionResult.SUCCESS;
            }
            this.setCommand((this.getCommand() + 1) % 3);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.displayClientMessage((Component)Component.translatable((String)("entity.alexsmobs.all.command_" + this.getCommand()), (Object[])new Object[]{this.getName()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.forcedSit = true;
                this.setOrderedToSit(true);
                return InteractionResult.SUCCESS;
            }
            this.forcedSit = false;
            this.setOrderedToSit(false);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    protected Vec3 getRiddenInput(Player player, Vec3 deltaIn) {
        if (player.zza != 0.0f) {
            float f = player.zza < 0.0f ? 0.5f : 1.0f;
            return new Vec3((double)(player.xxa * 0.25f), 0.0, (double)(player.zza * 0.5f * f));
        }
        this.setSprinting(false);
        return Vec3.ZERO;
    }

    protected void tickRidden(Player player, Vec3 vec3) {
        super.tickRidden(player, vec3);
        if (player.zza != 0.0f || player.xxa != 0.0f) {
            this.setRot(player.getYRot(), player.getXRot() * 0.25f);
            this.yBodyRot = this.yHeadRot = this.getYRot();
            this.yRotO = this.yHeadRot;
            this.getNavigation().stop();
            this.setTarget(null);
            this.setSprinting(true);
        }
    }

    protected float getRiddenSpeed(Player rider) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    public void travel(Vec3 vec3d) {
        if (!this.shouldMove()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    public void tick() {
        Player rider;
        super.tick();
        if (this.isBaby() || this.getEyeHeight() > this.getBbHeight()) {
            this.refreshDimensions();
        }
        if (!this.isStanding() && this.getBbHeight() >= 2.75f) {
            this.refreshDimensions();
        }
        this.prevStandProgress = this.standProgress;
        this.prevSitProgress = this.sitProgress;
        if (this.isSitting()) {
            if (this.sitProgress < 10.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isStanding()) {
            if (this.standProgress < 10.0f) {
                this.standProgress += 1.0f;
            }
        } else if (this.standProgress > 0.0f) {
            this.standProgress -= 1.0f;
        }
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && this.canTargetItem(this.getItemInHand(InteractionHand.MAIN_HAND))) {
            this.setEating(true);
            this.setOrderedToSit(true);
            this.setStanding(false);
        }
        if (this.recalcSize) {
            this.recalcSize = false;
            this.refreshDimensions();
        }
        if (this.isEating() && !this.canTargetItem(this.getItemInHand(InteractionHand.MAIN_HAND))) {
            this.setEating(false);
            this.eatingTime = 0;
            if (!this.forcedSit) {
                this.setOrderedToSit(true);
            }
        }
        if (this.isEating()) {
            ++this.eatingTime;
            for (int i = 0; i < 3; ++i) {
                double d2 = this.random.nextGaussian() * 0.02;
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItemInHand(InteractionHand.MAIN_HAND)), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() + (double)(this.getBbHeight() * 0.5f) + (double)(this.random.nextFloat() * this.getBbHeight() * 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, d0, d1, d2);
            }
            if (this.eatingTime % 5 == 0) {
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
            }
            if (this.eatingTime > 100) {
                ItemStack stack = this.getItemInHand(InteractionHand.MAIN_HAND);
                if (!stack.isEmpty()) {
                    if (stack.is(AMTagRegistry.GRIZZLY_HONEY)) {
                        this.setHoneyed(true);
                        this.heal(10.0f);
                        this.honeyedTime = 700;
                    } else {
                        this.heal(4.0f);
                    }
                    if (stack.is(AMTagRegistry.GRIZZLY_TAMEABLES) && !this.isTame() && this.salmonThrowerID != null) {
                        if (this.getRandom().nextFloat() < 0.3f) {
                            this.setTame(true, true);
                            this.setOwnerUUID(this.salmonThrowerID);
                            Player player = this.level().getPlayerByUUID(this.salmonThrowerID);
                            if (player instanceof ServerPlayer) {
                                CriteriaTriggers.TAME_ANIMAL.trigger((ServerPlayer)player, (Animal)this);
                            }
                            this.level().broadcastEntityEvent((Entity)this, (byte)7);
                        } else {
                            this.level().broadcastEntityEvent((Entity)this, (byte)6);
                        }
                    }
                    if (stack.hasCraftingRemainingItem()) {
                        this.spawnAtLocation(stack.getCraftingRemainingItem());
                    }
                    stack.shrink(1);
                }
                this.eatingTime = 0;
            }
        }
        if (this.isStanding() && ++this.standingTime > this.maxStandTime) {
            this.setStanding(false);
            this.standingTime = 0;
            this.maxStandTime = 75 + this.random.nextInt(50);
        }
        if (this.isSitting() && !this.forcedSit && ++this.sittingTime > this.maxSitTime) {
            this.setOrderedToSit(false);
            this.sittingTime = 0;
            this.maxSitTime = 75 + this.random.nextInt(50);
        }
        if (!(this.level().isClientSide || this.getAnimation() != NO_ANIMATION || this.isStanding() || this.isSitting() || this.random.nextInt(1500) != 0)) {
            this.maxSitTime = 300 + this.random.nextInt(250);
            this.setOrderedToSit(true);
        }
        if (!this.forcedSit && this.isSitting() && (this.getTarget() != null || this.isStanding()) && !this.isEating()) {
            this.setOrderedToSit(false);
        }
        if (this.getAnimation() == NO_ANIMATION && this.getAprilFoolsFlag() < 1 && this.random.nextInt(this.isStanding() ? 350 : 2500) == 0) {
            this.setAnimation(ANIMATION_SNIFF);
        }
        if (this.isSitting()) {
            this.getNavigation().stop();
        }
        LivingEntity attackTarget = this.getTarget();
        if (this.getControllingPassenger() != null && this.getControllingPassenger() instanceof Player && (rider = (Player)this.getControllingPassenger()).getLastHurtMob() != null && this.distanceTo((Entity)rider.getLastHurtMob()) < this.getBbWidth() + 3.0f && !this.isAlliedTo((Entity)rider.getLastHurtMob())) {
            UUID preyUUID = rider.getLastHurtMob().getUUID();
            if (!this.getUUID().equals(preyUUID)) {
                attackTarget = rider.getLastHurtMob();
                if (this.getAnimation() == NO_ANIMATION || this.getAnimation() == ANIMATION_SNIFF) {
                    this.setAnimation(this.random.nextBoolean() ? ANIMATION_MAUL : (this.random.nextBoolean() ? ANIMATION_SWIPE_L : ANIMATION_SWIPE_R));
                }
            }
        }
        if (attackTarget != null) {
            if (!this.level().isClientSide) {
                this.setSprinting(true);
            }
            if (this.distanceTo((Entity)attackTarget) < attackTarget.getBbWidth() + this.getBbWidth() + 2.5f) {
                if (this.getAnimation() == ANIMATION_MAUL && this.getAnimationTick() % 5 == 0 && this.getAnimationTick() > 3) {
                    this.doHurtTarget((Entity)attackTarget);
                }
                if (this.getAnimation() == ANIMATION_SWIPE_L && this.getAnimationTick() == 7) {
                    this.doHurtTarget((Entity)attackTarget);
                    float rot = this.getYRot() + 90.0f;
                    attackTarget.knockback(0.5, (double)Mth.sin((float)(rot * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(rot * ((float)Math.PI / 180)))));
                }
                if (this.getAnimation() == ANIMATION_SWIPE_R && this.getAnimationTick() == 7) {
                    this.doHurtTarget((Entity)attackTarget);
                    float rot = this.getYRot() - 90.0f;
                    attackTarget.knockback(0.5, (double)Mth.sin((float)(rot * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(rot * ((float)Math.PI / 180)))));
                }
            }
        } else if (!this.level().isClientSide && this.getControllingPassenger() == null) {
            this.setSprinting(false);
        }
        if (!this.level().isClientSide && this.isHoneyed() && --this.honeyedTime <= 0) {
            this.setHoneyed(false);
            this.honeyedTime = 0;
        }
        if (this.forcedSit && !this.isVehicle() && this.isTame()) {
            this.setOrderedToSit(true);
        }
        if (this.isVehicle() && this.isSitting()) {
            this.setOrderedToSit(false);
        }
        if (!this.level().isClientSide && this.isAlive() && this.isTame() && !this.isBaby() && --this.timeUntilNextFur <= 0) {
            this.spawnAtLocation((ItemLike)AMItemRegistry.BEAR_FUR.get());
            this.timeUntilNextFur = this.random.nextInt(24000) + 24000;
        }
        if (this.snowTimer > 0) {
            --this.snowTimer;
        }
        if (this.snowTimer == 0 && !this.level().isClientSide) {
            this.snowTimer = 200 + this.random.nextInt(400);
            if (this.isSnowy()) {
                if (!(this.permSnow || this.level().isClientSide && this.getRemainingFireTicks() <= 0 && !this.isInWaterOrBubble() && EntityGrizzlyBear.isSnowingAt(this.level(), this.blockPosition().above()))) {
                    this.setSnowy(false);
                }
            } else if (!this.level().isClientSide && EntityGrizzlyBear.isSnowingAt(this.level(), this.blockPosition())) {
                this.setSnowy(true);
            }
        }
        if (this.isFreddy()) {
            this.setStanding(true);
            this.standingTime = 0;
            this.maxStandTime = 40;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public static boolean isSnowingAt(Level world, BlockPos position) {
        if (!world.isRaining()) {
            return false;
        }
        if (!world.canSeeSky(position)) {
            return false;
        }
        if (world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, position).getY() > position.getY()) {
            return false;
        }
        return ((Biome)world.getBiome(position).value()).getPrecipitationAt(position) == Biome.Precipitation.SNOW;
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STANDING, (Object)false);
        builder.define(SITTING, (Object)false);
        builder.define(HONEYED, (Object)false);
        builder.define(SNOWY, (Object)false);
        builder.define(EATING, (Object)false);
        builder.define(APRIL_FOOLS_MODE, (Object)0);
        builder.define(COMMAND, (Object)0);
    }

    public boolean isEating() {
        return (Boolean)this.entityData.get(EATING);
    }

    public void setEating(boolean eating) {
        this.entityData.set(EATING, (Object)eating);
    }

    public boolean isHoneyed() {
        return (Boolean)this.entityData.get(HONEYED);
    }

    public void setHoneyed(boolean honeyed) {
        this.entityData.set(HONEYED, (Object)honeyed);
    }

    public boolean isSnowy() {
        return (Boolean)this.entityData.get(SNOWY);
    }

    public void setSnowy(boolean honeyed) {
        this.entityData.set(SNOWY, (Object)honeyed);
    }

    public boolean isStanding() {
        return (Boolean)this.entityData.get(STANDING);
    }

    public void setStanding(boolean standing) {
        this.entityData.set(STANDING, (Object)standing);
        this.recalcSize = true;
    }

    public int getAprilFoolsFlag() {
        return (Integer)this.entityData.get(APRIL_FOOLS_MODE);
    }

    public void setAprilFoolsFlag(int i) {
        this.entityData.set(APRIL_FOOLS_MODE, (Object)i);
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob p_241840_2_) {
        return (AgeableMob)((EntityType)AMEntityRegistry.GRIZZLY_BEAR.get()).create((Level)world);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        if (animation == ANIMATION_MAUL) {
            this.maxStandTime = 21;
            this.setStanding(true);
        }
        if (animation == ANIMATION_SWIPE_R || animation == ANIMATION_SWIPE_L) {
            this.maxStandTime = 2 + this.random.nextInt(5);
            this.setStanding(true);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_MAUL, ANIMATION_SNIFF, ANIMATION_SWIPE_R, ANIMATION_SWIPE_L};
    }

    public boolean shouldMove() {
        return !this.isSitting();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.is(AMTagRegistry.GRIZZLY_FOODSTUFFS);
    }

    @Override
    public void onGetItem(ItemEntity targetEntity) {
        ItemStack duplicate = targetEntity.getItem().copy();
        duplicate.setCount(1);
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
        }
        this.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
        Entity thrower = targetEntity.getOwner();
        this.salmonThrowerID = targetEntity.getItem().is(AMTagRegistry.GRIZZLY_TAMEABLES) && thrower != null && this.isHoneyed() ? thrower.getUUID() : null;
    }

    public boolean isEatingHeldItem() {
        return false;
    }

    public boolean isFreddy() {
        return this.getAprilFoolsFlag() > 1;
    }

    @Override
    public boolean shouldFollow() {
        return this.getAprilFoolsFlag() == 0 && this.getCommand() == 1;
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)EntityGrizzlyBear.this, 1.25, true);
        }

        protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= d0 && (EntityGrizzlyBear.this.getAnimation() == IAnimatedEntity.NO_ANIMATION || EntityGrizzlyBear.this.getAnimation() == ANIMATION_SNIFF)) {
                EntityGrizzlyBear.this.setAnimation(EntityGrizzlyBear.this.random.nextBoolean() ? ANIMATION_MAUL : (EntityGrizzlyBear.this.random.nextBoolean() ? ANIMATION_SWIPE_L : ANIMATION_SWIPE_R));
            }
        }

        public void stop() {
            EntityGrizzlyBear.this.setStanding(false);
            super.stop();
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return 3.0f + attackTarget.getBbWidth();
        }
    }

    class PanicGoal
    extends net.minecraft.world.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((PathfinderMob)EntityGrizzlyBear.this, 2.0);
        }

        public boolean canUse() {
            return (EntityGrizzlyBear.this.isBaby() || EntityGrizzlyBear.this.isOnFire()) && super.canUse();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((PathfinderMob)EntityGrizzlyBear.this, new Class[0]);
        }

        public void start() {
            super.start();
            if (EntityGrizzlyBear.this.isBaby()) {
                this.alertOthers();
                this.stop();
            }
        }

        protected void alertOther(Mob mobIn, LivingEntity targetIn) {
            if (mobIn instanceof EntityGrizzlyBear && !mobIn.isBaby()) {
                super.alertOther(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        public AttackPlayerGoal() {
            super((Mob)EntityGrizzlyBear.this, Player.class, 3, true, true, null);
        }

        public boolean canUse() {
            if (EntityGrizzlyBear.this.isBaby() || EntityGrizzlyBear.this.getAprilFoolsFlag() >= 1 || EntityGrizzlyBear.this.isHoneyed()) {
                return false;
            }
            return super.canUse();
        }

        protected double getFollowDistance() {
            return 5.0;
        }
    }
}

