/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIRideParent;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GorillaAIChargeLooker;
import com.github.alexthe666.alexsmobs.entity.ai.GorillaAIFollowCaravan;
import com.github.alexthe666.alexsmobs.entity.ai.GorillaAIForageLeaves;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAITempt;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class EntityGorilla
extends TamableAnimal
implements IAnimatedEntity,
ITargetsDroppedItems {
    public static final Animation ANIMATION_BREAKBLOCK_R = Animation.create((int)20);
    public static final Animation ANIMATION_BREAKBLOCK_L = Animation.create((int)20);
    public static final Animation ANIMATION_POUNDCHEST = Animation.create((int)40);
    public static final Animation ANIMATION_ATTACK = Animation.create((int)20);
    protected static final EntityDimensions SILVERBACK_SIZE = EntityDimensions.scalable((float)1.35f, (float)1.95f);
    private static final EntityDataAccessor<Boolean> SILVERBACK = SynchedEntityData.defineId(EntityGorilla.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.defineId(EntityGorilla.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityGorilla.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.defineId(EntityGorilla.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int maxStandTime = 75;
    public float prevStandProgress;
    public float prevSitProgress;
    public float standProgress;
    public float sitProgress;
    public boolean forcedSit = false;
    private int animationTick;
    private Animation currentAnimation;
    private int standingTime = 0;
    private int eatingTime;
    @Nullable
    private EntityGorilla caravanHead;
    @Nullable
    private EntityGorilla caravanTail;
    private int sittingTime = 0;
    private int maxSitTime = 75;
    @Nullable
    private UUID bananaThrowerID = null;
    private boolean hasSilverbackAttributes = false;
    public int poundChestCooldown = 0;

    protected EntityGorilla(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LEAVES, 0.0f);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new AdvancedPathNavigateNoTeleport((Mob)this, worldIn, false);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public static boolean isTameableFood(ItemStack stack) {
        return stack.is(AMTagRegistry.BANANAS);
    }

    public static boolean canGorillaSpawn(EntityType<EntityGorilla> gorilla, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223317_3_, RandomSource random) {
        BlockState blockstate = worldIn.getBlockState(p_223317_3_.below());
        return (blockstate.is(AMTagRegistry.GORILLA_SPAWNS) || blockstate.is(Blocks.AIR)) && worldIn.getRawBrightness(p_223317_3_, 0) > 8;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.gorillaSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public boolean isFood(ItemStack stack) {
        Item item = stack.getItem();
        return this.isTame() && stack.is(AMTagRegistry.GORILLA_BREEDABLES);
    }

    public int getMaxSpawnClusterSize() {
        return 8;
    }

    public boolean isMaxGroupSizeReached(int sizeIn) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && this.isTame() && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.hurt(source, amount);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.goalSelector.addGoal(2, (Goal)new GorillaAIFollowCaravan(this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new GorillaAIChargeLooker(this, 1.6));
        this.goalSelector.addGoal(4, (Goal)new TameableAITempt((Animal)this, 1.1, Ingredient.of(AMTagRegistry.GORILLA_TAMEABLES), false));
        this.goalSelector.addGoal(4, (Goal)new AnimalAIRideParent((Animal)this, 1.25));
        this.goalSelector.addGoal(6, (Goal)new AIWalkIdle(this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new GorillaAIForageLeaves(this));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new CreatureAITargetItems((PathfinderMob)this, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.GORILLA_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.GORILLA_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.GORILLA_HURT.get();
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    public void travel(Vec3 vec3d) {
        if (this.isSitting()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (spawnDataIn instanceof AgeableMob.AgeableMobGroupData) {
            AgeableMob.AgeableMobGroupData lvt_6_1_ = (AgeableMob.AgeableMobGroupData)spawnDataIn;
            if (lvt_6_1_.getGroupSize() == 0) {
                this.setSilverback(true);
            }
        } else {
            this.setSilverback(this.getRandom().nextBoolean());
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    @Nullable
    public EntityGorilla getNearestSilverback(LevelAccessor world, double dist) {
        List list = world.getEntitiesOfClass(this.getClass(), this.getBoundingBox().inflate(dist, dist / 2.0, dist));
        if (list.isEmpty()) {
            return null;
        }
        EntityGorilla gorilla = null;
        double d0 = Double.MAX_VALUE;
        for (EntityGorilla gorrila2 : list) {
            double d1;
            if (!gorrila2.isSilverback() || (d1 = this.distanceToSqr((Entity)gorrila2)) > d0) continue;
            d0 = d1;
            gorilla = gorrila2;
        }
        return gorilla;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        if (this.hasPassenger(passenger)) {
            this.setOrderedToSit(false);
            if (passenger instanceof EntityGorilla) {
                EntityGorilla babyGorilla = (EntityGorilla)passenger;
                babyGorilla.setStanding(this.isStanding());
                babyGorilla.setOrderedToSit(this.isSitting());
                babyGorilla.yBodyRot = this.yBodyRot;
            }
            float sitAdd = -0.03f * this.sitProgress;
            float standAdd = -0.03f * this.standProgress;
            float radius = standAdd + sitAdd;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            passenger.setPos(this.getX() + extraX, this.getY() + (double)this.getBbHeight() * 0.75 + 0.0, this.getZ() + extraZ);
        }
    }

    public double getPassengersRidingOffset() {
        return (double)this.getBbHeight() * (double)0.65f * (double)this.getGorillaScale() * (double)(this.isSilverback() ? 0.75f : 1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SILVERBACK, (Object)false);
        builder.define(STANDING, (Object)false);
        builder.define(SITTING, (Object)false);
        builder.define(EATING, (Object)false);
    }

    public boolean isSilverback() {
        return (Boolean)this.entityData.get(SILVERBACK);
    }

    public void setSilverback(boolean silver) {
        this.entityData.set(SILVERBACK, (Object)silver);
    }

    public boolean isStanding() {
        return (Boolean)this.entityData.get(STANDING);
    }

    public void setStanding(boolean standing) {
        this.entityData.set(STANDING, (Object)standing);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public boolean isEating() {
        return (Boolean)this.entityData.get(EATING);
    }

    public void setEating(boolean eating) {
        this.entityData.set(EATING, (Object)eating);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Silverback", this.isSilverback());
        compound.putBoolean("Standing", this.isStanding());
        compound.putBoolean("GorillaSitting", this.isSitting());
        compound.putBoolean("ForcedToSit", this.forcedSit);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSilverback(compound.getBoolean("Silverback"));
        this.setStanding(compound.getBoolean("Standing"));
        this.setOrderedToSit(compound.getBoolean("GorillaSitting"));
        this.forcedSit = compound.getBoolean("ForcedToSit");
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (itemstack.getItem() == Items.NAME_TAG) {
            return super.mobInteract(player, hand);
        }
        if (this.isTame() && EntityGorilla.isTameableFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
            this.heal(5.0f);
            this.usePlayerItem(player, hand, itemstack);
            this.gameEvent((Holder)GameEvent.EAT);
            this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
            return InteractionResult.SUCCESS;
        }
        InteractionResult type = super.mobInteract(player, hand);
        InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.isTame() && this.isOwnedBy((LivingEntity)player) && !this.isFood(itemstack)) {
            if (this.isSitting()) {
                this.forcedSit = false;
                this.setOrderedToSit(false);
                return InteractionResult.SUCCESS;
            }
            this.forcedSit = true;
            this.setOrderedToSit(true);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        if (animation == ANIMATION_POUNDCHEST) {
            this.maxStandTime = 45;
            this.setStanding(true);
        }
        if (animation == ANIMATION_ATTACK) {
            this.maxStandTime = 10;
            this.setStanding(true);
        }
    }

    public void tick() {
        super.tick();
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && this.canTargetItem(this.getItemInHand(InteractionHand.MAIN_HAND))) {
            this.setEating(true);
            this.setOrderedToSit(true);
            this.setStanding(false);
        }
        if (this.isEating() && !this.canTargetItem(this.getItemInHand(InteractionHand.MAIN_HAND))) {
            this.setEating(false);
            this.eatingTime = 0;
            if (!this.forcedSit) {
                this.setOrderedToSit(true);
            }
        }
        if (this.isEating()) {
            ++this.eatingTime;
            if (!this.getMainHandItem().is(ItemTags.LEAVES)) {
                for (int i = 0; i < 3; ++i) {
                    double d2 = this.random.nextGaussian() * 0.02;
                    double d0 = this.random.nextGaussian() * 0.02;
                    double d1 = this.random.nextGaussian() * 0.02;
                    this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItemInHand(InteractionHand.MAIN_HAND)), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() + (double)(this.getBbHeight() * 0.5f) + (double)(this.random.nextFloat() * this.getBbHeight() * 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, d0, d1, d2);
                }
            }
            if (this.eatingTime % 5 == 0) {
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.PANDA_EAT, this.getSoundVolume(), this.getVoicePitch());
            }
            if (this.eatingTime > 100) {
                ItemStack stack = this.getItemInHand(InteractionHand.MAIN_HAND);
                if (!stack.isEmpty()) {
                    this.heal(4.0f);
                    if (EntityGorilla.isTameableFood(stack) && this.bananaThrowerID != null) {
                        if (this.getRandom().nextFloat() < 0.3f) {
                            this.setTame(true, true);
                            this.setOwnerUUID(this.bananaThrowerID);
                            Player player = this.level().getPlayerByUUID(this.bananaThrowerID);
                            if (player instanceof ServerPlayer) {
                                CriteriaTriggers.TAME_ANIMAL.trigger((ServerPlayer)player, (Animal)this);
                            }
                            this.level().broadcastEntityEvent((Entity)this, (byte)7);
                        } else {
                            this.level().broadcastEntityEvent((Entity)this, (byte)6);
                        }
                    }
                    if (stack.hasCraftingRemainingItem()) {
                        this.spawnAtLocation(stack.getCraftingRemainingItem());
                    }
                    stack.shrink(1);
                }
                this.eatingTime = 0;
            }
        }
        this.prevSitProgress = this.sitProgress;
        this.prevStandProgress = this.standProgress;
        if (this.isSitting()) {
            if (this.sitProgress < 10.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isStanding()) {
            if (this.standProgress < 10.0f) {
                this.standProgress += 1.0f;
            }
        } else if (this.standProgress > 0.0f) {
            this.standProgress -= 1.0f;
        }
        if (this.isPassenger() && this.getVehicle() instanceof EntityGorilla) {
            if (!this.isBaby()) {
                this.removeVehicle();
            } else {
                EntityGorilla mount = (EntityGorilla)this.getVehicle();
                this.setYRot(mount.yBodyRot);
                this.yHeadRot = mount.yBodyRot;
                this.yBodyRot = mount.yBodyRot;
            }
        }
        if (this.isStanding() && ++this.standingTime > this.maxStandTime) {
            this.setStanding(false);
            this.standingTime = 0;
            this.maxStandTime = 75 + this.random.nextInt(50);
        }
        if (!this.forcedSit && this.isSitting() && ++this.sittingTime > this.maxSitTime) {
            this.setOrderedToSit(false);
            this.sittingTime = 0;
            this.maxSitTime = 75 + this.random.nextInt(50);
        }
        if (!this.forcedSit && this.isSitting() && (this.getTarget() != null || this.isStanding()) && !this.isEating()) {
            this.setOrderedToSit(false);
        }
        if (!(this.level().isClientSide || this.getAnimation() != NO_ANIMATION || this.isStanding() || this.isSitting() || this.random.nextInt(1500) != 0)) {
            this.maxSitTime = 300 + this.random.nextInt(250);
            this.setOrderedToSit(true);
        }
        if (this.forcedSit && !this.isVehicle() && this.isTame()) {
            this.setOrderedToSit(true);
        }
        if (this.sitProgress == 0.0f && this.poundChestCooldown <= 0 && this.isSilverback() && this.random.nextInt(800) == 0 && this.getAnimation() == NO_ANIMATION && !this.isSitting() && !this.isNoAi() && this.getMainHandItem().isEmpty()) {
            this.setAnimation(ANIMATION_POUNDCHEST);
        }
        if (!this.level().isClientSide && this.getTarget() != null && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 10) {
            float f1 = this.getYRot() * ((float)Math.PI / 180);
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-Mth.sin((float)f1) * 0.02f), 0.0, (double)(Mth.cos((float)f1) * 0.02f)));
            this.getTarget().knockback(1.0, this.getTarget().getX() - this.getX(), this.getTarget().getZ() - this.getZ());
            this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
        }
        if (!this.hasSilverbackAttributes && this.isSilverback() && !this.isBaby()) {
            this.hasSilverbackAttributes = true;
            this.refreshDimensions();
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(50.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(10.0);
            this.heal(50.0f);
        }
        if (this.hasSilverbackAttributes && !this.isSilverback() && !this.isBaby()) {
            this.hasSilverbackAttributes = false;
            this.refreshDimensions();
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(30.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(8.0);
            this.heal(30.0f);
        }
        if (this.poundChestCooldown > 0) {
            --this.poundChestCooldown;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public PathNavigation getNavigation() {
        return this.navigation;
    }

    @Nullable
    public Entity getControlledVehicle() {
        return this.getVehicle() instanceof EntityGorilla ? null : super.getControlledVehicle();
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.is(AMTagRegistry.GORILLA_FOODSTUFFS);
    }

    @Override
    public void onGetItem(ItemEntity targetEntity) {
        ItemStack duplicate = targetEntity.getItem().copy();
        duplicate.setCount(1);
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
        }
        this.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
        Entity thrower = targetEntity.getOwner();
        if (EntityGorilla.isTameableFood(targetEntity.getItem()) && thrower != null && !this.isTame()) {
            this.bananaThrowerID = thrower.getUUID();
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BREAKBLOCK_R, ANIMATION_BREAKBLOCK_L, ANIMATION_POUNDCHEST, ANIMATION_ATTACK};
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return (AgeableMob)((EntityType)AMEntityRegistry.GORILLA.get()).create((Level)p_241840_1_);
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(EntityGorilla caravanHeadIn) {
        this.caravanHead = caravanHeadIn;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTrail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public EntityGorilla getCaravanHead() {
        return this.caravanHead;
    }

    public float getGorillaScale() {
        return this.isBaby() ? 0.5f : (this.isSilverback() ? 1.3f : 1.0f);
    }

    public boolean isDonkeyKong() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && (s.toLowerCase().contains("donkey") && s.toLowerCase().contains("kong") || s.equalsIgnoreCase("dk"));
    }

    public boolean isFunkyKong() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && s.toLowerCase().contains("funky") && s.toLowerCase().contains("kong");
    }

    private class AIWalkIdle
    extends RandomStrollGoal {
        public AIWalkIdle(EntityGorilla entityGorilla2, double v) {
            super((PathfinderMob)entityGorilla2, v);
        }

        public boolean canUse() {
            this.interval = EntityGorilla.this.isSilverback() ? 10 : 120;
            return super.canUse();
        }

        @Nullable
        protected Vec3 getPosition() {
            return LandRandomPos.getPos((PathfinderMob)this.mob, (int)(EntityGorilla.this.isSilverback() ? 25 : 10), (int)7);
        }
    }
}

