/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.EntityGiantSquid;
import com.github.alexthe666.alexsmobs.entity.IHurtableMultipart;
import com.github.alexthe666.alexsmobs.network.MessageHurtMultipart;
import com.github.alexthe666.alexsmobs.network.MessageInteractMultipart;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;

public class EntityGiantSquidPart
extends PartEntity<EntityGiantSquid>
implements IHurtableMultipart {
    private final EntityDimensions size;
    public float scale = 1.0f;
    private boolean collisionOnly = false;

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public EntityGiantSquidPart(EntityGiantSquid parent, float sizeX, float sizeY) {
        super((Entity)parent);
        this.size = EntityDimensions.scalable((float)sizeX, (float)sizeY);
        this.refreshDimensions();
    }

    public EntityGiantSquidPart(EntityGiantSquid parent, float sizeX, float sizeY, boolean collisionOnly) {
        this(parent, sizeX, sizeY);
        this.collisionOnly = collisionOnly;
    }

    public boolean fireImmune() {
        return true;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)this.getEyeHeight() * (double)0.15f, (double)(this.getBbWidth() * 0.1f));
    }

    protected void collideWithNearbyEntities() {
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.level().isClientSide && this.getParent() != null) {
            AlexsMobs.sendMSGToServer(new MessageInteractMultipart(((EntityGiantSquid)this.getParent()).getId(), hand == InteractionHand.OFF_HAND));
        }
        return this.getParent() == null ? InteractionResult.PASS : ((EntityGiantSquid)this.getParent()).mobInteract(player, hand);
    }

    public boolean canBeCollidedWith() {
        return !this.collisionOnly;
    }

    protected void collideWithEntity(Entity entityIn) {
        if (!this.collisionOnly) {
            entityIn.push((Entity)this);
        }
    }

    public boolean isPickable() {
        return !this.collisionOnly;
    }

    @Nullable
    public ItemStack getPickResult() {
        Entity parent = this.getParent();
        return parent != null ? parent.getPickResult() : ItemStack.EMPTY;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level().isClientSide && this.getParent() != null && !((EntityGiantSquid)this.getParent()).isInvulnerableTo(source) && !this.collisionOnly) {
            AlexsMobs.sendMSGToServer(new MessageHurtMultipart(this.getId(), ((EntityGiantSquid)this.getParent()).getId(), amount, source.getMsgId()));
        }
        return !this.collisionOnly && !this.isInvulnerableTo(source) && ((EntityGiantSquid)this.getParent()).attackEntityPartFrom(this, source, amount);
    }

    public boolean is(Entity entityIn) {
        return this == entityIn || this.getParent() == entityIn;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        throw new UnsupportedOperationException();
    }

    protected void defineSynchedData() {
    }

    public void tick() {
        super.tick();
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    @Override
    public void onAttackedFromServer(LivingEntity parent, float damage, DamageSource damageSource) {
        if (damageSource != null) {
            parent.hurt(damageSource, damage);
        }
    }
}

