/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.GeladaAIGroom;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityGeladaMonkey
extends Animal
implements IAnimatedEntity,
IHerdPanic {
    public static final Animation ANIMATION_SWIPE_R = Animation.create((int)13);
    public static final Animation ANIMATION_SWIPE_L = Animation.create((int)13);
    public static final Animation ANIMATION_GROOM = Animation.create((int)35);
    public static final Animation ANIMATION_CHEST = Animation.create((int)35);
    private static final EntityDataAccessor<Boolean> LEADER = SynchedEntityData.defineId(EntityGeladaMonkey.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityGeladaMonkey.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_TARGET = SynchedEntityData.defineId(EntityGeladaMonkey.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> GRASS_TIME = SynchedEntityData.defineId(EntityGeladaMonkey.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float prevSitProgress;
    public float sitProgress;
    public boolean isGrooming = false;
    public int groomerID = -1;
    private int animationTick;
    private Animation currentAnimation;
    private int sittingTime;
    private int maxSitTime;
    private int leaderFightTime;
    private HurtByTargetGoal hurtByTargetGoal = null;
    private NearestAttackableTargetGoal<EntityGeladaMonkey> leaderFightGoal = null;
    private int revengeCooldown = 0;
    private boolean hasSpedUp = false;

    protected EntityGeladaMonkey(EntityType type, Level lvl) {
        super(type, lvl);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.geladaMonkeySpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 18.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public int getMaxSpawnClusterSize() {
        return 10;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.GELADA_MONKEY_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.GELADA_MONKEY_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.GELADA_MONKEY_HURT.get();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true){

            protected double getAttackReachSqr(LivingEntity attackTarget) {
                return (double)(EntityGeladaMonkey.this.getBbWidth() * 2.0f * EntityGeladaMonkey.this.getBbWidth() * 2.0f + attackTarget.getBbWidth()) + 1.5;
            }

            public boolean canUse() {
                return super.canUse() && EntityGeladaMonkey.this.revengeCooldown <= 0;
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && EntityGeladaMonkey.this.revengeCooldown <= 0;
            }
        });
        this.goalSelector.addGoal(2, (Goal)new AIClearGrass());
        this.goalSelector.addGoal(3, (Goal)new AnimalAIHerdPanic((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.fromValues(Stream.of(new Ingredient.TagValue(AMTagRegistry.GELADA_MONKEY_BREEDABLES), new Ingredient.TagValue(AMTagRegistry.GELADA_MONKEY_LAND_CLEARING_FOODS))), false));
        this.goalSelector.addGoal(7, (Goal)new GeladaAIGroom(this));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 120));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.hurtByTargetGoal = new HurtByTargetGoal((PathfinderMob)this, new Class[]{EntityGeladaMonkey.class}).setAlertOthers(new Class[0]);
        this.targetSelector.addGoal(1, (Goal)this.hurtByTargetGoal);
        this.leaderFightGoal = new NearestAttackableTargetGoal((Mob)this, EntityGeladaMonkey.class, 70, false, false, monkey -> this.isLeader() && this.leaderFightTime == 0 && ((EntityGeladaMonkey)monkey).isLeader() && ((EntityGeladaMonkey)monkey).leaderFightTime == 0);
        this.targetSelector.addGoal(2, (Goal)this.leaderFightGoal);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Leader", this.isLeader());
        compound.putInt("GrassTime", this.getClearGrassTime());
        compound.putInt("FightTime", this.leaderFightTime);
        compound.putBoolean("MonkeySitting", this.isSitting());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setLeader(compound.getBoolean("Leader"));
        this.setClearGrassTime(compound.getInt("GrassTime"));
        this.setSitting(compound.getBoolean("MonkeySitting"));
        this.leaderFightTime = compound.getInt("FightTime");
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.GELADA_MONKEY_BREEDABLES);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LEADER, (Object)false);
        builder.define(SITTING, (Object)false);
        builder.define(HAS_TARGET, (Object)false);
        builder.define(GRASS_TIME, (Object)0);
    }

    public boolean isLeader() {
        return (Boolean)this.entityData.get(LEADER) != false && !this.isBaby();
    }

    public void setLeader(boolean leader) {
        this.entityData.set(LEADER, (Object)leader);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setSitting(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public boolean isAggro() {
        return (Boolean)this.entityData.get(HAS_TARGET);
    }

    public void setAggro(boolean sit) {
        this.entityData.set(HAS_TARGET, (Object)sit);
    }

    public int getClearGrassTime() {
        return (Integer)this.entityData.get(GRASS_TIME);
    }

    public void setClearGrassTime(int i) {
        this.entityData.set(GRASS_TIME, (Object)i);
    }

    public void tick() {
        super.tick();
        this.prevSitProgress = this.sitProgress;
        if (this.isSitting()) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            if (this.isSitting() && ++this.sittingTime > this.maxSitTime) {
                this.setSitting(false);
                this.sittingTime = 0;
                this.maxSitTime = 75 + this.random.nextInt(50);
            }
            if (this.getDeltaMovement().lengthSqr() < 0.03 && this.getAnimation() == NO_ANIMATION && !this.isSitting() && this.random.nextInt(500) == 0) {
                this.sittingTime = 0;
                this.maxSitTime = 200 + this.random.nextInt(550);
                this.setSitting(true);
            }
            if (this.isSitting() && (this.getTarget() != null || this.isInLove())) {
                this.setSitting(false);
            }
            if (this.getTarget() != null && (this.getAnimation() == ANIMATION_SWIPE_L || this.getAnimation() == ANIMATION_SWIPE_R) && this.getAnimationTick() == 7 && this.hasLineOfSight((Entity)this.getTarget()) && this.distanceTo((Entity)this.getTarget()) < this.getBbHeight() + this.getTarget().getBbHeight() + 1.0f) {
                EntityGeladaMonkey monkey;
                LivingEntity livingEntity;
                this.getTarget().knockback((double)0.4f, this.getTarget().getX() - this.getX(), this.getTarget().getZ() - this.getZ());
                float dmg = (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();
                if (this.isLeader() && (livingEntity = this.getTarget()) instanceof EntityGeladaMonkey && (monkey = (EntityGeladaMonkey)livingEntity).isLeader()) {
                    monkey.setTarget((LivingEntity)this);
                    monkey.leaderFightTime = this.leaderFightTime;
                    dmg = 0.0f;
                }
                this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), dmg);
            }
            if (this.getTarget() != null && this.getTarget().isAlive()) {
                LivingEntity livingEntity;
                this.setAggro(true);
                if (this.isLeader() && (livingEntity = this.getTarget()) instanceof EntityGeladaMonkey) {
                    EntityGeladaMonkey monkey = (EntityGeladaMonkey)livingEntity;
                    if (monkey.isLeader()) {
                        ++this.leaderFightTime;
                    }
                    if (this.leaderFightTime < 10 && this.random.nextInt(5) == 0 && this.getAnimation() == NO_ANIMATION) {
                        this.setAnimation(ANIMATION_CHEST);
                    }
                    if (Math.max(this.leaderFightTime, monkey.leaderFightTime) >= 250) {
                        this.resetAttackAI();
                        monkey.resetAttackAI();
                    }
                }
            } else {
                this.setAggro(false);
            }
            if (this.leaderFightTime < 0) {
                ++this.leaderFightTime;
            }
        }
        if (this.isAggro()) {
            if (!this.hasSpedUp) {
                this.hasSpedUp = true;
                this.setSprinting(true);
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)0.31f);
            }
        } else if (this.hasSpedUp) {
            this.hasSpedUp = false;
            this.setSprinting(false);
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.25);
        }
        if (this.getClearGrassTime() > 0) {
            this.setClearGrassTime(this.getClearGrassTime() - 1);
        }
        if (this.getClearGrassTime() < 0) {
            this.setClearGrassTime(this.getClearGrassTime() + 1);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private void resetAttackAI() {
        this.leaderFightTime = -500 - this.random.nextInt(2000);
        this.setTarget(null);
        this.setLastHurtByMob(null);
        if (this.leaderFightGoal != null) {
            this.leaderFightGoal.stop();
        }
        if (this.hurtByTargetGoal != null) {
            this.hurtByTargetGoal.stop();
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.attackAnimation();
        }
        return true;
    }

    public float getGeladaScale() {
        return this.isBaby() ? 0.5f : (this.isLeader() ? 1.15f : 1.0f);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SWIPE_R, ANIMATION_SWIPE_L, ANIMATION_GROOM, ANIMATION_CHEST};
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity direct;
        boolean prev = super.hurt(source, amount);
        if (prev && (direct = source.getEntity()) instanceof EntityGeladaMonkey) {
            int fleeTime;
            this.revengeCooldown = fleeTime = 100 + this.getRandom().nextInt(5);
            this.revengeCooldown = 10 + this.getRandom().nextInt(30);
        }
        return prev;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        if (itemstack.is(AMTagRegistry.GELADA_MONKEY_LAND_CLEARING_FOODS) && this.getClearGrassTime() == 0) {
            this.usePlayerItem(player, hand, itemstack);
            this.eatGrassWithBuddies(3 + this.random.nextInt(2));
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel lvl, AgeableMob mob) {
        EntityGeladaMonkey baby = (EntityGeladaMonkey)((EntityType)AMEntityRegistry.GELADA_MONKEY.get()).create((Level)lvl);
        baby.setLeader(this.random.nextInt(2) == 0);
        return baby;
    }

    public void eatGrassWithBuddies(int otherMonkies) {
        int i = 300 + this.random.nextInt(300);
        this.setClearGrassTime(i);
        int monky = 0;
        for (EntityGeladaMonkey entity : this.level().getEntitiesOfClass(EntityGeladaMonkey.class, this.getBoundingBox().inflate(15.0))) {
            if (monky >= otherMonkies || entity.getId() == this.getId() || entity.shouldStopBeingGroomed()) continue;
            ++monky;
            entity.setClearGrassTime(i);
        }
    }

    @Override
    public void onPanic() {
    }

    @Override
    public boolean canPanic() {
        return this.getLastHurtByMob() instanceof EntityGeladaMonkey && this.random.nextInt(3) == 0;
    }

    public void travel(Vec3 vec3d) {
        if (this.isSitting() || this.getAnimation() == ANIMATION_CHEST) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    @javax.annotation.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnDataIn, @javax.annotation.Nullable CompoundTag dataTag) {
        if (spawnDataIn instanceof AgeableMob.AgeableMobGroupData) {
            AgeableMob.AgeableMobGroupData pack = (AgeableMob.AgeableMobGroupData)spawnDataIn;
            if (pack.getGroupSize() == 0 || pack.getGroupSize() > 4 && this.random.nextInt(2) == 0) {
                this.setLeader(true);
            }
        } else {
            this.setLeader(this.getRandom().nextInt(4) == 0);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public boolean canBeGroomed() {
        return this.groomerID == -1;
    }

    public boolean shouldStopBeingGroomed() {
        return this.getTarget() != null && this.getTarget().isAlive() || this.isInLove() || this.revengeCooldown > 0;
    }

    private void attackAnimation() {
        this.setAnimation(this.random.nextBoolean() ? ANIMATION_SWIPE_L : ANIMATION_SWIPE_R);
    }

    private class AIClearGrass
    extends Goal {
        private BlockPos target;

        public AIClearGrass() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (EntityGeladaMonkey.this.getClearGrassTime() > 0) {
                this.target = this.generateTarget();
                return this.target != null;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.target != null && EntityGeladaMonkey.this.level().getBlockState(this.target).is(AMTagRegistry.GELADA_MONKEY_GRASS);
        }

        public void tick() {
            EntityGeladaMonkey.this.setSitting(false);
            EntityGeladaMonkey.this.getNavigation().moveTo((double)((float)this.target.getX() + 0.5f), (double)((float)this.target.getY() + 0.5f), (double)((float)this.target.getZ() + 0.5f), (double)1.4f);
            if (EntityGeladaMonkey.this.distanceToSqr(Vec3.atCenterOf((Vec3i)this.target)) < (double)3.4f) {
                if (EntityGeladaMonkey.this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    EntityGeladaMonkey.this.attackAnimation();
                } else if (EntityGeladaMonkey.this.getAnimationTick() > 7) {
                    EntityGeladaMonkey.this.level().destroyBlock(this.target, true);
                }
            }
        }

        public BlockPos generateTarget() {
            BlockPos blockpos = null;
            Random random = new Random();
            int range = 7;
            for (int i = 0; i < 15; ++i) {
                BlockPos blockpos1 = EntityGeladaMonkey.this.blockPosition().offset(random.nextInt(range) - range / 2, 3, random.nextInt(range) - range / 2);
                while (EntityGeladaMonkey.this.level().isEmptyBlock(blockpos1) && blockpos1.getY() > -63) {
                    blockpos1 = blockpos1.below();
                }
                if (!EntityGeladaMonkey.this.level().getBlockState(blockpos1).is(AMTagRegistry.GELADA_MONKEY_GRASS)) continue;
                blockpos = blockpos1;
            }
            return blockpos;
        }
    }
}

