/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityBlobfish;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAISwimBottom;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityFrilledShark
extends WaterAnimal
implements IAnimatedEntity,
Bucketable {
    public static final Animation ANIMATION_ATTACK = Animation.create((int)17);
    private static final EntityDataAccessor<Boolean> DEPRESSURIZED = SynchedEntityData.defineId(EntityFrilledShark.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(EntityFrilledShark.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float prevOnLandProgress;
    public float onLandProgress;
    private int animationTick;
    private Animation currentAnimation;

    protected EntityFrilledShark(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.0f);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DEPRESSURIZED, (Object)false);
        builder.define(FROM_BUCKET, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new AIMelee());
        this.goalSelector.addGoal(3, (Goal)new AnimalAISwimBottom((PathfinderMob)this, 0.8f, 7));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, (double)0.8f, 3));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<Squid>((Mob)this, Squid.class, 40, false, true, null));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<EntityMimicOctopus>((Mob)this, EntityMimicOctopus.class, 70, false, true, null));
        this.targetSelector.addGoal(3, new EntityAINearestTarget3D<AbstractSchoolingFish>((Mob)this, AbstractSchoolingFish.class, 100, false, true, null));
        this.targetSelector.addGoal(4, new EntityAINearestTarget3D<EntityBlobfish>((Mob)this, EntityBlobfish.class, 70, false, true, null));
        this.targetSelector.addGoal(5, new EntityAINearestTarget3D<Drowned>((Mob)this, Drowned.class, 4, false, true, null));
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.frilledSharkSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static boolean canFrilledSharkSpawn(EntityType<EntityFrilledShark> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || iServerWorld.isWaterAt(pos) && iServerWorld.isWaterAt(pos.above());
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.entityData.set(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nonnull
    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("FromBucket", this.fromBucket());
        compound.putBoolean("Depressurized", this.isDepressurized());
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFromBucket(compound.getBoolean("FromBucket"));
        this.setDepressurized(compound.getBoolean("Depressurized"));
    }

    private void doInitialPosing(LevelAccessor world) {
        BlockPos down = this.blockPosition();
        while (!world.getFluidState(down).isEmpty() && down.getY() > 1) {
            down = down.below();
        }
        this.setPos((float)down.getX() + 0.5f, down.getY() + 1, (float)down.getZ() + 0.5f);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (reason == MobSpawnType.NATURAL) {
            this.doInitialPosing((LevelAccessor)worldIn);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        return worldIn.isUnobstructed((Entity)this);
    }

    public boolean isDepressurized() {
        return (Boolean)this.entityData.get(DEPRESSURIZED);
    }

    public void setDepressurized(boolean depressurized) {
        this.entityData.set(DEPRESSURIZED, (Object)depressurized);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COD_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.COD_HURT;
    }

    @Nonnull
    public ItemStack getBucketItemStack() {
        ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.FRILLED_SHARK_BUCKET.get());
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return stack;
    }

    public void saveToBucketTag(@Nonnull ItemStack bucket) {
        if (this.hasCustomName()) {
            bucket.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        CompoundTag platTag = new CompoundTag();
        this.addAdditionalSaveData(platTag);
        CompoundTag compound = ((CustomData)bucket.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        compound.put("FrilledSharkData", (Tag)platTag);
    }

    public void loadFromBucketTag(@Nonnull CompoundTag compound) {
        if (compound.contains("FrilledSharkData")) {
            this.readAdditionalSaveData(compound.getCompound("FrilledSharkData"));
        }
    }

    @Nonnull
    protected InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 0.6, 0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    public void calculateEntityAnimation(boolean flying) {
        float f1 = (float)Mth.length((double)(this.getX() - this.xo), (double)(this.getY() - this.yo), (double)(this.getZ() - this.zo));
        float f2 = Math.min(f1 * 8.0f, 1.0f);
        this.walkAnimation.update(f2, 0.4f);
    }

    public void tick() {
        super.tick();
        this.prevOnLandProgress = this.onLandProgress;
        if (!this.isInWater() && this.onLandProgress < 5.0f) {
            this.onLandProgress += 1.0f;
        }
        if (this.isInWater() && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        if (this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.8, 1.0));
        }
        boolean clear = this.hasClearance();
        if (this.isDepressurized() && clear) {
            this.setDepressurized(false);
        }
        if (!this.isDepressurized() && !clear) {
            this.setDepressurized(true);
        }
        if (!this.level().isClientSide && this.getTarget() != null && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 12) {
            float f1 = this.getYRot() * ((float)Math.PI / 180);
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-Mth.sin((float)f1) * 0.06f), 0.0, (double)(Mth.cos((float)f1) * 0.06f)));
            if (this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue())) {
                this.getTarget().addEffect(new MobEffectInstance(AMEffectRegistry.EXSANGUINATION.getDelegate(), 60, 2));
                if (this.random.nextInt(15) == 0 && this.getTarget() instanceof Squid) {
                    this.spawnAtLocation((ItemLike)AMItemRegistry.SERRATED_SHARK_TOOTH.get());
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() instanceof Drowned) {
            amount *= 0.5f;
        }
        return super.hurt(source, amount);
    }

    private boolean hasClearance() {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int l1 = 0; l1 < 10; ++l1) {
            BlockState blockstate = this.level().getBlockState((BlockPos)blockpos$mutable.set(this.getX(), this.getY() + (double)l1, this.getZ()));
            if (blockstate.getFluidState().is(FluidTags.WATER)) continue;
            return false;
        }
        return true;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public boolean isKaiju() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && (s.toLowerCase().contains("kamata kun") || s.toLowerCase().contains("kamata-kun"));
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 68) {
            double d2 = this.random.nextGaussian() * 0.1;
            double d0 = this.random.nextGaussian() * 0.1;
            double d1 = this.random.nextGaussian() * 0.1;
            float radius = this.getBbWidth() * 0.8f;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            double x = this.getX() + extraX + d0;
            double y = this.getY() + (double)(this.getBbHeight() * 0.15f) + d1;
            double z = this.getZ() + extraZ + d2;
            this.level().addParticle((ParticleOptions)AMParticleRegistry.TEETH_GLINT.get(), x, y, z, this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
        } else {
            super.handleEntityEvent(id);
        }
    }

    private class AIMelee
    extends Goal {
        public AIMelee() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return EntityFrilledShark.this.getTarget() != null && EntityFrilledShark.this.getTarget().isAlive();
        }

        public void tick() {
            LivingEntity target = EntityFrilledShark.this.getTarget();
            double speed = 1.0;
            if (EntityFrilledShark.this.distanceTo((Entity)target) < 10.0f) {
                if ((double)EntityFrilledShark.this.distanceTo((Entity)target) < 1.9) {
                    EntityFrilledShark.this.doHurtTarget((Entity)target);
                    speed = 0.8f;
                } else {
                    speed = 0.6f;
                    EntityFrilledShark.this.lookAt((Entity)target, 70.0f, 70.0f);
                    if (target instanceof Squid) {
                        Vec3 mouth = EntityFrilledShark.this.position();
                        float squidSpeed = 0.07f;
                        ((Squid)target).setMovementVector((float)(mouth.x - target.getX()) * squidSpeed, (float)(mouth.y - target.getEyeY()) * squidSpeed, (float)(mouth.z - target.getZ()) * squidSpeed);
                        EntityFrilledShark.this.level().broadcastEntityEvent((Entity)EntityFrilledShark.this, (byte)68);
                    }
                }
            }
            if (target instanceof Drowned || target instanceof Player) {
                speed = 1.0;
            }
            EntityFrilledShark.this.getNavigation().moveTo((Entity)target, speed);
        }
    }
}

