/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityEndergrade;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.network.MessageMosquitoDismount;
import com.github.alexthe666.alexsmobs.network.MessageMosquitoMountPlayer;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityEnderiophage
extends Animal
implements Enemy,
FlyingAnimal {
    private static final EntityDataAccessor<Float> PHAGE_PITCH = SynchedEntityData.defineId(EntityEnderiophage.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityEnderiophage.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> MISSING_EYE = SynchedEntityData.defineId(EntityEnderiophage.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> PHAGE_SCALE = SynchedEntityData.defineId(EntityEnderiophage.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntityEnderiophage.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Predicate<LivingEntity> ENDERGRADE_OR_INFECTED = entity -> entity instanceof EntityEndergrade || entity.hasEffect(AMEffectRegistry.ENDER_FLU);
    public float prevPhagePitch;
    public float tentacleAngle;
    public float lastTentacleAngle;
    public float phageRotation;
    public float prevFlyProgress;
    public float flyProgress;
    public int passengerIndex = 0;
    public float prevEnderiophageScale = 1.0f;
    private float rotationVelocity = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
    private int slowDownTicks = 0;
    private float randomMotionSpeed;
    private boolean isLandNavigator;
    private int timeFlying = 0;
    private int fleeAfterStealTime = 0;
    private int attachTime = 0;
    private int dismountCooldown = 0;
    private int squishCooldown = 0;
    private PathfinderMob angryEnderman = null;

    protected EntityEnderiophage(EntityType type, Level world) {
        super(type, world);
        this.switchNavigator(false);
        this.xpReward = 5;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, (double)0.15f).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public static boolean canEnderiophageSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return true;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.enderiophageSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    private void doInitialPosing(LevelAccessor world) {
        BlockPos down = this.getPhageGround(this.blockPosition());
        this.setPos((float)down.getX() + 0.5f, down.getY() + 1, (float)down.getZ() + 0.5f);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (reason == MobSpawnType.NATURAL) {
            this.doInitialPosing((LevelAccessor)worldIn);
        }
        this.setSkinForDimension();
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public float getPhageScale() {
        return ((Float)this.entityData.get(PHAGE_SCALE)).floatValue();
    }

    public void setPhageScale(float scale) {
        this.entityData.set(PHAGE_SCALE, (Object)Float.valueOf(scale));
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FlyTowardsTarget(this));
        this.goalSelector.addGoal(2, (Goal)new AIWalkIdle());
        this.targetSelector.addGoal(1, (Goal)new EntityAINearestTarget3D((Mob)this, EnderMan.class, 15, true, true, null){

            public boolean canUse() {
                return EntityEnderiophage.this.isMissingEye() && super.canUse();
            }

            public boolean canContinueToUse() {
                return EntityEnderiophage.this.isMissingEye() && super.canContinueToUse();
            }
        });
        this.targetSelector.addGoal(1, (Goal)new EntityAINearestTarget3D((Mob)this, LivingEntity.class, 15, true, true, ENDERGRADE_OR_INFECTED){

            public boolean canUse() {
                return !EntityEnderiophage.this.isMissingEye() && EntityEnderiophage.this.fleeAfterStealTime == 0 && super.canUse();
            }

            public boolean canContinueToUse() {
                return !EntityEnderiophage.this.isMissingEye() && super.canContinueToUse();
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EnderMan.class}));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigatorWide((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new FlightMoveController((Mob)this, 1.0f, false, true);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(PHAGE_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(PHAGE_SCALE, (Object)Float.valueOf(1.0f));
        builder.define(FLYING, (Object)false);
        builder.define(MISSING_EYE, (Object)false);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean isInOverworld() {
        return this.level().dimension() == Level.OVERWORLD && !this.isNoAi();
    }

    public boolean isInNether() {
        return this.level().dimension() == Level.NETHER && !this.isNoAi();
    }

    public void setStandardFleeTime() {
        this.fleeAfterStealTime = 20;
    }

    public void rideTick() {
        Entity entity = this.getVehicle();
        if (this.isPassenger() && !entity.isAlive()) {
            this.stopRiding();
        } else {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.tick();
            if (this.isPassenger()) {
                ++this.attachTime;
                Entity mount = this.getVehicle();
                if (mount instanceof LivingEntity) {
                    this.passengerIndex = mount.getPassengers().indexOf((Object)this);
                    this.yBodyRot = ((LivingEntity)mount).yBodyRot;
                    this.setYRot(((LivingEntity)mount).getYRot());
                    this.yHeadRot = ((LivingEntity)mount).yHeadRot;
                    this.yRotO = ((LivingEntity)mount).yHeadRot;
                    float radius = mount.getBbWidth();
                    float angle = (float)Math.PI / 180 * (((LivingEntity)mount).yBodyRot + (float)this.passengerIndex * 90.0f);
                    double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
                    double extraZ = radius * Mth.cos((float)angle);
                    this.setPos(mount.getX() + extraX, Math.max(mount.getY() + (double)(mount.getEyeHeight() * 0.25f), mount.getY()), mount.getZ() + extraZ);
                    if (!mount.isAlive() || mount instanceof Player && ((Player)mount).isCreative()) {
                        this.removeVehicle();
                    }
                    this.setPhagePitch(0.0f);
                    if (!this.level().isClientSide && this.attachTime > 15) {
                        LivingEntity target = (LivingEntity)mount;
                        float dmg = 1.0f;
                        if (target.getHealth() > target.getMaxHealth() * 0.2f) {
                            dmg = 6.0f;
                        }
                        if (((double)target.getHealth() < 1.5 || mount.hurt(this.damageSources().mobAttack((LivingEntity)this), dmg)) && mount instanceof LivingEntity) {
                            this.dismountCooldown = 100;
                            if (mount instanceof EnderMan) {
                                this.setMissingEye(false);
                                this.gameEvent((Holder)GameEvent.EAT);
                                this.playSound(SoundEvents.ENDER_EYE_DEATH, this.getSoundVolume(), this.getVoicePitch());
                                this.heal(5.0f);
                                ((EnderMan)mount).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 400));
                                this.fleeAfterStealTime = 400;
                                this.setFlying(true);
                                this.angryEnderman = (PathfinderMob)mount;
                            } else if (this.random.nextInt(3) == 0) {
                                if (!this.isMissingEye()) {
                                    if (target.getEffect(AMEffectRegistry.ENDER_FLU.getDelegate()) == null) {
                                        target.addEffect(new MobEffectInstance(AMEffectRegistry.ENDER_FLU.getDelegate(), 12000));
                                    } else {
                                        MobEffectInstance inst = target.getEffect(AMEffectRegistry.ENDER_FLU.getDelegate());
                                        int duration = 12000;
                                        int level = 0;
                                        if (inst != null) {
                                            duration = inst.getDuration();
                                            level = inst.getAmplifier();
                                        }
                                        target.removeEffect(AMEffectRegistry.ENDER_FLU.getDelegate());
                                        target.addEffect(new MobEffectInstance(AMEffectRegistry.ENDER_FLU.getDelegate(), duration, Math.min(level + 1, 4)));
                                    }
                                    this.heal(5.0f);
                                    this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                                    this.playSound(SoundEvents.ITEM_BREAK, this.getSoundVolume(), this.getVoicePitch());
                                    this.setMissingEye(true);
                                }
                                if (!this.level().isClientSide) {
                                    this.setTarget(null);
                                    this.setLastHurtMob(null);
                                    this.setLastHurtByMob(null);
                                    this.goalSelector.getAvailableGoals().forEach(w -> w.stop());
                                    this.targetSelector.getAvailableGoals().forEach(w -> w.stop());
                                }
                            }
                        }
                        if (((LivingEntity)mount).getHealth() <= 0.0f || this.fleeAfterStealTime > 0 || this.isMissingEye() && !(mount instanceof EnderMan) || !this.isMissingEye() && mount instanceof EnderMan) {
                            this.removeVehicle();
                            this.setTarget(null);
                            this.dismountCooldown = 100;
                            AlexsMobs.sendMSGToAll(new MessageMosquitoDismount(this.getId(), mount.getId()));
                            this.setFlying(true);
                        }
                    }
                }
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void onSpawnFromEffect() {
        this.prevEnderiophageScale = 0.2f;
        this.setPhageScale(0.2f);
    }

    public void setSkinForDimension() {
        if (this.isInNether()) {
            this.setVariant(2);
        } else if (this.isInOverworld()) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.ENDERIOPHAGE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.ENDERIOPHAGE_HURT.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)AMSoundRegistry.ENDERIOPHAGE_WALK.get(), 0.4f, 1.0f);
    }

    protected float nextStep() {
        return this.moveDist + 0.3f;
    }

    public void tick() {
        super.tick();
        this.prevEnderiophageScale = this.getPhageScale();
        float extraMotionSlow = 1.0f;
        float extraMotionSlowY = 1.0f;
        if (this.slowDownTicks > 0) {
            --this.slowDownTicks;
            extraMotionSlow = 0.33f;
            extraMotionSlowY = 0.1f;
        }
        if (this.dismountCooldown > 0) {
            --this.dismountCooldown;
        }
        if (this.squishCooldown > 0) {
            --this.squishCooldown;
        }
        if (!this.level().isClientSide) {
            if (!this.isPassenger() && this.attachTime != 0) {
                this.attachTime = 0;
            }
            if (this.fleeAfterStealTime > 0) {
                if (this.angryEnderman != null) {
                    Vec3 vec = this.getBlockInViewAway(this.angryEnderman.position(), 10.0f);
                    if (this.fleeAfterStealTime < 5) {
                        if (this.angryEnderman instanceof NeutralMob) {
                            ((NeutralMob)this.angryEnderman).stopBeingAngry();
                        }
                        try {
                            this.angryEnderman.goalSelector.getAvailableGoals().forEach(w -> w.stop());
                            this.angryEnderman.targetSelector.getAvailableGoals().forEach(w -> w.stop());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.angryEnderman = null;
                    }
                    if (vec != null) {
                        this.setFlying(true);
                        this.getMoveControl().setWantedPosition(vec.x, vec.y, vec.z, (double)1.3f);
                    }
                }
                --this.fleeAfterStealTime;
            }
        }
        this.yBodyRot = this.getYRot();
        this.yHeadRot = this.getYRot();
        this.setPhagePitch(-90.0f);
        if (this.isAlive() && this.isFlying() && this.randomMotionSpeed > 0.75f && this.getDeltaMovement().lengthSqr() > 0.02 && this.level().isClientSide) {
            float pitch = -this.getPhagePitch() / 90.0f;
            float radius = this.getBbWidth() * 0.2f * -pitch;
            float angle = (float)Math.PI / 180 * this.getYRot();
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraY = 0.2f - (1.0f - pitch) * 0.15f;
            double extraZ = radius * Mth.cos((float)angle);
            double motX = extraX * 8.0 + this.random.nextGaussian() * (double)0.05f;
            double motY = -0.1f;
            double motZ = extraZ + this.random.nextGaussian() * (double)0.05f;
            this.level().addParticle((ParticleOptions)AMParticleRegistry.DNA.get(), this.getX() + extraX, this.getY() + extraY, this.getZ() + extraZ, motX, motY, motZ);
        }
        this.prevPhagePitch = this.getPhagePitch();
        this.prevFlyProgress = this.flyProgress;
        if (this.isFlying()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        this.lastTentacleAngle = this.tentacleAngle;
        this.phageRotation += this.rotationVelocity;
        if ((double)this.phageRotation > Math.PI * 2) {
            if (this.level().isClientSide) {
                this.phageRotation = (float)Math.PI * 2;
            } else {
                this.phageRotation = (float)((double)this.phageRotation - Math.PI * 2);
                if (this.random.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)19);
            }
        }
        if (this.phageRotation < (float)Math.PI) {
            float f = this.phageRotation / (float)Math.PI;
            this.tentacleAngle = Mth.sin((float)(f * f * (float)Math.PI)) * 4.275f;
            if ((double)f > 0.75) {
                if (this.squishCooldown == 0 && this.isFlying()) {
                    this.squishCooldown = 20;
                    this.playSound((SoundEvent)AMSoundRegistry.ENDERIOPHAGE_SQUISH.get(), 3.0f, this.getVoicePitch());
                }
                this.randomMotionSpeed = 1.0f;
            } else {
                this.randomMotionSpeed = 0.01f;
            }
        }
        if (!this.level().isClientSide) {
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.isFlying()) {
                this.setDeltaMovement(this.getDeltaMovement().x * (double)this.randomMotionSpeed * (double)extraMotionSlow, this.getDeltaMovement().y * (double)this.randomMotionSpeed * (double)extraMotionSlowY, this.getDeltaMovement().z * (double)this.randomMotionSpeed * (double)extraMotionSlow);
                ++this.timeFlying;
                if (this.onGround() && this.timeFlying > 100) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
            }
            if (this.isMissingEye() && this.getTarget() != null && !(this.getTarget() instanceof EnderMan)) {
                this.setTarget(null);
            }
        }
        if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        if (this.isFlying()) {
            float phageDist = -((float)((Math.abs(this.getDeltaMovement().x()) + Math.abs(this.getDeltaMovement().z())) * 6.0));
            this.incrementPhagePitch(phageDist * 1.0f);
            this.setPhagePitch(Mth.clamp((float)this.getPhagePitch(), (float)-90.0f, (float)10.0f));
            float plateau = 2.0f;
            if (this.getPhagePitch() > plateau) {
                this.decrementPhagePitch(phageDist * Math.abs(this.getPhagePitch()) / 90.0f);
            }
            if (this.getPhagePitch() < -plateau) {
                this.incrementPhagePitch(phageDist * Math.abs(this.getPhagePitch()) / 90.0f);
            }
            if (this.getPhagePitch() > 2.0f) {
                this.decrementPhagePitch(1.0f);
            } else if (this.getPhagePitch() < -2.0f) {
                this.incrementPhagePitch(1.0f);
            }
            if (this.horizontalCollision) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)0.2f, 0.0));
            }
        } else {
            if (this.getPhagePitch() > 0.0f) {
                float decrease = Math.min(2.0f, this.getPhagePitch());
                this.decrementPhagePitch(decrease);
            }
            if (this.getPhagePitch() < 0.0f) {
                float decrease = Math.min(2.0f, -this.getPhagePitch());
                this.incrementPhagePitch(decrease);
            }
        }
        if (this.getPhageScale() < 1.0f) {
            this.setPhageScale(this.getPhageScale() + 0.05f);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Flying", this.isFlying());
        compound.putBoolean("MissingEye", this.isMissingEye());
        compound.putInt("Variant", this.getVariant());
        compound.putInt("SlowDownTicks", this.slowDownTicks);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFlying(compound.getBoolean("Flying"));
        this.setMissingEye(compound.getBoolean("MissingEye"));
        this.setVariant(compound.getInt("Variant"));
        this.slowDownTicks = compound.getInt("SlowDownTicks");
    }

    public boolean isMissingEye() {
        return (Boolean)this.entityData.get(MISSING_EYE);
    }

    public void setMissingEye(boolean missingEye) {
        this.entityData.set(MISSING_EYE, (Object)missingEye);
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    public void setFlying(boolean flying) {
        this.entityData.set(FLYING, (Object)flying);
    }

    public float getPhagePitch() {
        return ((Float)this.entityData.get(PHAGE_PITCH)).floatValue();
    }

    public void setPhagePitch(float pitch) {
        this.entityData.set(PHAGE_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementPhagePitch(float pitch) {
        this.entityData.set(PHAGE_PITCH, (Object)Float.valueOf(this.getPhagePitch() + pitch));
    }

    public void decrementPhagePitch(float pitch) {
        this.entityData.set(PHAGE_PITCH, (Object)Float.valueOf(this.getPhagePitch() - pitch));
    }

    protected float getStandingEyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        return 1.8f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.blockPosition();
        while (position.getY() > -63 && !this.level().getBlockState(position).isSolid()) {
            position = position.below();
        }
        return !this.level().getFluidState(position).isEmpty() || position.getY() < -63;
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = -9.45f - (float)this.getRandom().nextInt(24) - radiusAdd;
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), 0, (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getPhageGround(radialPos);
        int distFromGround = (int)this.getY() - ground.getY();
        int flightHeight = 6 + this.getRandom().nextInt(10);
        BlockPos newPos = ground.above(distFromGround > 8 || this.fleeAfterStealTime > 0 ? flightHeight : this.getRandom().nextInt(6) + 5);
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)newPos);
        }
        return null;
    }

    private BlockPos getPhageGround(BlockPos in) {
        BlockPos position = new BlockPos(in.getX(), (int)this.getY(), in.getZ());
        while (position.getY() > -63 && !this.level().getBlockState(position).isSolid()) {
            position = position.below();
        }
        if (position.getY() < -62) {
            return position.above(120 + this.random.nextInt(5));
        }
        return position;
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = -9.45f - (float)this.getRandom().nextInt(24);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = AMBlockPos.fromCoords(fleePos.x() + extraX, this.getY(), fleePos.z() + extraZ);
        BlockPos ground = this.getPhageGround(radialPos);
        if (ground.getY() <= -63) {
            return Vec3.upFromBottomCenterOf((Vec3i)ground, (double)(110 + this.random.nextInt(20)));
        }
        ground = this.blockPosition();
        while (ground.getY() > -63 && !this.level().getBlockState(ground).isSolid()) {
            ground = ground.below();
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
            return Vec3.atCenterOf((Vec3i)ground);
        }
        return null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof EnderMan) {
            amount = (amount + 1.0f) * 0.35f;
            this.angryEnderman = (EnderMan)entity;
        }
        return super.hurt(source, amount);
    }

    public static class FlyTowardsTarget
    extends Goal {
        private final EntityEnderiophage parentEntity;

        public FlyTowardsTarget(EntityEnderiophage phage) {
            this.parentEntity = phage;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !this.parentEntity.isPassenger() && this.parentEntity.getTarget() != null && !this.isBittenByPhage((Entity)this.parentEntity.getTarget()) && this.parentEntity.fleeAfterStealTime == 0;
        }

        public boolean canContinueToUse() {
            return this.parentEntity.getTarget() != null && !this.isBittenByPhage((Entity)this.parentEntity.getTarget()) && !this.parentEntity.horizontalCollision && !this.parentEntity.isPassenger() && this.parentEntity.isFlying() && this.parentEntity.getMoveControl().hasWanted() && this.parentEntity.fleeAfterStealTime == 0 && (this.parentEntity.getTarget() instanceof EnderMan || !this.parentEntity.isMissingEye());
        }

        public boolean isBittenByPhage(Entity entity) {
            int phageCount = 0;
            for (Entity e : entity.getPassengers()) {
                if (!(e instanceof EntityEnderiophage)) continue;
                ++phageCount;
            }
            return phageCount > 3;
        }

        public void stop() {
        }

        public void tick() {
            if (this.parentEntity.getTarget() != null) {
                boolean isWithinReach;
                float width = this.parentEntity.getTarget().getBbWidth() + this.parentEntity.getBbWidth() + 2.0f;
                boolean bl = isWithinReach = this.parentEntity.distanceToSqr((Entity)this.parentEntity.getTarget()) < (double)(width * width);
                if (this.parentEntity.isFlying() || isWithinReach) {
                    this.parentEntity.getMoveControl().setWantedPosition(this.parentEntity.getTarget().getX(), this.parentEntity.getTarget().getY(), this.parentEntity.getTarget().getZ(), isWithinReach ? 1.6 : 1.0);
                } else {
                    this.parentEntity.getNavigation().moveTo(this.parentEntity.getTarget().getX(), this.parentEntity.getTarget().getY(), this.parentEntity.getTarget().getZ(), 1.2);
                }
                if (this.parentEntity.getTarget().getY() > this.parentEntity.getY() + (double)1.2f) {
                    this.parentEntity.setFlying(true);
                }
                if (this.parentEntity.dismountCooldown == 0 && this.parentEntity.getBoundingBox().inflate(0.3, 0.3, 0.3).intersects(this.parentEntity.getTarget().getBoundingBox()) && !this.isBittenByPhage((Entity)this.parentEntity.getTarget())) {
                    this.parentEntity.startRiding((Entity)this.parentEntity.getTarget(), true);
                    if (!this.parentEntity.level().isClientSide) {
                        AlexsMobs.sendMSGToAll(new MessageMosquitoMountPlayer(this.parentEntity.getId(), this.parentEntity.getTarget().getId()));
                    }
                }
            }
        }
    }

    private class AIWalkIdle
    extends Goal {
        protected final EntityEnderiophage phage;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public AIWalkIdle() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.phage = EntityEnderiophage.this;
        }

        public boolean canUse() {
            Vec3 lvt_1_1_;
            if (this.phage.isVehicle() || this.phage.getTarget() != null && this.phage.getTarget().isAlive() || this.phage.isPassenger()) {
                return false;
            }
            if (this.phage.getRandom().nextInt(30) != 0 && !this.phage.isFlying() && this.phage.fleeAfterStealTime == 0) {
                return false;
            }
            if (this.phage.onGround()) {
                this.flightTarget = EntityEnderiophage.this.random.nextInt(12) == 0;
            } else {
                boolean bl = this.flightTarget = EntityEnderiophage.this.random.nextInt(5) > 0 && this.phage.timeFlying < 100;
            }
            if (this.phage.fleeAfterStealTime > 0) {
                this.flightTarget = true;
            }
            if ((lvt_1_1_ = this.getPosition()) == null) {
                return false;
            }
            this.x = lvt_1_1_.x;
            this.y = lvt_1_1_.y;
            this.z = lvt_1_1_.z;
            return true;
        }

        public void tick() {
            if (this.flightTarget) {
                this.phage.getMoveControl().setWantedPosition(this.x, this.y, this.z, EntityEnderiophage.this.fleeAfterStealTime == 0 ? (double)1.3f : 1.0);
            } else {
                this.phage.getNavigation().moveTo(this.x, this.y, this.z, EntityEnderiophage.this.fleeAfterStealTime == 0 ? (double)1.3f : 1.0);
            }
            if (!this.flightTarget && EntityEnderiophage.this.isFlying() && this.phage.onGround()) {
                this.phage.setFlying(false);
            }
            if (EntityEnderiophage.this.isFlying() && this.phage.onGround() && this.phage.timeFlying > 100 && this.phage.fleeAfterStealTime == 0) {
                this.phage.setFlying(false);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.phage.position();
            if (this.phage.isOverWaterOrVoid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.phage.timeFlying < 50 || EntityEnderiophage.this.fleeAfterStealTime > 0 || this.phage.isOverWaterOrVoid()) {
                    return this.phage.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.phage.getBlockGrounding(vector3d);
            }
            return LandRandomPos.getPos((PathfinderMob)this.phage, (int)10, (int)7);
        }

        public boolean canContinueToUse() {
            if (this.flightTarget) {
                return this.phage.isFlying() && this.phage.distanceToSqr(this.x, this.y, this.z) > 2.0;
            }
            return !this.phage.getNavigation().isDone() && !this.phage.isVehicle();
        }

        public void start() {
            if (this.flightTarget) {
                this.phage.setFlying(true);
                this.phage.getMoveControl().setWantedPosition(this.x, this.y, this.z, EntityEnderiophage.this.fleeAfterStealTime == 0 ? (double)1.3f : 1.0);
            } else {
                this.phage.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
        }

        public void stop() {
            this.phage.getNavigation().stop();
            super.stop();
        }
    }
}

