/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.ElephantAIFollowCaravan;
import com.github.alexthe666.alexsmobs.entity.ai.ElephantAIForageLeaves;
import com.github.alexthe666.alexsmobs.entity.ai.ElephantAIVillagerRide;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;

public class EntityElephant
extends TamableAnimal
implements ITargetsDroppedItems,
IAnimatedEntity {
    public static final Animation ANIMATION_TRUMPET_0 = Animation.create((int)20);
    public static final Animation ANIMATION_TRUMPET_1 = Animation.create((int)30);
    public static final Animation ANIMATION_CHARGE_PREPARE = Animation.create((int)25);
    public static final Animation ANIMATION_STOMP = Animation.create((int)20);
    public static final Animation ANIMATION_FLING = Animation.create((int)25);
    public static final Animation ANIMATION_EAT = Animation.create((int)30);
    public static final Animation ANIMATION_BREAKLEAVES = Animation.create((int)20);
    protected static final EntityDimensions TUSKED_SIZE = EntityDimensions.fixed((float)3.7f, (float)3.75f);
    private static final EntityDataAccessor<Boolean> TUSKED = SynchedEntityData.defineId(EntityElephant.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityElephant.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.defineId(EntityElephant.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.defineId(EntityElephant.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> CARPET_COLOR = SynchedEntityData.defineId(EntityElephant.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> TRADER = SynchedEntityData.defineId(EntityElephant.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final Map<DyeColor, Item> DYE_COLOR_ITEM_MAP = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(DyeColor.WHITE, Items.WHITE_CARPET);
        map.put(DyeColor.ORANGE, Items.ORANGE_CARPET);
        map.put(DyeColor.MAGENTA, Items.MAGENTA_CARPET);
        map.put(DyeColor.LIGHT_BLUE, Items.LIGHT_BLUE_CARPET);
        map.put(DyeColor.YELLOW, Items.YELLOW_CARPET);
        map.put(DyeColor.LIME, Items.LIME_CARPET);
        map.put(DyeColor.PINK, Items.PINK_CARPET);
        map.put(DyeColor.GRAY, Items.GRAY_CARPET);
        map.put(DyeColor.LIGHT_GRAY, Items.LIGHT_GRAY_CARPET);
        map.put(DyeColor.CYAN, Items.CYAN_CARPET);
        map.put(DyeColor.PURPLE, Items.PURPLE_CARPET);
        map.put(DyeColor.BLUE, Items.BLUE_CARPET);
        map.put(DyeColor.BROWN, Items.BROWN_CARPET);
        map.put(DyeColor.GREEN, Items.GREEN_CARPET);
        map.put(DyeColor.RED, Items.RED_CARPET);
        map.put(DyeColor.BLACK, Items.BLACK_CARPET);
    });
    private static final ResourceLocation TRADER_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"gameplay/trader_elephant_chest");
    public boolean forcedSit = false;
    public float prevSitProgress;
    public float sitProgress;
    public float prevStandProgress;
    public float standProgress;
    public int maxStandTime = 75;
    public boolean aiItemFlag = false;
    public SimpleContainer elephantInventory;
    private int animationTick;
    private Animation currentAnimation;
    private final boolean hasTuskedAttributes = false;
    private int standingTime = 0;
    @Nullable
    private EntityElephant caravanHead;
    @Nullable
    private EntityElephant caravanTail;
    private boolean hasChestVarChanged = false;
    private boolean hasChargedSpeed = false;
    private boolean charging;
    private int chargeCooldown = 0;
    private int chargingTicks = 0;
    @Nullable
    private UUID blossomThrowerUUID = null;
    private int despawnDelay = 47999;

    protected EntityElephant(EntityType type, Level world) {
        super(type, world);
        this.initElephantInventory();
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 85.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.9f).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.35f);
    }

    @Nullable
    public static DyeColor getCarpetColor(ItemStack stack) {
        Block lvt_1_1_ = Block.byItem((Item)stack.getItem());
        return lvt_1_1_ instanceof WoolCarpetBlock ? ((WoolCarpetBlock)lvt_1_1_).getColor() : null;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.ELEPHANT_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.ELEPHANT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.ELEPHANT_DIE.get();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.elephantSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    private void initElephantInventory() {
        SimpleContainer animalchest = this.elephantInventory;
        this.elephantInventory = new SimpleContainer(54){

            public boolean stillValid(Player player) {
                return EntityElephant.this.isAlive() && EntityElephant.this.portalProcess == null;
            }
        };
        if (animalchest != null) {
            int i = Math.min(animalchest.getContainerSize(), this.elephantInventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.elephantInventory.setItem(j, itemstack.copy());
            }
        }
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new AdvancedPathNavigateNoTeleport((Mob)this, worldIn, true);
    }

    public int getMaxHeadYRot() {
        return super.getMaxHeadYRot();
    }

    protected boolean isImmobile() {
        return super.isImmobile() || this.isSitting() || this.getAnimation() == ANIMATION_CHARGE_PREPARE && this.getAnimationTick() < 10;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal());
        this.goalSelector.addGoal(2, (Goal)new ElephantAIVillagerRide(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(AMTagRegistry.ELEPHANT_TAMEABLES), false));
        this.goalSelector.addGoal(5, (Goal)new ElephantAIForageLeaves(this));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new ElephantAIFollowCaravan(this, 0.5));
        this.goalSelector.addGoal(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, Bee.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(9, (Goal)new AIWalkIdle(this, 0.5));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal().setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, new CreatureAITargetItems((PathfinderMob)this, false));
    }

    public boolean isFood(ItemStack stack) {
        Item item = stack.getItem();
        return this.isTame() && stack.is(AMTagRegistry.ELEPHANT_BREEDABLES);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (!this.isBaby()) {
            this.playSound((SoundEvent)AMSoundRegistry.ELEPHANT_WALK.get(), 0.2f, 1.0f);
        } else {
            super.playStepSound(pos, state);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.getPassengers()) {
            if (!(passenger instanceof Player)) continue;
            return (LivingEntity)passenger;
        }
        return null;
    }

    @Nullable
    public AbstractVillager getControllingVillager() {
        for (Entity passenger : this.getPassengers()) {
            if (!(passenger instanceof AbstractVillager)) continue;
            return (AbstractVillager)passenger;
        }
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TUSKED, (Object)false);
        builder.define(SITTING, (Object)false);
        builder.define(STANDING, (Object)false);
        builder.define(CHESTED, (Object)false);
        builder.define(TRADER, (Object)false);
        builder.define(CARPET_COLOR, (Object)-1);
    }

    public void tick() {
        Player rider;
        super.tick();
        this.prevSitProgress = this.sitProgress;
        this.prevStandProgress = this.standProgress;
        if (this.isSitting()) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isStanding()) {
            if (this.standProgress < 5.0f) {
                this.standProgress += 0.5f;
            }
        } else if (this.standProgress > 0.0f) {
            this.standProgress -= 0.5f;
        }
        if (this.isStanding() && ++this.standingTime > this.maxStandTime) {
            this.setStanding(false);
            this.standingTime = 0;
            this.maxStandTime = 75 + this.random.nextInt(50);
        }
        if (this.isSitting() && this.isStanding()) {
            this.setStanding(false);
        }
        if (this.hasChestVarChanged && this.elephantInventory != null && !this.isChested()) {
            for (int i = 3; i < 18; ++i) {
                if (this.elephantInventory.getItem(i).isEmpty()) continue;
                if (!this.level().isClientSide) {
                    this.spawnAtLocation(this.elephantInventory.getItem(i), 1.0f);
                }
                this.elephantInventory.removeItemNoUpdate(i);
            }
            this.hasChestVarChanged = false;
        }
        if (this.isTusked() && !this.isBaby()) {
            this.refreshDimensions();
        }
        if (this.charging) {
            ++this.chargingTicks;
        }
        if (!this.getMainHandItem().isEmpty() && this.canTargetItem(this.getMainHandItem())) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_EAT);
            }
            if (this.getAnimation() == ANIMATION_EAT && this.getAnimationTick() == 17) {
                this.eatItemEffect(this.getMainHandItem());
                if (this.getMainHandItem().is(AMTagRegistry.ELEPHANT_TAMEABLES) && !this.isTame() && (!this.isTusked() || this.isBaby()) && this.blossomThrowerUUID != null) {
                    if (this.random.nextInt(3) == 0) {
                        this.setTame(true, true);
                        this.setOwnerUUID(this.blossomThrowerUUID);
                        Player player = this.level().getPlayerByUUID(this.blossomThrowerUUID);
                        if (player != null) {
                            this.tame(player);
                        }
                        for (Entity passenger : this.getPassengers()) {
                            passenger.removeVehicle();
                        }
                        this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    }
                }
                this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                this.heal(10.0f);
            }
        }
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        this.chargingTicks = this.charging ? ++this.chargingTicks : 0;
        if (this.getAnimation() == ANIMATION_CHARGE_PREPARE) {
            this.yBodyRot = this.getYRot();
            if (this.getAnimationTick() == 20) {
                this.charging = true;
            }
        }
        if (this.getControllingPassenger() != null && this.charging && this.chargingTicks > 100) {
            this.charging = false;
            this.chargeCooldown = 200;
        }
        LivingEntity target = this.getTarget();
        double maxAttackMod = 0.0;
        if (this.getControllingPassenger() != null && this.getControllingPassenger() instanceof Player && (rider = (Player)this.getControllingPassenger()).getLastHurtMob() != null && !this.isAlliedTo((Entity)rider.getLastHurtMob())) {
            UUID preyUUID = rider.getLastHurtMob().getUUID();
            if (!this.getUUID().equals(preyUUID)) {
                target = rider.getLastHurtMob();
                maxAttackMod = 4.0;
            }
        }
        if (!this.level().isClientSide && target != null) {
            double dist;
            if (this.distanceTo((Entity)target) > this.getBbWidth() * 0.5f + 0.5f && this.getControllingPassenger() == null && this.isTusked() && this.hasLineOfSight((Entity)target) && this.getAnimation() == NO_ANIMATION && !this.charging && this.chargeCooldown == 0) {
                this.setAnimation(ANIMATION_CHARGE_PREPARE);
            }
            if (this.getAnimation() == ANIMATION_CHARGE_PREPARE && this.getControllingPassenger() == null) {
                this.lookAt((Entity)target, 360.0f, 30.0f);
                this.yBodyRot = this.getYRot();
                if (this.getAnimationTick() == 20) {
                    this.charging = true;
                }
            }
            if ((double)this.distanceTo((Entity)target) < 10.0 && this.charging) {
                this.setAnimation(ANIMATION_FLING);
            }
            if ((double)this.distanceTo((Entity)target) < 2.1 && this.charging) {
                target.knockback(1.0, target.getX() - this.getX(), target.getZ() - this.getZ());
                target.hasImpulse = true;
                target.setDeltaMovement(target.getDeltaMovement().add(0.0, (double)0.7f, 0.0));
                target.hurt(this.damageSources().mobAttack((LivingEntity)this), 2.4f * (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
                this.launch((Entity)target, true);
                this.charging = false;
                this.chargeCooldown = 400;
            }
            if ((dist = (double)this.distanceTo((Entity)target)) < 4.5 + maxAttackMod && this.getAnimation() == ANIMATION_FLING && this.getAnimationTick() == 15) {
                target.knockback(1.0, target.getX() - this.getX(), target.getZ() - this.getZ());
                target.setDeltaMovement(target.getDeltaMovement().add(0.0, (double)0.3f, 0.0));
                this.launch((Entity)target, false);
                target.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
            }
            if (dist < 4.5 + maxAttackMod && this.getAnimation() == ANIMATION_STOMP && this.getAnimationTick() == 17) {
                target.knockback((double)0.3f, target.getX() - this.getX(), target.getZ() - this.getZ());
                target.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
            }
        }
        if (!this.level().isClientSide && this.getTarget() == null && this.getControllingPassenger() == null) {
            this.charging = false;
        }
        if (this.charging && !this.hasChargedSpeed) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)0.65f);
            this.hasChargedSpeed = true;
        }
        if (!this.charging && this.hasChargedSpeed) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)0.35f);
            this.hasChargedSpeed = false;
        }
        if (!this.level().isClientSide && this.getRandom().nextInt(400) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.getRandom().nextBoolean() ? ANIMATION_TRUMPET_0 : ANIMATION_TRUMPET_1);
        }
        if (this.getAnimation() == ANIMATION_TRUMPET_0 && this.getAnimationTick() == 8 || this.getAnimation() == ANIMATION_TRUMPET_1 && this.getAnimationTick() == 4) {
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound((SoundEvent)AMSoundRegistry.ELEPHANT_TRUMPET.get(), this.getSoundVolume(), this.getVoicePitch());
        }
        if (this.isAlive() && this.charging) {
            for (Entity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(1.0))) {
                if (this.isTame() && this.isAlliedTo(entity) || !this.isTame() && entity instanceof EntityElephant || entity == this) continue;
                entity.hurt(this.damageSources().mobAttack((LivingEntity)this), 8.0f + this.random.nextFloat() * 8.0f);
                this.launch(entity, true);
            }
        }
        if (!this.isTame() && this.isTrader() && !this.level().isClientSide) {
            this.tryDespawn();
        }
        if (this.getTarget() != null && !this.getTarget().isAlive()) {
            this.setTarget(null);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isBaby() && this.getEyeHeight() > this.getBbHeight()) {
            this.refreshDimensions();
        }
    }

    private boolean canDespawn() {
        return !this.isTame() && this.isTrader();
    }

    private void tryDespawn() {
        if (this.canDespawn()) {
            int riderDelay;
            if (this.getControllingVillager() instanceof WanderingTrader && (riderDelay = ((WanderingTrader)this.getControllingVillager()).getDespawnDelay()) > 0) {
                this.despawnDelay = riderDelay;
            }
            --this.despawnDelay;
            if (this.despawnDelay <= 0) {
                this.dropLeash(true, false);
                this.elephantInventory.clearContent();
                if (this.getControllingVillager() != null) {
                    this.getControllingVillager().remove(Entity.RemovalReason.DISCARDED);
                }
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private void launch(Entity e, boolean huge) {
        if (e.onGround()) {
            double d0 = e.getX() - this.getX();
            double d1 = e.getZ() - this.getZ();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = huge ? 2.0f : 0.5f;
            e.push(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
        }
    }

    private void eatItemEffect(ItemStack heldItemMainhand) {
        this.gameEvent((Holder)GameEvent.EAT);
        this.playSound(SoundEvents.STRIDER_EAT, this.getVoicePitch(), this.getSoundVolume());
        for (int i = 0; i < 8 + this.random.nextInt(3); ++i) {
            double d2 = this.random.nextGaussian() * 0.02;
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            float radius = this.getBbWidth() * 0.65f;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, heldItemMainhand);
            if (heldItemMainhand.getItem() instanceof BlockItem) {
                data = new BlockParticleOption(ParticleTypes.BLOCK, ((BlockItem)heldItemMainhand.getItem()).getBlock().defaultBlockState());
            }
            this.level().addParticle((ParticleOptions)data, this.getX() + extraX, this.getY() + (double)(this.getBbHeight() * 0.6f), this.getZ() + extraZ, d0, d1, d2);
        }
    }

    private boolean isChargePlayer(Entity controllingPassenger) {
        return true;
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION && !this.charging) {
            this.setAnimation(this.random.nextBoolean() ? ANIMATION_FLING : ANIMATION_STOMP);
        }
        return true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        boolean owner = this.isTame() && this.isOwnedBy((LivingEntity)player);
        InteractionResult type = super.mobInteract(player, hand);
        if (this.isChested() && player.isShiftKeyDown()) {
            this.openGUI(player);
            return InteractionResult.SUCCESS;
        }
        if (this.canTargetItem(stack) && this.getMainHandItem().isEmpty()) {
            ItemStack rippedStack = stack.copy();
            rippedStack.setCount(1);
            stack.shrink(1);
            this.setItemInHand(InteractionHand.MAIN_HAND, rippedStack);
            if (rippedStack.is(AMTagRegistry.ELEPHANT_TAMEABLES)) {
                this.blossomThrowerUUID = player.getUUID();
            }
            return InteractionResult.SUCCESS;
        }
        if (owner && stack.is(ItemTags.WOOL_CARPETS)) {
            DyeColor color = EntityElephant.getCarpetColor(stack);
            if (color != this.getColor()) {
                if (this.getColor() != null) {
                    this.spawnAtLocation((ItemLike)this.getCarpetItemBeingWorn());
                }
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                this.playSound((SoundEvent)SoundEvents.LLAMA_SWAG.value(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                if (!this.level().isClientSide && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.ELEPHANT_SWAG.get())).trigger(serverPlayer);
                }
                stack.shrink(1);
                this.setColor(color);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (owner && this.getColor() != null && stack.getItem() instanceof ShearsItem) {
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            if (this.getColor() != null) {
                this.spawnAtLocation((ItemLike)this.getCarpetItemBeingWorn());
            }
            this.setColor(null);
            return InteractionResult.SUCCESS;
        }
        if (owner && !this.isChested() && stack.is(Tags.Items.CHESTS_WOODEN)) {
            this.setChested(true);
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEvents.DONKEY_CHEST, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (owner && this.isChested() && stack.getItem() instanceof ShearsItem) {
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.spawnAtLocation((ItemLike)Blocks.CHEST);
            for (int i = 0; i < this.elephantInventory.getContainerSize(); ++i) {
                this.spawnAtLocation(this.elephantInventory.getItem(i));
            }
            this.elephantInventory.clearContent();
            this.setChested(false);
            return InteractionResult.SUCCESS;
        }
        if (owner && !this.isBaby() && type != InteractionResult.CONSUME) {
            if (!this.level().isClientSide) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_TRUMPET_0, ANIMATION_TRUMPET_1, ANIMATION_CHARGE_PREPARE, ANIMATION_STOMP, ANIMATION_FLING, ANIMATION_EAT, ANIMATION_BREAKLEAVES};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Item getCarpetItemBeingWorn() {
        if (this.getColor() != null) {
            return DYE_COLOR_ITEM_MAP.get(this.getColor());
        }
        return Items.AIR;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isChested()) {
            if (!this.level().isClientSide) {
                this.spawnAtLocation((ItemLike)Blocks.CHEST);
            }
            for (int i = 0; i < this.elephantInventory.getContainerSize(); ++i) {
                this.spawnAtLocation(this.elephantInventory.getItem(i));
            }
            this.elephantInventory.clearContent();
            this.setChested(false);
        }
        if (!this.isTrader() && this.getColor() != null) {
            if (!this.level().isClientSide) {
                this.spawnAtLocation((ItemLike)this.getCarpetItemBeingWorn());
            }
            this.setColor(null);
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityElephant baby = (EntityElephant)((EntityType)AMEntityRegistry.ELEPHANT.get()).create((Level)serverWorld);
        baby.setTusked(this.getNearestTusked((LevelAccessor)this.level(), 15.0) == null || this.random.nextInt(2) == 0);
        return baby;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Tusked", this.isTusked());
        compound.putBoolean("ElephantSitting", this.isSitting());
        compound.putBoolean("Standing", this.isStanding());
        compound.putBoolean("Chested", this.isChested());
        compound.putBoolean("Trader", this.isTrader());
        compound.putBoolean("ForcedToSit", this.forcedSit);
        compound.putBoolean("Tamed", this.isTame());
        compound.putInt("ChargeCooldown", this.chargeCooldown);
        compound.putInt("Carpet", ((Integer)this.entityData.get(CARPET_COLOR)).intValue());
        compound.putInt("DespawnDelay", this.despawnDelay);
        if (this.elephantInventory != null) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.elephantInventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.elephantInventory.getItem(i);
                if (itemstack.isEmpty()) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                CompoundNBT.putByte("Slot", (byte)i);
                itemstack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)CompoundNBT);
                nbttaglist.add((Object)CompoundNBT);
            }
            compound.put("Items", (Tag)nbttaglist);
        }
    }

    public boolean canBeAffected(MobEffectInstance potioneffectIn) {
        if (potioneffectIn.getEffect() == MobEffects.WITHER) {
            return false;
        }
        return super.canBeAffected(potioneffectIn);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setTame(compound.getBoolean("Tamed"), false);
        this.setTusked(compound.getBoolean("Tusked"));
        this.setStanding(compound.getBoolean("Standing"));
        this.setOrderedToSit(compound.getBoolean("ElephantSitting"));
        this.setChested(compound.getBoolean("Chested"));
        this.setTrader(compound.getBoolean("Trader"));
        this.forcedSit = compound.getBoolean("ForcedToSit");
        this.chargeCooldown = compound.getInt("ChargeCooldown");
        this.entityData.set(CARPET_COLOR, (Object)compound.getInt("Carpet"));
        if (this.elephantInventory != null) {
            ListTag nbttaglist = compound.getList("Items", 10);
            this.initElephantInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag CompoundNBT = nbttaglist.getCompound(i);
                int j = CompoundNBT.getByte("Slot") & 0xFF;
                this.elephantInventory.setItem(j, ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)CompoundNBT));
            }
        } else {
            ListTag nbttaglist = compound.getList("Items", 10);
            this.initElephantInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag CompoundNBT = nbttaglist.getCompound(i);
                int j = CompoundNBT.getByte("Slot") & 0xFF;
                this.initElephantInventory();
                this.elephantInventory.setItem(j, ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)CompoundNBT));
            }
        }
        if (compound.contains("DespawnDelay", 99)) {
            this.despawnDelay = compound.getInt("DespawnDelay");
        }
    }

    public boolean isChested() {
        return (Boolean)this.entityData.get(CHESTED);
    }

    public void setChested(boolean chested) {
        this.entityData.set(CHESTED, (Object)chested);
        this.hasChestVarChanged = true;
    }

    public boolean setSlot(int inventorySlot, @Nullable ItemStack itemStackIn) {
        int j = inventorySlot - 500 + 2;
        if (j >= 0 && j < this.elephantInventory.getContainerSize()) {
            this.elephantInventory.setItem(j, itemStackIn);
            return true;
        }
        return false;
    }

    public void die(DamageSource cause) {
        super.die(cause);
        if (this.elephantInventory != null && !this.level().isClientSide) {
            for (int i = 0; i < this.elephantInventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.elephantInventory.getItem(i);
                if (itemstack.isEmpty()) continue;
                this.spawnAtLocation(itemstack, 0.0f);
            }
        }
    }

    public boolean isStanding() {
        return (Boolean)this.entityData.get(STANDING);
    }

    public void setStanding(boolean standing) {
        this.entityData.set(STANDING, (Object)standing);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    @Nullable
    public DyeColor getColor() {
        int lvt_1_1_ = (Integer)this.entityData.get(CARPET_COLOR);
        return lvt_1_1_ == -1 ? null : DyeColor.byId((int)lvt_1_1_);
    }

    public void setColor(@Nullable DyeColor color) {
        this.entityData.set(CARPET_COLOR, (Object)(color == null ? -1 : color.getId()));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (spawnDataIn instanceof AgeableMob.AgeableMobGroupData) {
            AgeableMob.AgeableMobGroupData lvt_6_1_ = (AgeableMob.AgeableMobGroupData)spawnDataIn;
            if (lvt_6_1_.getGroupSize() == 0) {
                this.setTusked(true);
            }
        } else {
            this.setTusked(this.getRandom().nextBoolean());
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    @Nullable
    public EntityElephant getNearestTusked(LevelAccessor world, double dist) {
        List list = world.getEntitiesOfClass(this.getClass(), this.getBoundingBox().inflate(dist, dist / 2.0, dist));
        if (list.isEmpty()) {
            return null;
        }
        EntityElephant elephant1 = null;
        double d0 = Double.MAX_VALUE;
        for (EntityElephant elephant : list) {
            double d1;
            if (!elephant.isTusked() || (d1 = this.distanceToSqr((Entity)elephant)) > d0) continue;
            d0 = d1;
            elephant1 = elephant;
        }
        return elephant1;
    }

    public boolean isTusked() {
        return (Boolean)this.entityData.get(TUSKED);
    }

    public void setTusked(boolean tusked) {
        boolean prev = this.isTusked();
        if (!prev && tusked) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(110.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(15.0);
            this.setHealth(150.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(85.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(10.0);
        }
        this.entityData.set(TUSKED, (Object)tusked);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.is(AMTagRegistry.ELEPHANT_FOODSTUFFS);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack duplicate = e.getItem().copy();
        duplicate.setCount(1);
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
        }
        Entity itemThrower = e.getOwner();
        this.blossomThrowerUUID = duplicate.is(AMTagRegistry.ELEPHANT_TAMEABLES) && itemThrower != null ? itemThrower.getUUID() : null;
        this.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
        this.aiItemFlag = false;
    }

    @Override
    public void onFindTarget(ItemEntity e) {
        this.aiItemFlag = true;
    }

    public void addElephantLoot(@Nullable Player player, int seed) {
        if (this.level().getServer() != null) {
            LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)TRADER_LOOT));
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.level());
            loottable.fill((Container)this.elephantInventory, lootcontext$builder.create(LootContextParamSets.EMPTY), (long)seed);
        }
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(EntityElephant caravanHeadIn) {
        this.caravanHead = caravanHeadIn;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTrail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public EntityElephant getCaravanHead() {
        return this.caravanHead;
    }

    @Override
    public double getMaxDistToItem() {
        return Math.pow(this.getBbWidth() + 3.0f, 2.0);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        if (this.hasPassenger(passenger)) {
            float sinWave;
            float standAdd = -0.3f * this.standProgress;
            float scale = this.isBaby() ? 0.5f : (this.isTusked() ? 1.1f : 1.0f);
            float sitAdd = -0.065f * this.sitProgress;
            float scaleY = scale * (2.4f * sitAdd - 0.4f * standAdd);
            if (passenger instanceof AbstractVillager) {
                AbstractVillager villager = (AbstractVillager)passenger;
                scaleY -= 0.3f;
            }
            float radius = scale * (0.5f + standAdd);
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            if (this.getAnimation() == ANIMATION_CHARGE_PREPARE) {
                sinWave = Mth.sin((float)((float)(Math.PI * (double)((float)this.getAnimationTick() / 25.0f))));
                radius += sinWave * 0.2f * scale;
            }
            if (this.getAnimation() == ANIMATION_STOMP) {
                sinWave = Mth.sin((float)((float)(Math.PI * (double)((float)this.getAnimationTick() / 20.0f))));
                radius -= sinWave * 1.0f * scale;
                scaleY += sinWave * 0.7f * scale;
            }
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            passenger.setPos(this.getX() + extraX, this.getY() + (double)this.getBbHeight() * 0.75 + (double)scaleY + 0.0, this.getZ() + extraZ);
        }
    }

    protected Vec3 getRiddenInput(Player player, Vec3 deltaIn) {
        if (player.zza != 0.0f) {
            float f = player.zza < 0.0f ? 0.5f : 1.0f;
            return new Vec3((double)(player.xxa * 0.25f), 0.0, (double)(player.zza * 0.5f * f));
        }
        this.setSprinting(false);
        return Vec3.ZERO;
    }

    protected void tickRidden(Player player, Vec3 vec3) {
        super.tickRidden(player, vec3);
        if (player.zza != 0.0f || player.xxa != 0.0f) {
            this.setRot(player.getYRot(), player.getXRot() * 0.25f);
            this.yBodyRot = this.yHeadRot = this.getYRot();
            this.yRotO = this.yHeadRot;
            this.getNavigation().stop();
            this.setTarget(null);
            this.setSprinting(true);
        }
    }

    protected float getRiddenSpeed(Player rider) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    public double getPassengersRidingOffset() {
        float scale = this.isBaby() ? 0.5f : (this.isTusked() ? 1.1f : 1.0f);
        float f = Math.min(0.25f, this.walkAnimation.speed());
        float f1 = this.walkAnimation.position();
        float sitAdd = 0.0f;
        float standAdd = 0.0f;
        return (double)this.getBbHeight() - (double)0.05f - (double)scale * ((double)(0.1f * Mth.cos((float)(f1 * 1.4f)) * 1.4f * f) + (double)sitAdd + (double)standAdd);
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public void travel(Vec3 vec3d) {
        if (this.isSitting()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    public void openGUI(Player playerEntity) {
        if (!this.level().isClientSide && !this.hasPassenger((Entity)playerEntity)) {
            ((ServerPlayer)playerEntity).openMenu(new MenuProvider(){

                public AbstractContainerMenu createMenu(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
                    return ChestMenu.sixRows((int)p_createMenu_1_, (Inventory)p_createMenu_2_, (Container)EntityElephant.this.elephantInventory);
                }

                public Component getDisplayName() {
                    return Component.translatable((String)"entity.alexsmobs.elephant.chest");
                }
            });
        }
    }

    public boolean isTrader() {
        return (Boolean)this.entityData.get(TRADER);
    }

    public void setTrader(boolean trader) {
        this.entityData.set(TRADER, (Object)trader);
    }

    public boolean triggerCharge(ItemStack stack) {
        if (this.getControllingPassenger() != null && this.chargeCooldown == 0 && !this.charging && this.getAnimation() == NO_ANIMATION && this.isTusked()) {
            this.setAnimation(ANIMATION_CHARGE_PREPARE);
            this.eatItemEffect(stack);
            this.heal(2.0f);
            return true;
        }
        return false;
    }

    public boolean canSpawnWithTraderHere() {
        return this.level().isLoaded(this.blockPosition()) && this.checkSpawnObstruction((LevelReader)this.level()) && this.level().isEmptyBlock(this.blockPosition().above(4));
    }

    class PanicGoal
    extends net.minecraft.world.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((PathfinderMob)EntityElephant.this, 1.0);
        }

        public boolean canUse() {
            return (EntityElephant.this.isBaby() || !EntityElephant.this.isTusked() || EntityElephant.this.isOnFire()) && super.canUse();
        }
    }

    private class AIWalkIdle
    extends RandomStrollGoal {
        public AIWalkIdle(EntityElephant e, double v) {
            super((PathfinderMob)e, v);
        }

        public boolean canUse() {
            this.interval = EntityElephant.this.isTusked() || !EntityElephant.this.inCaravan() ? 50 : 120;
            return super.canUse();
        }

        @Nullable
        protected Vec3 getPosition() {
            return LandRandomPos.getPos((PathfinderMob)this.mob, (int)(EntityElephant.this.isTusked() || !EntityElephant.this.inCaravan() ? 25 : 10), (int)7);
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((PathfinderMob)EntityElephant.this, new Class[0]);
        }

        public void start() {
            if (EntityElephant.this.isBaby() || !EntityElephant.this.isTusked()) {
                this.alertOthers();
                this.stop();
            } else {
                super.start();
            }
        }

        protected void alertOther(Mob mobIn, LivingEntity targetIn) {
            if (!(!(mobIn instanceof EntityElephant) || mobIn.isBaby() && ((EntityElephant)mobIn).isTusked())) {
                super.alertOther(mobIn, targetIn);
            }
        }
    }
}

