/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityLaviathan;
import com.github.alexthe666.alexsmobs.entity.EntityMosquitoSpit;
import com.github.alexthe666.alexsmobs.entity.EntityMungus;
import com.github.alexthe666.alexsmobs.entity.EntityTriops;
import com.github.alexthe666.alexsmobs.entity.EntityWarpedMosco;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.network.MessageMosquitoDismount;
import com.github.alexthe666.alexsmobs.network.MessageMosquitoMountPlayer;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityCrimsonMosquito
extends Monster {
    public static final ResourceLocation FULL_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/crimson_mosquito_full");
    public static final ResourceLocation FROM_FLY_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/crimson_mosquito_fly");
    public static final ResourceLocation FROM_FLY_FULL_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/crimson_mosquito_fly_full");
    protected static final EntityDimensions FLIGHT_SIZE = EntityDimensions.fixed((float)1.2f, (float)1.8f);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityCrimsonMosquito.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.defineId(EntityCrimsonMosquito.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> BLOOD_LEVEL = SynchedEntityData.defineId(EntityCrimsonMosquito.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SHRINKING = SynchedEntityData.defineId(EntityCrimsonMosquito.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FROM_FLY = SynchedEntityData.defineId(EntityCrimsonMosquito.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> MOSQUITO_SCALE = SynchedEntityData.defineId(EntityCrimsonMosquito.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> SICK = SynchedEntityData.defineId(EntityCrimsonMosquito.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> LURING_LAVIATHAN = SynchedEntityData.defineId(EntityCrimsonMosquito.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FLEEING_ENTITY = SynchedEntityData.defineId(EntityCrimsonMosquito.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Predicate<LivingEntity> REPELLENT = mob -> mob.hasEffect(AMEffectRegistry.MOSQUITO_REPELLENT) || mob instanceof EntityTriops;
    private static final Predicate<LivingEntity> NO_REPELLENT = mob -> !mob.hasEffect(AMEffectRegistry.MOSQUITO_REPELLENT);
    public float prevFlyProgress;
    public float flyProgress;
    public float prevShootProgress;
    public float shootProgress;
    public int shootingTicks;
    public int randomWingFlapTick = 0;
    private int flightTicks = 0;
    private int sickTicks = 0;
    private boolean prevFlying = false;
    private int spitCooldown = 0;
    private int loopSoundTick = 0;
    private int drinkTime = 0;
    public float prevMosquitoScale = 1.0f;
    private int repellentCheckTime = 0;
    private Vec3 fleePos = null;

    protected EntityCrimsonMosquito(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new MoveHelperController(this);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public boolean hasLuringLaviathan() {
        return (Integer)this.entityData.get(LURING_LAVIATHAN) != -1;
    }

    public void onSpawnFromFly() {
        this.prevMosquitoScale = 0.2f;
        this.setShrink(false);
        this.setMosquitoScale(0.2f);
        this.setFromFly(true);
        for (int j = 0; j < 4; ++j) {
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)1.0f, (float)0.0f, (float)0.0f), this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, 0.0, 0.0);
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.MOSQUITO_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.MOSQUITO_DIE.get();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.crimsonMosquitoSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean canRiderInteract() {
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new FlyTowardsTarget(this));
        this.goalSelector.addGoal(2, (Goal)new FlyAwayFromTarget(this));
        this.goalSelector.addGoal(3, (Goal)new RandomFlyGoal(this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 32.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EntityCrimsonMosquito.class, EntityWarpedMosco.class}));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<Player>((Mob)this, Player.class, 20, true, false, NO_REPELLENT));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<LivingEntity>((Mob)this, LivingEntity.class, 50, false, true, AMEntityRegistry.buildPredicateFromTag(AMTagRegistry.CRIMSON_MOSQUITO_TARGETS)));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityTriops.class, 16.0f, 1.3, 1.0));
    }

    public static boolean canMosquitoSpawn(EntityType<? extends Mob> typeIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        BlockPos blockpos = pos.below();
        boolean spawnBlock = worldIn.getBlockState(blockpos).canOcclude();
        return reason == MobSpawnType.SPAWNER || spawnBlock && worldIn.getBlockState(blockpos).isValidSpawn((BlockGetter)worldIn, blockpos, typeIn) && EntityCrimsonMosquito.isDarkEnoughToSpawn((ServerLevelAccessor)worldIn, (BlockPos)pos, (RandomSource)randomIn) && EntityCrimsonMosquito.checkMobSpawnRules((EntityType)((EntityType)AMEntityRegistry.CRIMSON_MOSQUITO.get()), (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("FlightTicks", this.flightTicks);
        compound.putInt("SickTicks", this.sickTicks);
        compound.putFloat("MosquitoScale", this.getMosquitoScale());
        compound.putBoolean("Flying", this.isFlying());
        compound.putBoolean("Shrinking", this.isShrinking());
        compound.putBoolean("IsFromFly", this.isFromFly());
        compound.putBoolean("Sick", this.isSick());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.flightTicks = compound.getInt("FlightTicks");
        this.sickTicks = compound.getInt("SickTicks");
        this.setMosquitoScale(compound.getFloat("MosquitoScale"));
        this.setFlying(compound.getBoolean("Flying"));
        this.setShrink(compound.getBoolean("Shrinking"));
        this.setFromFly(compound.getBoolean("IsFromFly"));
        this.setSick(compound.getBoolean("Sick"));
    }

    private void spit(LivingEntity target) {
        if (this.isSick()) {
            return;
        }
        EntityMosquitoSpit llamaspitentity = new EntityMosquitoSpit(this.level(), this);
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.3333333333333333) - llamaspitentity.getY();
        double d2 = target.getZ() - this.getZ();
        float f = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2))) * 0.2f;
        llamaspitentity.shoot(d0, d1 + (double)f, d2, 1.5f, 10.0f);
        if (!this.isSilent()) {
            this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.LLAMA_SPIT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        if (this.getBloodLevel() > 0) {
            this.setBloodLevel(this.getBloodLevel() - 1);
        }
        this.level().addFreshEntity((Entity)llamaspitentity);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.FALL) || source.is(DamageTypes.DROWN) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.LAVA) || source.is(DamageTypeTags.IS_FIRE) || super.isInvulnerableTo(source);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() != null && this.getRootVehicle() == source.getEntity().getRootVehicle()) {
            return super.hurt(source, amount * 0.333f);
        }
        if (this.flightTicks < 0) {
            this.flightTicks = 0;
        }
        return super.hurt(source, amount);
    }

    public void rideTick() {
        Entity entity = this.getVehicle();
        if (this.isPassenger() && !entity.isAlive()) {
            this.stopRiding();
        } else {
            Entity mount;
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.tick();
            if (this.isPassenger() && (mount = this.getVehicle()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)mount;
                this.yBodyRot = livingEntity.yBodyRot;
                this.setYRot(livingEntity.getYRot());
                this.yHeadRot = livingEntity.yHeadRot;
                this.yRotO = livingEntity.yHeadRot;
                float radius = 1.0f;
                float angle = (float)Math.PI / 180 * livingEntity.yBodyRot;
                double extraX = 1.0f * Mth.sin((float)((float)Math.PI + angle));
                double extraZ = 1.0f * Mth.cos((float)angle);
                this.setPos(mount.getX() + extraX, Math.max(mount.getY() + (double)(mount.getEyeHeight() * 0.25f), mount.getY()), mount.getZ() + extraZ);
                if (!mount.isAlive() || mount instanceof Player && ((Player)mount).isCreative()) {
                    this.removeVehicle();
                }
                if (!this.level().isClientSide) {
                    if (this.drinkTime % 20 == 0 && this.isAlive()) {
                        boolean mungus = AMConfig.warpedMoscoTransformation && mount instanceof EntityMungus && ((EntityMungus)mount).isWarpedMoscoReady();
                        if (mount.hurt(this.damageSources().mobAttack((LivingEntity)this), mungus ? 7.0f : 2.0f)) {
                            boolean sick;
                            if (mungus) {
                                ((EntityMungus)mount).disableExplosion();
                            }
                            if ((sick = this.isNonMungusWarpedTrigger(mount)) || mungus) {
                                if (!this.isSick()) {
                                    for (ServerPlayer serverplayerentity : this.level().getEntitiesOfClass(ServerPlayer.class, this.getBoundingBox().inflate(40.0, 25.0, 40.0))) {
                                        ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.MOSQUITO_SICK.get())).trigger(serverplayerentity);
                                    }
                                }
                                this.setSick(true);
                                this.setFlying(false);
                                this.flightTicks = -150 - this.random.nextInt(200);
                            }
                            this.gameEvent((Holder)GameEvent.EAT);
                            this.playSound(SoundEvents.HONEY_DRINK, this.getSoundVolume(), this.getVoicePitch());
                            this.setBloodLevel(this.getBloodLevel() + 1);
                            if (this.getBloodLevel() > 3) {
                                this.removeVehicle();
                                AlexsMobs.sendMSGToAll(new MessageMosquitoDismount(this.getId(), mount.getId()));
                                this.setFlying(false);
                                this.flightTicks = -15;
                            }
                        }
                    }
                    if (this.drinkTime > 81) {
                        this.drinkTime = -20 - this.random.nextInt(20);
                        this.removeVehicle();
                        AlexsMobs.sendMSGToAll(new MessageMosquitoDismount(this.getId(), mount.getId()));
                        this.setFlying(false);
                        this.flightTicks = -15;
                    }
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
        builder.define(SHOOTING, (Object)false);
        builder.define(SICK, (Object)false);
        builder.define(BLOOD_LEVEL, (Object)0);
        builder.define(SHRINKING, (Object)false);
        builder.define(FROM_FLY, (Object)false);
        builder.define(MOSQUITO_SCALE, (Object)Float.valueOf(1.0f));
        builder.define(LURING_LAVIATHAN, (Object)-1);
        builder.define(FLEEING_ENTITY, (Object)-1);
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    public void setFlying(boolean flying) {
        this.entityData.set(FLYING, (Object)flying);
    }

    public void setupShooting() {
        this.entityData.set(SHOOTING, (Object)true);
        this.shootingTicks = 5;
    }

    public int getLuringLaviathan() {
        return (Integer)this.entityData.get(LURING_LAVIATHAN);
    }

    public void setLuringLaviathan(int lure) {
        this.entityData.set(LURING_LAVIATHAN, (Object)lure);
    }

    public int getFleeingEntityId() {
        return (Integer)this.entityData.get(FLEEING_ENTITY);
    }

    public void setFleeingEntityId(int lure) {
        this.entityData.set(FLEEING_ENTITY, (Object)lure);
    }

    public int getBloodLevel() {
        return Math.min((Integer)this.entityData.get(BLOOD_LEVEL), 4);
    }

    public void setBloodLevel(int bloodLevel) {
        this.entityData.set(BLOOD_LEVEL, (Object)bloodLevel);
    }

    public boolean isShrinking() {
        return (Boolean)this.entityData.get(SHRINKING);
    }

    public boolean isFromFly() {
        return (Boolean)this.entityData.get(FROM_FLY);
    }

    public void setShrink(boolean shrink) {
        this.entityData.set(SHRINKING, (Object)shrink);
    }

    public void setFromFly(boolean fromFly) {
        this.entityData.set(FROM_FLY, (Object)fromFly);
    }

    public float getMosquitoScale() {
        return ((Float)this.entityData.get(MOSQUITO_SCALE)).floatValue();
    }

    public void setMosquitoScale(float scale) {
        this.entityData.set(MOSQUITO_SCALE, (Object)Float.valueOf(scale));
    }

    public boolean isSick() {
        return (Boolean)this.entityData.get(SICK);
    }

    public void setSick(boolean shrink) {
        this.entityData.set(SICK, (Object)shrink);
    }

    public void tick() {
        super.tick();
        boolean shooting = (Boolean)this.entityData.get(SHOOTING);
        if (this.prevFlying != this.isFlying()) {
            this.refreshDimensions();
        }
        if (shooting) {
            if (this.shootProgress < 5.0f) {
                this.shootProgress += 1.0f;
            }
        } else if (this.shootProgress > 0.0f) {
            this.shootProgress -= 1.0f;
        }
        if (this.isFlying()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            if (this.isPassenger()) {
                this.setFlying(false);
            }
            if (this.isFlying()) {
                this.setNoGravity(true);
            } else {
                this.setNoGravity(false);
            }
            LivingEntity target = this.getTarget();
            if (this.getFleeingEntityId() == -1) {
                if (target == null && this.tickCount - this.repellentCheckTime > 50) {
                    this.repellentCheckTime = this.tickCount;
                    LivingEntity closestRepel = null;
                    for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(30.0), REPELLENT)) {
                        if (closestRepel != null && !(entity.distanceTo((Entity)this) < closestRepel.distanceTo((Entity)this))) continue;
                        closestRepel = entity;
                    }
                    if (closestRepel != null) {
                        this.setFleeingEntityId(closestRepel.getId());
                    }
                }
                if (target != null && REPELLENT.test(target) && this.distanceTo((Entity)target) < 20.0f) {
                    this.setFleeingEntityId(target.getId());
                }
            } else {
                LivingEntity living;
                Entity fleeing = this.level().getEntity(this.getFleeingEntityId());
                if (fleeing instanceof LivingEntity && REPELLENT.test(living = (LivingEntity)fleeing) && this.distanceTo((Entity)living) < 20.0f) {
                    this.setTarget(null);
                    this.setLastHurtByMob(null);
                    if (this.isPassenger()) {
                        this.stopRiding();
                    }
                    if (this.fleePos == null || this.fleePos.distanceTo(this.position()) < 3.0 || this.random.nextInt(40) == 0) {
                        Vec3 vec = LandRandomPos.getPosAway((PathfinderMob)this, (int)8, (int)4, (Vec3)fleeing.position());
                        if (vec != null) {
                            this.fleePos = vec;
                        }
                    } else {
                        this.setFlying(true);
                        this.moveControl.setWantedPosition(this.fleePos.x, this.fleePos.y + 1.0, this.fleePos.z, (double)1.2f);
                    }
                } else {
                    this.setFleeingEntityId(-1);
                }
            }
            if (this.hasLuringLaviathan()) {
                this.setTarget(null);
                this.setLastHurtByMob(null);
                Entity entity = this.level().getEntity(this.getLuringLaviathan());
                if (entity instanceof EntityLaviathan && ((EntityLaviathan)entity).isChilling()) {
                    Vec3 vec = ((EntityLaviathan)entity).getLureMosquitoPos();
                    this.setFlying(true);
                    this.lookAt(entity, 10.0f, 10.0f);
                    this.getMoveControl().setWantedPosition(vec.x, vec.y, vec.z, (double)0.7f);
                } else {
                    this.setLuringLaviathan(-1);
                }
            }
        }
        if (this.flyProgress == 0.0f && this.random.nextInt(200) == 0) {
            this.randomWingFlapTick = 5 + this.random.nextInt(15);
        }
        if (this.randomWingFlapTick > 0) {
            --this.randomWingFlapTick;
        }
        if (!this.level().isClientSide && this.onGround() && !this.isFlying() && (this.flightTicks >= 0 && this.random.nextInt(5) == 0 || this.getTarget() != null)) {
            this.setFlying(true);
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.setOnGround(false);
            this.hasImpulse = true;
        }
        if (this.flightTicks < 0) {
            ++this.flightTicks;
        }
        if (!this.level().isClientSide && this.isFlying()) {
            ++this.flightTicks;
            if (!(this.flightTicks <= 200 || this.getTarget() != null && this.getTarget().isAlive())) {
                BlockPos above = this.getGroundPosition(this.blockPosition().above());
                if (this.level().getFluidState(above).isEmpty() && !this.level().getBlockState(above).isAir()) {
                    this.getDeltaMovement().add(0.0, -0.2, 0.0);
                    if (this.onGround()) {
                        this.setFlying(false);
                        this.flightTicks = -150 - this.random.nextInt(200);
                    }
                }
            }
        }
        this.prevMosquitoScale = this.getMosquitoScale();
        if (this.isShrinking()) {
            if (this.getMosquitoScale() > 0.4f) {
                this.setMosquitoScale(this.getMosquitoScale() - 0.1f);
            }
        } else if (this.getMosquitoScale() < 1.0f && !this.isSick()) {
            this.setMosquitoScale(this.getMosquitoScale() + 0.05f);
        }
        if (!this.level().isClientSide && this.shootingTicks > 0) {
            --this.shootingTicks;
            if (this.shootingTicks == 0) {
                if (this.getTarget() != null && this.getBloodLevel() > 0) {
                    this.spit(this.getTarget());
                }
                this.entityData.set(SHOOTING, (Object)false);
            }
        }
        if (this.isFlying()) {
            if (this.loopSoundTick == 0) {
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                this.playSound((SoundEvent)AMSoundRegistry.MOSQUITO_LOOP.get(), this.getSoundVolume(), this.getVoicePitch());
            }
            ++this.loopSoundTick;
            if (this.loopSoundTick > 100) {
                this.loopSoundTick = 0;
            }
        }
        if (this.isPassenger()) {
            if (this.drinkTime < 0) {
                this.drinkTime = 0;
            }
            ++this.drinkTime;
        } else {
            this.drinkTime = 0;
        }
        this.prevFlyProgress = this.flyProgress;
        this.prevShootProgress = this.shootProgress;
        this.prevFlying = this.isFlying();
        if (this.isSick()) {
            ++this.sickTicks;
            if (this.getTarget() != null && !this.isPassenger()) {
                this.setTarget(null);
            }
            if (this.sickTicks > 100) {
                this.setShrink(false);
                this.setMosquitoScale(this.getMosquitoScale() + 0.015f);
                if (this.sickTicks > 160) {
                    EntityWarpedMosco mosco = (EntityWarpedMosco)((EntityType)AMEntityRegistry.WARPED_MOSCO.get()).create(this.level());
                    mosco.copyPosition((Entity)this);
                    if (!this.level().isClientSide) {
                        mosco.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.CONVERSION, null);
                    }
                    if (!this.level().isClientSide) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)79);
                        this.level().addFreshEntity((Entity)mosco);
                    }
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 79) {
            for (int i = 0; i < 27; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getRandomX(1.6), this.getY() + (double)(this.random.nextFloat() * 3.4f), this.getRandomZ(1.6), d0, d1, d2);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void travel(Vec3 vec3d) {
        if (this.onGround() && !this.isFlying()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        InteractionResult type = super.mobInteract(player, hand);
        if (item == AMItemRegistry.WARPED_MIXTURE.get() && !this.isSick()) {
            this.spawnAtLocation(item.getCraftingRemainingItem(itemstack));
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            this.setSick(true);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    private BlockPos getGroundPosition(BlockPos radialPos) {
        while (radialPos.getY() > 1 && this.level().isEmptyBlock(radialPos)) {
            radialPos = radialPos.below();
        }
        return radialPos;
    }

    public boolean isNonMungusWarpedTrigger(Entity entity) {
        ResourceLocation mobtype = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        return mobtype != null && !AMConfig.warpedMoscoMobTriggers.isEmpty() && AMConfig.warpedMoscoMobTriggers.contains(mobtype.toString());
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityCrimsonMosquito parentEntity;

        public MoveHelperController(EntityCrimsonMosquito sunbird) {
            super((Mob)sunbird);
            this.parentEntity = sunbird;
        }

        public void tick() {
            if (this.speedModifier >= 1.0 && this.parentEntity.isSick()) {
                this.speedModifier = 0.35;
            }
            if (this.parentEntity.isFlying()) {
                if (this.operation == MoveControl.Operation.STRAFE) {
                    Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                    double d0 = vector3d.length();
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(0.0, vector3d.scale(this.speedModifier * 0.05 / d0).y(), 0.0));
                    float f = (float)this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
                    float f1 = (float)this.speedModifier * f;
                    this.strafeForwards = 1.0f;
                    this.strafeRight = 0.0f;
                    this.mob.setSpeed(f1);
                    this.mob.setZza(this.strafeForwards);
                    this.mob.setXxa(this.strafeRight);
                    this.operation = MoveControl.Operation.WAIT;
                } else if (this.operation == MoveControl.Operation.MOVE_TO) {
                    Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                    double d0 = vector3d.length();
                    if (d0 < this.parentEntity.getBoundingBox().getSize()) {
                        this.operation = MoveControl.Operation.WAIT;
                        this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().scale(0.5));
                    } else {
                        this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d.scale(this.speedModifier * 0.05 / d0)));
                        if (this.parentEntity.getTarget() == null) {
                            Vec3 vector3d1 = this.parentEntity.getDeltaMovement();
                            this.parentEntity.setYRot(-((float)Mth.atan2((double)vector3d1.x, (double)vector3d1.z)) * 57.295776f);
                            this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                        } else {
                            double d2 = this.parentEntity.getTarget().getX() - this.parentEntity.getX();
                            double d1 = this.parentEntity.getTarget().getZ() - this.parentEntity.getZ();
                            this.parentEntity.setYRot(-((float)Mth.atan2((double)d2, (double)d1)) * 57.295776f);
                            this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                        }
                    }
                }
            } else {
                this.operation = MoveControl.Operation.WAIT;
                this.mob.setSpeed(0.0f);
                this.mob.setZza(0.0f);
                this.mob.setXxa(0.0f);
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.getBoundingBox();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.move(p_220673_1_);
                if (this.parentEntity.level().noCollision((Entity)this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    public static class FlyTowardsTarget
    extends Goal {
        private final EntityCrimsonMosquito parentEntity;

        public FlyTowardsTarget(EntityCrimsonMosquito mosquito) {
            this.parentEntity = mosquito;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!this.parentEntity.isFlying() || this.parentEntity.getBloodLevel() > 0 || this.parentEntity.drinkTime < 0 || this.parentEntity.getFleeingEntityId() != -1) {
                return false;
            }
            return !this.parentEntity.isPassenger() && this.parentEntity.getTarget() != null && !this.isBittenByMosquito((Entity)this.parentEntity.getTarget());
        }

        public boolean canContinueToUse() {
            return this.parentEntity.drinkTime >= 0 && this.parentEntity.getFleeingEntityId() == -1 && this.parentEntity.getTarget() != null && !this.isBittenByMosquito((Entity)this.parentEntity.getTarget()) && !this.parentEntity.horizontalCollision && this.parentEntity.getBloodLevel() == 0 && this.parentEntity.isFlying() && this.parentEntity.getMoveControl().hasWanted();
        }

        public boolean isBittenByMosquito(Entity entity) {
            for (Entity e : entity.getPassengers()) {
                if (!(e instanceof EntityCrimsonMosquito)) continue;
                return true;
            }
            return false;
        }

        public void stop() {
        }

        public void tick() {
            if (this.parentEntity.getTarget() != null) {
                this.parentEntity.getMoveControl().setWantedPosition(this.parentEntity.getTarget().getX(), this.parentEntity.getTarget().getY(), this.parentEntity.getTarget().getZ(), 1.0);
                if (this.parentEntity.getBoundingBox().inflate((double)0.3f, (double)0.3f, (double)0.3f).intersects(this.parentEntity.getTarget().getBoundingBox()) && !this.isBittenByMosquito((Entity)this.parentEntity.getTarget()) && this.parentEntity.drinkTime == 0) {
                    this.parentEntity.startRiding((Entity)this.parentEntity.getTarget(), true);
                    if (!this.parentEntity.level().isClientSide) {
                        AlexsMobs.sendMSGToAll(new MessageMosquitoMountPlayer(this.parentEntity.getId(), this.parentEntity.getTarget().getId()));
                    }
                }
            }
        }
    }

    public static class FlyAwayFromTarget
    extends Goal {
        private final EntityCrimsonMosquito parentEntity;
        private int spitCooldown = 0;
        private BlockPos shootPos = null;

        public FlyAwayFromTarget(EntityCrimsonMosquito mosquito) {
            this.parentEntity = mosquito;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!this.parentEntity.isFlying() || this.parentEntity.getBloodLevel() <= 0 && this.parentEntity.drinkTime >= 0 || this.parentEntity.getFleeingEntityId() != -1) {
                return false;
            }
            if (!this.parentEntity.isPassenger() && this.parentEntity.getTarget() != null) {
                this.shootPos = this.getBlockInTargetsViewMosquito(this.parentEntity.getTarget());
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.parentEntity.getTarget() != null && (this.parentEntity.getBloodLevel() > 0 || this.parentEntity.drinkTime < 0) && this.parentEntity.isFlying() && !this.parentEntity.horizontalCollision;
        }

        public void stop() {
            this.spitCooldown = 20;
        }

        public void tick() {
            if (this.spitCooldown > 0) {
                --this.spitCooldown;
            }
            if (this.parentEntity.getTarget() != null) {
                if (this.shootPos == null) {
                    this.shootPos = this.getBlockInTargetsViewMosquito(this.parentEntity.getTarget());
                } else {
                    this.parentEntity.getMoveControl().setWantedPosition((double)this.shootPos.getX() + 0.5, (double)this.shootPos.getY() + 0.5, (double)this.shootPos.getZ() + 0.5, 1.0);
                    this.parentEntity.lookAt((Entity)this.parentEntity.getTarget(), 30.0f, 30.0f);
                    if (this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.shootPos)) < 2.5) {
                        if (this.spitCooldown == 0 && this.parentEntity.getBloodLevel() > 0) {
                            this.parentEntity.setupShooting();
                            this.spitCooldown = 20;
                        }
                        this.shootPos = null;
                    }
                }
            }
        }

        public BlockPos getBlockInTargetsViewMosquito(LivingEntity target) {
            float radius = 4 + this.parentEntity.getRandom().nextInt(5);
            float angle = (float)Math.PI / 180 * (target.yHeadRot + 90.0f + (float)this.parentEntity.getRandom().nextInt(180));
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            BlockPos ground = AMBlockPos.fromCoords(target.getX() + extraX, target.getY() + 1.0, target.getZ() + extraZ);
            if (this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)ground)) > 30.0 && !this.parentEntity.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground)) && this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)ground)) > 6.0) {
                return ground;
            }
            return this.parentEntity.blockPosition();
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityCrimsonMosquito parentEntity;
        private BlockPos target = null;

        public RandomFlyGoal(EntityCrimsonMosquito mosquito) {
            this.parentEntity = mosquito;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            MoveControl movementcontroller = this.parentEntity.getMoveControl();
            if (!this.parentEntity.isFlying() || this.parentEntity.getTarget() != null || this.parentEntity.hasLuringLaviathan() || this.parentEntity.getFleeingEntityId() != -1) {
                return false;
            }
            if (!movementcontroller.hasWanted() || this.target == null) {
                this.target = this.getBlockInViewMosquito();
                if (this.target != null) {
                    this.parentEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, 1.0);
                }
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.parentEntity.isFlying() && this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.target)) > 2.4 && this.parentEntity.getMoveControl().hasWanted() && !this.parentEntity.horizontalCollision;
        }

        public void stop() {
            this.target = null;
        }

        public void tick() {
            if (this.target == null) {
                this.target = this.getBlockInViewMosquito();
            }
            if (this.target != null) {
                this.parentEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, 1.0);
                if (this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.target)) < 2.5) {
                    this.target = null;
                }
            }
        }

        public BlockPos getBlockInViewMosquito() {
            float radius = 1 + this.parentEntity.getRandom().nextInt(5);
            float neg = this.parentEntity.getRandom().nextBoolean() ? 1.0f : -1.0f;
            float renderYawOffset = this.parentEntity.yBodyRot;
            float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.parentEntity.getRandom().nextFloat() * neg;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            BlockPos radialPos = AMBlockPos.fromCoords(this.parentEntity.getX() + extraX, this.parentEntity.getY() + 2.0, this.parentEntity.getZ() + extraZ);
            BlockPos ground = this.parentEntity.getGroundPosition(radialPos);
            int up = this.parentEntity.isSick() ? 2 : 6;
            BlockPos newPos = ground.above(1 + this.parentEntity.getRandom().nextInt(up));
            if (!this.parentEntity.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 6.0) {
                return newPos;
            }
            return null;
        }
    }
}

