/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCentipedeHead;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFleeLight;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.IShearable;

public class EntityCockroach
extends Animal
implements Shearable,
IShearable,
ITargetsDroppedItems {
    public static final ResourceLocation MARACA_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/cockroach_maracas");
    public static final ResourceLocation MARACA_HEADLESS_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/cockroach_maracas_headless");
    protected static final EntityDimensions STAND_SIZE = EntityDimensions.fixed((float)0.7f, (float)0.9f);
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.defineId(EntityCockroach.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HEADLESS = SynchedEntityData.defineId(EntityCockroach.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> MARACAS = SynchedEntityData.defineId(EntityCockroach.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<UUID>> NEAREST_MUSICIAN = SynchedEntityData.defineId(EntityCockroach.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> BREADED = SynchedEntityData.defineId(EntityCockroach.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int randomWingFlapTick = 0;
    public float prevDanceProgress;
    public float danceProgress;
    private boolean prevStand = false;
    private boolean isJukeboxing;
    private BlockPos jukeboxPosition;
    private int laCucarachaTimer = 0;
    public int timeUntilNextEgg = this.random.nextInt(24000) + 24000;

    public EntityCockroach(EntityType type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.35f);
    }

    public static boolean isValidLightLevel(ServerLevelAccessor p_223323_0_, BlockPos p_223323_1_, RandomSource p_223323_2_) {
        if (p_223323_0_.getBrightness(LightLayer.SKY, p_223323_1_) > p_223323_2_.nextInt(32)) {
            return false;
        }
        int lvt_3_1_ = p_223323_0_.getLevel().isThundering() ? p_223323_0_.getMaxLocalRawBrightness(p_223323_1_, 10) : p_223323_0_.getMaxLocalRawBrightness(p_223323_1_);
        return lvt_3_1_ <= p_223323_2_.nextInt(8);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.cockroachSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static boolean canMonsterSpawnInLight(EntityType<? extends EntityCockroach> p_223325_0_, ServerLevelAccessor p_223325_1_, MobSpawnType p_223325_2_, BlockPos p_223325_3_, RandomSource p_223325_4_) {
        return EntityCockroach.isValidLightLevel(p_223325_1_, p_223325_3_, p_223325_4_) && EntityCockroach.checkMobSpawnRules(p_223325_0_, (LevelAccessor)p_223325_1_, (MobSpawnType)p_223325_2_, (BlockPos)p_223325_3_, (RandomSource)p_223325_4_);
    }

    public static <T extends Mob> boolean canCockroachSpawn(EntityType<EntityCockroach> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || !iServerWorld.canSeeSky(pos) && pos.getY() <= 64 && EntityCockroach.canMonsterSpawnInLight(entityType, iServerWorld, reason, pos, random);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.requiresCustomPersistence();
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.hasCustomName() || this.isBreaded() || this.isDancing() || this.hasMaracas() || this.isHeadless();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.COCKROACH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.COCKROACH_HURT.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(AMTagRegistry.COCKROACH_FOODSTUFFS), false));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityCentipedeHead.class, 16.0f, 1.3, 1.0));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.3, 1.0){

            public boolean canUse() {
                return !EntityCockroach.this.isBreaded() && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new AnimalAIFleeLight((PathfinderMob)this, 1.0){

            @Override
            public boolean canUse() {
                return !EntityCockroach.this.isBreaded() && super.canUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new CreatureAITargetItems((PathfinderMob)this, false));
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean prev = super.hurt(source, amount);
        if (prev) {
            this.randomWingFlapTick = 5 + this.random.nextInt(15);
            if (this.getHealth() <= 1.0f && amount > 0.0f && !this.isHeadless() && this.getRandom().nextInt(3) == 0) {
                this.setHeadless(true);
                if (!this.level().isClientSide) {
                    ServerLevel serverLevel = (ServerLevel)this.level();
                    for (int i = 0; i < 3; ++i) {
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.SNEEZE, this.getRandomX(0.52f), this.getY(1.0), this.getRandomZ(0.52f), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        return prev;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.COCKROACH_BREEDABLES);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Maracas", this.hasMaracas());
        compound.putBoolean("Dancing", this.isDancing());
        compound.putBoolean("Breaded", this.isBreaded());
        compound.putInt("EggTime", this.timeUntilNextEgg);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setMaracas(compound.getBoolean("Maracas"));
        this.setDancing(compound.getBoolean("Dancing"));
        this.setBreaded(compound.getBoolean("Breaded"));
        if (compound.contains("EggTime")) {
            this.timeUntilNextEgg = compound.getInt("EggTime");
        }
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        return 0.5f - (float)Math.max(worldIn.getBrightness(LightLayer.BLOCK, pos), worldIn.getBrightness(LightLayer.SKY, pos));
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.FALL) || source.is(DamageTypes.DROWN) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypeTags.IS_EXPLOSION) || source.getMsgId().equals("anvil") || super.isInvulnerableTo(source);
    }

    public InteractionResult mobInteract(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack lvt_3_1_ = p_230254_1_.getItemInHand(p_230254_2_);
        if (lvt_3_1_.getItem() == AMItemRegistry.MARACA.get() && this.isAlive() && !this.hasMaracas()) {
            this.setMaracas(true);
            lvt_3_1_.shrink(1);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (lvt_3_1_.getItem() != AMItemRegistry.MARACA.get() && this.isAlive() && this.hasMaracas()) {
            this.setMaracas(false);
            this.setDancing(false);
            this.spawnAtLocation(new ItemStack((ItemLike)AMItemRegistry.MARACA.get()));
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_230254_1_, p_230254_2_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DANCING, (Object)false);
        builder.define(HEADLESS, (Object)false);
        builder.define(MARACAS, (Object)false);
        builder.define(NEAREST_MUSICIAN, Optional.empty());
        builder.define(BREADED, (Object)false);
    }

    public boolean isDancing() {
        return (Boolean)this.entityData.get(DANCING);
    }

    public void setDancing(boolean dancing) {
        this.entityData.set(DANCING, (Object)dancing);
    }

    public boolean isHeadless() {
        return (Boolean)this.entityData.get(HEADLESS);
    }

    public void setHeadless(boolean head) {
        this.entityData.set(HEADLESS, (Object)head);
    }

    public boolean hasMaracas() {
        return (Boolean)this.entityData.get(MARACAS);
    }

    public void setMaracas(boolean head) {
        this.entityData.set(MARACAS, (Object)head);
    }

    public boolean isBreaded() {
        return (Boolean)this.entityData.get(BREADED);
    }

    public void setBreaded(boolean breaded) {
        this.entityData.set(BREADED, (Object)breaded);
    }

    @Nullable
    public UUID getNearestMusicianId() {
        return ((Optional)this.entityData.get(NEAREST_MUSICIAN)).orElse(null);
    }

    public void tick() {
        Entity musician;
        boolean dance;
        super.tick();
        this.prevDanceProgress = this.danceProgress;
        boolean bl = dance = this.isJukeboxing || this.isDancing();
        if (this.jukeboxPosition == null || !this.jukeboxPosition.closerToCenterThan((Position)this.position(), 3.46) || !this.level().getBlockState(this.jukeboxPosition).is(Blocks.JUKEBOX)) {
            this.isJukeboxing = false;
            this.jukeboxPosition = null;
        }
        if (this.getEyeHeight() > this.getBbHeight()) {
            this.refreshDimensions();
        }
        if (dance) {
            if (this.danceProgress < 5.0f) {
                this.danceProgress += 1.0f;
            }
        } else if (this.danceProgress > 0.0f) {
            this.danceProgress -= 1.0f;
        }
        if (!this.onGround() || this.random.nextInt(200) == 0) {
            this.randomWingFlapTick = 5 + this.random.nextInt(15);
        }
        if (this.randomWingFlapTick > 0) {
            --this.randomWingFlapTick;
        }
        if (this.prevStand != dance) {
            if (this.hasMaracas()) {
                this.tellOthersImPlayingLaCucaracha();
            }
            this.refreshDimensions();
        }
        if (!this.hasMaracas() && (musician = this.getNearestMusician()) != null) {
            if (!musician.isAlive() || this.distanceTo(musician) > 10.0f || musician instanceof EntityCockroach && !((EntityCockroach)musician).hasMaracas()) {
                this.setNearestMusician(null);
                this.setDancing(false);
            } else {
                this.setDancing(true);
            }
        }
        if (this.hasMaracas()) {
            ++this.laCucarachaTimer;
            if (this.laCucarachaTimer % 20 == 0 && this.random.nextFloat() < 0.3f) {
                this.tellOthersImPlayingLaCucaracha();
            }
            this.setDancing(true);
            if (!this.isSilent()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)67);
            }
        } else {
            this.laCucarachaTimer = 0;
        }
        if (!this.level().isClientSide && this.isAlive() && !this.isBaby() && --this.timeUntilNextEgg <= 0) {
            ItemEntity dropped = this.spawnAtLocation((ItemLike)AMItemRegistry.COCKROACH_OOTHECA.get());
            if (dropped != null) {
                dropped.setDefaultPickUpDelay();
            }
            this.timeUntilNextEgg = this.random.nextInt(24000) + 24000;
        }
        this.prevStand = dance;
    }

    private void tellOthersImPlayingLaCucaracha() {
        List list = this.level().getEntitiesOfClass(EntityCockroach.class, this.getMusicianDistance(), EntitySelector.NO_SPECTATORS);
        for (EntityCockroach roach : list) {
            if (roach.hasMaracas()) continue;
            roach.setNearestMusician(this.getUUID());
        }
    }

    private AABB getMusicianDistance() {
        return this.getBoundingBox().inflate(10.0, 10.0, 10.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 67) {
            AlexsMobs.PROXY.onEntityStatus((Entity)this, id);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public Entity getNearestMusician() {
        UUID id = this.getNearestMusicianId();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    public void setNearestMusician(@Nullable UUID uniqueId) {
        this.entityData.set(NEAREST_MUSICIAN, Optional.ofNullable(uniqueId));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRecordPlayingNearby(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.isJukeboxing = isPartying;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityCockroach roach = (EntityCockroach)((EntityType)AMEntityRegistry.COCKROACH.get()).create((Level)serverWorld);
        roach.setBreaded(true);
        return roach;
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby() && !this.isHeadless();
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.readyForShearing();
    }

    public void shear(SoundSource category) {
        this.hurt(this.damageSources().generic(), 0.0f);
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, category, 1.0f, 1.0f);
        this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
        this.setHeadless(true);
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
        this.hurt(this.damageSources().generic(), 0.0f);
        if (!world.isClientSide) {
            for (int i = 0; i < 3; ++i) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SNEEZE, this.getRandomX(0.52f), this.getY(1.0), this.getRandomZ(0.52f), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.setHeadless(true);
        return Collections.emptyList();
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.has(DataComponents.FOOD) || stack.is(AMTagRegistry.COCKROACH_BREEDABLES);
    }

    public void travel(Vec3 vec3d) {
        if (this.isDancing() || this.danceProgress > 0.0f) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        if (e.getItem().getItem() == AMItemRegistry.MARACA.get()) {
            this.setMaracas(true);
        } else {
            if (e.getItem().hasCraftingRemainingItem()) {
                this.spawnAtLocation(e.getItem().getCraftingRemainingItem().copy());
            }
            this.heal(5.0f);
            if (e.getItem().is(AMTagRegistry.COCKROACH_FOODSTUFFS)) {
                this.setBreaded(true);
            }
        }
    }
}

