/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAISwimBottom;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityCatfish
extends WaterAnimal
implements FlyingAnimal,
Bucketable,
ContainerListener {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(EntityCatfish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> CATFISH_SIZE = SynchedEntityData.defineId(EntityCatfish.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SPIT_TIME = SynchedEntityData.defineId(EntityCatfish.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> HAS_SWALLOWED_ENTITY = SynchedEntityData.defineId(EntityCatfish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> SWALLOWED_ENTITY_TYPE = SynchedEntityData.defineId(EntityCatfish.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<CompoundTag> SWALLOWED_ENTITY_DATA = SynchedEntityData.defineId(EntityCatfish.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDimensions SMALL_SIZE = EntityDimensions.scalable((float)0.9f, (float)0.6f);
    private static final EntityDimensions MEDIUM_SIZE = EntityDimensions.scalable((float)1.25f, (float)0.9f);
    private static final EntityDimensions LARGE_SIZE = EntityDimensions.scalable((float)1.9f, (float)0.9f);
    public static final ResourceLocation MEDIUM_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/catfish_medium");
    public static final ResourceLocation LARGE_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/catfish_large");
    public SimpleContainer catfishInventory;
    private int eatCooldown = 0;

    protected EntityCatfish(EntityType<? extends WaterAnimal> type, Level level) {
        super(type, level);
        this.initCatfishInventory();
        this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.0f, 15.0f);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public boolean isMaxGroupSizeReached(int sze) {
        return sze > 2;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TargetFoodGoal(this));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(AMTagRegistry.CATFISH_ITEM_FASCINATIONS), false));
        this.goalSelector.addGoal(5, (Goal)new FascinateLanternGoal(this));
        this.goalSelector.addGoal(6, (Goal)new AnimalAISwimBottom((PathfinderMob)this, 1.0, 7));
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    private void initCatfishInventory() {
        SimpleContainer animalchest = this.catfishInventory;
        int size = this.getCatfishSize() > 2 ? 1 : (this.getCatfishSize() == 1 ? 9 : 3);
        this.catfishInventory = new SimpleContainer(size){

            public boolean stillValid(Player player) {
                return EntityCatfish.this.isAlive() && EntityCatfish.this.portalProcess == null;
            }
        };
        this.catfishInventory.addListener((ContainerListener)this);
        if (animalchest != null) {
            int i = Math.min(animalchest.getContainerSize(), this.catfishInventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.catfishInventory.setItem(j, itemstack.copy());
            }
        }
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.catfishInventory != null) {
            for (int i = 0; i < this.catfishInventory.getContainerSize(); ++i) {
                this.spawnAtLocation(this.catfishInventory.getItem(i));
            }
            this.catfishInventory.clearContent();
        }
        if (this.getCatfishSize() == 2) {
            this.spit();
        }
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.hasCustomName() || this.fromBucket() || this.hasSwallowedEntity() || this.catfishInventory != null && !this.catfishInventory.isEmpty();
    }

    public static boolean canCatfishSpawn(EntityType<EntityCatfish> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        return iServerWorld.getFluidState(pos).is((Fluid)Fluids.WATER) && iServerWorld.getFluidState(pos.above()).is((Fluid)Fluids.WATER) && !iServerWorld.getBlockState(pos).isAir();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.catfishSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROM_BUCKET, (Object)false);
        builder.define(CATFISH_SIZE, (Object)0);
        builder.define(SPIT_TIME, (Object)0);
        builder.define(SWALLOWED_ENTITY_TYPE, (Object)"minecraft:pig");
        builder.define(SWALLOWED_ENTITY_DATA, (Object)new CompoundTag());
        builder.define(HAS_SWALLOWED_ENTITY, (Object)false);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getSpitTime() > 0) {
                this.setSpitTime(this.getSpitTime() - 1);
            }
            if (this.eatCooldown > 0) {
                --this.eatCooldown;
            }
        }
    }

    public void aiStep() {
        super.aiStep();
        boolean inSeaPickle = false;
        int width = (int)Math.ceil(this.getBbWidth() / 2.0f);
        int height = (int)Math.ceil(this.getBbHeight() / 2.0f);
        BlockPos.MutableBlockPos pos = this.blockPosition().mutable();
        BlockPos.MutableBlockPos vomitTo = null;
        for (int i = -width; i <= width; ++i) {
            block1: for (int j = -height; j <= height; ++j) {
                for (int k = -width; k <= width; ++k) {
                    pos.set(this.getX() + (double)i, this.getY() + (double)j, this.getZ() + (double)k);
                    if (!this.level().getBlockState((BlockPos)pos).is(Blocks.SEA_PICKLE)) continue;
                    inSeaPickle = true;
                    vomitTo = pos;
                    continue block1;
                }
            }
        }
        if (inSeaPickle && this.canSpit()) {
            if (this.getSpitTime() == 0) {
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.PLAYER_BURP, this.getSoundVolume(), this.getVoicePitch());
            }
            if (vomitTo != null) {
                Vec3 face = Vec3.atCenterOf(vomitTo).subtract(this.getMouthVec());
                double d0 = face.horizontalDistance();
                this.setXRot((float)(-Mth.atan2((double)face.y, (double)d0) * 57.2957763671875));
                this.setYRot((float)Mth.atan2((double)face.z, (double)face.x) * 57.295776f - 90.0f);
                this.yBodyRot = this.getYRot();
                this.yHeadRot = this.getYRot();
            }
            this.spit();
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        if (CATFISH_SIZE.equals(accessor)) {
            this.refreshDimensions();
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(10.0f * (float)this.getCatfishSize() + 10.0f));
            this.heal(50.0f);
        }
        super.onSyncedDataUpdated(accessor);
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean bucketed) {
        this.entityData.set(FROM_BUCKET, (Object)bucketed);
    }

    public void saveToBucketTag(@Nonnull ItemStack bucket) {
        if (this.hasCustomName()) {
            bucket.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)bucket);
        CompoundTag compound = ((CustomData)bucket.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        this.addAdditionalSaveData(compound);
    }

    public void loadFromBucketTag(@Nonnull CompoundTag compound) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)compound);
        this.readAdditionalSaveData(compound);
    }

    public ItemStack getBucketItemStack() {
        int catfishSize = this.getCatfishSize();
        Item item = switch (catfishSize) {
            case 1 -> (Item)AMItemRegistry.MEDIUM_CATFISH_BUCKET.get();
            case 2 -> (Item)AMItemRegistry.LARGE_CATFISH_BUCKET.get();
            default -> (Item)AMItemRegistry.SMALL_CATFISH_BUCKET.get();
        };
        return new ItemStack((ItemLike)item);
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public int getCatfishSize() {
        return Mth.clamp((int)((Integer)this.entityData.get(CATFISH_SIZE)), (int)0, (int)2);
    }

    public void setCatfishSize(int catfishSize) {
        this.entityData.set(CATFISH_SIZE, (Object)catfishSize);
    }

    public int getSpitTime() {
        return (Integer)this.entityData.get(SPIT_TIME);
    }

    public void setSpitTime(int time) {
        this.entityData.set(SPIT_TIME, (Object)time);
    }

    public boolean isSpitting() {
        return this.getSpitTime() > 0;
    }

    public String getSwallowedEntityType() {
        return (String)this.entityData.get(SWALLOWED_ENTITY_TYPE);
    }

    public void setSwallowedEntityType(String containedEntityType) {
        this.entityData.set(SWALLOWED_ENTITY_TYPE, (Object)containedEntityType);
    }

    public CompoundTag getSwallowedData() {
        return (CompoundTag)this.entityData.get(SWALLOWED_ENTITY_DATA);
    }

    public void setSwallowedData(CompoundTag containedData) {
        this.entityData.set(SWALLOWED_ENTITY_DATA, (Object)containedData);
    }

    public boolean hasSwallowedEntity() {
        return (Boolean)this.entityData.get(HAS_SWALLOWED_ENTITY);
    }

    public void setHasSwallowedEntity(boolean swallowedEntity) {
        this.entityData.set(HAS_SWALLOWED_ENTITY, (Object)swallowedEntity);
    }

    public boolean hurt(DamageSource source, float f) {
        if (super.hurt(source, f)) {
            this.spit();
            return true;
        }
        return false;
    }

    @Nonnull
    protected InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() == Items.SEA_PICKLE) {
            this.spit();
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("FromBucket", this.fromBucket());
        compound.putFloat("CatfishSize", (float)this.getCatfishSize());
        if (this.catfishInventory != null) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.catfishInventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.catfishInventory.getItem(i);
                if (itemstack.isEmpty()) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                CompoundNBT.putByte("Slot", (byte)i);
                itemstack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)CompoundNBT);
                nbttaglist.add((Object)CompoundNBT);
            }
            compound.put("Items", (Tag)nbttaglist);
        }
        compound.putString("ContainedEntityType", this.getSwallowedEntityType());
        compound.put("ContainedData", (Tag)this.getSwallowedData());
        compound.putBoolean("HasSwallowedEntity", this.hasSwallowedEntity());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFromBucket(compound.getBoolean("FromBucket"));
        this.setCatfishSize(compound.getInt("CatfishSize"));
        if (this.catfishInventory != null) {
            ListTag nbttaglist = compound.getList("Items", 10);
            this.initCatfishInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag CompoundNBT = nbttaglist.getCompound(i);
                int j = CompoundNBT.getByte("Slot") & 0xFF;
                this.catfishInventory.setItem(j, ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)CompoundNBT));
            }
        }
        this.setSwallowedEntityType(compound.getString("ContainedEntityType"));
        if (!compound.getCompound("ContainedData").isEmpty()) {
            this.setSwallowedData(compound.getCompound("ContainedData"));
        }
        this.setHasSwallowedEntity(compound.getBoolean("HasSwallowedEntity"));
    }

    private EntityDimensions getDimsForCatfish() {
        return switch (this.getCatfishSize()) {
            case 1 -> MEDIUM_SIZE;
            case 2 -> LARGE_SIZE;
            default -> SMALL_SIZE;
        };
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.getDimsForCatfish();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        Holder holder;
        this.setCatfishSize(this.random.nextFloat() < 0.35f ? 1 : 0);
        if (this.random.nextFloat() < 0.1f && ((holder = worldIn.getBiome(this.blockPosition())).is(AMTagRegistry.SPAWNS_HUGE_CATFISH) || reason == MobSpawnType.SPAWN_EGG)) {
            this.setCatfishSize(2);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    protected void playStepSound(BlockPos p_180429_1_, BlockState p_180429_2_) {
    }

    public void containerChanged(Container p_18983_) {
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.getItem();
        if (this.getCatfishSize() != 2 && !this.isFull() && this.catfishInventory != null && this.catfishInventory.addItem(itemstack).isEmpty()) {
            this.onItemPickup(itemEntity);
            this.take((Entity)itemEntity, itemstack.getCount());
            itemEntity.discard();
            this.gameEvent((Holder)GameEvent.EAT);
            this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public boolean isFull() {
        if (this.getCatfishSize() == 2 || this.catfishInventory == null) {
            return this.hasSwallowedEntity();
        }
        for (int i = 0; i < this.catfishInventory.getContainerSize(); ++i) {
            if (!this.catfishInventory.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public float getVoicePitch() {
        float f = (float)(3 - this.getCatfishSize()) * 0.33f;
        return (float)((double)super.getVoicePitch() * Math.sqrt(f) * (double)1.2f);
    }

    public boolean swallowEntity(Entity entity) {
        if (this.getCatfishSize() == 2 && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            this.setHasSwallowedEntity(true);
            ResourceLocation mobtype = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType());
            if (mobtype != null) {
                this.setSwallowedEntityType(mobtype.toString());
            }
            CompoundTag tag = new CompoundTag();
            mob.addAdditionalSaveData(tag);
            this.setSwallowedData(tag);
            this.gameEvent((Holder)GameEvent.EAT);
            this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
            return true;
        }
        if (this.getCatfishSize() < 2 && entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            this.pickUpItem(item);
        }
        return false;
    }

    public boolean canSpit() {
        return this.getCatfishSize() == 2 ? this.hasSwallowedEntity() : this.catfishInventory != null && !this.catfishInventory.isEmpty();
    }

    public void spit() {
        this.setSpitTime(10);
        this.eatCooldown = 60 + this.random.nextInt(60);
        if (this.getCatfishSize() == 2) {
            Entity entity;
            EntityType type;
            if (this.hasSwallowedEntity() && (type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)this.getSwallowedEntityType()))) != null && (entity = type.create(this.level())) instanceof LivingEntity) {
                LivingEntity alive = (LivingEntity)entity;
                alive.readAdditionalSaveData(this.getSwallowedData());
                alive.setHealth(Math.max(2.0f, alive.getMaxHealth() * 0.25f));
                alive.setYRot(this.random.nextFloat() * 360.0f - 180.0f);
                alive.setPos(this.getMouthVec());
                if (this.level().addFreshEntity((Entity)alive)) {
                    this.setHasSwallowedEntity(false);
                    this.setSwallowedEntityType("minecraft:pig");
                    this.setSwallowedData(new CompoundTag());
                }
            }
        } else {
            ItemStack itemStack = ItemStack.EMPTY;
            int index = -1;
            if (this.catfishInventory != null) {
                for (int i = 0; i < this.catfishInventory.getContainerSize(); ++i) {
                    if (this.catfishInventory.getItem(i).isEmpty()) continue;
                    itemStack = this.catfishInventory.getItem(i);
                    index = i;
                    break;
                }
            }
            if (!itemStack.isEmpty()) {
                Vec3 vec3 = this.getMouthVec();
                Vec3 vec32 = vec3.subtract(this.position()).normalize().scale((double)0.14f);
                ItemEntity item = new ItemEntity(this.level(), vec3.x, vec3.y, vec3.z, itemStack, vec32.x, vec32.y, vec32.z);
                item.setDeltaMovement(Vec3.ZERO);
                item.setPickUpDelay(30);
                if (this.level().addFreshEntity((Entity)item) && this.catfishInventory != null) {
                    this.catfishInventory.setItem(index, ItemStack.EMPTY);
                }
            }
        }
    }

    private Vec3 getMouthVec() {
        Vec3 vec3 = new Vec3(0.0, (double)(this.getBbHeight() * 0.25f), (double)(this.getBbWidth() * 0.8f)).xRot(this.getXRot() * ((float)Math.PI / 180)).yRot(-this.getYRot() * ((float)Math.PI / 180));
        return this.position().add(vec3);
    }

    private boolean isFood(Entity entity) {
        if (this.getCatfishSize() == 2) {
            return !entity.getType().is(AMTagRegistry.CATFISH_IGNORE_EATING) && entity instanceof Mob && !(entity instanceof EntityCatfish) && entity.getBbHeight() <= 1.0f;
        }
        return entity instanceof ItemEntity && ((ItemEntity)entity).getAge() > 35;
    }

    private boolean canSeeBlock(BlockPos destinationBlock) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 blockVec = Vec3.atCenterOf((Vec3i)destinationBlock);
        BlockHitResult result = this.level().clip(new ClipContext(Vector3d, blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return result.getBlockPos().equals((Object)destinationBlock);
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COD_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.COD_HURT;
    }

    public boolean isFlying() {
        return false;
    }

    private class TargetFoodGoal
    extends Goal {
        private final EntityCatfish catfish;
        private Entity food;
        private int executionCooldown = 50;

        public TargetFoodGoal(EntityCatfish catfish) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.catfish = catfish;
        }

        public boolean canUse() {
            if (!this.catfish.isInWaterOrBubble() || this.catfish.eatCooldown > 0) {
                return false;
            }
            if (this.executionCooldown > 0) {
                --this.executionCooldown;
            } else {
                this.executionCooldown = 50 + EntityCatfish.this.random.nextInt(50);
                if (!this.catfish.isFull()) {
                    List list = this.catfish.level().getEntitiesOfClass(Entity.class, this.catfish.getBoundingBox().inflate(8.0, 8.0, 8.0), EntitySelector.NO_SPECTATORS.and(entity -> entity != this.catfish && this.catfish.isFood((Entity)entity)));
                    list.sort(Comparator.comparingDouble(arg_0 -> ((EntityCatfish)this.catfish).distanceToSqr(arg_0)));
                    if (!list.isEmpty()) {
                        this.food = (Entity)list.get(0);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.food != null && this.food.isAlive() && !this.catfish.isFull();
        }

        public void stop() {
            this.executionCooldown = 5;
        }

        public void tick() {
            this.catfish.getNavigation().moveTo(this.food.getX(), this.food.getY(0.5), this.food.getZ(), 1.0);
            float eatDist = this.catfish.getBbWidth() * 0.65f + this.food.getBbWidth();
            if (this.catfish.distanceTo(this.food) < eatDist + 3.0f && this.catfish.hasLineOfSight(this.food)) {
                Vec3 delta = this.catfish.getMouthVec().subtract(this.food.position()).normalize().scale((double)0.1f);
                this.food.setDeltaMovement(this.food.getDeltaMovement().add(delta));
                if (this.catfish.distanceTo(this.food) < eatDist) {
                    if (this.food instanceof Player) {
                        this.food.hurt(this.catfish.damageSources().mobAttack((LivingEntity)this.catfish), 12000.0f);
                    } else if (this.catfish.swallowEntity(this.food)) {
                        this.catfish.gameEvent((Holder)GameEvent.EAT);
                        this.catfish.playSound(SoundEvents.GENERIC_EAT, this.catfish.getSoundVolume(), this.catfish.getVoicePitch());
                        this.food.discard();
                    }
                }
            }
        }
    }

    private class FascinateLanternGoal
    extends Goal {
        private final int searchLength;
        private final int verticalSearchRange;
        protected BlockPos destinationBlock;
        private final EntityCatfish fish;
        private int runDelay = 70;
        private int chillTime = 0;
        private int maxChillTime = 200;

        private FascinateLanternGoal(EntityCatfish fish) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.fish = fish;
            this.searchLength = 16;
            this.verticalSearchRange = 6;
        }

        public boolean canContinueToUse() {
            return this.destinationBlock != null && this.isSeaLantern(this.fish.level(), this.destinationBlock.mutable()) && this.isCloseToLantern(16.0) && !this.fish.isFull();
        }

        public boolean isCloseToLantern(double dist) {
            return this.destinationBlock == null || this.fish.distanceToSqr(Vec3.atCenterOf((Vec3i)this.destinationBlock)) < dist * dist;
        }

        public boolean canUse() {
            if (!this.fish.isInWaterOrBubble()) {
                return false;
            }
            if (this.runDelay > 0) {
                --this.runDelay;
                return false;
            }
            this.runDelay = 70 + this.fish.random.nextInt(70);
            return !this.fish.isFull() && this.searchForDestination();
        }

        public void start() {
            this.chillTime = 0;
            this.maxChillTime = 10 + EntityCatfish.this.random.nextInt(20);
        }

        public void tick() {
            Vec3 vec = Vec3.atCenterOf((Vec3i)this.destinationBlock);
            this.fish.getNavigation().moveTo(vec.x, vec.y, vec.z, 1.0);
            if (this.fish.distanceToSqr(vec) < (double)(1.0f + this.fish.getBbWidth() * 0.6f)) {
                Vec3 face = vec.subtract(this.fish.position());
                this.fish.setDeltaMovement(this.fish.getDeltaMovement().add(face.normalize().scale((double)0.1f)));
                if (this.chillTime++ > this.maxChillTime) {
                    this.destinationBlock = null;
                }
            }
        }

        public void stop() {
            this.destinationBlock = null;
        }

        protected boolean searchForDestination() {
            int lvt_1_1_ = this.searchLength;
            BlockPos lvt_3_1_ = this.fish.blockPosition();
            BlockPos.MutableBlockPos lvt_4_1_ = new BlockPos.MutableBlockPos();
            for (int lvt_5_1_ = -8; lvt_5_1_ <= 2; ++lvt_5_1_) {
                for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_1_1_; ++lvt_6_1_) {
                    int lvt_7_1_ = 0;
                    while (lvt_7_1_ <= lvt_6_1_) {
                        int lvt_8_1_;
                        int n = lvt_8_1_ = lvt_7_1_ < lvt_6_1_ && lvt_7_1_ > -lvt_6_1_ ? lvt_6_1_ : 0;
                        while (lvt_8_1_ <= lvt_6_1_) {
                            lvt_4_1_.setWithOffset((Vec3i)lvt_3_1_, lvt_7_1_, lvt_5_1_ - 1, lvt_8_1_);
                            if (this.isSeaLantern(this.fish.level(), lvt_4_1_) && this.fish.canSeeBlock((BlockPos)lvt_4_1_)) {
                                this.destinationBlock = lvt_4_1_;
                                return true;
                            }
                            lvt_8_1_ = lvt_8_1_ > 0 ? -lvt_8_1_ : 1 - lvt_8_1_;
                        }
                        lvt_7_1_ = lvt_7_1_ > 0 ? -lvt_7_1_ : 1 - lvt_7_1_;
                    }
                }
            }
            return false;
        }

        private boolean isSeaLantern(Level world, BlockPos.MutableBlockPos pos) {
            return world.getBlockState((BlockPos)pos).is(AMTagRegistry.CATFISH_BLOCK_FASCINATIONS);
        }
    }
}

