/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotEcho;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotPart;
import com.github.alexthe666.alexsmobs.entity.EntityGiantSquid;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFollowParentRanged;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalSwimMoveControllerSink;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;

public class EntityCachalotWhale
extends Animal {
    private static final TargetingConditions REWARD_PLAYER_PREDICATE = TargetingConditions.forNonCombat().range(50.0).ignoreLineOfSight();
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.defineId(EntityCachalotWhale.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.defineId(EntityCachalotWhale.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BEACHED = SynchedEntityData.defineId(EntityCachalotWhale.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ALBINO = SynchedEntityData.defineId(EntityCachalotWhale.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DESPAWN_BEACH = SynchedEntityData.defineId(EntityCachalotWhale.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GRABBING = SynchedEntityData.defineId(EntityCachalotWhale.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HOLDING_SQUID_LEFT = SynchedEntityData.defineId(EntityCachalotWhale.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> CAUGHT_ID = SynchedEntityData.defineId(EntityCachalotWhale.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final double[][] ringBuffer = new double[64][3];
    public final EntityCachalotPart headPart;
    public final EntityCachalotPart bodyFrontPart;
    public final EntityCachalotPart bodyPart;
    public final EntityCachalotPart tail1Part;
    public final EntityCachalotPart tail2Part;
    public final EntityCachalotPart tail3Part;
    public final EntityCachalotPart[] whaleParts;
    private final boolean hasAlbinoAttribute = false;
    public int ringBufferIndex = -1;
    public float prevChargingProgress;
    public float chargeProgress;
    public float prevSleepProgress;
    public float sleepProgress;
    public float prevBeachedProgress;
    public float beachedProgress;
    public float prevGrabProgress;
    public float grabProgress;
    public int grabTime = 0;
    private boolean receivedEcho = false;
    private boolean waitForEchoFlag = true;
    private int echoTimer = 0;
    private boolean prevEyesInWater = false;
    private int spoutTimer = 0;
    private int chargeCooldown = 0;
    private float whaleSpeedMod = 1.0f;
    private int rewardTime = 0;
    private Player rewardPlayer;
    private int blockBreakCounter;
    private int despawnDelay = 47999;
    private int echoSoundCooldown = 0;
    private boolean hasRewardedPlayer = false;

    public EntityCachalotWhale(EntityType type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new AnimalSwimMoveControllerSink((PathfinderMob)this, 1.0f, 1.0f, 6.0f);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 4);
        this.headPart = new EntityCachalotPart(this, 3.0f, 3.5f);
        this.bodyFrontPart = new EntityCachalotPart(this, 4.0f, 4.0f);
        this.bodyPart = new EntityCachalotPart(this, 5.0f, 4.0f);
        this.tail1Part = new EntityCachalotPart(this, 4.0f, 3.0f);
        this.tail2Part = new EntityCachalotPart(this, 3.0f, 2.0f);
        this.tail3Part = new EntityCachalotPart(this, 3.0f, 0.7f);
        this.whaleParts = new EntityCachalotPart[]{this.headPart, this.bodyFrontPart, this.bodyPart, this.tail1Part, this.tail2Part, this.tail3Part};
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 160.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, (double)1.2f).add(Attributes.ATTACK_DAMAGE, 30.0);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public static <T extends Mob> boolean canCachalotWhaleSpawn(EntityType<T> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockPos up = pos;
        while (up.getY() < iServerWorld.getMaxBuildHeight() && iServerWorld.getFluidState(up).is(FluidTags.WATER)) {
            up = up.above();
        }
        return iServerWorld.getFluidState(up.below()).is(FluidTags.WATER) && up.getY() < iServerWorld.getSeaLevel() + 15 && iServerWorld.canSeeSky(up);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isSleeping() && !this.isCharging() && !this.isDespawnBeach() && !this.isAlbino();
    }

    private boolean canDespawn() {
        return this.isDespawnBeach();
    }

    private void tryDespawn() {
        if (this.canDespawn()) {
            --this.despawnDelay;
            if (this.despawnDelay <= 0) {
                this.dropLeash(true, false);
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.CACHALOT_WHALE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.CACHALOT_WHALE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.CACHALOT_WHALE_HURT.get();
    }

    public void scaleParts() {
        for (EntityCachalotPart parts : this.whaleParts) {
            float prev = parts.scale;
            float f = parts.scale = this.isBaby() ? 0.5f : 1.0f;
            if (prev == parts.scale) continue;
            parts.refreshDimensions();
        }
    }

    public boolean isPickable() {
        return true;
    }

    public void pushEntities() {
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        return super.mobInteract(player, hand);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Albino", this.isAlbino());
        compound.putBoolean("Beached", this.isBeached());
        compound.putBoolean("BeachedDespawnFlag", this.isDespawnBeach());
        compound.putBoolean("GivenReward", this.hasRewardedPlayer);
        compound.putInt("DespawnDelay", this.despawnDelay);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setAlbino(compound.getBoolean("Albino"));
        this.setBeached(compound.getBoolean("Beached"));
        this.setDespawnBeach(compound.getBoolean("BeachedDespawnFlag"));
        if (compound.contains("DespawnDelay", 99)) {
            this.despawnDelay = compound.getInt("DespawnDelay");
        }
        this.hasRewardedPlayer = compound.getBoolean("GivenReward");
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CHARGING, (Object)false);
        builder.define(SLEEPING, (Object)false);
        builder.define(BEACHED, (Object)false);
        builder.define(ALBINO, (Object)false);
        builder.define(GRABBING, (Object)false);
        builder.define(HOLDING_SQUID_LEFT, (Object)false);
        builder.define(DESPAWN_BEACH, (Object)false);
        builder.define(CAUGHT_ID, (Object)-1);
    }

    public boolean hasCaughtSquid() {
        return (Integer)this.entityData.get(CAUGHT_ID) != -1;
    }

    private void setCaughtSquidId(int i) {
        this.entityData.set(CAUGHT_ID, (Object)i);
    }

    @Nullable
    public Entity getCaughtSquid() {
        if (!this.hasCaughtSquid()) {
            return null;
        }
        return this.level().getEntity(((Integer)this.entityData.get(CAUGHT_ID)).intValue());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new AIBreathe());
        this.goalSelector.addGoal(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AnimalAIFollowParentRanged(this, 1.1f, 32.0f, 10.0f));
        this.goalSelector.addGoal(4, (Goal)new AnimalAIRandomSwimming((PathfinderMob)this, 0.6, 10, 24, true){

            @Override
            public boolean canUse() {
                return !EntityCachalotWhale.this.isSleeping() && !EntityCachalotWhale.this.isBeached() && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 20.0f));
        this.goalSelector.addGoal(7, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.targetSelector.addGoal(1, (Goal)new AnimalAIHurtByTargetNotBaby(this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new EntityAINearestTarget3D((Mob)this, LivingEntity.class, 30, false, true, AMEntityRegistry.buildPredicateFromTag(AMTagRegistry.CACHALOT_WHALE_TARGETS)){

            public boolean canUse() {
                return !EntityCachalotWhale.this.isSleeping() && !EntityCachalotWhale.this.isBeached() && super.canUse();
            }
        });
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.breakBlock();
    }

    public void breakBlock() {
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            return;
        }
        boolean flag = false;
        if (!this.level().isClientSide && this.blockBreakCounter == 0 && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            TagKey<Block> breakables = this.isCharging() && this.getTarget() != null && AMConfig.cachalotDestruction ? AMTagRegistry.CACHALOT_WHALE_BREAKABLES : AMTagRegistry.ORCA_BREAKABLES;
            for (int a = (int)Math.round(this.getBoundingBox().minX); a <= (int)Math.round(this.getBoundingBox().maxX); ++a) {
                for (int b = (int)Math.round(this.getBoundingBox().minY) - 1; b <= (int)Math.round(this.getBoundingBox().maxY) + 1 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.getBoundingBox().minZ); c <= (int)Math.round(this.getBoundingBox().maxZ); ++c) {
                        Block block;
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.level().getBlockState(pos);
                        FluidState fluidState = this.level().getFluidState(pos);
                        if (state.isAir() || state.getShape((BlockGetter)this.level(), pos).isEmpty() || !state.is(breakables) || !fluidState.isEmpty() || (block = state.getBlock()) == Blocks.AIR) continue;
                        this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.6f, 1.0, (double)0.6f));
                        flag = true;
                        this.level().destroyBlock(pos, true);
                        if (!state.is(BlockTags.ICE)) continue;
                        this.level().setBlockAndUpdate(pos, Blocks.WATER.defaultBlockState());
                    }
                }
            }
        }
        if (flag) {
            this.blockBreakCounter = this.isCharging() && this.getTarget() != null ? 2 : 20;
        }
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    private void spawnSpoutParticles() {
        if (this.isAlive()) {
            float radius = this.headPart.getBbWidth() * 0.5f;
            for (int j = 0; j < 5 + this.random.nextInt(4); ++j) {
                float angle = (float)Math.PI / 180 * this.yBodyRot;
                double extraX = (double)(radius * (1.0f + this.random.nextFloat() * 0.13f) * Mth.sin((float)((float)Math.PI + angle)) + (this.random.nextFloat() - 0.5f)) + this.getDeltaMovement().x * 2.0;
                double extraZ = (double)(radius * (1.0f + this.random.nextFloat() * 0.13f) * Mth.cos((float)angle) + (this.random.nextFloat() - 0.5f)) + this.getDeltaMovement().z * 2.0;
                double motX = this.random.nextGaussian();
                double motZ = this.random.nextGaussian();
                this.level().addParticle((ParticleOptions)AMParticleRegistry.WHALE_SPLASH.get(), this.headPart.getX() + extraX, this.headPart.getY() + (double)this.headPart.getBbHeight(), this.headPart.getZ() + extraZ, motX * (double)0.1f + this.getDeltaMovement().x, 2.0, motZ * (double)0.1f + this.getDeltaMovement().z);
            }
        }
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.entityData.set(CHARGING, (Object)charging);
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(SLEEPING);
    }

    public void setSleeping(boolean charging) {
        this.entityData.set(SLEEPING, (Object)charging);
    }

    public boolean isBeached() {
        return (Boolean)this.entityData.get(BEACHED);
    }

    public void setBeached(boolean charging) {
        this.entityData.set(BEACHED, (Object)charging);
    }

    public boolean isGrabbing() {
        return (Boolean)this.entityData.get(GRABBING);
    }

    public void setGrabbing(boolean charging) {
        this.entityData.set(GRABBING, (Object)charging);
    }

    public boolean isHoldingSquidLeft() {
        return (Boolean)this.entityData.get(HOLDING_SQUID_LEFT);
    }

    public void setHoldingSquidLeft(boolean charging) {
        this.entityData.set(HOLDING_SQUID_LEFT, (Object)charging);
    }

    public boolean isAlbino() {
        return (Boolean)this.entityData.get(ALBINO);
    }

    public void setAlbino(boolean albino) {
        boolean prev = this.isAlbino();
        if (!prev && albino) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(230.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(45.0);
            this.setHealth(230.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(160.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(30.0);
        }
        this.entityData.set(ALBINO, (Object)albino);
    }

    public boolean isDespawnBeach() {
        return (Boolean)this.entityData.get(DESPAWN_BEACH);
    }

    public void setDespawnBeach(boolean despawn) {
        this.entityData.set(DESPAWN_BEACH, (Object)despawn);
    }

    protected float getSoundVolume() {
        return this.isSilent() ? 0.0f : (float)AMConfig.cachalotVolume;
    }

    public void aiStep() {
        super.aiStep();
        this.scaleParts();
        if (this.echoSoundCooldown > 0) {
            --this.echoSoundCooldown;
        }
        if (this.isSleeping()) {
            this.getNavigation().stop();
            this.setXRot(-90.0f);
            this.whaleSpeedMod = 0.0f;
            if (this.isEyeInFluid(FluidTags.WATER) && this.getAirSupply() < 200) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.06, 0.0));
            } else {
                BlockPos waterPos = this.blockPosition();
                while (this.level().getFluidState(waterPos).is(FluidTags.WATER) && waterPos.getY() < 255) {
                    waterPos = waterPos.above();
                }
                double d = (double)waterPos.getY() - this.getY();
                int n = this.isBaby() ? 7 : 12;
                if (d < (double)n) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.06, 0.0));
                }
                if (this.random.nextInt(100) == 0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, this.random.nextGaussian() * 0.06, 0.0));
                }
            }
        } else if (this.whaleSpeedMod == 0.0f) {
            this.whaleSpeedMod = 1.0f;
        }
        float rPitch = -((float)this.getDeltaMovement().y * 57.295776f);
        if (this.isGrabbing()) {
            this.setXRot(0.0f);
        } else {
            this.setXRot(Mth.clamp((float)rPitch, (float)-90.0f, (float)90.0f));
        }
        if (this.onGround() && !this.isInWaterOrBubble()) {
            this.setBeached(true);
            this.setXRot(0.0f);
            this.setSleeping(false);
        }
        if (this.isBeached()) {
            this.whaleSpeedMod = 0.0f;
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 1.0, 0.5));
            if (this.isEyeInFluid(FluidTags.WATER)) {
                Player entity = this.level().getNearestPlayer(REWARD_PLAYER_PREDICATE, (LivingEntity)this);
                if (this.getLastHurtByMob() != entity) {
                    this.rewardPlayer = entity;
                }
                this.despawnDelay = 47999;
                this.setBeached(false);
            }
        }
        if (this.rewardPlayer != null && !this.hasRewardedPlayer && this.isInWaterOrBubble()) {
            double d0 = this.rewardPlayer.getX() - this.getX();
            double d1 = this.rewardPlayer.getEyeY() - this.getEyeY();
            double d2 = this.rewardPlayer.getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            float targetYaw = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float targetPitch = (float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875));
            this.setYRot(this.getYRot() + Mth.clamp((float)(targetYaw - this.getYRot()), (float)-2.0f, (float)2.0f));
            this.setXRot(this.getXRot() + Mth.clamp((float)(targetPitch - this.getXRot()), (float)-2.0f, (float)2.0f));
            this.yBodyRot = this.getYRot();
            this.whaleSpeedMod = 0.1f;
            this.getMoveControl().setWantedPosition(this.rewardPlayer.getX(), this.rewardPlayer.getY(), this.rewardPlayer.getZ(), 0.5);
            if (this.distanceTo((Entity)this.rewardPlayer) < 10.0f) {
                if (!this.level().isClientSide) {
                    Vec3 vec = this.getMouthVec();
                    ItemEntity itementity = new ItemEntity(this.level(), vec.x, vec.y, vec.z, new ItemStack((ItemLike)AMItemRegistry.AMBERGRIS.get(), 2 + this.random.nextInt(2)));
                    itementity.setDefaultPickUpDelay();
                    this.level().addFreshEntity((Entity)itementity);
                }
                this.hasRewardedPlayer = true;
                this.rewardPlayer = null;
            }
        }
        this.prevChargingProgress = this.chargeProgress;
        this.prevSleepProgress = this.sleepProgress;
        this.prevBeachedProgress = this.beachedProgress;
        this.prevGrabProgress = this.grabProgress;
        if (this.tickCount % 200 == 0) {
            this.heal(2.0f);
        }
        if (this.isCharging()) {
            if (this.chargeProgress < 10.0f) {
                this.chargeProgress += 1.0f;
            }
        } else if (this.chargeProgress > 0.0f) {
            this.chargeProgress -= 1.0f;
        }
        if (this.isSleeping()) {
            if (this.sleepProgress < 10.0f) {
                this.sleepProgress += 1.0f;
            }
        } else if (this.sleepProgress > 0.0f) {
            this.sleepProgress -= 1.0f;
        }
        if (this.isBeached()) {
            if (this.beachedProgress < 10.0f) {
                this.beachedProgress += 1.0f;
            }
        } else if (this.beachedProgress > 0.0f) {
            this.beachedProgress -= 1.0f;
        }
        if (this.isGrabbing()) {
            if (this.grabProgress < 10.0f) {
                this.grabProgress += 1.0f;
            }
            ++this.grabTime;
        } else {
            if (this.grabProgress > 0.0f) {
                this.grabProgress -= 1.0f;
            }
            this.grabTime = 0;
        }
        this.yHeadRot = this.getYRot();
        this.yBodyRot = this.getYRot();
        if (!this.isNoAi()) {
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.getYRot();
                    this.ringBuffer[i][1] = this.getY();
                }
            }
            ++this.ringBufferIndex;
            if (this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.getYRot();
            this.ringBuffer[this.ringBufferIndex][1] = this.getY();
            Vec3[] avector3d = new Vec3[this.whaleParts.length];
            for (int j = 0; j < this.whaleParts.length; ++j) {
                this.whaleParts[j].collideWithNearbyEntities();
                avector3d[j] = new Vec3(this.whaleParts[j].getX(), this.whaleParts[j].getY(), this.whaleParts[j].getZ());
            }
            float f15 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
            float f16 = Mth.cos((float)f15);
            float f17 = this.getYRot() * ((float)Math.PI / 180);
            float pitch = this.getXRot() * ((float)Math.PI / 180);
            float xRotDiv90 = Math.abs(this.getXRot() / 90.0f);
            float f3 = Mth.sin((float)f17) * (1.0f - xRotDiv90);
            float f18 = Mth.cos((float)f17) * (1.0f - xRotDiv90);
            this.setPartPosition(this.bodyPart, f3 * 0.5f, -pitch * 0.5f, -f18 * 0.5f);
            this.setPartPosition(this.bodyFrontPart, f3 * -3.5f, -pitch * 3.0f, f18 * 3.5f);
            this.setPartPosition(this.headPart, f3 * -7.0f, -pitch * 5.0f, -f18 * -7.0f);
            double[] adouble = this.getMovementOffsets(5, 1.0f);
            for (int k = 0; k < 3; ++k) {
                EntityCachalotPart enderdragonpartentity = k == 0 ? this.tail1Part : (k == 1 ? this.tail2Part : this.tail3Part);
                double[] adouble1 = this.getMovementOffsets(15 + k * 5, 1.0f);
                float f7 = this.getYRot() * ((float)Math.PI / 180) + (float)Mth.wrapDegrees((double)(adouble1[0] - adouble[0])) * ((float)Math.PI / 180);
                float f19 = 1.0f - Math.abs(this.getXRot() / 90.0f);
                float f20 = Mth.sin((float)f7) * f19;
                float f21 = Mth.cos((float)f7) * f19;
                float f22 = -3.6f;
                float f23 = (float)(k + 1) * -3.6f - 2.0f;
                this.setPartPosition(enderdragonpartentity, -(f3 * 0.5f + f20 * f23) * f16, pitch * 1.5f * (float)(k + 1), (f18 * 0.5f + f21 * f23) * f16);
            }
            for (int l = 0; l < this.whaleParts.length; ++l) {
                this.whaleParts[l].xo = avector3d[l].x;
                this.whaleParts[l].yo = avector3d[l].y;
                this.whaleParts[l].zo = avector3d[l].z;
                this.whaleParts[l].xOld = avector3d[l].x;
                this.whaleParts[l].yOld = avector3d[l].y;
                this.whaleParts[l].zOld = avector3d[l].z;
            }
        }
        if (!this.level().isClientSide) {
            LivingEntity target = this.getTarget();
            if (target == null || !target.isAlive()) {
                this.setGrabbing(false);
                this.whaleSpeedMod = this.isSleeping() ? 0.0f : 1.0f;
                this.setCharging(false);
                this.setCaughtSquidId(-1);
            } else if (!this.isBeached() && !this.isSleeping() && this.rewardPlayer == null) {
                if (this.isGrabbing() && this.getTarget().isAlive()) {
                    this.setCaughtSquidId(this.getTarget().getId());
                    this.whaleSpeedMod = 0.1f;
                    float scale = this.isBaby() ? 0.5f : 1.0f;
                    float offsetAngle = -((float)Math.cos((float)this.grabTime * 0.3f)) * 0.1f * this.grabProgress;
                    float renderYaw = (float)this.getMovementOffsets(0, 1.0f)[0];
                    Vec3 extraVec = new Vec3(0.0, 0.0, -3.0).xRot(-this.getXRot() * ((float)Math.PI / 180)).yRot(-renderYaw * ((float)Math.PI / 180));
                    Vec3 backOfHead = this.headPart.position().add(extraVec);
                    Vec3 swingVec = new Vec3(this.isHoldingSquidLeft() ? (double)1.4f : (double)-1.4f, -0.1, 3.0).xRot(-this.getXRot() * ((float)Math.PI / 180)).yRot(-renderYaw * ((float)Math.PI / 180)).yRot(offsetAngle);
                    Vec3 mouth = backOfHead.add(swingVec).scale((double)scale);
                    this.getTarget().setPos(mouth.x, mouth.y, mouth.z);
                    if (this.isHoldingSquidLeft()) {
                        this.getTarget().setYRot(this.yBodyRot + 90.0f - (float)Math.toDegrees(offsetAngle));
                    } else {
                        this.getTarget().setYRot(this.yBodyRot - 90.0f - (float)Math.toDegrees(offsetAngle));
                    }
                    if (this.getTarget() instanceof EntityGiantSquid && ((EntityGiantSquid)this.getTarget()).tickCaptured(this)) {
                        this.setGrabbing(false);
                        this.getTarget().setPos(this.getDismountLocationForPassenger(this.getTarget()));
                    }
                    if (this.grabTime % 20 == 0 && this.grabTime > 30) {
                        this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), (float)(4 + this.random.nextInt(4)));
                    }
                    if (this.grabTime > 300) {
                        this.setGrabbing(false);
                        this.getTarget().setPos(this.getDismountLocationForPassenger(this.getTarget()));
                    }
                } else {
                    this.setCaughtSquidId(-1);
                    this.lookAt((Entity)target, 360.0f, 360.0f);
                    boolean bl = this.waitForEchoFlag = this.getLastHurtByMob() == null || !this.getLastHurtByMob().is((Entity)target);
                    if (target instanceof Player || !target.isInWaterOrBubble()) {
                        this.waitForEchoFlag = false;
                    }
                    if (this.waitForEchoFlag && !this.receivedEcho) {
                        this.setCharging(false);
                        this.whaleSpeedMod = 0.25f;
                        if (this.echoTimer % 10 == 0) {
                            if (this.echoTimer % 40 == 0) {
                                this.playSound((SoundEvent)AMSoundRegistry.CACHALOT_WHALE_CLICK.get(), this.getSoundVolume(), this.getVoicePitch());
                                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                            }
                            EntityCachalotEcho echo = new EntityCachalotEcho(this.level(), this);
                            float radius = this.headPart.getBbWidth() * 0.5f;
                            float angle = (float)Math.PI / 180 * this.yBodyRot;
                            double extraX = (double)(radius * (1.0f + this.random.nextFloat() * 0.13f) * Mth.sin((float)((float)Math.PI + angle)) + (this.random.nextFloat() - 0.5f)) + this.getDeltaMovement().x * 2.0;
                            double extraZ = (double)(radius * (1.0f + this.random.nextFloat() * 0.13f) * Mth.cos((float)angle) + (this.random.nextFloat() - 0.5f)) + this.getDeltaMovement().z * 2.0;
                            double x = this.headPart.getX() + extraX;
                            double y = this.headPart.getY() + (double)this.headPart.getBbHeight() * 0.5;
                            double z = this.headPart.getZ() + extraZ;
                            echo.setPos(x, y, z);
                            double d0 = target.getX() - x;
                            double d1 = target.getY(0.1) - y;
                            double d2 = target.getZ() - z;
                            echo.shoot(d0, d1, d2, 1.0f, 0.0f);
                            this.level().addFreshEntity((Entity)echo);
                        }
                        ++this.echoTimer;
                    }
                    if (!this.waitForEchoFlag || this.receivedEcho) {
                        double d0 = target.getX() - this.getX();
                        double d1 = target.getEyeY() - this.getEyeY();
                        double d2 = target.getZ() - this.getZ();
                        double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
                        float targetYaw = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                        float targetPitch = (float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875));
                        this.setXRot(this.getXRot() + Mth.clamp((float)(targetPitch - this.getXRot()), (float)-2.0f, (float)2.0f));
                        if (d0 * d0 + d2 * d2 >= 4.0) {
                            this.setYRot(this.getYRot() + Mth.clamp((float)(targetYaw - this.getYRot()), (float)-2.0f, (float)2.0f));
                            this.yBodyRot = this.getYRot();
                        }
                        if (this.chargeCooldown <= 0 && Math.abs(Mth.wrapDegrees((float)targetYaw) - Mth.wrapDegrees((float)this.getYRot())) < 4.0f) {
                            this.setCharging(true);
                            this.whaleSpeedMod = 1.2f;
                            double distSq = d0 * d0 + d2 * d2;
                            if (distSq < 4.0) {
                                this.setYRot(this.yRotO);
                                this.yBodyRot = this.yRotO;
                                this.setDeltaMovement(this.getDeltaMovement().multiply(0.8, 1.0, 0.8));
                            } else {
                                if (this.isInWater() && target.isInWater()) {
                                    Vec3 vector3d = this.getDeltaMovement();
                                    Vec3 vector3d1 = new Vec3(target.getX() - this.getX(), target.getY() - this.getY(), target.getZ() - this.getZ());
                                    if (vector3d1.lengthSqr() > 1.0E-7) {
                                        vector3d1 = vector3d1.normalize().scale(0.5).add(vector3d.scale(0.8));
                                    }
                                    this.setDeltaMovement(vector3d1.x, vector3d1.y, vector3d1.z);
                                }
                                this.getMoveControl().setWantedPosition(target.getX(), target.getY(), target.getZ(), 1.0);
                            }
                            if (this.isCharging() && this.distanceTo((Entity)target) < this.getBbWidth() && this.chargeProgress > 4.0f) {
                                if (target instanceof EntityGiantSquid && !this.isBaby()) {
                                    this.setGrabbing(true);
                                    this.setHoldingSquidLeft(this.random.nextBoolean());
                                } else {
                                    target.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
                                }
                                this.setCharging(false);
                                Entity vector3d1 = target.getVehicle();
                                if (vector3d1 instanceof Boat) {
                                    Boat boat = (Boat)vector3d1;
                                    for (int i = 0; i < 3; ++i) {
                                        this.spawnAtLocation((ItemLike)boat.getVariant().getPlanks());
                                    }
                                    for (int j = 0; j < 2; ++j) {
                                        this.spawnAtLocation((ItemLike)Items.STICK);
                                    }
                                    target.removeVehicle();
                                    boat.hurt(this.damageSources().mobAttack((LivingEntity)this), 1000.0f);
                                    boat.remove(Entity.RemovalReason.DISCARDED);
                                }
                                int n = this.chargeCooldown = target instanceof Player ? 30 : 100;
                                if (this.random.nextInt(10) == 0) {
                                    Vec3 vec = this.getMouthVec();
                                    ItemEntity itementity = new ItemEntity(this.level(), vec.x, vec.y, vec.z, new ItemStack((ItemLike)AMItemRegistry.CACHALOT_WHALE_TOOTH.get()));
                                    itementity.setDefaultPickUpDelay();
                                    this.level().addFreshEntity((Entity)itementity);
                                }
                            }
                        }
                    }
                }
            }
            if (this.chargeCooldown > 0) {
                --this.chargeCooldown;
            }
            if (this.spoutTimer > 0) {
                this.level().broadcastEntityEvent((Entity)this, (byte)67);
                --this.spoutTimer;
                this.setXRot(0.0f);
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 0.0, 0.0));
            }
            if (this.isSleepTime() && !this.isSleeping() && this.isInWaterOrBubble() && this.getTarget() == null) {
                this.setSleeping(true);
            }
            if (this.isSleeping() && (!this.isSleepTime() || this.getTarget() != null)) {
                this.setSleeping(false);
            }
            if (target instanceof Player && ((Player)target).isCreative()) {
                this.setTarget(null);
            }
        }
        if (this.isAlive() && this.isCharging()) {
            for (Entity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.headPart.getBoundingBox().inflate(1.0))) {
                if (this.isAlliedTo(entity) || entity instanceof EntityCachalotPart || entity == this) continue;
                this.launch(entity, true);
            }
        }
        if (this.isInWater() && !this.isEyeInFluid(FluidTags.WATER) && this.getAirSupply() > 140) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.06, 0.0));
        }
        if (!this.level().isClientSide) {
            this.tryDespawn();
        }
        this.prevEyesInWater = this.isEyeInFluid(FluidTags.WATER);
    }

    private void launch(Entity e, boolean huge) {
        if ((e.onGround() || e.isInWater()) && !(e instanceof EntityCachalotWhale)) {
            double d0 = e.getX() - this.getX();
            double d1 = e.getZ() - this.getZ();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = huge ? 2.0f : 0.5f;
            e.push(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
        }
    }

    private boolean isSleepTime() {
        long time = this.level().getDayTime();
        return time > 18000L && time < 22812L && this.isInWaterOrBubble();
    }

    public Vec3 getReturnEchoVector() {
        return this.getVec(0.5);
    }

    public Vec3 getMouthVec() {
        return this.getVec(0.25);
    }

    private Vec3 getVec(double yShift) {
        float radius = this.headPart.getBbWidth() * 0.5f;
        float angle = (float)Math.PI / 180 * this.yBodyRot;
        double extraX = (double)(radius * (1.0f + this.random.nextFloat() * 0.13f) * Mth.sin((float)((float)Math.PI + angle)) + (this.random.nextFloat() - 0.5f)) + this.getDeltaMovement().x * 2.0;
        double extraZ = (double)(radius * (1.0f + this.random.nextFloat() * 0.13f) * Mth.cos((float)angle) + (this.random.nextFloat() - 0.5f)) + this.getDeltaMovement().z * 2.0;
        double x = this.headPart.getX() + extraX;
        double y = this.headPart.getY() + yShift;
        double z = this.headPart.getZ() + extraZ;
        return new Vec3(x, y, z);
    }

    public void setTarget(@Nullable LivingEntity entitylivingbaseIn) {
        LivingEntity prev = this.getTarget();
        if (prev != entitylivingbaseIn && entitylivingbaseIn != null) {
            this.receivedEcho = false;
        }
        super.setTarget(entitylivingbaseIn);
    }

    public double[] getMovementOffsets(int p_70974_1_, float partialTicks) {
        if (this.isDeadOrDying()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - p_70974_1_ & 0x3F;
        int j = this.ringBufferIndex - p_70974_1_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = this.ringBuffer[j][0] - d0;
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = Mth.lerp((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    public void push(Entity entityIn) {
    }

    private void setPartPosition(EntityCachalotPart part, double offsetX, double offsetY, double offsetZ) {
        part.setPos(this.getX() + offsetX * (double)part.scale, this.getY() + offsetY * (double)part.scale, this.getZ() + offsetZ * (double)part.scale);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.whaleParts;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityCachalotWhale whale = (EntityCachalotWhale)((EntityType)AMEntityRegistry.CACHALOT_WHALE.get()).create((Level)serverWorld);
        whale.setAlbino(this.isAlbino());
        return whale;
    }

    public boolean attackEntityPartFrom(EntityCachalotPart entityCachalotPart, DamageSource source, float amount) {
        return this.hurt(source, amount);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setAirSupply(this.getMaxAirSupply());
        this.setXRot(0.0f);
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(0.75f);
        }
        this.setAlbino(this.random.nextInt(100) == 0);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public boolean canBreatheUnderwaterAM() {
        return false;
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        this.updateAir(i);
    }

    public boolean isPushedByFluid() {
        return this.isBeached();
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        return worldIn.isUnobstructed((Entity)this);
    }

    protected void updateAir(int p_209207_1_) {
    }

    public int getMaxAirSupply() {
        return 4000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 67) {
            this.spawnSpoutParticles();
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected int increaseAirSupply(int currentAir) {
        if (!this.level().isClientSide && this.prevEyesInWater && this.spoutTimer <= 0 && !this.isEyeInFluid(FluidTags.WATER) && currentAir < this.getMaxAirSupply() / 2) {
            this.spoutTimer = 20 + this.random.nextInt(10);
        }
        return this.getMaxAirSupply();
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 3;
    }

    public void recieveEcho() {
        this.receivedEcho = true;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.cachalotWhaleSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity dismount) {
        Vec3 mouth = this.getMouthVec();
        BlockPos pos = AMBlockPos.fromVec3(mouth);
        while (!this.level().isEmptyBlock(pos) && !this.level().isWaterAt(pos) && pos.getY() < this.level().getMaxBuildHeight()) {
            pos = pos.above();
        }
        return new Vec3(mouth.x, (double)((float)pos.getY() + 0.5f), mouth.z);
    }

    class AIBreathe
    extends Goal {
        public AIBreathe() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return EntityCachalotWhale.this.getAirSupply() < 140;
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public boolean isInterruptable() {
            return false;
        }

        public void start() {
            this.navigate();
        }

        private void navigate() {
            Iterable lvt_1_1_ = BlockPos.betweenClosed((int)Mth.floor((double)(EntityCachalotWhale.this.getX() - 1.0)), (int)Mth.floor((double)EntityCachalotWhale.this.getY()), (int)Mth.floor((double)(EntityCachalotWhale.this.getZ() - 1.0)), (int)Mth.floor((double)(EntityCachalotWhale.this.getX() + 1.0)), (int)Mth.floor((double)(EntityCachalotWhale.this.getY() + 8.0)), (int)Mth.floor((double)(EntityCachalotWhale.this.getZ() + 1.0)));
            BlockPos lvt_2_1_ = null;
            for (BlockPos lvt_4_1_ : lvt_1_1_) {
                if (!this.canBreatheAt((LevelReader)EntityCachalotWhale.this.level(), lvt_4_1_)) continue;
                lvt_2_1_ = lvt_4_1_.below((int)((double)EntityCachalotWhale.this.getBbHeight() * 0.25));
                break;
            }
            if (lvt_2_1_ == null) {
                lvt_2_1_ = AMBlockPos.fromCoords(EntityCachalotWhale.this.getX(), EntityCachalotWhale.this.getY() + 4.0, EntityCachalotWhale.this.getZ());
            }
            if (EntityCachalotWhale.this.isEyeInFluid(FluidTags.WATER)) {
                EntityCachalotWhale.this.setDeltaMovement(EntityCachalotWhale.this.getDeltaMovement().add(0.0, (double)0.05f, 0.0));
            }
            EntityCachalotWhale.this.getNavigation().moveTo((double)lvt_2_1_.getX(), (double)lvt_2_1_.getY(), (double)lvt_2_1_.getZ(), 0.7);
        }

        public void tick() {
            this.navigate();
        }

        private boolean canBreatheAt(LevelReader p_205140_1_, BlockPos p_205140_2_) {
            BlockState lvt_3_1_ = p_205140_1_.getBlockState(p_205140_2_);
            return (p_205140_1_.getFluidState(p_205140_2_).isEmpty() || lvt_3_1_.is(Blocks.BUBBLE_COLUMN)) && lvt_3_1_.isPathfindable(PathComputationType.LAND);
        }
    }
}

