/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeapRandomly;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.BunfungusAIBeg;
import com.github.alexthe666.alexsmobs.entity.ai.BunfungusAIMelee;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class EntityBunfungus
extends PathfinderMob
implements IAnimatedEntity {
    public static final Animation ANIMATION_SLAM = Animation.create((int)20);
    public static final Animation ANIMATION_BELLY = Animation.create((int)10);
    public static final Animation ANIMATION_EAT = Animation.create((int)20);
    private static final EntityDataAccessor<Boolean> JUMP_ACTIVE = SynchedEntityData.defineId(EntityBunfungus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.defineId(EntityBunfungus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BEGGING = SynchedEntityData.defineId(EntityBunfungus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CARROTED = SynchedEntityData.defineId(EntityBunfungus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TRANSFORMS_IN = SynchedEntityData.defineId(EntityBunfungus.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float jumpProgress;
    public float prevJumpProgress;
    public float reboundProgress;
    public float prevReboundProgress;
    public float sleepProgress;
    public float prevSleepProgress;
    public float interestedProgress;
    public float prevInterestedProgress;
    private int animationTick;
    private Animation currentAnimation;
    public int prevTransformTime;
    public static final int MAX_TRANSFORM_TIME = 50;

    protected EntityBunfungus(EntityType t, Level lvl) {
        super(t, lvl);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, (double)0.21f);
    }

    public void playAmbientSound() {
        if (!this.isSleeping()) {
            super.playAmbientSound();
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.BUNFUNGUS_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.BUNFUNGUS_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.BUNFUNGUS_HURT.get();
    }

    public boolean removeWhenFarAway(double p_27598_) {
        return false;
    }

    public static boolean canBunfungusSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.getBlockState(pos.below()).canOcclude();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.mungusSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new GroundPathNavigatorWide((Mob)this, worldIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BunfungusAIMelee(this));
        this.goalSelector.addGoal(2, (Goal)new BunfungusAIBeg(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AnimalAIWanderRanged(this, 60, 1.0, 16, 7){

            @Override
            public boolean canUse() {
                return super.canUse() && EntityBunfungus.this.canUseComplexAI();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new AnimalAILeapRandomly(this, 60, 7){

            @Override
            public boolean canUse() {
                return super.canUse() && EntityBunfungus.this.canUseComplexAI();
            }
        });
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f){

            public boolean canUse() {
                return super.canUse() && EntityBunfungus.this.canUseComplexAI();
            }
        });
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                return super.canUse() && EntityBunfungus.this.canUseComplexAI();
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, mob -> mob instanceof Enemy && !(mob instanceof Creeper) && (!mob.canBreatheUnderwater() || !mob.isInWaterOrBubble()) && !mob.getType().is(AMTagRegistry.BUNFUNGUS_IGNORES)));
    }

    private boolean canUseComplexAI() {
        return !this.isRabbitForm() && !this.isSleeping();
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(JUMP_ACTIVE, (Object)false);
        builder.define(SLEEPING, (Object)false);
        builder.define(BEGGING, (Object)false);
        builder.define(CARROTED, (Object)false);
        builder.define(TRANSFORMS_IN, (Object)0);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void tick() {
        double d2;
        super.tick();
        this.prevJumpProgress = this.jumpProgress;
        this.prevReboundProgress = this.reboundProgress;
        this.prevSleepProgress = this.sleepProgress;
        this.prevInterestedProgress = this.interestedProgress;
        this.prevTransformTime = this.transformsIn();
        if (!this.level().isClientSide) {
            this.entityData.set(JUMP_ACTIVE, (Object)(!this.onGround() ? 1 : 0));
        }
        if (((Boolean)this.entityData.get(JUMP_ACTIVE)).booleanValue() && !this.isInWaterOrBubble()) {
            if (this.jumpProgress < 5.0f) {
                this.jumpProgress += 0.5f;
                if (this.reboundProgress > 0.0f) {
                    this.reboundProgress -= 1.0f;
                }
            }
            if (this.jumpProgress >= 5.0f && this.reboundProgress < 5.0f) {
                this.reboundProgress += 0.5f;
            }
        } else {
            if (this.reboundProgress > 0.0f) {
                this.reboundProgress = Math.max(this.reboundProgress - 1.0f, 0.0f);
            }
            if (this.jumpProgress > 0.0f) {
                this.jumpProgress = Math.max(this.jumpProgress - 1.0f, 0.0f);
            }
        }
        if (this.isSleepingPose()) {
            if (this.sleepProgress < 5.0f) {
                this.sleepProgress += 1.0f;
            }
        } else if (this.sleepProgress > 0.0f) {
            this.sleepProgress -= 1.0f;
        }
        if (this.isBegging()) {
            if (this.interestedProgress < 5.0f) {
                this.interestedProgress += 1.0f;
            }
        } else if (this.interestedProgress > 0.0f) {
            this.interestedProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            LivingEntity target = this.getTarget();
            if (target != null && target.isAlive()) {
                if (this.isSleeping()) {
                    this.setSleeping(false);
                }
                double dist = this.distanceTo((Entity)target);
                boolean flag = false;
                if (this.getAnimationTick() == 5) {
                    if (dist < 3.5 && this.getAnimation() == ANIMATION_BELLY) {
                        for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.0))) {
                            if (entity != target && !(entity instanceof Monster) || entity.getType().is(AMTagRegistry.BUNFUNGUS_IGNORE_AOE_ATTACKS)) continue;
                            flag = true;
                            this.launch(entity);
                            entity.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
                        }
                    } else if (dist < 2.5 && this.getAnimation() == ANIMATION_SLAM) {
                        for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.0))) {
                            if (entity != target && !(entity instanceof Monster) || entity.getType().is(AMTagRegistry.BUNFUNGUS_IGNORE_AOE_ATTACKS)) continue;
                            flag = true;
                            entity.knockback((double)0.2f, entity.getX() - this.getX(), entity.getZ() - this.getZ());
                            entity.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
                        }
                    }
                }
                if (flag) {
                    this.playSound((SoundEvent)AMSoundRegistry.BUNFUNGUS_ATTACK.get(), this.getSoundVolume(), this.getVoicePitch());
                }
            }
            if (this.tickCount % 40 == 0) {
                this.heal(1.0f);
            }
        }
        if (this.getAnimation() == NO_ANIMATION && this.isCarrot(this.getItemInHand(InteractionHand.MAIN_HAND))) {
            this.setAnimation(ANIMATION_EAT);
        }
        if (this.getAnimation() == ANIMATION_EAT) {
            if (this.getAnimationTick() % 4 == 0) {
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
            }
            if (this.getAnimationTick() >= 18) {
                ItemStack stack = this.getItemInHand(InteractionHand.MAIN_HAND);
                if (!stack.isEmpty()) {
                    stack.shrink(1);
                    this.setCarroted(true);
                    this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1000));
                    this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 1000, 1));
                    this.heal(8.0f);
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    d2 = this.random.nextGaussian() * 0.02;
                    double d0 = this.random.nextGaussian() * 0.02;
                    double d1 = this.random.nextGaussian() * 0.02;
                    this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItemInHand(InteractionHand.MAIN_HAND)), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() + (double)(this.getBbHeight() * 0.5f) + (double)(this.random.nextFloat() * this.getBbHeight() * 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, d0, d1, d2);
                }
            }
        }
        if (!this.level().isClientSide && this.transformsIn() > 0) {
            this.setTransformsIn(this.transformsIn() - 1);
        }
        if (this.level().isClientSide) {
            if (this.isRabbitForm()) {
                for (int i = 0; i < 3; ++i) {
                    d2 = this.random.nextGaussian() * 0.02;
                    double d0 = this.random.nextGaussian() * 0.02;
                    double d1 = this.random.nextGaussian() * 0.02;
                    float f1 = (float)(50 - this.transformsIn()) / 50.0f;
                    float scale = f1 * 0.5f + 0.15f;
                    this.level().addParticle((ParticleOptions)AMParticleRegistry.BUNFUNGUS_TRANSFORMATION.get(), this.getRandomX(scale), this.getY(this.random.nextDouble() * (double)scale), this.getRandomZ(scale), d0, d1, d2);
                }
            }
            if (this.isSleeping() && this.random.nextFloat() < 0.3f) {
                double d0 = this.random.nextGaussian() * 0.02;
                float radius = this.getBbWidth() * (0.7f + this.random.nextFloat() * 0.1f);
                float angle = (float)Math.PI / 180 * this.yBodyRot;
                double extraX = radius * Mth.sin((float)((float)Math.PI + angle)) + this.random.nextFloat() * 0.5f - 0.25f;
                double extraZ = radius * Mth.cos((float)angle) + this.random.nextFloat() * 0.5f - 0.25f;
                ParticleOptions data = this.random.nextFloat() < 0.3f ? (ParticleOptions)AMParticleRegistry.BUNFUNGUS_TRANSFORMATION.get() : (ParticleOptions)AMParticleRegistry.FUNGUS_BUBBLE.get();
                this.level().addParticle(data, this.getX() + extraX, this.getY() + (double)(this.random.nextFloat() * 0.1f), this.getZ() + extraZ, 0.0, d0, 0.0);
            }
        } else if (this.level().isDay() && this.getTarget() == null && !this.isBegging() && !this.isInWaterOrBubble()) {
            if (this.tickCount % 10 == 0 && this.getRandom().nextInt(300) == 0) {
                this.setSleeping(true);
            }
        } else if (this.isSleeping()) {
            this.setSleeping(false);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private void launch(LivingEntity target) {
        if (target.onGround()) {
            double d0 = target.getX() - this.getX();
            double d1 = target.getZ() - this.getZ();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = 6.0f + this.random.nextFloat() * 2.0f;
            target.push(d0 / d2 * (double)f, (double)(0.6f + this.random.nextFloat() * 0.7f), d1 / d2 * (double)f);
        }
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.entityData.set(SLEEPING, (Object)sleeping);
    }

    public boolean isSleepingPose() {
        return this.isSleeping() || this.getAnimation() == ANIMATION_SLAM && this.getAnimationTick() < 10;
    }

    public boolean isCarroted() {
        return (Boolean)this.entityData.get(CARROTED);
    }

    public void setCarroted(boolean head) {
        this.entityData.set(CARROTED, (Object)head);
    }

    public boolean isBegging() {
        return (Boolean)this.entityData.get(BEGGING) != false && this.getAnimation() != ANIMATION_EAT;
    }

    public void setBegging(boolean begging) {
        this.entityData.set(BEGGING, (Object)begging);
    }

    public int transformsIn() {
        return Math.min((Integer)this.entityData.get(TRANSFORMS_IN), 50);
    }

    public boolean isRabbitForm() {
        return this.transformsIn() > 0;
    }

    public void setTransformsIn(int time) {
        this.entityData.set(TRANSFORMS_IN, (Object)time);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && this.isCarrot(itemstack) && this.getMainHandItem().isEmpty()) {
            ItemStack cop = itemstack.copy();
            cop.setCount(1);
            this.setItemInHand(InteractionHand.MAIN_HAND, cop);
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
        }
        return type;
    }

    public void travel(Vec3 travelVector) {
        if (!this.isRabbitForm() && !this.isSleeping()) {
            super.travel(travelVector);
        } else {
            super.travel(Vec3.ZERO);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_EAT, ANIMATION_BELLY, ANIMATION_SLAM};
    }

    public boolean isCarrot(ItemStack stack) {
        return stack.is(AMTagRegistry.BUNFUNGUS_FOODSTUFFS);
    }

    public boolean defendsMungusAgainst(LivingEntity lastHurtByMob) {
        return !(lastHurtByMob instanceof Player) || this.isCarroted();
    }

    public void onJump() {
    }
}

