/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAISwimBottom;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityBlobfish
extends WaterAnimal
implements FlyingAnimal,
Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(EntityBlobfish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> BLOBFISH_SCALE = SynchedEntityData.defineId(EntityBlobfish.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DEPRESSURIZED = SynchedEntityData.defineId(EntityBlobfish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SLIMED = SynchedEntityData.defineId(EntityBlobfish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float squishFactor;
    public float prevSquishFactor;
    public float squishAmount;
    private boolean wasOnGround;

    protected EntityBlobfish(EntityType type, Level world) {
        super(type, world);
        this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.blobfishSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    protected void handleAirSupply(int p_209207_1_) {
        if (this.isAlive() && !this.isInWaterOrBubble() && !this.isSlimed()) {
            this.setAirSupply(p_209207_1_ - 1);
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                this.hurt(this.damageSources().drown(), this.random.nextInt(2) == 0 ? 1.0f : 0.0f);
            }
        } else {
            this.setAirSupply(2000);
        }
    }

    protected float getStandingEyeHeight(Pose p_213348_1_, EntityDimensions p_213348_2_) {
        return p_213348_2_.height() * 0.65f;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.hasCustomName() || this.fromBucket() || this.isSlimed();
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROM_BUCKET, (Object)false);
        builder.define(BLOBFISH_SCALE, (Object)Float.valueOf(1.0f));
        builder.define(DEPRESSURIZED, (Object)false);
        builder.define(SLIMED, (Object)false);
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.entityData.set(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nonnull
    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("FromBucket", this.fromBucket());
        compound.putBoolean("Depressurized", this.isDepressurized());
        compound.putBoolean("Slimed", this.isSlimed());
        compound.putFloat("BlobfishScale", this.getBlobfishScale());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFromBucket(compound.getBoolean("FromBucket"));
        this.setDepressurized(compound.getBoolean("Depressurized"));
        this.setSlimed(compound.getBoolean("Slimed"));
        this.setBlobfishScale(compound.getFloat("BlobfishScale"));
    }

    private boolean hasClearance() {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int l1 = 0; l1 < 10; ++l1) {
            BlockState blockstate = this.level().getBlockState((BlockPos)blockpos$mutable.set(this.getX(), this.getY() + (double)l1, this.getZ()));
            if (blockstate.getFluidState().is(FluidTags.WATER) || blockstate.isSolid()) continue;
            return false;
        }
        return true;
    }

    public float getBlobfishScale() {
        return ((Float)this.entityData.get(BLOBFISH_SCALE)).floatValue();
    }

    public void setBlobfishScale(float scale) {
        this.entityData.set(BLOBFISH_SCALE, (Object)Float.valueOf(scale));
    }

    public boolean isDepressurized() {
        return (Boolean)this.entityData.get(DEPRESSURIZED);
    }

    public void setDepressurized(boolean depressurized) {
        this.entityData.set(DEPRESSURIZED, (Object)depressurized);
    }

    public boolean isSlimed() {
        return (Boolean)this.entityData.get(SLIMED);
    }

    public void setSlimed(boolean slimed) {
        this.entityData.set(SLIMED, (Object)slimed);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AnimalAISwimBottom((PathfinderMob)this, 1.0, 7));
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    @Nonnull
    protected InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack lvt_3_1_ = player.getItemInHand(hand);
        if (lvt_3_1_.getItem() == Items.SLIME_BALL && this.isAlive() && !this.isSlimed()) {
            this.setSlimed(true);
            for (int i = 0; i < 6 + this.random.nextInt(3); ++i) {
                double d2 = this.random.nextGaussian() * 0.02;
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, lvt_3_1_), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() + (double)(this.getBbHeight() * 0.5f) + (double)(this.random.nextFloat() * this.getBbHeight() * 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, d0, d1, d2);
            }
            lvt_3_1_.shrink(1);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.FISH_SWIM;
    }

    protected void playStepSound(BlockPos p_180429_1_, BlockState p_180429_2_) {
    }

    @Nonnull
    public ItemStack getBucketItemStack() {
        ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.BLOBFISH_BUCKET.get());
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return stack;
    }

    public void saveToBucketTag(@Nonnull ItemStack bucket) {
        if (this.hasCustomName()) {
            bucket.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)bucket);
        CompoundTag compound = ((CustomData)bucket.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        compound.putFloat("BucketScale", this.getBlobfishScale());
        compound.putBoolean("Slimed", this.isSlimed());
    }

    public void loadFromBucketTag(@Nonnull CompoundTag compound) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)compound);
        if (compound.contains("BucketScale")) {
            this.setBlobfishScale(compound.getFloat("BucketScale"));
        }
        if (compound.contains("Slimed")) {
            this.setSlimed(compound.getBoolean("Slimed"));
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setBlobfishScale(0.75f + this.random.nextFloat() * 0.5f);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public void tick() {
        super.tick();
        this.prevSquishFactor = this.squishFactor;
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        float f2 = -((float)this.getDeltaMovement().y * 2.2f * 57.295776f);
        this.setXRot(f2);
        if (!this.isInWater()) {
            if (this.onGround()) {
                if (!this.wasOnGround) {
                    this.squishAmount = -0.35f;
                }
            } else if (this.wasOnGround) {
                this.squishAmount = 2.0f;
            }
        }
        this.wasOnGround = this.onGround();
        this.alterSquishAmount();
        boolean clear = this.hasClearance();
        if (clear) {
            if (this.isDepressurized()) {
                this.setDepressurized(false);
            }
        } else if (!this.isDepressurized()) {
            this.setDepressurized(true);
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COD_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.COD_HURT;
    }

    public static boolean canBlobfishSpawn(EntityType<EntityBlobfish> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || pos.getY() <= AMConfig.blobfishSpawnHeight && iServerWorld.getFluidState(pos).is(FluidTags.WATER) && iServerWorld.getFluidState(pos.above()).is(FluidTags.WATER);
    }

    public boolean isFlying() {
        return false;
    }
}

