/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityGrizzlyBear;
import com.github.alexthe666.alexsmobs.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIPanicBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import org.jetbrains.annotations.Nullable;

public class EntityBison
extends Animal
implements IAnimatedEntity,
Shearable,
IShearable {
    public static final Animation ANIMATION_PREPARE_CHARGE = Animation.create((int)40);
    public static final Animation ANIMATION_EAT = Animation.create((int)35);
    public static final Animation ANIMATION_ATTACK = Animation.create((int)15);
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.defineId(EntityBison.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SNOWY = SynchedEntityData.defineId(EntityBison.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.defineId(EntityBison.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float prevChargeProgress;
    public float chargeProgress;
    private int animationTick;
    private Animation currentAnimation;
    private int snowTimer = 0;
    private boolean permSnow = false;
    private int blockBreakCounter;
    private int chargeCooldown = this.random.nextInt(2000);
    private EntityBison chargePartner;
    private boolean hasChargedSpeed = false;
    private int feedingsSinceLastShear = 0;

    protected EntityBison(EntityType<? extends Animal> animal, Level lvl) {
        super(animal, lvl);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_KNOCKBACK, 2.0);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.bisonSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnDataIn, @javax.annotation.Nullable CompoundTag dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(0.25f);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.BISON_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.BISON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.BISON_HURT.get();
    }

    protected void playStepSound(BlockPos p_28301_, BlockState p_28302_) {
        this.playSound(SoundEvents.COW_STEP, 0.1f, 1.0f);
    }

    public boolean isSnowy() {
        return (Boolean)this.entityData.get(SNOWY);
    }

    public void setSnowy(boolean honeyed) {
        this.entityData.set(SNOWY, (Object)honeyed);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new AnimalAIPanicBaby(this, 1.25));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(AMTagRegistry.BISON_BREEDABLES), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new AIChargeFurthest());
        this.goalSelector.addGoal(7, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 70, 1.0, 18, 7));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AIAttackNearPlayers());
        this.targetSelector.addGoal(2, (Goal)new AnimalAIHurtByTargetNotBaby(this, new Class[0]));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.BISON_BREEDABLES);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHEARED, (Object)false);
        builder.define(SNOWY, (Object)false);
        builder.define(CHARGING, (Object)false);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)AMEntityRegistry.BISON.get()).create(this.level());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSnowy(compound.getBoolean("Snowy"));
        this.setSheared(compound.getBoolean("Sheared"));
        this.permSnow = compound.getBoolean("SnowPerm");
        this.chargeCooldown = compound.getInt("ChargeCooldown");
        this.feedingsSinceLastShear = compound.getInt("Feedings");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Snowy", this.isSnowy());
        compound.putBoolean("Sheared", this.isSheared());
        compound.putBoolean("SnowPerm", this.permSnow);
        compound.putInt("ChargeCooldown", this.chargeCooldown);
        compound.putInt("Feedings", this.feedingsSinceLastShear);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new AdvancedPathNavigateNoTeleport((Mob)this, worldIn, true);
    }

    public void tick() {
        super.tick();
        this.prevChargeProgress = this.chargeProgress;
        if (this.isCharging() && this.chargeProgress < 5.0f) {
            this.chargeProgress += 1.0f;
        }
        if (!this.isCharging() && this.chargeProgress > 0.0f) {
            this.chargeProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            if (this.snowTimer == 0) {
                this.snowTimer = 200 + this.random.nextInt(400);
                if (this.isSnowy()) {
                    if (!(this.permSnow || this.getRemainingFireTicks() <= 0 && !this.isInWaterOrBubble() && EntityGrizzlyBear.isSnowingAt(this.level(), this.blockPosition().above()))) {
                        this.setSnowy(false);
                    }
                } else if (EntityGrizzlyBear.isSnowingAt(this.level(), this.blockPosition())) {
                    this.setSnowy(true);
                }
            }
            LivingEntity attackTarget = this.getTarget();
            if (this.getDeltaMovement().lengthSqr() < 0.05 && this.getAnimation() == NO_ANIMATION && (attackTarget == null || !attackTarget.isAlive()) && this.getRandom().nextInt(600) == 0 && this.level().getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK)) {
                this.setAnimation(ANIMATION_EAT);
            }
            if (this.getAnimation() == ANIMATION_EAT && this.getAnimationTick() == 30 && this.level().getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK)) {
                ++this.feedingsSinceLastShear;
                BlockPos down = this.blockPosition().below();
                this.level().levelEvent(2001, down, Block.getId((BlockState)Blocks.GRASS_BLOCK.defaultBlockState()));
                this.level().setBlock(down, Blocks.DIRT.defaultBlockState(), 2);
            }
            if (this.isCharging()) {
                if (!this.hasChargedSpeed) {
                    this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)0.65f);
                    this.hasChargedSpeed = true;
                }
            } else if (this.hasChargedSpeed) {
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.25);
                this.hasChargedSpeed = false;
            }
            if (attackTarget != null && attackTarget.isAlive() && this.isAlive()) {
                double dist = this.distanceTo((Entity)attackTarget);
                if (this.hasLineOfSight((Entity)attackTarget)) {
                    this.lookAt((Entity)attackTarget, 30.0f, 30.0f);
                    this.yBodyRot = this.getYRot();
                }
                if (dist < (double)(this.getBbWidth() + 3.0f)) {
                    if (this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() > 8 && dist < (double)(this.getBbWidth() + 1.0f) && this.hasLineOfSight((Entity)attackTarget)) {
                        float dmg = (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();
                        if (attackTarget instanceof Wolf) {
                            dmg = 2.0f;
                        }
                        this.launch((Entity)attackTarget, this.isCharging());
                        if (this.isCharging()) {
                            dmg += 3.0f;
                            this.setCharging(false);
                        }
                        attackTarget.hurt(this.damageSources().mobAttack((LivingEntity)this), dmg);
                    }
                } else if (!this.isCharging()) {
                    Animation animation = this.getAnimation();
                    if (animation == NO_ANIMATION) {
                        this.setAnimation(ANIMATION_PREPARE_CHARGE);
                    } else if (animation == ANIMATION_PREPARE_CHARGE) {
                        this.getNavigation().stop();
                        if (this.getAnimationTick() > 30) {
                            this.setCharging(true);
                        }
                    }
                }
            }
        }
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        if (this.feedingsSinceLastShear >= 5 && this.isSheared()) {
            this.feedingsSinceLastShear = 0;
            this.setSheared(false);
        }
        if (!this.level().isClientSide && this.isCharging() && (this.getTarget() == null && this.chargePartner == null || this.isInWaterOrBubble())) {
            this.setCharging(false);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(SHEARED);
    }

    public void setSheared(boolean b) {
        this.entityData.set(SHEARED, (Object)b);
    }

    private void launch(Entity launch, boolean huge) {
        float rot = 180.0f + this.getYRot();
        float hugeScale = huge ? 4.0f : 0.6f;
        float strength = (float)((double)hugeScale * (1.0 - ((LivingEntity)launch).getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)));
        float rotRad = rot * ((float)Math.PI / 180);
        float x = Mth.sin((float)rotRad);
        float z = -Mth.cos((float)rotRad);
        launch.hasImpulse = true;
        Vec3 vec3 = this.getDeltaMovement();
        Vec3 vec31 = vec3.add(new Vec3((double)x, 0.0, (double)z).normalize().scale((double)strength));
        launch.setDeltaMovement(vec31.x, huge ? 1.0 : 0.5, vec31.z);
        launch.setOnGround(false);
    }

    private void knockbackTarget(LivingEntity entity, float strength, float angle) {
        float rot = this.getYRot() + angle;
        if (entity != null) {
            entity.knockback((double)strength, (double)Mth.sin((float)(rot * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(rot * ((float)Math.PI / 180)))));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        InteractionResult type = super.mobInteract(player, hand);
        if (!this.level().isClientSide) {
            if (item == Items.SNOW && !this.isSnowy()) {
                this.usePlayerItem(player, hand, itemstack);
                this.permSnow = true;
                this.setSnowy(true);
                this.playSound(SoundEvents.SNOW_PLACE, this.getSoundVolume(), this.getVoicePitch());
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof ShovelItem && this.isSnowy()) {
                this.permSnow = false;
                if (!player.isCreative() && player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    itemstack.hurtAndBreak(1, (LivingEntity)sp, EquipmentSlot.MAINHAND);
                }
                this.setSnowy(false);
                this.playSound(SoundEvents.SNOW_BREAK, this.getSoundVolume(), this.getVoicePitch());
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                return InteractionResult.SUCCESS;
            }
        }
        return type;
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.breakBlock();
    }

    public void breakBlock() {
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            return;
        }
        boolean flag = false;
        if (!this.level().isClientSide && this.blockBreakCounter == 0 && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            for (int a = (int)Math.round(this.getBoundingBox().minX); a <= (int)Math.round(this.getBoundingBox().maxX); ++a) {
                for (int b = (int)Math.round(this.getBoundingBox().minY) - 1; b <= (int)Math.round(this.getBoundingBox().maxY) + 1 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.getBoundingBox().minZ); c <= (int)Math.round(this.getBoundingBox().maxZ); ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.level().getBlockState(pos);
                        Block block = state.getBlock();
                        if (block != Blocks.SNOW || (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) > 1) continue;
                        this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.6f, 1.0, (double)0.6f));
                        flag = true;
                        this.level().destroyBlock(pos, true);
                    }
                }
            }
        }
        if (flag) {
            this.blockBreakCounter = this.isCharging() && this.getTarget() != null ? 2 : 20;
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PREPARE_CHARGE, ANIMATION_ATTACK, ANIMATION_EAT};
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.readyForShearing();
    }

    public void shear(SoundSource category) {
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, category, 1.0f, 1.0f);
        this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
        this.setSheared(true);
        this.feedingsSinceLastShear = 0;
        for (int i = 0; i < 2 + this.random.nextInt(2); ++i) {
            this.spawnAtLocation((ItemLike)AMItemRegistry.BISON_FUR.get());
        }
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.entityData.set(CHARGING, (Object)charging);
    }

    public boolean readyForShearing() {
        return !this.isSheared() && !this.isBaby();
    }

    @Nonnull
    public List<ItemStack> onSheared(@javax.annotation.Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(6);
        for (int i = 0; i < 2 + this.random.nextInt(2); ++i) {
            list.add(new ItemStack((ItemLike)AMItemRegistry.BISON_FUR.get()));
        }
        this.feedingsSinceLastShear = 0;
        this.setSheared(true);
        return list;
    }

    public boolean isValidCharging() {
        return !this.isBaby() && this.isAlive() && this.chargeCooldown == 0 && !this.isInWaterOrBubble();
    }

    public void pushBackJostling(EntityBison bison, float strength) {
        this.applyKnockbackFromBuffalo(strength, bison.getX() - this.getX(), bison.getZ() - this.getZ());
    }

    private void applyKnockbackFromBuffalo(float strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = CommonHooks.onLivingKnockBack((LivingEntity)this, (float)strength, (double)ratioX, (double)ratioZ);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        if (!(strength <= 0.0f)) {
            this.hasImpulse = true;
            Vec3 vector3d = this.getDeltaMovement();
            Vec3 vector3d1 = new Vec3(ratioX, 0.0, ratioZ).normalize().scale((double)strength);
            this.setDeltaMovement(vector3d.x / 2.0 - vector3d1.x, 0.3f, vector3d.z / 2.0 - vector3d1.z);
        }
    }

    private void resetChargeCooldown() {
        this.setCharging(false);
        this.chargePartner = null;
        this.chargeCooldown = 1000 + this.random.nextInt(2000);
    }

    private class AIChargeFurthest
    extends Goal {
        public AIChargeFurthest() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (EntityBison.this.isValidCharging()) {
                if (EntityBison.this.chargePartner != null && EntityBison.this.chargePartner.isValidCharging() && EntityBison.this.chargePartner != EntityBison.this) {
                    EntityBison.this.chargePartner.chargePartner = EntityBison.this;
                    return true;
                }
                if (EntityBison.this.random.nextInt(100) == 0) {
                    EntityBison furthest = null;
                    for (EntityBison bison : EntityBison.this.level().getEntitiesOfClass(EntityBison.class, EntityBison.this.getBoundingBox().inflate(15.0))) {
                        if (bison.chargeCooldown != 0 || bison.isBaby() || bison.is((Entity)EntityBison.this) || furthest != null && !(EntityBison.this.distanceTo((Entity)furthest) < EntityBison.this.distanceTo((Entity)bison))) continue;
                        furthest = bison;
                    }
                    if (furthest != null && furthest != EntityBison.this) {
                        EntityBison.this.chargePartner = furthest;
                        furthest.chargePartner = EntityBison.this;
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return EntityBison.this.isValidCharging() && EntityBison.this.chargePartner != null && EntityBison.this.chargePartner.isValidCharging() && !EntityBison.this.chargePartner.is((Entity)EntityBison.this);
        }

        public void tick() {
            EntityBison.this.lookAt((Entity)EntityBison.this.chargePartner, 30.0f, 30.0f);
            EntityBison.this.yBodyRot = EntityBison.this.getYRot();
            if (!EntityBison.this.isCharging()) {
                Animation bisonAnimation = EntityBison.this.getAnimation();
                if (bisonAnimation == IAnimatedEntity.NO_ANIMATION || bisonAnimation == ANIMATION_PREPARE_CHARGE && EntityBison.this.getAnimationTick() > 35) {
                    EntityBison.this.setCharging(true);
                }
            } else {
                float dist = EntityBison.this.distanceTo((Entity)EntityBison.this.chargePartner);
                EntityBison.this.getNavigation().moveTo((Entity)EntityBison.this.chargePartner, 1.0);
                if (EntityBison.this.hasLineOfSight((Entity)EntityBison.this.chargePartner)) {
                    float flingAnimAt = EntityBison.this.getBbWidth() + 1.0f;
                    if (dist < flingAnimAt && EntityBison.this.getAnimation() == ANIMATION_ATTACK) {
                        if (EntityBison.this.getAnimationTick() > 8) {
                            boolean flag = false;
                            if (EntityBison.this.onGround()) {
                                EntityBison.this.pushBackJostling(EntityBison.this.chargePartner, 0.2f);
                                flag = true;
                            }
                            if (EntityBison.this.chargePartner.onGround()) {
                                EntityBison.this.chargePartner.pushBackJostling(EntityBison.this, 0.9f);
                                flag = true;
                            }
                            if (flag) {
                                EntityBison.this.resetChargeCooldown();
                            }
                        }
                    } else {
                        float startFlingAnimAt = EntityBison.this.getBbWidth() + 3.0f;
                        if (dist < startFlingAnimAt && EntityBison.this.getAnimation() != ANIMATION_ATTACK) {
                            EntityBison.this.setAnimation(ANIMATION_ATTACK);
                        }
                    }
                }
            }
        }
    }

    class AIAttackNearPlayers
    extends NearestAttackableTargetGoal<Player> {
        public AIAttackNearPlayers() {
            super((Mob)EntityBison.this, Player.class, 80, true, true, null);
        }

        public boolean canUse() {
            if (EntityBison.this.isBaby() || EntityBison.this.isInLove()) {
                return false;
            }
            return super.canUse();
        }

        protected double getFollowDistance() {
            return 3.0;
        }
    }
}

