/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.effect;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityTarantulaHawk;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EffectDebilitatingSting
extends MobEffect {
    private int lastDuration = -1;

    protected EffectDebilitatingSting() {
        super(MobEffectCategory.NEUTRAL, 16774021);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, ResourceLocation.parse((String)"alexsmobs:debilitating_sting_speed"), -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public void removeAttributeModifiers(LivingEntity entityLivingBaseIn, AttributeMap attributeMapIn, int amplifier) {
        if (entityLivingBaseIn.getType().is(EntityTypeTags.ARTHROPOD)) {
            super.removeAttributeModifiers(attributeMapIn);
        }
    }

    public void addAttributeModifiers(LivingEntity entityLivingBaseIn, AttributeMap attributeMapIn, int amplifier) {
        if (entityLivingBaseIn.getType().is(EntityTypeTags.ARTHROPOD)) {
            super.addAttributeModifiers(attributeMapIn, amplifier);
        }
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.getType().is(EntityTypeTags.ARTHROPOD)) {
            if (entity.getHealth() > entity.getMaxHealth() * 0.5f) {
                entity.hurt(entity.damageSources().magic(), 1.0f);
            }
        } else {
            boolean suf = this.isEntityInsideOpaqueBlock((Entity)entity);
            if (suf) {
                entity.setDeltaMovement(Vec3.ZERO);
                entity.noPhysics = true;
            }
            entity.setNoGravity(suf);
            entity.setJumping(false);
            if (!entity.isPassenger() && entity instanceof Mob && ((Mob)entity).getMoveControl().getClass() != MoveControl.class) {
                entity.setDeltaMovement(new Vec3(0.0, -1.0, 0.0));
            }
            if (this.lastDuration == 1) {
                entity.hurt(entity.damageSources().magic(), (float)((amplifier + 1) * 30));
                if (amplifier > 0) {
                    BlockPos surface = entity.blockPosition();
                    while (!entity.level().isEmptyBlock(surface) && surface.getY() < 256) {
                        surface = surface.above();
                    }
                    EntityTarantulaHawk baby = (EntityTarantulaHawk)((EntityType)AMEntityRegistry.TARANTULA_HAWK.get()).create(entity.level());
                    baby.setBaby(true);
                    baby.setPos(entity.getX(), (float)surface.getY() + 0.1f, entity.getZ());
                    if (!entity.level().isClientSide) {
                        baby.finalizeSpawn((ServerLevelAccessor)entity.level(), entity.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.BREEDING, null);
                        entity.level().addFreshEntity((Entity)baby);
                    }
                }
                entity.setNoGravity(false);
                entity.noPhysics = false;
            }
        }
        return true;
    }

    public boolean isEntityInsideOpaqueBlock(Entity entity) {
        Vec3 vec3 = entity.getEyePosition();
        float f = entity.getDimensions(entity.getPose()).width() * 0.8f;
        AABB axisalignedbb = AABB.ofSize((Vec3)vec3, (double)f, (double)1.0E-6, (double)f);
        return entity.level().getBlockStates(axisalignedbb).filter(Predicate.not(BlockBehaviour.BlockStateBase::isAir)).anyMatch(p_185969_ -> {
            BlockPos blockpos = AMBlockPos.fromVec3(vec3);
            return p_185969_.isSuffocating((BlockGetter)entity.level(), blockpos) && Shapes.joinIsNotEmpty((VoxelShape)p_185969_.getCollisionShape((BlockGetter)entity.level(), blockpos).move(vec3.x, vec3.y, vec3.z), (VoxelShape)Shapes.create((AABB)axisalignedbb), (BooleanOp)BooleanOp.AND);
        });
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        this.lastDuration = duration;
        return duration > 0;
    }

    public String getDescriptionId() {
        return "alexsmobs.potion.debilitating_sting";
    }
}

