/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.effect;

import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class EffectClinging
extends MobEffect {
    public EffectClinging() {
        super(MobEffectCategory.BENEFICIAL, 0xBD4B4B);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        boolean shouldActivate;
        entity.refreshDimensions();
        entity.setNoGravity(false);
        boolean nearCeiling = EffectClinging.isNearCeiling(entity);
        boolean touchingCeiling = entity.verticalCollision && !entity.onGround();
        double yVelocity = entity.getDeltaMovement().y;
        boolean bl = shouldActivate = touchingCeiling || nearCeiling && !entity.onGround() && yVelocity > 0.0;
        if (shouldActivate) {
            entity.fallDistance = 0.0f;
            if (!entity.isShiftKeyDown()) {
                if (touchingCeiling) {
                    entity.setDeltaMovement(entity.getDeltaMovement().x, 0.08, entity.getDeltaMovement().z);
                } else {
                    entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, (double)0.15f, 0.0));
                }
                entity.setDeltaMovement(entity.getDeltaMovement().multiply((double)0.98f, 1.0, (double)0.98f));
            } else if (touchingCeiling) {
                entity.setDeltaMovement(entity.getDeltaMovement().x, -0.2, entity.getDeltaMovement().z);
            }
        }
        return true;
    }

    public static boolean isNearCeiling(LivingEntity entity) {
        for (double offset = 0.1; offset <= 3.0; offset += 0.3) {
            BlockPos pos = AMBlockPos.fromCoords(entity.getX(), entity.getBoundingBox().maxY + offset, entity.getZ());
            BlockState state = entity.level().getBlockState(pos);
            if (state.isAir() || state.getCollisionShape((BlockGetter)entity.level(), pos).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isUpsideDown(LivingEntity entity) {
        return entity.verticalCollision && !entity.onGround() && EffectClinging.isNearCeiling(entity);
    }

    public void removeAttributeModifiers(LivingEntity entityLivingBaseIn, AttributeMap attributeMapIn, int amplifier) {
        super.removeAttributeModifiers(attributeMapIn);
        entityLivingBaseIn.refreshDimensions();
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public String getDescriptionId() {
        return "alexsmobs.potion.clinging";
    }
}

