/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.tile;

import com.github.alexthe666.alexsmobs.block.BlockEndPirateFlag;
import com.github.alexthe666.alexsmobs.client.model.ModelEndPirateFlag;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityEndPirateFlag;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderEndPirateFlag<T extends TileEntityEndPirateFlag>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/flag.png");
    private static final ModelEndPirateFlag FLAG_MODEL = new ModelEndPirateFlag();

    public RenderEndPirateFlag(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.pushPose();
        Direction dir = (Direction)tileEntityIn.getBlockState().getValue((Property)BlockEndPirateFlag.FACING);
        switch (dir) {
            case NORTH: {
                matrixStackIn.translate(0.5, 1.5, 0.5);
                break;
            }
            case EAST: {
                matrixStackIn.translate(0.5f, 1.5f, 0.5f);
                break;
            }
            case SOUTH: {
                matrixStackIn.translate(0.5, 1.5, 0.5);
                break;
            }
            case WEST: {
                matrixStackIn.translate(0.5f, 1.5f, 0.5f);
            }
        }
        matrixStackIn.mulPose(dir.getOpposite().getRotation());
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStackIn.mulPose(Axis.YN.rotationDegrees(dir.getAxis() == Direction.Axis.Y ? -90.0f : 90.0f));
        matrixStackIn.pushPose();
        FLAG_MODEL.renderFlag((TileEntityEndPirateFlag)((Object)tileEntityIn), partialTicks);
        FLAG_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE)), combinedLightIn, combinedOverlayIn);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }
}

