/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.tile;

import com.github.alexthe666.alexsmobs.block.BlockEndPirateAnchorWinch;
import com.github.alexthe666.alexsmobs.client.model.ModelEndPirateAnchorChain;
import com.github.alexthe666.alexsmobs.client.model.ModelEndPirateAnchorWinch;
import com.github.alexthe666.alexsmobs.client.render.tile.RenderEndPirateAnchor;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityEndPirateAnchorWinch;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderEndPirateAnchorWinch<T extends TileEntityEndPirateAnchorWinch>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/anchor_winch.png");
    private static final ResourceLocation TEXTURE_CHAIN = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/anchor_chain.png");
    private static final ModelEndPirateAnchorWinch WINCH_MODEL = new ModelEndPirateAnchorWinch();
    private static final ModelEndPirateAnchorChain CHAIN_MODEL = new ModelEndPirateAnchorChain();

    public RenderEndPirateAnchorWinch(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.pushPose();
        boolean east = (Boolean)tileEntityIn.getBlockState().getValue((Property)BlockEndPirateAnchorWinch.EASTORWEST);
        matrixStackIn.translate(0.5f, 1.5f, 0.5f);
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
        if (east) {
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        boolean flag = false;
        matrixStackIn.pushPose();
        if (!((TileEntityEndPirateAnchorWinch)((Object)tileEntityIn)).isAnchorEW()) {
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        float bottomOfChain = ((TileEntityEndPirateAnchorWinch)((Object)tileEntityIn)).getChainLength(partialTicks);
        for (float i = 0.0f; i < ((TileEntityEndPirateAnchorWinch)((Object)tileEntityIn)).getChainLengthForRender(); i += 0.5f) {
            matrixStackIn.pushPose();
            float moveDown = Math.max(bottomOfChain - i, 0.0f);
            matrixStackIn.translate(0.0f, 0.1f + moveDown, 0.0f);
            if (flag) {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            if (moveDown <= 1.0f) {
                float modulatedScale = 0.5f + moveDown * 0.5f;
                matrixStackIn.translate(0.0f, (1.0f - moveDown) * 0.5f, 0.0f);
                matrixStackIn.scale(modulatedScale, modulatedScale, modulatedScale);
            }
            CHAIN_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE_CHAIN)), combinedLightIn, combinedOverlayIn);
            CHAIN_MODEL.renderToBuffer(matrixStackIn, null, 0, 0);
            WINCH_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE)), combinedLightIn, combinedOverlayIn);
            WINCH_MODEL.renderToBuffer(matrixStackIn, null, 0, 0);
            matrixStackIn.pushPose();
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
            if (((TileEntityEndPirateAnchorWinch)((Object)tileEntityIn)).isAnchorEW()) {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            RenderEndPirateAnchor.ANCHOR_MODEL.resetToDefaultPose();
            RenderEndPirateAnchor.ANCHOR_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)RenderEndPirateAnchor.TEXTURE_ANCHOR)), combinedLightIn, combinedOverlayIn);
            RenderEndPirateAnchor.ANCHOR_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.eyes((ResourceLocation)RenderEndPirateAnchor.TEXTURE_ANCHOR_GLOW)), combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
    }

    public boolean shouldRenderOffScreen(T entity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }
}

