/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.tile;

import com.github.alexthe666.alexsmobs.block.BlockEndPirateAnchor;
import com.github.alexthe666.alexsmobs.client.model.ModelEndPirateAnchor;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityEndPirateAnchor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderEndPirateAnchor<T extends TileEntityEndPirateAnchor>
implements BlockEntityRenderer<T> {
    protected static final ResourceLocation TEXTURE_ANCHOR = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/anchor.png");
    protected static final ResourceLocation TEXTURE_ANCHOR_GLOW = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/anchor_glow.png");
    protected static final ModelEndPirateAnchor ANCHOR_MODEL = new ModelEndPirateAnchor();

    public RenderEndPirateAnchor(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.pushPose();
        boolean east = (Boolean)tileEntityIn.getBlockState().getValue((Property)BlockEndPirateAnchor.EASTORWEST);
        matrixStackIn.translate(0.5f, 1.5f, 0.5f);
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
        if (east) {
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        ANCHOR_MODEL.renderAnchor((TileEntityEndPirateAnchor)((Object)tileEntityIn), partialTicks, east);
        ANCHOR_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE_ANCHOR)), combinedLightIn, combinedOverlayIn);
        ANCHOR_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.eyes((ResourceLocation)TEXTURE_ANCHOR_GLOW)), combinedLightIn, combinedOverlayIn);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }

    public boolean shouldRenderOffScreen(T p_112306_) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }
}

