/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.tile;

import com.github.alexthe666.alexsmobs.entity.util.Maths;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityCapsid;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public class RenderCapsid<T extends TileEntityCapsid>
implements BlockEntityRenderer<T> {
    private final Random random = new Random();

    public RenderCapsid(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    protected int getModelCount(ItemStack stack) {
        int i = 1;
        if (stack.getCount() > 48) {
            i = 5;
        } else if (stack.getCount() > 32) {
            i = 4;
        } else if (stack.getCount() > 16) {
            i = 3;
        } else if (stack.getCount() > 1) {
            i = 2;
        }
        return i;
    }

    public void render(T entity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack stack = ((TileEntityCapsid)((Object)entity)).getItem(0);
        if (!stack.isEmpty()) {
            int i = Item.getId((Item)stack.getItem()) + stack.getDamageValue();
            this.random.setSeed(i);
            float floatProgress = ((TileEntityCapsid)((Object)entity)).prevFloatUpProgress + (((TileEntityCapsid)((Object)entity)).floatUpProgress - ((TileEntityCapsid)((Object)entity)).prevFloatUpProgress) * partialTicks;
            float yaw = ((TileEntityCapsid)((Object)entity)).prevYawSwitchProgress + (((TileEntityCapsid)((Object)entity)).yawSwitchProgress - ((TileEntityCapsid)((Object)entity)).prevYawSwitchProgress) * partialTicks;
            int j = this.getModelCount(stack);
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5f, 0.5f + floatProgress, 0.5f);
            matrixStackIn.mulPose(new Quaternionf().rotateY(Maths.rad(((TileEntityCapsid)((Object)entity)).getBlockAngle() + yaw)));
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, -0.1f, 0.0f);
            if (((TileEntityCapsid)((Object)entity)).vibratingThisTick && entity.getLevel() != null) {
                float vibrate = 0.05f;
                matrixStackIn.translate((entity.getLevel().random.nextFloat() - 0.5f) * vibrate, (entity.getLevel().random.nextFloat() - 0.5f) * vibrate, (entity.getLevel().random.nextFloat() - 0.5f) * vibrate);
            }
            matrixStackIn.scale(1.3f, 1.3f, 1.3f);
            BakedModel ibakedmodel = Minecraft.getInstance().getItemRenderer().getModel(stack, entity.getLevel(), (LivingEntity)null, 0);
            boolean flag = ibakedmodel.isGui3d();
            if (!flag) {
                float f7 = -0.0f * (float)(j - 1) * 0.5f;
                float f8 = -0.0f * (float)(j - 1) * 0.5f;
                float f9 = -0.09375f * (float)(j - 1) * 0.5f;
                matrixStackIn.translate((double)f7, (double)f8, (double)f9);
            }
            for (int k = 0; k < j; ++k) {
                matrixStackIn.pushPose();
                if (k > 0) {
                    if (flag) {
                        float f11 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        float f13 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        float f10 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        matrixStackIn.translate(f11, f13, f10);
                    } else {
                        float f12 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                        float f14 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                        matrixStackIn.translate((double)f12, (double)f14, 0.0);
                    }
                }
                Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ibakedmodel);
                matrixStackIn.popPose();
                if (flag) continue;
                matrixStackIn.translate(0.0, 0.0, 0.09375);
            }
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
    }
}

