/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.client.model.ModelMimicube;
import com.github.alexthe666.alexsmobs.client.render.RenderMimicube;
import com.github.alexthe666.alexsmobs.entity.EntityMimicube;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

public class LayerMimicubeHelmet
extends RenderLayer<EntityMimicube, ModelMimicube> {
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    private final HumanoidModel defaultBipedModel;
    private final RenderMimicube renderer;

    public LayerMimicubeHelmet(RenderMimicube render, EntityRendererProvider.Context renderManagerIn) {
        super((RenderLayerParent)render);
        this.renderer = render;
        this.defaultBipedModel = new HumanoidModel(renderManagerIn.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR));
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        String s1;
        ResourceLocation resourcelocation;
        ArmorItem item = (ArmorItem)stack.getItem();
        String texture = ((ResourceKey)item.getMaterial().unwrapKey().get()).location().getPath();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        if ((resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type)))) == null) {
            resourcelocation = ResourceLocation.parse((String)s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityMimicube cube, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ArmorItem armoritem;
        matrixStackIn.pushPose();
        ItemStack itemstack = cube.getItemBySlot(EquipmentSlot.HEAD);
        float helmetSwap = Mth.lerp((float)partialTicks, (float)cube.prevHelmetSwapProgress, (float)cube.helmetSwapProgress) * 0.2f;
        if (itemstack.getItem() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.getItem()).getEquipmentSlot() == EquipmentSlot.HEAD) {
            HumanoidModel<?> a = this.defaultBipedModel;
            boolean notAVanillaModel = (a = this.getArmorModelHook((LivingEntity)cube, itemstack, EquipmentSlot.HEAD, (HumanoidModel)a)) != this.defaultBipedModel;
            this.setModelSlotVisible(a, EquipmentSlot.HEAD);
            boolean flag = false;
            ((ModelMimicube)this.renderer.getModel()).root.translateAndRotate(matrixStackIn);
            ((ModelMimicube)this.renderer.getModel()).innerbody.translateAndRotate(matrixStackIn);
            matrixStackIn.translate(0.0f, notAVanillaModel ? 0.25f : -0.75f, 0.0f);
            matrixStackIn.scale(1.0f + 0.3f * (1.0f - helmetSwap), 1.0f + 0.3f * (1.0f - helmetSwap), 1.0f + 0.3f * (1.0f - helmetSwap));
            boolean flag1 = itemstack.hasFoil();
            int clampedLight = helmetSwap > 0.0f ? (int)(-100.0f * helmetSwap) : packedLightIn;
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(360.0f * helmetSwap));
            if (itemstack.has(DataComponents.DYED_COLOR)) {
                int i = ((DyedItemColor)itemstack.get(DataComponents.DYED_COLOR)).rgb();
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderArmor(cube, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, LayerMimicubeHelmet.getArmorResource((Entity)cube, itemstack, EquipmentSlot.HEAD, null), notAVanillaModel);
                this.renderArmor(cube, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerMimicubeHelmet.getArmorResource((Entity)cube, itemstack, EquipmentSlot.HEAD, "overlay"), notAVanillaModel);
            } else {
                this.renderArmor(cube, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerMimicubeHelmet.getArmorResource((Entity)cube, itemstack, EquipmentSlot.HEAD, null), notAVanillaModel);
            }
        }
        matrixStackIn.popPose();
    }

    private void renderArmor(EntityMimicube entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        if (notAVanillaModel) {
            ((ModelMimicube)this.renderer.getModel()).copyPropertiesTo((EntityModel)modelIn);
            modelIn.body.y = 0.0f;
            modelIn.head.setPos(0.0f, 1.0f, 0.0f);
            modelIn.hat.y = 0.0f;
            modelIn.head.xRot = ((ModelMimicube)this.renderer.getModel()).body.rotateAngleX;
            modelIn.head.yRot = ((ModelMimicube)this.renderer.getModel()).body.rotateAngleY;
            modelIn.head.zRot = ((ModelMimicube)this.renderer.getModel()).body.rotateAngleZ;
            modelIn.head.x = ((ModelMimicube)this.renderer.getModel()).body.rotationPointX;
            modelIn.head.y = ((ModelMimicube)this.renderer.getModel()).body.rotationPointY;
            modelIn.head.z = ((ModelMimicube)this.renderer.getModel()).body.rotationPointZ;
            modelIn.hat.copyFrom(modelIn.head);
            modelIn.body.copyFrom(modelIn.head);
        }
        modelIn.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY);
    }

    protected void setModelSlotVisible(HumanoidModel p_188359_1_, EquipmentSlot slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.head.visible = true;
                p_188359_1_.hat.visible = true;
                break;
            }
            case CHEST: {
                p_188359_1_.body.visible = true;
                p_188359_1_.rightArm.visible = true;
                p_188359_1_.leftArm.visible = true;
                break;
            }
            case LEGS: {
                p_188359_1_.body.visible = true;
                p_188359_1_.rightLeg.visible = true;
                p_188359_1_.leftLeg.visible = true;
                break;
            }
            case FEET: {
                p_188359_1_.rightLeg.visible = true;
                p_188359_1_.leftLeg.visible = true;
            }
        }
    }

    protected void setModelVisible(HumanoidModel model) {
        model.setAllVisible(false);
    }

    protected HumanoidModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
        try {
            HumanoidModel basicModel = model;
            return basicModel instanceof HumanoidModel ? basicModel : model;
        }
        catch (Exception e) {
            return model;
        }
    }
}

