/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.client.model.ModelMantisShrimp;
import com.github.alexthe666.alexsmobs.client.render.RenderMantisShrimp;
import com.github.alexthe666.alexsmobs.entity.EntityMantisShrimp;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class LayerMantisShrimpItem
extends RenderLayer<EntityMantisShrimp, ModelMantisShrimp> {
    public LayerMantisShrimpItem(RenderMantisShrimp render) {
        super((RenderLayerParent)render);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityMantisShrimp entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = entitylivingbaseIn.getItemBySlot(EquipmentSlot.MAINHAND);
        matrixStackIn.pushPose();
        boolean left = entitylivingbaseIn.isLeftHanded();
        if (entitylivingbaseIn.isBaby()) {
            matrixStackIn.scale(0.5f, 0.5f, 0.5f);
            matrixStackIn.translate(0.0, 1.5, 0.0);
        }
        matrixStackIn.pushPose();
        this.translateToHand(matrixStackIn, left);
        matrixStackIn.translate(left ? 0.075f : -0.075f, 0.45f, -0.125f);
        if (!Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(itemstack).isGui3d()) {
            matrixStackIn.translate(0.0f, 0.0f, 0.05f);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(left ? -40.0f : 40.0f));
        }
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(-2.5f));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(-180.0f));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStackIn.scale(1.2f, 1.2f, 1.2f);
        ItemInHandRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
        renderer.renderItem((LivingEntity)entitylivingbaseIn, itemstack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }

    protected void translateToHand(PoseStack matrixStack, boolean left) {
        ((ModelMantisShrimp)this.getParentModel()).root.translateAndRotate(matrixStack);
        ((ModelMantisShrimp)this.getParentModel()).body.translateAndRotate(matrixStack);
        ((ModelMantisShrimp)this.getParentModel()).head.translateAndRotate(matrixStack);
        if (left) {
            ((ModelMantisShrimp)this.getParentModel()).arm_left.translateAndRotate(matrixStack);
            ((ModelMantisShrimp)this.getParentModel()).fist_left.translateAndRotate(matrixStack);
        } else {
            ((ModelMantisShrimp)this.getParentModel()).arm_right.translateAndRotate(matrixStack);
            ((ModelMantisShrimp)this.getParentModel()).fist_right.translateAndRotate(matrixStack);
        }
    }
}

