/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.client.model.ModelKangaroo;
import com.github.alexthe666.alexsmobs.client.render.RenderKangaroo;
import com.github.alexthe666.alexsmobs.entity.EntityKangaroo;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;

public class LayerKangarooArmor
extends RenderLayer<EntityKangaroo, ModelKangaroo> {
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    private final HumanoidModel defaultBipedModel;
    private final RenderKangaroo renderer;

    public LayerKangarooArmor(RenderKangaroo render, EntityRendererProvider.Context context) {
        super((RenderLayerParent)render);
        this.defaultBipedModel = new HumanoidModel(context.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR));
        this.renderer = render;
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        String s1;
        ResourceLocation resourcelocation;
        ArmorItem item = (ArmorItem)stack.getItem();
        String texture = ((ResourceKey)item.getMaterial().unwrapKey().get()).location().getPath();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        if ((resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type)))) == null) {
            resourcelocation = ResourceLocation.parse((String)s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityKangaroo roo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.pushPose();
        if (roo.isRoger()) {
            ItemStack haloStack = new ItemStack((ItemLike)AMItemRegistry.HALO.get());
            matrixStackIn.pushPose();
            this.translateToHead(matrixStackIn);
            float f = 0.1f * (float)Math.sin(((float)roo.tickCount + partialTicks) * 0.1f) + (roo.isBaby() ? 0.2f : 0.0f);
            matrixStackIn.translate(0.0f, -0.75f - f, -0.2f);
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
            matrixStackIn.scale(1.3f, 1.3f, 1.3f);
            ItemInHandRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            renderer.renderItem((LivingEntity)roo, haloStack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.popPose();
        }
        if (!roo.isBaby()) {
            ArmorItem armoritem;
            float f2;
            float f1;
            float f;
            int i;
            int clampedLight;
            boolean flag1;
            boolean notAVanillaModel;
            HumanoidModel<?> a;
            matrixStackIn.pushPose();
            ItemStack itemstack = roo.getItemBySlot(EquipmentSlot.HEAD);
            if (itemstack.getItem() instanceof ArmorItem) {
                ArmorItem armoritem2 = (ArmorItem)itemstack.getItem();
                if (itemstack.canEquip(EquipmentSlot.HEAD, (LivingEntity)roo)) {
                    a = this.defaultBipedModel;
                    notAVanillaModel = (a = this.getArmorModelHook((LivingEntity)roo, itemstack, EquipmentSlot.HEAD, (HumanoidModel)a)) != this.defaultBipedModel;
                    this.setModelSlotVisible(a, EquipmentSlot.HEAD);
                    this.translateToHead(matrixStackIn);
                    matrixStackIn.translate(0.0f, 0.015f, -0.05f);
                    if (itemstack.getItem() == AMItemRegistry.FEDORA.get()) {
                        matrixStackIn.translate(0.0f, 0.05f, 0.0f);
                    }
                    matrixStackIn.scale(0.7f, 0.7f, 0.7f);
                    flag1 = itemstack.hasFoil();
                    clampedLight = packedLightIn;
                    if (itemstack.has(DataComponents.DYED_COLOR)) {
                        i = ((DyedItemColor)itemstack.get(DataComponents.DYED_COLOR)).rgb();
                        f = (float)(i >> 16 & 0xFF) / 255.0f;
                        f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                        f2 = (float)(i & 0xFF) / 255.0f;
                        this.renderHelmet(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlot.HEAD, null), notAVanillaModel);
                        this.renderHelmet(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlot.HEAD, "overlay"), notAVanillaModel);
                    } else {
                        this.renderHelmet(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlot.HEAD, null), notAVanillaModel);
                    }
                }
            } else {
                this.translateToHead(matrixStackIn);
                matrixStackIn.translate(0.0, -0.2, (double)-0.1f);
                matrixStackIn.mulPose(new Quaternionf().rotateX((float)Math.PI));
                matrixStackIn.mulPose(new Quaternionf().rotateY((float)Math.PI));
                matrixStackIn.scale(1.0f, 1.0f, 1.0f);
                Minecraft.getInstance().getItemRenderer().renderStatic(itemstack, ItemDisplayContext.FIXED, packedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, roo.level(), 0);
            }
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            itemstack = roo.getItemBySlot(EquipmentSlot.CHEST);
            if (itemstack.getItem() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.getItem()).getEquipmentSlot() == EquipmentSlot.CHEST) {
                a = this.defaultBipedModel;
                notAVanillaModel = (a = this.getArmorModelHook((LivingEntity)roo, itemstack, EquipmentSlot.CHEST, (HumanoidModel)a)) != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlot.CHEST);
                this.translateToChest(matrixStackIn);
                matrixStackIn.translate(0.0f, 0.25f, 0.0f);
                matrixStackIn.scale(1.0f, 1.0f, 1.0f);
                flag1 = itemstack.hasFoil();
                clampedLight = packedLightIn;
                if (itemstack.has(DataComponents.DYED_COLOR)) {
                    i = ((DyedItemColor)itemstack.get(DataComponents.DYED_COLOR)).rgb();
                    f = (float)(i >> 16 & 0xFF) / 255.0f;
                    f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderChestplate(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlot.CHEST, null), notAVanillaModel);
                    this.renderChestplate(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlot.CHEST, "overlay"), notAVanillaModel);
                } else {
                    this.renderChestplate(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlot.CHEST, null), notAVanillaModel);
                }
            }
            matrixStackIn.popPose();
        }
        matrixStackIn.popPose();
    }

    private void translateToHead(PoseStack matrixStackIn) {
        this.translateToChest(matrixStackIn);
        ((ModelKangaroo)this.renderer.getModel()).neck.translateAndRotate(matrixStackIn);
        ((ModelKangaroo)this.renderer.getModel()).head.translateAndRotate(matrixStackIn);
    }

    private void translateToChest(PoseStack matrixStackIn) {
        ((ModelKangaroo)this.renderer.getModel()).root.translateAndRotate(matrixStackIn);
        ((ModelKangaroo)this.renderer.getModel()).body.translateAndRotate(matrixStackIn);
        ((ModelKangaroo)this.renderer.getModel()).chest.translateAndRotate(matrixStackIn);
    }

    private void renderChestplate(EntityKangaroo entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        ((ModelKangaroo)this.renderer.getModel()).copyPropertiesTo((EntityModel)modelIn);
        float sitProgress = entity.prevSitProgress + (entity.sitProgress - entity.prevSitProgress) * Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        modelIn.body.xRot = 1.5707964f;
        modelIn.body.yRot = 0.0f;
        modelIn.body.zRot = 0.0f;
        modelIn.body.x = 0.0f;
        modelIn.body.y = 0.25f;
        modelIn.body.z = -7.6f;
        modelIn.rightArm.x = ((ModelKangaroo)this.renderer.getModel()).arm_right.rotationPointX;
        modelIn.rightArm.y = ((ModelKangaroo)this.renderer.getModel()).arm_right.rotationPointY;
        modelIn.rightArm.z = ((ModelKangaroo)this.renderer.getModel()).arm_right.rotationPointZ;
        modelIn.rightArm.xRot = ((ModelKangaroo)this.renderer.getModel()).arm_right.rotateAngleX;
        modelIn.rightArm.yRot = ((ModelKangaroo)this.renderer.getModel()).arm_right.rotateAngleY;
        modelIn.rightArm.zRot = ((ModelKangaroo)this.renderer.getModel()).arm_right.rotateAngleZ;
        modelIn.leftArm.x = ((ModelKangaroo)this.renderer.getModel()).arm_left.rotationPointX;
        modelIn.leftArm.y = ((ModelKangaroo)this.renderer.getModel()).arm_left.rotationPointY;
        modelIn.leftArm.z = ((ModelKangaroo)this.renderer.getModel()).arm_left.rotationPointZ;
        modelIn.leftArm.xRot = ((ModelKangaroo)this.renderer.getModel()).arm_left.rotateAngleX;
        modelIn.leftArm.yRot = ((ModelKangaroo)this.renderer.getModel()).arm_left.rotateAngleY;
        modelIn.leftArm.zRot = ((ModelKangaroo)this.renderer.getModel()).arm_left.rotateAngleZ;
        modelIn.leftArm.y = ((ModelKangaroo)this.renderer.getModel()).arm_left.rotationPointY - 4.0f + sitProgress * 0.25f;
        modelIn.rightArm.y = ((ModelKangaroo)this.renderer.getModel()).arm_right.rotationPointY - 4.0f + sitProgress * 0.25f;
        modelIn.leftArm.z = ((ModelKangaroo)this.renderer.getModel()).arm_left.rotationPointZ - 0.5f;
        modelIn.rightArm.z = ((ModelKangaroo)this.renderer.getModel()).arm_right.rotationPointZ - 0.5f;
        modelIn.body.visible = false;
        modelIn.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY);
        modelIn.body.visible = true;
        modelIn.rightArm.visible = false;
        modelIn.leftArm.visible = false;
        matrixStackIn.pushPose();
        matrixStackIn.scale(1.1f, 1.65f, 1.1f);
        modelIn.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
        modelIn.rightArm.visible = true;
        modelIn.leftArm.visible = true;
    }

    private void renderHelmet(EntityKangaroo entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        ((ModelKangaroo)this.renderer.getModel()).copyPropertiesTo((EntityModel)modelIn);
        modelIn.head.xRot = 0.0f;
        modelIn.head.yRot = 0.0f;
        modelIn.head.zRot = 0.0f;
        modelIn.hat.xRot = 0.0f;
        modelIn.hat.yRot = 0.0f;
        modelIn.hat.zRot = 0.0f;
        modelIn.head.x = 0.0f;
        modelIn.head.y = 0.0f;
        modelIn.head.z = 0.0f;
        modelIn.hat.x = 0.0f;
        modelIn.hat.y = 0.0f;
        modelIn.hat.z = 0.0f;
        modelIn.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY);
    }

    protected void setModelSlotVisible(HumanoidModel p_188359_1_, EquipmentSlot slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.head.visible = true;
                p_188359_1_.hat.visible = true;
                break;
            }
            case CHEST: {
                p_188359_1_.body.visible = true;
                p_188359_1_.rightArm.visible = true;
                p_188359_1_.leftArm.visible = true;
                break;
            }
            case LEGS: {
                p_188359_1_.body.visible = true;
                p_188359_1_.rightLeg.visible = true;
                p_188359_1_.leftLeg.visible = true;
                break;
            }
            case FEET: {
                p_188359_1_.rightLeg.visible = true;
                p_188359_1_.leftLeg.visible = true;
            }
        }
    }

    protected void setModelVisible(HumanoidModel model) {
        model.setAllVisible(false);
    }

    protected HumanoidModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
        HumanoidModel basicModel = model;
        return basicModel instanceof HumanoidModel ? basicModel : model;
    }
}

