/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.client.model.ModelElephant;
import com.github.alexthe666.alexsmobs.client.render.RenderElephant;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;

public class LayerElephantOverlays
extends RenderLayer<EntityElephant, ModelElephant> {
    private static final ResourceLocation[] ELEPHANT_DECOR_TEXTURES = new ResourceLocation[]{ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/white.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/orange.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/magenta.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/light_blue.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/yellow.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/lime.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/pink.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/gray.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/light_gray.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/cyan.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/purple.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/blue.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/brown.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/green.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/red.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/black.png")};
    private static final ResourceLocation TRADER_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/decor/trader.png");
    private static final ResourceLocation TEXTURE_CHEST = ResourceLocation.parse((String)"alexsmobs:textures/entity/elephant/elephant_chest.png");
    private final ModelElephant model = new ModelElephant(0.5f);

    public LayerElephantOverlays(RenderElephant renderElephant) {
        super((RenderLayerParent)renderElephant);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityElephant elephant, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DyeColor lvt_11_1_;
        if (elephant.isChested()) {
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE_CHEST));
            ((ModelElephant)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)elephant, (float)0.0f));
        }
        if ((lvt_11_1_ = elephant.getColor()) != null || elephant.isTrader()) {
            ResourceLocation lvt_12_3_ = !elephant.isTrader() ? ELEPHANT_DECOR_TEXTURES[lvt_11_1_.getId()] : TRADER_TEXTURE;
            ((ModelElephant)this.getParentModel()).copyPropertiesTo((EntityModel)this.model);
            this.model.setupAnim(elephant, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer lvt_13_1_ = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)lvt_12_3_));
            this.model.renderToBuffer(matrixStackIn, lvt_13_1_, packedLightIn, OverlayTexture.NO_OVERLAY);
        }
    }
}

