/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.client.model.ModelAnteater;
import com.github.alexthe666.alexsmobs.client.model.ModelLeafcutterAnt;
import com.github.alexthe666.alexsmobs.client.render.RenderAnteater;
import com.github.alexthe666.alexsmobs.entity.EntityAnteater;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class LayerAnteaterTongueItem
extends RenderLayer<EntityAnteater, ModelAnteater> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/leafcutter_ant.png");
    private final ModelLeafcutterAnt ANT_MODEL = new ModelLeafcutterAnt();

    public LayerAnteaterTongueItem(RenderAnteater render) {
        super((RenderLayerParent)render);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityAnteater anteater, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = anteater.getMainHandItem();
        if (!itemstack.isEmpty() || anteater.hasAntOnTongue()) {
            double tongueM = Math.min(Math.sin(ageInTicks * 0.15f), 0.0);
            float scaleItem = -0.2f * (float)tongueM * (anteater.prevTongueProgress + (anteater.tongueProgress - anteater.prevTongueProgress) * partialTicks * 0.2f);
            matrixStackIn.pushPose();
            if (anteater.isBaby()) {
                matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                matrixStackIn.translate(0.0, 2.8, 0.0);
            }
            matrixStackIn.pushPose();
            this.translateToTongue(matrixStackIn);
            if (anteater.isBaby()) {
                matrixStackIn.translate(0.0, (double)0.2f, -0.22);
            }
            matrixStackIn.translate(-0.0, 0.0, (double)-0.35f);
            matrixStackIn.scale(scaleItem, scaleItem, scaleItem);
            if (anteater.hasAntOnTongue()) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.0f, -1.35f, -0.01f);
                VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
                this.ANT_MODEL.animateAnteater(anteater, partialTicks);
                this.ANT_MODEL.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            }
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
    }

    protected void translateToTongue(PoseStack matrixStack) {
        ((ModelAnteater)this.getParentModel()).root.translateAndRotate(matrixStack);
        ((ModelAnteater)this.getParentModel()).body.translateAndRotate(matrixStack);
        ((ModelAnteater)this.getParentModel()).head.translateAndRotate(matrixStack);
        ((ModelAnteater)this.getParentModel()).snout.translateAndRotate(matrixStack);
        ((ModelAnteater)this.getParentModel()).tongue1.translateAndRotate(matrixStack);
        ((ModelAnteater)this.getParentModel()).tongue2.translateAndRotate(matrixStack);
    }
}

