/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelTerrapin;
import com.github.alexthe666.alexsmobs.entity.EntityTerrapin;
import com.github.alexthe666.alexsmobs.entity.util.TerrapinTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class RenderTerrapin
extends MobRenderer<EntityTerrapin, ModelTerrapin> {
    private static final ResourceLocation[] SHELL_TEXTURES = new ResourceLocation[]{ResourceLocation.parse((String)"alexsmobs:textures/entity/terrapin/overlay/terrapin_shell_pattern_0.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/terrapin/overlay/terrapin_shell_pattern_1.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/terrapin/overlay/terrapin_shell_pattern_2.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/terrapin/overlay/terrapin_shell_pattern_3.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/terrapin/overlay/terrapin_shell_pattern_4.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/terrapin/overlay/terrapin_shell_pattern_5.png")};
    private static final ResourceLocation[] SKIN_PATTERN_TEXTURES = new ResourceLocation[]{ResourceLocation.parse((String)"alexsmobs:textures/entity/terrapin/overlay/terrapin_skin_pattern_0.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/terrapin/overlay/terrapin_skin_pattern_1.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/terrapin/overlay/terrapin_skin_pattern_2.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/terrapin/overlay/terrapin_skin_pattern_3.png")};

    public RenderTerrapin(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelTerrapin(), 0.3f);
        this.addLayer(new TurtleOverlayLayer(this, 0));
        this.addLayer(new TurtleOverlayLayer(this, 1));
        this.addLayer(new TurtleOverlayLayer(this, 2));
    }

    protected void scale(EntityTerrapin entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        ((ModelTerrapin)this.model).young = entitylivingbaseIn.isBaby();
    }

    public ResourceLocation getTextureLocation(EntityTerrapin entity) {
        if (entity.isKoopa()) {
            return TerrapinTypes.KOOPA.getTexture();
        }
        return entity.getTurtleType().getTexture();
    }

    protected void setupRotations(EntityTerrapin entity, PoseStack stack, float pitchIn, float yawIn, float partialTickTime, float scale) {
        Pose pose;
        if (this.isShaking((LivingEntity)entity)) {
            yawIn += (float)(Math.cos((double)entity.tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = entity.getPose()) != Pose.SLEEPING && !entity.isSpinning()) {
            stack.mulPose(Axis.YP.rotationDegrees(180.0f - yawIn));
        }
        if (entity.deathTime > 0) {
            float f = ((float)entity.deathTime + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            stack.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees((LivingEntity)entity)));
        } else if (entity.isAutoSpinAttack()) {
            stack.mulPose(Axis.XP.rotationDegrees(-90.0f - entity.getXRot()));
            stack.mulPose(Axis.YP.rotationDegrees(((float)entity.tickCount + partialTickTime) * -75.0f));
        } else if (pose != Pose.SLEEPING && RenderTerrapin.isEntityUpsideDown((LivingEntity)entity)) {
            stack.translate(0.0, (double)(entity.getBbHeight() + 0.1f), 0.0);
            stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    static class TurtleOverlayLayer
    extends RenderLayer<EntityTerrapin, ModelTerrapin> {
        private final int layer;

        public TurtleOverlayLayer(RenderTerrapin render, int layer) {
            super((RenderLayerParent)render);
            this.layer = layer;
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource buffer, int packedLightIn, EntityTerrapin turtle, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (turtle.getTurtleType() == TerrapinTypes.OVERLAY && !turtle.isKoopa()) {
                ResourceLocation tex;
                ResourceLocation resourceLocation = this.layer == 0 ? this.getTextureLocation((Entity)turtle) : (tex = this.layer == 1 ? SHELL_TEXTURES[turtle.getShellType() % SHELL_TEXTURES.length] : SKIN_PATTERN_TEXTURES[turtle.getSkinType() % SKIN_PATTERN_TEXTURES.length]);
                int color = this.layer == 0 ? turtle.getTurtleColor() : (this.layer == 1 ? turtle.getShellColor() : turtle.getSkinColor());
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                TurtleOverlayLayer.renderColoredCutoutModel((EntityModel)this.getParentModel(), (ResourceLocation)tex, (PoseStack)matrixStackIn, (MultiBufferSource)buffer, (int)packedLightIn, (LivingEntity)turtle, (int)((int)(r * 255.0f) << 24 | (int)(g * 255.0f) << 16 | (int)(b * 255.0f) << 8 | 0xFF));
            }
        }
    }
}

