/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelSpectre;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.entity.EntitySpectre;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class RenderSpectre
extends MobRenderer<EntitySpectre, ModelSpectre> {
    private static final ResourceLocation TEXTURE_BONE = ResourceLocation.parse((String)"alexsmobs:textures/entity/spectre_bone.png");
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/spectre.png");
    private static final ResourceLocation TEXTURE_EYES = ResourceLocation.parse((String)"alexsmobs:textures/entity/spectre_glow.png");
    private static final ResourceLocation TEXTURE_LEAD = ResourceLocation.parse((String)"alexsmobs:textures/entity/spectre_lead.png");

    public RenderSpectre(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelSpectre(), 0.5f);
        this.addLayer((RenderLayer)new SpectreEyesLayer(this));
        this.addLayer(new SpectreMembraneLayer(this, this));
    }

    protected void scale(EntitySpectre entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.scale(1.3f, 1.3f, 1.3f);
    }

    protected int getBlockLightLevel(EntitySpectre entityIn, BlockPos partialTicks) {
        return 15;
    }

    public ResourceLocation getTextureLocation(EntitySpectre entity) {
        return TEXTURE_BONE;
    }

    public float getAlphaForRender(EntitySpectre entityIn, float partialTicks) {
        return ((float)Math.sin(((float)entityIn.tickCount + partialTicks) * 0.1f) + 1.5f) * 0.1f + 0.5f;
    }

    static class SpectreEyesLayer
    extends EyesLayer<EntitySpectre, ModelSpectre> {
        public SpectreEyesLayer(RenderSpectre p_i50928_1_) {
            super((RenderLayerParent)p_i50928_1_);
        }

        public RenderType renderType() {
            return RenderType.eyes((ResourceLocation)TEXTURE_EYES);
        }
    }

    class SpectreMembraneLayer
    extends RenderLayer<EntitySpectre, ModelSpectre> {
        public SpectreMembraneLayer(RenderSpectre this$0, RenderSpectre p_i50928_1_) {
            super((RenderLayerParent)p_i50928_1_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntitySpectre entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer lvt_11_1_ = bufferIn.getBuffer(this.getRenderType());
            ((ModelSpectre)this.getParentModel()).renderToBuffer(matrixStackIn, lvt_11_1_, 0xF00000, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            if (entitylivingbaseIn.isLeashed()) {
                VertexConsumer lead = bufferIn.getBuffer(AMRenderTypes.entityCutoutNoCull((ResourceLocation)TEXTURE_LEAD));
                ((ModelSpectre)this.getParentModel()).renderToBuffer(matrixStackIn, lead, 0xF00000, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            }
        }

        public RenderType getRenderType() {
            return AMRenderTypes.getSpectreBones(TEXTURE);
        }
    }
}

