/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelSeal;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerSealItem;
import com.github.alexthe666.alexsmobs.entity.EntitySeal;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.joml.Matrix4f;

public class RenderSeal
extends MobRenderer<EntitySeal, ModelSeal> {
    private static final ResourceLocation TEXTURE_BROWN_0 = ResourceLocation.parse((String)"alexsmobs:textures/entity/seal/seal_brown_0.png");
    private static final ResourceLocation TEXTURE_BROWN_1 = ResourceLocation.parse((String)"alexsmobs:textures/entity/seal/seal_brown_1.png");
    private static final ResourceLocation TEXTURE_ARCTIC_0 = ResourceLocation.parse((String)"alexsmobs:textures/entity/seal/seal_arctic_0.png");
    private static final ResourceLocation TEXTURE_ARCTIC_1 = ResourceLocation.parse((String)"alexsmobs:textures/entity/seal/seal_arctic_1.png");
    private static final ResourceLocation TEXTURE_ARCTIC_BABY = ResourceLocation.parse((String)"alexsmobs:textures/entity/seal/seal_arctic_baby.png");
    private static final ResourceLocation TEXTURE_TEARS = ResourceLocation.parse((String)"alexsmobs:textures/entity/seal/seal_crying.png");
    private static final ResourceLocation TEXTURE_TONGUE = ResourceLocation.parse((String)"alexsmobs:textures/entity/seal/seal_tongue.png");

    public RenderSeal(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelSeal(), 0.45f);
        this.addLayer(new LayerSealItem(this));
        this.addLayer(new SealTearsLayer(this));
    }

    protected void scale(EntitySeal entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        ((ModelSeal)this.model).young = entitylivingbaseIn.isBaby();
    }

    protected boolean shouldShowName(EntitySeal seal) {
        return super.shouldShowName((Mob)seal) || seal.isTearsEasterEgg();
    }

    public ResourceLocation getTextureLocation(EntitySeal entity) {
        if (entity.isArctic()) {
            return entity.isBaby() ? TEXTURE_ARCTIC_BABY : (entity.getVariant() == 1 ? TEXTURE_ARCTIC_1 : TEXTURE_ARCTIC_0);
        }
        return entity.getVariant() == 1 ? TEXTURE_BROWN_1 : TEXTURE_BROWN_0;
    }

    protected void renderNameTag(EntitySeal seal, Component text, PoseStack poseStack, MultiBufferSource bufferSrc, int numberIn) {
        if (seal.isTearsEasterEgg()) {
            double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)seal);
            boolean flag = !seal.isDiscrete();
            float f = seal.getBbHeight() + 0.5f;
            String[] split = text.getString(512).split(" ");
            StringBuilder recombined = new StringBuilder();
            ArrayList<String> strings = new ArrayList<String>();
            for (int wordIndex = 0; wordIndex < split.length; ++wordIndex) {
                recombined.append(split[wordIndex]).append(" ");
                if (recombined.length() <= 15 && wordIndex != split.length - 1) continue;
                strings.add(recombined.toString());
                recombined = new StringBuilder();
            }
            int i = 10 - 10 * strings.size();
            poseStack.pushPose();
            poseStack.translate(0.0, (double)f, 0.0);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.scale(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.last().pose();
            float f1 = 1.0f;
            int j = -1;
            Font font = this.getFont();
            String widest = "";
            for (String print : strings) {
                if (font.width(widest) >= font.width(print)) continue;
                widest = print;
            }
            float widestCenter = -font.width(widest) / 2;
            for (String print : strings) {
                float f2 = -font.width(print) / 2;
                poseStack.translate(0.0, 0.0, 0.1);
                font.drawInBatch(widest, widestCenter, (float)i, j, false, matrix4f, bufferSrc, Font.DisplayMode.NORMAL, j, 240);
                poseStack.translate(0.0, 0.0, -0.1);
                font.drawInBatch(print, f2, (float)i, 1, false, matrix4f, bufferSrc, Font.DisplayMode.NORMAL, j, 240);
                font.drawInBatch(print, f2, (float)i, 0, false, matrix4f, bufferSrc, Font.DisplayMode.NORMAL, j, 240);
                i += 10;
            }
            poseStack.popPose();
        } else {
            super.renderNameTag((Entity)seal, text, poseStack, bufferSrc, numberIn, 0.0f);
        }
    }

    static class SealTearsLayer
    extends RenderLayer<EntitySeal, ModelSeal> {
        public SealTearsLayer(RenderSeal p_i50928_1_) {
            super((RenderLayerParent)p_i50928_1_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntitySeal entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.isTearsEasterEgg()) {
                VertexConsumer lead = bufferIn.getBuffer(AMRenderTypes.entityCutoutNoCull((ResourceLocation)TEXTURE_TEARS));
                ((ModelSeal)this.getParentModel()).renderToBuffer(matrixStackIn, lead, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            }
        }
    }
}

