/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelLeafcutterAnt;
import com.github.alexthe666.alexsmobs.client.model.ModelLeafcutterAntQueen;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerLeafcutterAntLeaf;
import com.github.alexthe666.alexsmobs.entity.EntityLeafcutterAnt;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class RenderLeafcutterAnt
extends MobRenderer<EntityLeafcutterAnt, AdvancedEntityModel<EntityLeafcutterAnt>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/leafcutter_ant.png");
    private static final ResourceLocation TEXTURE_QUEEN = ResourceLocation.parse((String)"alexsmobs:textures/entity/leafcutter_ant_queen.png");
    private static final ResourceLocation TEXTURE_ANGRY = ResourceLocation.parse((String)"alexsmobs:textures/entity/leafcutter_ant_angry.png");
    private static final ResourceLocation TEXTURE_QUEEN_ANGRY = ResourceLocation.parse((String)"alexsmobs:textures/entity/leafcutter_ant_queen_angry.png");
    private final ModelLeafcutterAnt modelAnt = new ModelLeafcutterAnt();
    private final ModelLeafcutterAntQueen modelQueen = new ModelLeafcutterAntQueen();

    public RenderLeafcutterAnt(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelLeafcutterAnt(), 0.25f);
        this.addLayer(new LayerLeafcutterAntLeaf(this));
    }

    protected void setupRotations(EntityLeafcutterAnt entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        String s;
        if (this.isShaking((LivingEntity)entityLiving)) {
            rotationYaw += (float)(Math.cos((double)entityLiving.tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        float trans = entityLiving.isBaby() ? 0.25f : 0.5f;
        Pose pose = entityLiving.getPose();
        if (pose != Pose.SLEEPING) {
            float progresso = 1.0f - (entityLiving.prevAttachChangeProgress + (entityLiving.attachChangeProgress - entityLiving.prevAttachChangeProgress) * partialTicks);
            if (entityLiving.getAttachmentFacing() == Direction.DOWN) {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
                matrixStackIn.translate(0.0, (double)trans, 0.0);
                if (entityLiving.yo < entityLiving.getY()) {
                    matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f * (1.0f - progresso)));
                } else {
                    matrixStackIn.mulPose(Axis.XP.rotationDegrees(-90.0f * (1.0f - progresso)));
                }
                matrixStackIn.translate(0.0, (double)(-trans), 0.0);
            } else if (entityLiving.getAttachmentFacing() == Direction.UP) {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrixStackIn.translate(0.0, (double)(-trans), 0.0);
            } else {
                matrixStackIn.translate(0.0, (double)trans, 0.0);
                switch (entityLiving.getAttachmentFacing()) {
                    case NORTH: {
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f * progresso));
                        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(0.0f));
                        break;
                    }
                    case SOUTH: {
                        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f * progresso));
                        break;
                    }
                    case WEST: {
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
                        matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f - 90.0f * progresso));
                        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                        break;
                    }
                    case EAST: {
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
                        matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f * progresso - 90.0f));
                        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    }
                }
                if (entityLiving.getDeltaMovement().y <= (double)-0.001f) {
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(-180.0f));
                }
                matrixStackIn.translate(0.0, (double)(-trans), 0.0);
            }
        }
        if (entityLiving.deathTime > 0) {
            float f = ((float)entityLiving.deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees((LivingEntity)entityLiving)));
        } else if (entityLiving.isAutoSpinAttack()) {
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-90.0f - entityLiving.getXRot()));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(((float)entityLiving.tickCount + partialTicks) * -75.0f));
        } else if (pose != Pose.SLEEPING && entityLiving.hasCustomName() && ("Dinnerbone".equals(s = ChatFormatting.stripFormatting((String)entityLiving.getName().getString())) || "Grumm".equals(s))) {
            matrixStackIn.translate(0.0, (double)(entityLiving.getBbHeight() + 0.1f), 0.0);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected void scale(EntityLeafcutterAnt entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        this.model = entitylivingbaseIn.isQueen() ? this.modelQueen : this.modelAnt;
        ((AdvancedEntityModel)this.model).young = entitylivingbaseIn.isBaby();
    }

    public ResourceLocation getTextureLocation(EntityLeafcutterAnt entity) {
        if (entity.getRemainingPersistentAngerTime() > 0) {
            return entity.isQueen() ? TEXTURE_QUEEN_ANGRY : TEXTURE_ANGRY;
        }
        return entity.isQueen() ? TEXTURE_QUEEN : TEXTURE;
    }
}

