/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelLaviathan;
import com.github.alexthe666.alexsmobs.entity.EntityLaviathan;
import com.github.alexthe666.alexsmobs.entity.EntityLaviathanPart;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class RenderLaviathan
extends MobRenderer<EntityLaviathan, ModelLaviathan> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/laviathan.png");
    private static final ResourceLocation TEXTURE_GLOW = ResourceLocation.parse((String)"alexsmobs:textures/entity/laviathan_glow.png");
    private static final ResourceLocation TEXTURE_OBSIDIAN = ResourceLocation.parse((String)"alexsmobs:textures/entity/laviathan_obsidian.png");
    private static final ResourceLocation TEXTURE_GEAR = ResourceLocation.parse((String)"alexsmobs:textures/entity/laviathan_gear.png");
    private static final ResourceLocation TEXTURE_HELMET = ResourceLocation.parse((String)"alexsmobs:textures/entity/laviathan_helmet.png");
    private static final float REINS_COLOR_R = 0.38431373f;
    private static final float REINS_COLOR_G = 0.3019608f;
    private static final float REINS_COLOR_B = 0.20392157f;
    private static final float REINS_COLOR_R2 = 0.22745098f;
    private static final float REINS_COLOR_G2 = 0.15686275f;
    private static final float REINS_COLOR_B2 = 0.13333334f;
    public static boolean renderWithoutShaking = false;

    public RenderLaviathan(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelLaviathan(), 4.0f);
        this.addLayer(new LayerOverlays(this));
    }

    private static void addVertexPairAlex(VertexConsumer p_174308_, Matrix4f p_174309_, float p_174310_, float p_174311_, float p_174312_, int p_174313_, int p_174314_, int p_174315_, int p_174316_, float p_174317_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_) {
        float f = (float)p_174321_ / 24.0f;
        int i = (int)Mth.lerp((float)f, (float)p_174313_, (float)p_174314_);
        int j = (int)Mth.lerp((float)f, (float)p_174315_, (float)p_174316_);
        int k = LightTexture.pack((int)i, (int)j);
        float f2 = 0.38431373f;
        float f3 = 0.3019608f;
        float f4 = 0.20392157f;
        if (p_174321_ % 2 == (p_174322_ ? 1 : 0)) {
            f2 = 0.22745098f;
            f3 = 0.15686275f;
            f4 = 0.13333334f;
        }
        float f5 = p_174310_ * f;
        float f6 = p_174311_ > 0.0f ? p_174311_ * f * f : p_174311_ - p_174311_ * (1.0f - f) * (1.0f - f);
        float f7 = p_174312_ * f;
        p_174308_.addVertex(p_174309_, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).setColor((int)(f2 * 255.0f), (int)(f3 * 255.0f), (int)(f4 * 255.0f), 255).setLight(k);
        p_174308_.addVertex(p_174309_, f5 + p_174319_, f6 + p_174317_ - p_174318_, f7 - p_174320_).setColor((int)(f2 * 255.0f), (int)(f3 * 255.0f), (int)(f4 * 255.0f), 255).setLight(k);
    }

    public boolean shouldRender(EntityLaviathan livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        if (super.shouldRender((Entity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        for (EntityLaviathanPart part : livingEntityIn.allParts) {
            if (!camera.isVisible(part.getBoundingBox())) continue;
            return true;
        }
        return false;
    }

    public void render(EntityLaviathan mob, float p_115456_, float partialTick, PoseStack ms, MultiBufferSource p_115459_, int p_115460_) {
        super.render((LivingEntity)mob, p_115456_, partialTick, ms, p_115459_, p_115460_);
        LivingEntity entity = mob.getControllingPassenger();
        if (entity != null) {
            double d0 = Mth.lerp((double)partialTick, (double)mob.xOld, (double)mob.getX());
            double d1 = Mth.lerp((double)partialTick, (double)mob.yOld, (double)mob.getY());
            double d2 = Mth.lerp((double)partialTick, (double)mob.zOld, (double)mob.getZ());
            ms.pushPose();
            ms.translate(-d0, -d1, -d2);
            this.renderRein(mob, partialTick, ms, p_115459_, entity, true);
            this.renderRein(mob, partialTick, ms, p_115459_, entity, false);
            ms.popPose();
        }
    }

    protected void scale(EntityLaviathan entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        ((ModelLaviathan)this.model).young = entitylivingbaseIn.isBaby();
    }

    protected boolean isShaking(EntityLaviathan entity) {
        return entity.isInWaterRainOrBubble() && !entity.isObsidian() && !renderWithoutShaking;
    }

    public ResourceLocation getTextureLocation(EntityLaviathan entity) {
        return entity.isObsidian() ? TEXTURE_OBSIDIAN : TEXTURE;
    }

    private float getHeadShakeForReins(EntityLaviathan mob, float partialTick) {
        float hh1 = mob.prevHeadHeight;
        float hh2 = mob.getHeadHeight();
        float rawHeadHeight = (hh1 + (hh2 - hh1) * partialTick) / 3.0f;
        float clampedNeckRot = Mth.clamp((float)(-rawHeadHeight), (float)-1.0f, (float)1.0f);
        float headStillProgress = 1.0f - Math.abs(clampedNeckRot);
        float swim = Mth.lerp((float)partialTick, (float)mob.prevSwimProgress, (float)mob.swimProgress);
        float limbSwingAmount = mob.walkAnimation.speed(partialTick);
        float swing = mob.walkAnimation.position() + partialTick;
        float swingAmount = limbSwingAmount * swim * 0.2f * headStillProgress;
        float swimSpeed = mob.swimProgress >= 5.0f ? 0.3f : 0.9f;
        float swimDegree = 0.5f + swim * 0.05f;
        float boxOffset = -10.995574f;
        float moveScale = 1.0f;
        return 1.3f * Mth.cos((float)(swing * swimSpeed * moveScale + boxOffset * 2.0f)) * swingAmount * swimDegree * moveScale;
    }

    private float getHeadBobForReins(EntityLaviathan mob, float partialTick) {
        float swing = (float)mob.tickCount + partialTick;
        float swingAmount = 1.0f;
        float idleSpeed = 0.04f;
        float idleDegree = 0.3f;
        float boxOffset = 4.712389f;
        float moveScale = 1.0f;
        return 0.8f * Mth.cos((float)(swing * idleSpeed * moveScale + boxOffset * 2.0f)) * swingAmount * idleDegree * moveScale;
    }

    private <E extends Entity> void renderRein(EntityLaviathan mob, float partialTick, PoseStack p_115464_, MultiBufferSource p_115465_, E rider, boolean left) {
        p_115464_.pushPose();
        EntityLaviathanPart head = mob.headPart;
        if (head == null) {
            return;
        }
        float limbSwingAmount = mob.walkAnimation.speed(partialTick);
        float shake = this.getHeadShakeForReins(mob, partialTick);
        float headYaw = Math.abs(mob.getHeadYaw(partialTick)) / 50.0f;
        float headPitch = 1.0f - Math.abs((mob.prevHeadHeight + (mob.getHeadHeight() - mob.prevHeadHeight) * partialTick) / 3.0f);
        float yawAdd = (1.0f - headYaw) * 0.4f * (1.0f - limbSwingAmount * 0.7f) - headPitch * 0.2f;
        Vec3 vec3 = rider instanceof LivingEntity ? this.getReinPosition((LivingEntity)rider, partialTick, left, shake) : rider.getRopeHoldPosition(partialTick);
        double d0 = (double)(Mth.lerp((float)partialTick, (float)mob.yBodyRot, (float)mob.yBodyRotO) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec31 = new Vec3((double)((left ? -0.05f - yawAdd : 0.05f + yawAdd) + shake), (double)(0.45f - headYaw * 0.2f + this.getHeadBobForReins(mob, partialTick)), (double)0.1f);
        double d1 = Math.cos(d0) * vec31.z + Math.sin(d0) * vec31.x;
        double d2 = Math.sin(d0) * vec31.z - Math.cos(d0) * vec31.x;
        double d3 = Mth.lerp((double)partialTick, (double)((Entity)head).xo, (double)head.getX()) + d1;
        double d4 = Mth.lerp((double)partialTick, (double)((Entity)head).yo, (double)head.getY()) + vec31.y;
        double d5 = Mth.lerp((double)partialTick, (double)((Entity)head).zo, (double)head.getZ()) + d2;
        p_115464_.translate(d3, d4, d5);
        float f = (float)(vec3.x - d3);
        float f1 = (float)(vec3.y - d4);
        float f2 = (float)(vec3.z - d5);
        VertexConsumer vertexconsumer = p_115465_.getBuffer(RenderType.leash());
        Matrix4f matrix4f = p_115464_.last().pose();
        float f4 = (float)(Mth.fastInvSqrt((double)(f * f + f2 * f2)) * (double)0.025f / 2.0);
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = AMBlockPos.fromVec3(mob.getEyePosition(partialTick));
        BlockPos blockpos1 = AMBlockPos.fromVec3(rider.getEyePosition(partialTick));
        int i = this.getBlockLightLevel((Entity)mob, blockpos);
        int j = mob.level().getBrightness(LightLayer.BLOCK, blockpos1);
        int k = mob.level().getBrightness(LightLayer.SKY, blockpos);
        int l = mob.level().getBrightness(LightLayer.SKY, blockpos1);
        float width = 0.05f;
        for (int i1 = 0; i1 <= 24; ++i1) {
            RenderLaviathan.addVertexPairAlex(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, width, width, f5, f6, i1, false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            RenderLaviathan.addVertexPairAlex(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, width, width, f5, f6, j1, true);
        }
        p_115464_.popPose();
    }

    private Vec3 getReinPosition(LivingEntity entity, float p_36374_, boolean left, float shake) {
        float f2;
        double d0 = 0.4 * (left ? -1.0 : 1.0) - 0.0;
        float f = Mth.lerp((float)(p_36374_ * 0.5f), (float)entity.getXRot(), (float)entity.xRotO) * ((float)Math.PI / 180);
        float f1 = Mth.lerp((float)p_36374_, (float)entity.yBodyRotO, (float)entity.yBodyRot) * ((float)Math.PI / 180);
        if (!entity.isFallFlying() && !entity.isAutoSpinAttack()) {
            if (entity.isVisuallySwimming()) {
                return entity.getPosition(p_36374_).add(new Vec3(d0, 0.3, -0.34).xRot(-f).yRot(-f1));
            }
            double d5 = entity.getBoundingBox().getYsize() - 1.0;
            double d6 = entity.isCrouching() ? -0.2 : 0.07;
            return entity.getPosition(p_36374_).add(new Vec3(d0, d5, d6).yRot(-f1));
        }
        Vec3 vec3 = entity.getViewVector(p_36374_);
        Vec3 vec31 = entity.getDeltaMovement();
        double d1 = vec31.horizontalDistanceSqr();
        double d2 = vec3.horizontalDistanceSqr();
        if (d1 > 0.0 && d2 > 0.0) {
            double d3 = (vec31.x * vec3.x + vec31.z * vec3.z) / Math.sqrt(d1 * d2);
            double d4 = vec31.x * vec3.z - vec31.z * vec3.x;
            f2 = (float)(Math.signum(d4) * Math.acos(d3));
        } else {
            f2 = 0.0f;
        }
        return entity.getPosition(p_36374_).add(new Vec3(d0, -0.11, 0.85).zRot(-f2).xRot(-f).yRot(-f1));
    }

    static class LayerOverlays
    extends RenderLayer<EntityLaviathan, ModelLaviathan> {
        public LayerOverlays(RenderLaviathan render) {
            super((RenderLayerParent)render);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityLaviathan laviathan, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer vertexConsumer;
            if (!laviathan.isObsidian()) {
                vertexConsumer = bufferIn.getBuffer(RenderType.eyes((ResourceLocation)TEXTURE_GLOW));
            }
            if (laviathan.hasHeadGear()) {
                vertexConsumer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE_HELMET));
            }
        }
    }
}

