/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelGrizzlyBear;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerGrizzlyHoney;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerGrizzlyItem;
import com.github.alexthe666.alexsmobs.entity.EntityGrizzlyBear;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class RenderGrizzlyBear
extends MobRenderer<EntityGrizzlyBear, ModelGrizzlyBear> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/grizzly_bear.png");
    private static final ResourceLocation TEXTURE_SNOWY = ResourceLocation.parse((String)"alexsmobs:textures/entity/grizzly_bear_snowy.png");
    public static final ResourceLocation TEXTURE_FREDDY = ResourceLocation.parse((String)"alexsmobs:textures/entity/grizzly_bear_freddy.png");
    private static final ResourceLocation TEXTURE_FREDDY_EYES = ResourceLocation.parse((String)"alexsmobs:textures/entity/grizzly_bear_freddy_eyes.png");

    public RenderGrizzlyBear(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelGrizzlyBear(), 0.8f);
        this.addLayer(new LayerFreddyEyes(this));
        this.addLayer(new LayerGrizzlyHoney(this));
        this.addLayer(new LayerSnow(this));
        this.addLayer(new LayerGrizzlyItem(this));
    }

    protected void scale(EntityGrizzlyBear entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        ((ModelGrizzlyBear)this.model).young = entitylivingbaseIn.isBaby();
    }

    public boolean shouldRender(EntityGrizzlyBear livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        if (livingEntityIn.getAprilFoolsFlag() == 5) {
            return false;
        }
        return super.shouldRender((Entity)livingEntityIn, camera, camX, camY, camZ);
    }

    public ResourceLocation getTextureLocation(EntityGrizzlyBear entity) {
        return entity.isFreddy() ? TEXTURE_FREDDY : TEXTURE;
    }

    class LayerFreddyEyes
    extends RenderLayer<EntityGrizzlyBear, ModelGrizzlyBear> {
        public LayerFreddyEyes(RenderGrizzlyBear this$0) {
            super((RenderLayerParent)this$0);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityGrizzlyBear entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.getAprilFoolsFlag() == 4 && entitylivingbaseIn.tickCount % 6 <= 2) {
                VertexConsumer ivertexbuilder = bufferIn.getBuffer(AMRenderTypes.getEyesNoFog(TEXTURE_FREDDY_EYES));
                ((ModelGrizzlyBear)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            }
        }
    }

    class LayerSnow
    extends RenderLayer<EntityGrizzlyBear, ModelGrizzlyBear> {
        public LayerSnow(RenderGrizzlyBear this$0) {
            super((RenderLayerParent)this$0);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityGrizzlyBear entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.isSnowy()) {
                VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE_SNOWY));
                ((ModelGrizzlyBear)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            }
        }
    }
}

