/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelFarseer;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.entity.EntityFarseer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RenderFarseer
extends MobRenderer<EntityFarseer, ModelFarseer> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/farseer.png");
    private static final ResourceLocation TEXTURE_ANGRY = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/farseer_angry.png");
    private static final ResourceLocation TEXTURE_CLAWS = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/farseer_claws.png");
    private static final ResourceLocation TEXTURE_EYE = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/farseer_eye.png");
    private static final ResourceLocation TEXTURE_SCARS = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/farseer_scars.png");
    private static final ResourceLocation[] PORTAL_TEXTURES = new ResourceLocation[]{ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/portal_0.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/portal_1.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/portal_2.png"), ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/portal_3.png")};
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private static final ModelFarseer EYE_MODEL = new ModelFarseer(0.1f);
    private static final ModelFarseer SCARS_MODEL = new ModelFarseer(0.05f);
    private static final ModelFarseer AFTERIMAGE_MODEL = new ModelFarseer(0.05f);

    public RenderFarseer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelFarseer(0.0f), 0.9f);
        this.addLayer(new LayerOverlay(this));
    }

    public boolean shouldRender(EntityFarseer livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        LivingEntity livingentity;
        if (super.shouldRender((Entity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.hasLaser() && (livingentity = livingEntityIn.getLaserTarget()) != null) {
            Vec3 vector3d = this.getPosition(livingentity, (double)livingentity.getBbHeight() * 0.5, 1.0f);
            Vec3 vector3d1 = this.getPosition((LivingEntity)livingEntityIn, livingEntityIn.getEyeHeight(), 1.0f);
            return camera.isVisible(new AABB(vector3d1.x, vector3d1.y, vector3d1.z, vector3d.x, vector3d.y, vector3d.z));
        }
        return false;
    }

    private Vec3 getPosition(LivingEntity entityLivingBaseIn, double p_177110_2_, float p_177110_4_) {
        double d0 = Mth.lerp((double)p_177110_4_, (double)entityLivingBaseIn.xOld, (double)entityLivingBaseIn.getX());
        double d1 = Mth.lerp((double)p_177110_4_, (double)entityLivingBaseIn.yOld, (double)entityLivingBaseIn.getY()) + p_177110_2_;
        double d2 = Mth.lerp((double)p_177110_4_, (double)entityLivingBaseIn.zOld, (double)entityLivingBaseIn.getZ());
        return new Vec3(d0, d1, d2);
    }

    public void render(EntityFarseer entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Direction direction;
        boolean shouldSit;
        LivingEntity laserTarget = entityIn.getLaserTarget();
        float faceCameraAmount = entityIn.getFacingCameraAmount(partialTicks);
        Quaternionf camera = this.entityRenderDispatcher.cameraOrientation();
        matrixStackIn.pushPose();
        ((ModelFarseer)this.model).attackTime = this.getAttackAnim((LivingEntity)entityIn, partialTicks);
        ((ModelFarseer)this.model).riding = shouldSit = entityIn.isPassenger() && entityIn.getVehicle() != null && entityIn.getVehicle().shouldRiderSit();
        ((ModelFarseer)this.model).young = entityIn.isBaby();
        float f = Mth.rotLerp((float)partialTicks, (float)entityIn.yBodyRotO, (float)entityIn.yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)entityIn.yHeadRotO, (float)entityIn.yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && entityIn.getVehicle() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.getVehicle();
            f = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot());
        if (entityIn.getPose() == Pose.SLEEPING && (direction = entityIn.getBedOrientation()) != null) {
            float f4 = entityIn.getEyeHeight(Pose.STANDING) - 0.1f;
            matrixStackIn.translate((double)((float)(-direction.getStepX()) * f4), 0.0, (double)((float)(-direction.getStepZ()) * f4));
        }
        float f7 = this.getBob((LivingEntity)entityIn, partialTicks);
        if (faceCameraAmount != 0.0f) {
            matrixStackIn.mulPose(camera);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        this.setupRotations(entityIn, matrixStackIn, f7, f, partialTicks);
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntity)entityIn, matrixStackIn, partialTicks);
        matrixStackIn.translate(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.isAlive()) {
            f8 = entityIn.walkAnimation.position(partialTicks);
            f5 = entityIn.walkAnimation.position() - entityIn.walkAnimation.speed() * (1.0f - partialTicks);
            if (entityIn.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((ModelFarseer)this.model).prepareMobModel((Entity)entityIn, f5, f8, partialTicks);
        ((ModelFarseer)this.model).setupAnim(entityIn, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = this.isBodyVisible((LivingEntity)entityIn);
        boolean flag1 = !flag && !entityIn.isInvisibleTo((Player)minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)entityIn);
        RenderType rendertype = this.getRenderType(entityIn, flag, flag1, flag2);
        EYE_MODEL.setupAnim(entityIn, f5, f8, f7, f2, f6);
        SCARS_MODEL.setupAnim(entityIn, f5, f8, f7, f2, f6);
        AFTERIMAGE_MODEL.setupAnim(entityIn, f5, f8, f7, f2, f6);
        if (rendertype != null) {
            float portalLevel = entityIn.getFarseerOpacity(partialTicks);
            this.shadowRadius = 0.9f * portalLevel;
            int i = RenderFarseer.getOverlayCoords((LivingEntity)entityIn, (float)this.getWhiteOverlayProgress((LivingEntity)entityIn, partialTicks));
            this.renderFarseerModel(matrixStackIn, bufferIn, rendertype, partialTicks, packedLightIn, i, flag1 ? 0.15f : Mth.clamp((float)portalLevel, (float)0.0f, (float)1.0f), entityIn);
        }
        if (!entityIn.isSpectator()) {
            for (RenderLayer layerrenderer : this.layers) {
                layerrenderer.render(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        matrixStackIn.popPose();
        if (this.shouldShowName((Mob)entityIn)) {
            this.renderNameTag((Entity)entityIn, entityIn.getDisplayName(), matrixStackIn, bufferIn, packedLightIn, partialTicks);
        }
        if (entityIn.getAnimation() == EntityFarseer.ANIMATION_EMERGE) {
            matrixStackIn.pushPose();
            matrixStackIn.scale(3.0f, 3.0f, 3.0f);
            matrixStackIn.mulPose(camera);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
            PoseStack.Pose posestack$pose = matrixStackIn.last();
            Matrix4f matrix4f = posestack$pose.pose();
            Matrix3f matrix3f = posestack$pose.normal();
            int portalTexture = Mth.clamp((int)entityIn.getPortalFrame(), (int)0, (int)(PORTAL_TEXTURES.length - 1));
            VertexConsumer portalConsumer = bufferIn.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)PORTAL_TEXTURES[portalTexture]));
            float portalAlpha = entityIn.getPortalOpacity(partialTicks);
            RenderFarseer.portalVertex(portalConsumer, matrix4f, matrix3f, packedLightIn, 0.0f, 0, 0, 1, portalAlpha);
            RenderFarseer.portalVertex(portalConsumer, matrix4f, matrix3f, packedLightIn, 1.0f, 0, 1, 1, portalAlpha);
            RenderFarseer.portalVertex(portalConsumer, matrix4f, matrix3f, packedLightIn, 1.0f, 1, 1, 0, portalAlpha);
            RenderFarseer.portalVertex(portalConsumer, matrix4f, matrix3f, packedLightIn, 0.0f, 1, 0, 0, portalAlpha);
            matrixStackIn.popPose();
        }
        if (entityIn.hasLaser() && laserTarget != null && !laserTarget.isRemoved()) {
            float laserProgress = (entityIn.prevLaserLvl + ((float)entityIn.getLaserAttackLvl() - entityIn.prevLaserLvl) * partialTicks) / 10.0f;
            float laserHeight = entityIn.getEyeHeight();
            Vec3 angryShake = Vec3.ZERO;
            double d0 = Mth.lerp((double)partialTicks, (double)laserTarget.xo, (double)laserTarget.getX()) - Mth.lerp((double)partialTicks, (double)entityIn.xo, (double)entityIn.getX()) - angryShake.x;
            double d1 = Mth.lerp((double)partialTicks, (double)laserTarget.yo, (double)laserTarget.getY()) + (double)laserTarget.getEyeHeight() - Mth.lerp((double)partialTicks, (double)entityIn.yo, (double)entityIn.getY()) - angryShake.y - (double)laserHeight;
            double d2 = Mth.lerp((double)partialTicks, (double)laserTarget.zo, (double)laserTarget.getZ()) - Mth.lerp((double)partialTicks, (double)entityIn.zo, (double)entityIn.getZ()) - angryShake.z;
            double d4 = Math.sqrt(d0 * d0 + d2 * d2);
            float laserY = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float laserX = (float)(-(Mth.atan2((double)d1, (double)d4) * 57.2957763671875));
            VertexConsumer beamStatic = bufferIn.getBuffer(AMRenderTypes.getFarseerBeam());
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, laserHeight, 0.0f);
            matrixStackIn.mulPose(Axis.YN.rotationDegrees(laserY));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(laserX));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
            float length = entityIn.getLaserDistance() * laserProgress;
            float width = (1.5f - laserProgress) * 2.0f;
            float speed = 1.0f + laserProgress * laserProgress * 5.0f;
            PoseStack.Pose posestack$pose = matrixStackIn.last();
            Matrix4f matrix4f = posestack$pose.pose();
            Matrix3f matrix3f = posestack$pose.normal();
            int j = 255;
            long systemTime = Util.getMillis() * 7L;
            float u = (float)(systemTime % 30000L) / 30000.0f;
            float v = (float)Math.floor((float)(systemTime % 3000L) / 3000.0f * 4.0f) * 0.25f + (float)Math.sin((float)systemTime / 30000.0f) * 0.05f + (float)(systemTime % 20000L) / 20000.0f * speed;
            RenderFarseer.laserOriginVertex(beamStatic, matrix4f, matrix3f, j, u, v);
            RenderFarseer.laserLeftCornerVertex(beamStatic, matrix4f, matrix3f, length, width, u, v);
            RenderFarseer.laserRightCornerVertex(beamStatic, matrix4f, matrix3f, length, width, u, v);
            RenderFarseer.laserLeftCornerVertex(beamStatic, matrix4f, matrix3f, length, width, u, v);
            matrixStackIn.popPose();
        }
    }

    private void renderFarseerModel(PoseStack matrixStackIn, MultiBufferSource source, RenderType defRenderType, float partialTicks, int packedLightIn, int overlayColors, float alphaIn, EntityFarseer entityIn) {
        if (entityIn.hasLaser()) {
            VertexConsumer eyeConsumer = source.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)TEXTURE_EYE));
            EYE_MODEL.renderToBuffer(matrixStackIn, eyeConsumer, packedLightIn, OverlayTexture.NO_OVERLAY);
        }
        float hurt = Math.max(entityIn.hurtTime, entityIn.deathTime);
        float defAlpha = alphaIn * 0.2f;
        float afterimageSpeed = 0.3f;
        if (hurt > 0.0f) {
            afterimageSpeed = Math.min(hurt / 20.0f, 1.0f) + 0.3f;
            VertexConsumer scarsConsumer = source.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)TEXTURE_SCARS));
            SCARS_MODEL.renderToBuffer(matrixStackIn, scarsConsumer, packedLightIn, overlayColors);
        }
        ((ModelFarseer)this.model).renderToBuffer(matrixStackIn, source.getBuffer(defRenderType), packedLightIn, overlayColors);
        matrixStackIn.pushPose();
        matrixStackIn.popPose();
        RenderFarseer.AFTERIMAGE_MODEL.eye.showModel = false;
        RenderType afterimage = RenderType.entityTranslucentEmissive((ResourceLocation)this.getTextureLocation(entityIn));
        Vec3 colorOffset = entityIn.getLatencyOffsetVec(10, partialTicks).scale((double)-0.2f).add(entityIn.angryShakeVec.scale((double)0.3f));
        Vec3 redOffset = colorOffset.add(entityIn.calculateAfterimagePos(partialTicks, false, afterimageSpeed));
        Vec3 blueOffset = colorOffset.add(entityIn.calculateAfterimagePos(partialTicks, true, afterimageSpeed));
        float scale = (float)Mth.clamp((double)(colorOffset.length() * (double)0.1f), (double)0.0, (double)1.0);
        float angryProgress = entityIn.prevAngryProgress + (entityIn.angryProgress - entityIn.prevAngryProgress) * partialTicks;
        float afterimageAlpha1 = defAlpha * Math.max(((float)Math.sin(((float)entityIn.tickCount + partialTicks) * 0.2f) + 1.0f) * 0.3f, angryProgress * 0.2f);
        float afterimageAlpha2 = defAlpha * Math.max(((float)Math.cos(((float)entityIn.tickCount + partialTicks) * 0.2f) + 1.0f) * 0.3f, angryProgress * 0.2f);
        matrixStackIn.pushPose();
        matrixStackIn.scale(scale + 1.0f, scale + 1.0f, scale + 1.0f);
        matrixStackIn.pushPose();
        matrixStackIn.translate(redOffset.x, redOffset.y, redOffset.z);
        AFTERIMAGE_MODEL.renderToBuffer(matrixStackIn, source.getBuffer(afterimage), 240, overlayColors);
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        matrixStackIn.translate(blueOffset.x, blueOffset.y, blueOffset.z);
        AFTERIMAGE_MODEL.renderToBuffer(matrixStackIn, source.getBuffer(afterimage), 240, overlayColors);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
        RenderFarseer.AFTERIMAGE_MODEL.eye.showModel = true;
    }

    private static void laserOriginVertex(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, int p_114222_, float xOffset, float yOffset) {
        p_114220_.addVertex(0.0f, 0.0f, 0.0f).setColor(65025, 65025, 65025, 65025).setUv(xOffset + 0.5f, yOffset).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 0).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static void laserLeftCornerVertex(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.addVertex(0.0f, 0.0f, 0.0f).setColor(65025, 65025, 65025, 0).setUv(xOffset, yOffset + 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 0).setNormal(0.0f, -1.0f, 0.0f);
    }

    private static void laserRightCornerVertex(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.addVertex(0.0f, 0.0f, 0.0f).setColor(65025, 65025, 65025, 0).setUv(xOffset + 1.0f, yOffset + 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 0).setNormal(0.0f, -1.0f, 0.0f);
    }

    private static void portalVertex(VertexConsumer p_114090_, Matrix4f p_114091_, Matrix3f p_114092_, int p_114093_, float p_114094_, int p_114095_, int p_114096_, int p_114097_, float alpha) {
        p_114090_.addVertex(0.0f, 0.0f, 0.0f).setColor(255, 255, 255, (int)(alpha * 255.0f)).setUv((float)p_114096_, (float)p_114097_).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 0).setNormal(0.0f, -1.0f, 0.0f);
    }

    protected void setupRotations(EntityFarseer farseer, PoseStack matrixStackIn, float f1, float f2, float f3) {
        float invCameraAmount = 1.0f - farseer.getFacingCameraAmount(Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true));
        if (this.isShaking((LivingEntity)farseer)) {
            f2 += (float)(Math.cos((double)farseer.tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        if (!farseer.hasPose(Pose.SLEEPING)) {
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - f2 * invCameraAmount));
        }
        if (farseer.deathTime > 0) {
            float f = ((float)farseer.deathTime + f3 - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(f * this.getFlipDegrees((LivingEntity)farseer) * invCameraAmount));
        } else if (RenderFarseer.isEntityUpsideDown((LivingEntity)farseer)) {
            matrixStackIn.translate(0.0, (double)(farseer.getBbHeight() + 0.1f), 0.0);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    @Nullable
    protected RenderType getRenderType(EntityFarseer farseer, boolean normal, boolean invis, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(farseer);
        if (invis || farseer.getAnimation() == EntityFarseer.ANIMATION_EMERGE) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourcelocation);
        }
        if (normal) {
            return ((ModelFarseer)this.model).renderType(resourcelocation);
        }
        return outline ? RenderType.outline((ResourceLocation)resourcelocation) : null;
    }

    public ResourceLocation getTextureLocation(EntityFarseer entity) {
        return entity.isAngry() ? TEXTURE_ANGRY : TEXTURE;
    }

    class LayerOverlay
    extends RenderLayer<EntityFarseer, ModelFarseer> {
        public LayerOverlay(RenderFarseer this$0) {
            super((RenderLayerParent)this$0);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityFarseer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.getAnimation() == EntityFarseer.ANIMATION_EMERGE) {
                VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE_CLAWS));
                ((ModelFarseer)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            }
        }
    }
}

