/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelCrimsonMosquito;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerCrimsonMosquitoBlood;
import com.github.alexthe666.alexsmobs.entity.EntityCrimsonMosquito;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class RenderCrimsonMosquito
extends MobRenderer<EntityCrimsonMosquito, ModelCrimsonMosquito> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/crimson_mosquito.png");
    private static final ResourceLocation TEXTURE_SICK = ResourceLocation.parse((String)"alexsmobs:textures/entity/crimson_mosquito_blue.png");
    private static final ResourceLocation TEXTURE_FLY = ResourceLocation.parse((String)"alexsmobs:textures/entity/crimson_mosquito_fly.png");
    private static final ResourceLocation TEXTURE_SICK_FLY = ResourceLocation.parse((String)"alexsmobs:textures/entity/crimson_mosquito_fly_blue.png");

    public RenderCrimsonMosquito(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelCrimsonMosquito(), 0.6f);
        this.addLayer(new LayerCrimsonMosquitoBlood(this));
    }

    protected void scale(EntityCrimsonMosquito entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        float mosScale = entitylivingbaseIn.prevMosquitoScale + (entitylivingbaseIn.getMosquitoScale() - entitylivingbaseIn.prevMosquitoScale) * partialTickTime;
        matrixStackIn.scale(mosScale * 1.2f, mosScale * 1.2f, mosScale * 1.2f);
    }

    protected boolean isShaking(EntityCrimsonMosquito fly) {
        return fly.isSick() || fly.getFleeingEntityId() != -1;
    }

    protected void setupRotations(EntityCrimsonMosquito entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, scale);
        if (this.isShaking(entityLiving)) {
            rotationYaw += (float)(Math.cos((double)entityLiving.tickCount * 7.0) * Math.PI * (double)0.9f);
            float vibrate = 0.05f * entityLiving.getMosquitoScale();
            matrixStackIn.translate((entityLiving.getRandom().nextFloat() - 0.5f) * vibrate, (entityLiving.getRandom().nextFloat() - 0.5f) * vibrate, (entityLiving.getRandom().nextFloat() - 0.5f) * vibrate);
        }
    }

    public ResourceLocation getTextureLocation(EntityCrimsonMosquito entity) {
        if (entity.isSick()) {
            return entity.isFromFly() ? TEXTURE_SICK_FLY : TEXTURE_SICK;
        }
        return entity.isFromFly() ? TEXTURE_FLY : TEXTURE;
    }
}

