/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelBunfungus;
import com.github.alexthe666.alexsmobs.entity.EntityBunfungus;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RenderBunfungus
extends MobRenderer<EntityBunfungus, ModelBunfungus> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/bunfungus.png");
    private static final ResourceLocation TEXTURE_SLEEPING = ResourceLocation.parse((String)"alexsmobs:textures/entity/bunfungus_sleeping.png");

    public RenderBunfungus(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelBunfungus(), 0.6f);
        this.addLayer(new LayerHeldItem(this));
    }

    protected void scale(EntityBunfungus rabbit, PoseStack matrixStackIn, float partialTickTime) {
        float f = (float)rabbit.prevTransformTime + (float)(rabbit.transformsIn() - rabbit.prevTransformTime) * partialTickTime;
        float f1 = (50.0f - f) / 50.0f;
        float f2 = f1 * 0.7f + 0.3f;
        matrixStackIn.scale(f2, f2, f2);
    }

    public ResourceLocation getTextureLocation(EntityBunfungus entity) {
        return entity.isSleeping() ? TEXTURE_SLEEPING : TEXTURE;
    }

    static class LayerHeldItem
    extends RenderLayer<EntityBunfungus, ModelBunfungus> {
        public LayerHeldItem(RenderBunfungus render) {
            super((RenderLayerParent)render);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityBunfungus entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack itemstack = entitylivingbaseIn.getItemBySlot(EquipmentSlot.MAINHAND);
            matrixStackIn.pushPose();
            if (entitylivingbaseIn.isBaby()) {
                matrixStackIn.scale(0.5f, 0.5f, 0.5f);
                matrixStackIn.translate(0.0, 1.5, 0.0);
            }
            matrixStackIn.pushPose();
            this.translateToHand(matrixStackIn);
            matrixStackIn.translate(0.3f, 0.45f, -0.15f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-90.0f));
            matrixStackIn.scale(1.15f, 1.15f, 1.15f);
            ItemInHandRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            renderer.renderItem((LivingEntity)entitylivingbaseIn, itemstack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }

        protected void translateToHand(PoseStack matrixStack) {
            ((ModelBunfungus)this.getParentModel()).root.translateAndRotate(matrixStack);
            ((ModelBunfungus)this.getParentModel()).body.translateAndRotate(matrixStack);
            ((ModelBunfungus)this.getParentModel()).right_arm.translateAndRotate(matrixStack);
        }
    }
}

