/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.client.model.ModelEndPirateAnchor;
import com.github.alexthe666.alexsmobs.client.model.ModelEndPirateAnchorWinch;
import com.github.alexthe666.alexsmobs.client.model.ModelEndPirateShipWheel;
import com.github.alexthe666.alexsmobs.client.model.ModelMysteriousWorm;
import com.github.alexthe666.alexsmobs.client.model.ModelShieldOfTheDeep;
import com.github.alexthe666.alexsmobs.client.model.ModelTransmutationTable;
import com.github.alexthe666.alexsmobs.client.render.AMMobIcons;
import com.github.alexthe666.alexsmobs.client.render.RenderLaviathan;
import com.github.alexthe666.alexsmobs.client.render.RenderMurmurBody;
import com.github.alexthe666.alexsmobs.client.render.RenderUnderminer;
import com.github.alexthe666.alexsmobs.entity.EntityBaldEagle;
import com.github.alexthe666.alexsmobs.entity.EntityBlobfish;
import com.github.alexthe666.alexsmobs.entity.EntityCockroach;
import com.github.alexthe666.alexsmobs.entity.EntityCosmaw;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.entity.EntityGiantSquid;
import com.github.alexthe666.alexsmobs.entity.EntityLaviathan;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.github.alexthe666.alexsmobs.entity.EntityMurmur;
import com.github.alexthe666.alexsmobs.entity.EntityUnderminer;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWorm;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.item.ItemStinkRay;
import com.github.alexthe666.alexsmobs.item.ItemTabIcon;
import com.github.alexthe666.alexsmobs.item.ItemVineLasso;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class AMItemstackRenderer
extends BlockEntityWithoutLevelRenderer {
    public static int ticksExisted = 0;
    private static final ModelShieldOfTheDeep SHIELD_OF_THE_DEEP_MODEL = new ModelShieldOfTheDeep();
    private static final ResourceLocation SHIELD_OF_THE_DEEP_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/armor/shield_of_the_deep.png");
    private static final ModelMysteriousWorm MYTERIOUS_WORM_MODEL = new ModelMysteriousWorm();
    private static final ResourceLocation MYTERIOUS_WORM_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/item/mysterious_worm_model.png");
    private static final ModelEndPirateAnchor ANCHOR_MODEL = new ModelEndPirateAnchor();
    private static final ResourceLocation ANCHOR_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/anchor.png");
    private static final ModelEndPirateAnchorWinch WINCH_MODEL = new ModelEndPirateAnchorWinch();
    private static final ResourceLocation WINCH_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/anchor_winch.png");
    private static final ModelEndPirateShipWheel SHIP_WHEEL_MODEL = new ModelEndPirateShipWheel();
    private static final ResourceLocation SHIP_WHEEL_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/ship_wheel.png");
    private static final ResourceLocation TRANSMUTATION_TABLE_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/transmutation_table.png");
    private static final ResourceLocation TRANSMUTATION_TABLE_GLOW_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/transmutation_table_glow.png");
    private static final ResourceLocation TRANSMUTATION_TABLE_OVERLAY = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/transmutation_table_overlay.png");
    private static final ModelTransmutationTable TRANSMUTATION_TABLE_MODEL = new ModelTransmutationTable(0.0f);
    private static final ModelTransmutationTable TRANSMUTATION_TABLE_OVERLAY_MODEL = new ModelTransmutationTable(0.01f);
    private static List<ItemStack> DIMENSIONAL_CARVER_SHARDS;
    private final Map<String, Entity> renderedEntites = new HashMap<String, Entity>();
    private final List<EntityType> blockedRenderEntities = new ArrayList<EntityType>();

    public AMItemstackRenderer() {
        super(null, null);
    }

    public static void incrementTick() {
        ++ticksExisted;
    }

    private static float getScaleFor(EntityType type, List<Pair<EntityType, Float>> mobIcons) {
        for (Pair<EntityType, Float> pair : mobIcons) {
            if (pair.getFirst() != type) continue;
            return ((Float)pair.getSecond()).floatValue();
        }
        return 1.0f;
    }

    private static List<ItemStack> getDimensionalCarverShards() {
        if (DIMENSIONAL_CARVER_SHARDS == null || DIMENSIONAL_CARVER_SHARDS.isEmpty()) {
            DIMENSIONAL_CARVER_SHARDS = (List)Util.make((Object)Lists.newArrayList(), list -> {
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_0"))));
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_1"))));
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_2"))));
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_3"))));
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_4"))));
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_5"))));
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_6"))));
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_7"))));
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_8"))));
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_9"))));
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"alexsmobs:dimensional_carver_shard_10"))));
            });
        }
        return DIMENSIONAL_CARVER_SHARDS;
    }

    public static void drawEntityOnScreen(PoseStack matrixstack, int posX, int posY, float scale, boolean follow, double xRot, double yRot, double zRot, float mouseX, float mouseY, Entity entity) {
        float f = (float)Math.atan(-mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        matrixstack.scale(scale, scale, scale);
        entity.setOnGround(false);
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf quaternion1 = Axis.XP.rotationDegrees(20.0f);
        float partialTicksForRender = Minecraft.getInstance().isPaused() || entity instanceof EntityMimicOctopus ? 0.0f : partialTicks;
        int tick = Minecraft.getInstance().player == null || Minecraft.getInstance().isPaused() ? ticksExisted : Minecraft.getInstance().player.tickCount;
        if (follow) {
            float yaw = f * 45.0f;
            entity.setYRot(yaw);
            entity.tickCount = tick;
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).yBodyRot = yaw;
                ((LivingEntity)entity).yBodyRotO = yaw;
                ((LivingEntity)entity).yHeadRot = yaw;
                ((LivingEntity)entity).yHeadRotO = yaw;
            }
            quaternion1 = Axis.XP.rotationDegrees(f1 * 20.0f);
            quaternion.mul((Quaternionfc)quaternion1);
        }
        matrixstack.mulPose(quaternion);
        matrixstack.mulPose(Axis.XP.rotationDegrees((float)(-xRot)));
        matrixstack.mulPose(Axis.YP.rotationDegrees((float)yRot));
        matrixstack.mulPose(Axis.ZP.rotationDegrees((float)zRot));
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        quaternion1.conjugate();
        entityrenderdispatcher.overrideCameraOrientation(quaternion1);
        entityrenderdispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTicksForRender, matrixstack, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        multibuffersource$buffersource.endBatch();
        entityrenderdispatcher.setRenderShadow(true);
        entity.setYRot(0.0f);
        entity.setXRot(0.0f);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).yBodyRot = 0.0f;
            ((LivingEntity)entity).yHeadRotO = 0.0f;
            ((LivingEntity)entity).yHeadRot = 0.0f;
        }
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
    }

    public void renderByItem(ItemStack itemStackIn, ItemDisplayContext transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int tick = Minecraft.getInstance().player == null || Minecraft.getInstance().isPaused() ? ticksExisted : Minecraft.getInstance().player.tickCount;
        ClientLevel level = Minecraft.getInstance().level;
        if (itemStackIn.getItem() == AMItemRegistry.SHIELD_OF_THE_DEEP.get()) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.4f, -0.75f, 0.5f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-180.0f));
            VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)SHIELD_OF_THE_DEEP_TEXTURE), (boolean)itemStackIn.hasFoil());
            SHIELD_OF_THE_DEEP_MODEL.renderToBuffer(matrixStackIn, vertexconsumer, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
        }
        if (itemStackIn.getItem() == AMItemRegistry.MYSTERIOUS_WORM.get()) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, -2.0f, 0.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-180.0f));
            MYTERIOUS_WORM_MODEL.animateStack(itemStackIn);
            MYTERIOUS_WORM_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)MYTERIOUS_WORM_TEXTURE)), combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
        }
        if (itemStackIn.getItem() == AMItemRegistry.FALCONRY_GLOVE.get()) {
            matrixStackIn.translate(0.5f, 0.5f, 0.5f);
            if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                Minecraft.getInstance().getItemRenderer().renderStatic(new ItemStack((ItemLike)AMItemRegistry.FALCONRY_GLOVE_HAND.get()), transformType, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
            } else {
                Minecraft.getInstance().getItemRenderer().renderStatic(new ItemStack((ItemLike)AMItemRegistry.FALCONRY_GLOVE_INVENTORY.get()), transformType, transformType == ItemDisplayContext.GROUND ? combinedLightIn : 240, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
            }
        }
        if (itemStackIn.getItem() == AMItemRegistry.VINE_LASSO.get()) {
            matrixStackIn.translate(0.5f, 0.5f, 0.5f);
            if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                if (ItemVineLasso.isItemInUse(itemStackIn)) {
                    if (transformType.firstPerson()) {
                        matrixStackIn.translate(transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND ? -0.3f : 0.3f, 0.0f, -0.5f);
                    }
                    matrixStackIn.mulPose(Axis.YP.rotation((float)tick + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true)));
                }
                Minecraft.getInstance().getItemRenderer().renderStatic(new ItemStack((ItemLike)AMItemRegistry.VINE_LASSO_HAND.get()), transformType, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
            } else {
                Minecraft.getInstance().getItemRenderer().renderStatic(new ItemStack((ItemLike)AMItemRegistry.VINE_LASSO_INVENTORY.get()), transformType, transformType == ItemDisplayContext.GROUND ? combinedLightIn : 240, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
            }
        }
        if (itemStackIn.getItem() == AMItemRegistry.SKELEWAG_SWORD.get()) {
            matrixStackIn.translate(0.5f, 0.5f, 0.5f);
            ItemStack spriteItem = new ItemStack((ItemLike)AMItemRegistry.SKELEWAG_SWORD_INVENTORY.get());
            ItemStack handItem = new ItemStack((ItemLike)AMItemRegistry.SKELEWAG_SWORD_HAND.get());
            CustomData customData = (CustomData)itemStackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            if (!customData.isEmpty()) {
                spriteItem.set(DataComponents.CUSTOM_DATA, (Object)customData);
                handItem.set(DataComponents.CUSTOM_DATA, (Object)customData);
            }
            if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                Minecraft.getInstance().getItemRenderer().renderStatic(handItem, transformType, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
            } else {
                Minecraft.getInstance().getItemRenderer().renderStatic(spriteItem, transformType, transformType == ItemDisplayContext.GROUND ? combinedLightIn : 240, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
            }
        }
        if (itemStackIn.getItem() == ((Block)AMBlockRegistry.TRANSMUTATION_TABLE.get()).asItem()) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5f, 1.6f, 0.5f);
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-180.0f));
            TRANSMUTATION_TABLE_MODEL.resetToDefaultPose();
            TRANSMUTATION_TABLE_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TRANSMUTATION_TABLE_TEXTURE)), combinedLightIn, combinedOverlayIn);
            TRANSMUTATION_TABLE_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)TRANSMUTATION_TABLE_GLOW_TEXTURE)), combinedLightIn, combinedOverlayIn);
            TRANSMUTATION_TABLE_OVERLAY_MODEL.resetToDefaultPose();
            VertexConsumer staticyOverlay = bufferIn.getBuffer(RenderType.eyes((ResourceLocation)TRANSMUTATION_TABLE_OVERLAY));
            TRANSMUTATION_TABLE_OVERLAY_MODEL.renderToBuffer(matrixStackIn, staticyOverlay, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
        }
        if (itemStackIn.getItem() == AMItemRegistry.SHATTERED_DIMENSIONAL_CARVER.get()) {
            matrixStackIn.translate(0.5f, 0.5f, 0.5f);
            float f = (float)tick + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            List<ItemStack> shards = AMItemstackRenderer.getDimensionalCarverShards();
            matrixStackIn.pushPose();
            if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                matrixStackIn.translate(-0.2f, 0.0f, 0.0f);
                matrixStackIn.scale(1.3f, 1.3f, 1.3f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(60.0f));
            }
            for (int i = 0; i < shards.size(); ++i) {
                matrixStackIn.pushPose();
                ItemStack shard = shards.get(i);
                matrixStackIn.translate((float)Math.sin(f * 0.15f + (float)i * 1.0f) * 0.035f, -((float)Math.cos(f * 0.15f + (float)i * 1.0f)) * 0.035f, (float)Math.cos((double)(f * 0.15f + (float)i * 0.5f) + 1.5707963267948966) * 0.025f);
                Minecraft.getInstance().getItemRenderer().renderStatic(shard, transformType, transformType == ItemDisplayContext.GROUND ? combinedLightIn : 240, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
                matrixStackIn.popPose();
            }
            matrixStackIn.popPose();
        }
        if (itemStackIn.getItem() == AMItemRegistry.STINK_RAY.get()) {
            matrixStackIn.translate(0.5f, 0.5f, 0.5f);
            ItemStack hand = new ItemStack(ItemStinkRay.isUsable(itemStackIn) ? (ItemLike)AMItemRegistry.STINK_RAY_HAND.get() : (ItemLike)AMItemRegistry.STINK_RAY_EMPTY_HAND.get());
            ItemStack inventory = new ItemStack(ItemStinkRay.isUsable(itemStackIn) ? (ItemLike)AMItemRegistry.STINK_RAY_INVENTORY.get() : (ItemLike)AMItemRegistry.STINK_RAY_EMPTY_INVENTORY.get());
            if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                Minecraft.getInstance().getItemRenderer().renderStatic(hand, transformType, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
            } else {
                Minecraft.getInstance().getItemRenderer().renderStatic(inventory, transformType, transformType == ItemDisplayContext.GROUND ? combinedLightIn : 240, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
            }
        }
        if (itemStackIn.getItem() == AMItemRegistry.TAB_ICON.get()) {
            Entity fakeEntity = null;
            List<Pair<EntityType, Float>> mobIcons = AMMobIcons.getMobIcons();
            int entityIndex = tick / 40 % mobIcons.size();
            float scale = 1.0f;
            int flags = 0;
            if (level != null) {
                if (ItemTabIcon.hasCustomEntityDisplay(itemStackIn)) {
                    flags = ItemTabIcon.getDisplayMobFlags(itemStackIn);
                    String index = ItemTabIcon.getCustomDisplayEntityString(itemStackIn);
                    EntityType local = ItemTabIcon.getEntityType(itemStackIn);
                    scale = AMItemstackRenderer.getScaleFor(local, mobIcons);
                    float componentScale = ItemTabIcon.getDisplayMobScale(itemStackIn);
                    if (componentScale > 0.0f) {
                        scale = componentScale;
                    }
                    if (this.renderedEntites.get(index) == null && !this.blockedRenderEntities.contains(local)) {
                        try {
                            Entity entity = local.create((Level)level);
                            if (entity instanceof EntityBlobfish) {
                                ((EntityBlobfish)entity).setDepressurized(true);
                            }
                            this.renderedEntites.put(local.getDescriptionId(), entity);
                            fakeEntity = entity;
                        }
                        catch (Exception e) {
                            this.blockedRenderEntities.add(local);
                            AlexsMobs.LOGGER.error("Could not render item for entity: " + String.valueOf(local));
                        }
                    } else {
                        fakeEntity = this.renderedEntites.get(local.getDescriptionId());
                    }
                } else {
                    EntityType type = (EntityType)mobIcons.get(entityIndex).getFirst();
                    scale = ((Float)mobIcons.get(entityIndex).getSecond()).floatValue();
                    if (type != null) {
                        if (this.renderedEntites.get(type.getDescriptionId()) == null && !this.blockedRenderEntities.contains(type)) {
                            try {
                                Entity entity = type.create((Level)level);
                                if (entity instanceof EntityBlobfish) {
                                    ((EntityBlobfish)entity).setDepressurized(true);
                                }
                                this.renderedEntites.put(type.getDescriptionId(), entity);
                                fakeEntity = entity;
                            }
                            catch (Exception e) {
                                this.blockedRenderEntities.add(type);
                                AlexsMobs.LOGGER.error("Could not render item for entity: " + String.valueOf(type));
                            }
                        } else {
                            fakeEntity = this.renderedEntites.get(type.getDescriptionId());
                        }
                    }
                }
            }
            if (fakeEntity instanceof EntityCockroach) {
                if (flags == 99) {
                    matrixStackIn.translate(0.0f, 0.25f, 0.0f);
                    matrixStackIn.mulPose(Axis.XP.rotationDegrees(-80.0f));
                    ((EntityCockroach)fakeEntity).setMaracas(true);
                } else {
                    ((EntityCockroach)fakeEntity).setMaracas(false);
                }
            }
            if (fakeEntity instanceof EntityElephant) {
                if (flags == 99) {
                    ((EntityElephant)fakeEntity).setTusked(true);
                    ((EntityElephant)fakeEntity).setColor(null);
                } else if (flags == 98) {
                    ((EntityElephant)fakeEntity).setTusked(false);
                    ((EntityElephant)fakeEntity).setColor(DyeColor.BROWN);
                } else {
                    ((EntityElephant)fakeEntity).setTusked(false);
                    ((EntityElephant)fakeEntity).setColor(null);
                }
            }
            if (fakeEntity instanceof EntityBaldEagle) {
                if (flags == 98) {
                    ((EntityBaldEagle)fakeEntity).setCap(true);
                } else {
                    ((EntityBaldEagle)fakeEntity).setCap(false);
                }
            }
            if (fakeEntity instanceof EntityVoidWorm) {
                matrixStackIn.translate(0.0f, 0.5f, 0.0f);
            }
            if (fakeEntity instanceof EntityMimicOctopus) {
                matrixStackIn.translate(0.0f, 0.5f, 0.0f);
            }
            if (fakeEntity instanceof EntityLaviathan) {
                RenderLaviathan.renderWithoutShaking = true;
                matrixStackIn.translate(0.0f, 0.3f, 0.0f);
            }
            if (fakeEntity instanceof EntityCosmaw) {
                matrixStackIn.translate(0.0f, 0.2f, 0.0f);
            }
            if (fakeEntity instanceof EntityGiantSquid) {
                matrixStackIn.translate(0.0f, 0.5f, 0.3f);
            }
            if (fakeEntity instanceof EntityUnderminer) {
                RenderUnderminer.renderWithPickaxe = true;
            }
            if (fakeEntity instanceof EntityMurmur) {
                RenderMurmurBody.renderWithHead = true;
                matrixStackIn.translate(0.0f, -0.2f, 0.0f);
            }
            if (fakeEntity != null) {
                MouseHandler mouseHelper = Minecraft.getInstance().mouseHandler;
                double mouseX = mouseHelper.xpos() * (double)Minecraft.getInstance().getWindow().getGuiScaledWidth() / (double)Minecraft.getInstance().getWindow().getScreenWidth();
                double mouseY = mouseHelper.ypos() * (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() / (double)Minecraft.getInstance().getWindow().getScreenHeight();
                matrixStackIn.translate(0.5f, 0.0f, 0.0f);
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                if (transformType != ItemDisplayContext.GUI) {
                    mouseX = 0.0;
                    mouseY = 0.0;
                }
                try {
                    AMItemstackRenderer.drawEntityOnScreen(matrixStackIn, 0, 0, scale, true, 0.0, -45.0, 0.0, (float)mouseX, (float)mouseY, fakeEntity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fakeEntity instanceof EntityLaviathan) {
                RenderLaviathan.renderWithoutShaking = false;
            }
            if (fakeEntity instanceof EntityUnderminer) {
                RenderUnderminer.renderWithPickaxe = false;
            }
            if (fakeEntity instanceof EntityMurmur) {
                RenderMurmurBody.renderWithHead = false;
            }
        }
    }
}

