/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ParticleSmelly
extends SimpleAnimatedParticle {
    private ParticleSmelly(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, SpriteSet sprites) {
        super(world, x, y, z, sprites, 0.0f);
        this.xd = (float)motionX;
        this.yd = (float)motionY;
        this.zd = (float)motionZ;
        this.quadSize *= 0.7f + this.random.nextFloat() * 0.6f;
        this.lifetime = 15 + this.random.nextInt(15);
        this.gravity = -0.1f;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        this.yd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        this.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        this.setSpriteFromAge(this.sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSmelly p = new ParticleSmelly(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            return p;
        }
    }
}

