/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ParticleDna
extends SimpleAnimatedParticle {
    private ParticleDna(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, SpriteSet sprites) {
        super(world, x, y, z, sprites, 0.0f);
        this.xd = (float)motionX;
        this.yd = (float)motionY;
        this.zd = (float)motionZ;
        this.quadSize *= 1.5f + this.random.nextFloat() * 0.6f;
        this.lifetime = 15 + this.random.nextInt(15);
        this.gravity = 0.1f;
        int color = 15916745;
        float lvt_18_1_ = (float)(color >> 16 & 0xFF) / 255.0f;
        float lvt_19_1_ = (float)(color >> 8 & 0xFF) / 255.0f;
        float lvt_20_1_ = (float)(color & 0xFF) / 255.0f;
        this.setColor(lvt_18_1_, lvt_19_1_, lvt_20_1_);
        this.setSpriteFromAge(sprites);
        this.alpha = 0.0f;
        this.roll = (float)(1.5707963267948966 * (double)this.random.nextFloat());
    }

    public int getLightColor(float p_189214_1_) {
        int lvt_2_1_ = super.getLightColor(p_189214_1_);
        int lvt_4_1_ = lvt_2_1_ >> 16 & 0xFF;
        return 0xF0 | lvt_4_1_ << 16;
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        this.yd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        this.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        float subAlpha = 1.0f;
        if (this.age > 5) {
            subAlpha = 1.0f - (float)(this.age - 5) / (float)(this.getLifetime() - 5);
        }
        this.alpha = subAlpha;
        this.setSpriteFromAge(this.sprites);
        this.roll += (float)Math.random() * (0.9424779f * this.alpha);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleDna p = new ParticleDna(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            return p;
        }
    }
}

