/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.model.layered;

import com.github.alexthe666.alexsmobs.entity.util.FlyingFishBootsUtil;
import com.github.alexthe666.alexsmobs.entity.util.Maths;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class ModelFlyingFishBoots
extends HumanoidModel {
    private final ModelPart rightFish;
    private final ModelPart leftFish;
    private final ModelPart rightWingOuter;
    private final ModelPart leftWingOuter;
    private final ModelPart rightWingInner;
    private final ModelPart leftWingInner;

    public ModelFlyingFishBoots(ModelPart root) {
        super(root);
        this.rightFish = root.getChild("right_leg").getChild("RBoot");
        this.leftFish = root.getChild("left_leg").getChild("LBoot");
        this.rightWingOuter = this.rightFish.getChild("RwingR");
        this.leftWingOuter = this.leftFish.getChild("LwingL");
        this.rightWingInner = this.rightFish.getChild("RwingL");
        this.leftWingInner = this.leftFish.getChild("LwingR");
    }

    public static LayerDefinition createArmorLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)deformation, (float)1.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition leftleg = partdefinition.getChild("left_leg");
        PartDefinition rightleg = partdefinition.getChild("right_leg");
        PartDefinition RBoot = rightleg.addOrReplaceChild("RBoot", CubeListBuilder.create().texOffs(18, 12).mirror().addBox(-1.9f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.3f)).mirror(false).texOffs(0, 25).mirror().addBox(0.0f, -2.0f, 2.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).mirror().addBox(-2.5f, 0.0f, -5.0f, 5.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-0.1f, (float)10.0f, (float)0.0f));
        RBoot.addOrReplaceChild("RwingR", CubeListBuilder.create().texOffs(9, 47).mirror().addBox(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)1.0f, (float)-3.0f, (float)0.0f, (float)-0.5672f, (float)0.0f));
        RBoot.addOrReplaceChild("RwingL", CubeListBuilder.create().texOffs(0, 42).mirror().addBox(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)1.0f, (float)-3.0f, (float)0.0f, (float)0.5672f, (float)0.0f));
        PartDefinition LBoot = leftleg.addOrReplaceChild("LBoot", CubeListBuilder.create().texOffs(18, 12).addBox(-2.1f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.3f)).texOffs(0, 25).addBox(0.0f, -2.0f, 2.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.5f, 0.0f, -5.0f, 5.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.1f, (float)10.0f, (float)0.0f));
        LBoot.addOrReplaceChild("LwingL", CubeListBuilder.create().texOffs(9, 47).addBox(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)1.0f, (float)-3.0f, (float)0.0f, (float)0.5672f, (float)0.0f));
        LBoot.addOrReplaceChild("LwingR", CubeListBuilder.create().texOffs(0, 42).addBox(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)1.0f, (float)-3.0f, (float)0.0f, (float)-0.5672f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelFlyingFishBoots withAnimations(LivingEntity entity) {
        if (entity != null) {
            boolean flying;
            float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            float ageInTicks = (float)entity.tickCount + partialTick;
            float fly = Mth.cos((float)(ageInTicks * 0.2f)) * 0.1f;
            float fly2 = fly * 0.35f;
            boolean bl = flying = FlyingFishBootsUtil.getBoostTicks(entity) > 0;
            if (flying) {
                fly2 = fly = (1.0f + Mth.sin((float)(ageInTicks * 1.2f))) * 0.8f;
            }
            this.rightWingOuter.yRot = -0.5672f - fly;
            this.leftWingOuter.yRot = 0.5672f + fly;
            this.rightWingInner.yRot = 0.5672f + fly2;
            this.leftWingInner.yRot = -0.5672f - fly2;
            if (flying || entity.getPose() == Pose.SWIMMING) {
                this.leftFish.xRot = Maths.rad(-45.0);
                this.rightFish.xRot = Maths.rad(-45.0);
                this.rightFish.y = 11.0f;
                this.leftFish.y = 11.0f;
                this.rightFish.z = -1.5f;
                this.leftFish.z = -1.5f;
            } else if (entity.getPose() == Pose.CROUCHING) {
                this.leftFish.xRot = 0.0f;
                this.rightFish.xRot = 0.0f;
                this.rightFish.y = 8.0f;
                this.leftFish.y = 8.0f;
                this.rightFish.z = 0.0f;
                this.leftFish.z = 0.0f;
            } else {
                this.leftFish.xRot = 0.0f;
                this.rightFish.xRot = 0.0f;
                this.rightFish.y = 10.0f;
                this.leftFish.y = 10.0f;
                this.rightFish.z = 0.0f;
                this.leftFish.z = 0.0f;
            }
        }
        return this;
    }
}

