/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.model;

import com.github.alexthe666.alexsmobs.entity.EntityRattlesnake;
import com.github.alexthe666.alexsmobs.entity.util.Maths;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;

public class ModelRattlesnake
extends AdvancedEntityModel<EntityRattlesnake> {
    private final AdvancedModelBox body;
    private final AdvancedModelBox tail1;
    private final AdvancedModelBox tail2;
    private final AdvancedModelBox neck1;
    private final AdvancedModelBox neck2;
    private final AdvancedModelBox head;
    private final AdvancedModelBox tongue;

    public ModelRattlesnake() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this, "body");
        this.body.setPos(0.0f, 24.0f, 0.0f);
        this.body.setTextureOffset(0, 0).addBox(-2.0f, -3.0f, -4.0f, 4.0f, 3.0f, 7.0f, 0.0f, false);
        this.tail1 = new AdvancedModelBox((AdvancedEntityModel)this, "tail1");
        this.tail1.setPos(0.0f, -1.75f, 2.95f);
        this.body.addChild((BasicModelPart)this.tail1);
        this.tail1.setTextureOffset(0, 11).addBox(-1.5f, -1.25f, 0.05f, 3.0f, 3.0f, 7.0f, 0.0f, false);
        this.tail2 = new AdvancedModelBox((AdvancedEntityModel)this, "tail2");
        this.tail2.setPos(0.0f, 0.45f, 7.05f);
        this.tail1.addChild((BasicModelPart)this.tail2);
        this.tail2.setTextureOffset(15, 16).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 6.0f, 0.0f, false);
        this.neck1 = new AdvancedModelBox((AdvancedEntityModel)this, "neck1");
        this.neck1.setPos(0.0f, -1.5f, -4.0f);
        this.body.addChild((BasicModelPart)this.neck1);
        this.neck1.setTextureOffset(18, 6).addBox(-1.5f, -1.5f, -5.0f, 3.0f, 3.0f, 5.0f, 0.0f, false);
        this.neck2 = new AdvancedModelBox((AdvancedEntityModel)this, "neck2");
        this.neck2.setPos(0.0f, 0.0f, -4.9f);
        this.neck1.addChild((BasicModelPart)this.neck2);
        this.neck2.setTextureOffset(12, 25).addBox(-1.0f, -1.5f, -5.1f, 2.0f, 3.0f, 5.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this, "head");
        this.head.setPos(0.0f, 0.0f, -5.0f);
        this.neck2.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(0, 22).addBox(-2.0f, -1.0f, -3.8f, 4.0f, 2.0f, 4.0f, 0.0f, false);
        this.tongue = new AdvancedModelBox((AdvancedEntityModel)this, "tongue");
        this.tongue.setPos(0.0f, 0.0f, -3.8f);
        this.head.addChild((BasicModelPart)this.tongue);
        this.tongue.setTextureOffset(0, 0).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 0.0f, 2.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        if (this.young) {
            float f = 1.75f;
            this.head.setScale(f, f, f);
            this.head.setShouldScaleChildren(true);
            matrixStackIn.pushPose();
            matrixStackIn.scale(0.35f, 0.35f, 0.35f);
            matrixStackIn.translate(0.0, 2.75, 0.125);
            this.parts().forEach(p_228292_8_ -> p_228292_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color));
            matrixStackIn.popPose();
            this.head.setScale(1.0f, 1.0f, 1.0f);
        } else {
            matrixStackIn.pushPose();
            this.parts().forEach(p_228290_8_ -> p_228290_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color));
            matrixStackIn.popPose();
        }
    }

    public void setupAnim(EntityRattlesnake entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float walkSpeed = 0.8f;
        float walkDegree = 0.3f;
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        float curlProgress = entity.prevCurlProgress + (entity.curlProgress - entity.prevCurlProgress) * partialTick;
        boolean isBiting = entity.getAnimation() == EntityRattlesnake.ANIMATION_BITE;
        int biteTick = isBiting ? entity.getAnimationTick() : 0;
        float curlFade = 1.0f;
        if (isBiting && biteTick < 5) {
            curlFade = 1.0f - (float)biteTick / 5.0f;
        } else if (isBiting) {
            curlFade = 0.0f;
        }
        float effectiveCurl = curlProgress * curlFade;
        if (effectiveCurl > 0.0f) {
            this.progressPositionPrev(this.body, effectiveCurl, 0.0f, 0.0f, 3.0f, 5.0f);
            this.progressRotationPrev(this.body, effectiveCurl, 0.0f, Maths.rad(-90.0), 0.0f, 5.0f);
            this.progressRotationPrev(this.tail1, effectiveCurl, Maths.rad(-10.0), Maths.rad(-70.0), 0.0f, 5.0f);
            this.progressRotationPrev(this.neck1, effectiveCurl, Maths.rad(-20.0), Maths.rad(60.0), 0.0f, 5.0f);
            if (entity.isRattling() && !isBiting) {
                this.progressRotationPrev(this.tail2, effectiveCurl, Maths.rad(70.0), Maths.rad(-60.0), 0.0f, 5.0f);
                this.walk(this.tail2, 18.0f, 0.1f, false, 1.0f, 0.2f, ageInTicks, 1.0f);
                this.swing(this.tail2, 18.0f, 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
            } else {
                this.progressRotationPrev(this.tail2, effectiveCurl, Maths.rad(10.0), Maths.rad(-90.0), 0.0f, 5.0f);
            }
        }
        if (isBiting) {
            float biteBlend = Math.min(1.0f, (float)biteTick / 5.0f);
            if (biteTick < 7) {
                float windUp = (float)biteTick / 7.0f;
                this.body.rotationPointZ += 2.0f * windUp * biteBlend;
                this.neck1.rotateAngleX += Maths.rad(-45.0) * windUp * biteBlend;
                this.neck2.rotateAngleX += Maths.rad(15.0) * windUp * biteBlend;
                this.tail1.rotateAngleY += Maths.rad(15.0) * windUp * biteBlend;
                this.tail2.rotateAngleY += Maths.rad(-15.0) * windUp * biteBlend;
                this.head.rotateAngleX += Maths.rad(20.0) * windUp * biteBlend;
            } else if (biteTick < 12) {
                float strikeProgress = (float)(biteTick - 7) / 5.0f;
                this.body.rotationPointZ += 2.0f - 4.0f * strikeProgress;
                this.neck1.rotateAngleX += Maths.rad(-45.0) * (1.0f - strikeProgress);
                this.neck2.rotateAngleX += Maths.rad(15.0) * (1.0f - strikeProgress);
                this.tail1.rotateAngleY += Maths.rad(15.0) * (1.0f - strikeProgress);
                this.tail2.rotateAngleY += Maths.rad(-15.0) * (1.0f - strikeProgress);
                this.head.rotateAngleX += Maths.rad(20.0) * (1.0f - strikeProgress);
            } else if (biteTick < 15) {
                float resetProgress = (float)(biteTick - 12) / 3.0f;
                this.body.rotationPointZ += -2.0f * (1.0f - resetProgress);
            }
        }
        if (entity.randomToungeTick > 0) {
            this.tongue.showModel = true;
            this.walk(this.tongue, 1.0f, 0.5f, false, 1.0f, 0.0f, ageInTicks, 1.0f);
        } else {
            this.tongue.showModel = false;
        }
        if (curlProgress < 0.5f && limbSwingAmount > 0.01f && !isBiting) {
            this.swing(this.body, walkSpeed, walkDegree * 0.5f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.swing(this.neck1, walkSpeed, walkDegree * 0.4f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.swing(this.tail1, walkSpeed, walkDegree * 0.6f, false, -1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.swing(this.tail2, walkSpeed, walkDegree * 0.5f, false, -2.0f, 0.0f, limbSwing, limbSwingAmount);
        }
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.tail1, (Object)this.tail2, (Object)this.neck1, (Object)this.neck2, (Object)this.head, (Object)this.tongue);
    }

    public void setRotationAngle(AdvancedModelBox AdvancedModelBox2, float x, float y, float z) {
        AdvancedModelBox2.rotateAngleX = x;
        AdvancedModelBox2.rotateAngleY = y;
        AdvancedModelBox2.rotateAngleZ = z;
    }
}

