/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerRainbow;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientLayerRegistry {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        ImmutableList entityTypes = ImmutableList.copyOf((Collection)BuiltInRegistries.ENTITY_TYPE.stream().filter(DefaultAttributes::hasSupplier).map(entityType -> entityType).collect(Collectors.toList()));
        entityTypes.forEach(entityType -> ClientLayerRegistry.addLayerIfApplicable((EntityType<? extends LivingEntity>)entityType, event));
        for (PlayerSkin.Model skinModel : event.getSkins()) {
            EntityRenderer skin = event.getSkin(skinModel);
            if (skin == null || !(skin instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)skin;
            livingRenderer.addLayer(new LayerRainbow((RenderLayerParent<?, ?>)livingRenderer));
        }
    }

    private static void addLayerIfApplicable(EntityType<? extends LivingEntity> entityType, EntityRenderersEvent.AddLayers event) {
        if (entityType != EntityType.ENDER_DRAGON) {
            try {
                EntityRenderer renderer = event.getRenderer(entityType);
                if (renderer instanceof LivingEntityRenderer) {
                    LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
                    livingRenderer.addLayer(new LayerRainbow((RenderLayerParent<?, ?>)livingRenderer));
                }
            }
            catch (Exception e) {
                AlexsMobs.LOGGER.warn("Could not apply rainbow color layer to " + String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey(entityType)) + ", has custom renderer that is not LivingEntityRenderer.");
            }
        }
    }
}

