/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;

public class BlockCrystalizedMucus
extends TransparentBlock {
    public static final MapCodec<BlockCrystalizedMucus> CODEC = BlockCrystalizedMucus.simpleCodec(props -> new BlockCrystalizedMucus());
    public static final int DECAY_DISTANCE = 7;
    public static final IntegerProperty DISTANCE = BlockStateProperties.DISTANCE;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    private static final int TICK_DELAY = 1;

    public MapCodec<? extends TransparentBlock> codec() {
        return CODEC;
    }

    protected BlockCrystalizedMucus() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(0.1f).sound(SoundType.GLASS).noOcclusion().isSuffocating((s, s1, s2) -> false).isViewBlocking((s, s1, s2) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isRandomlyTicking(BlockState p_54449_) {
        return (Integer)p_54449_.getValue((Property)DISTANCE) == 7 && (Boolean)p_54449_.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(BlockState p_221379_, ServerLevel p_221380_, BlockPos p_221381_, RandomSource p_221382_) {
        if (this.decaying(p_221379_)) {
            BlockCrystalizedMucus.dropResources((BlockState)p_221379_, (Level)p_221380_, (BlockPos)p_221381_);
            p_221380_.removeBlock(p_221381_, true);
        }
    }

    protected boolean decaying(BlockState p_221386_) {
        return (Boolean)p_221386_.getValue((Property)PERSISTENT) == false && (Integer)p_221386_.getValue((Property)DISTANCE) == 7;
    }

    public void tick(BlockState p_221369_, ServerLevel p_221370_, BlockPos p_221371_, RandomSource p_221372_) {
        p_221370_.setBlock(p_221371_, BlockCrystalizedMucus.updateDistance(p_221369_, (LevelAccessor)p_221370_, p_221371_), 3);
    }

    public int getLightBlock(BlockState p_54460_, BlockGetter p_54461_, BlockPos p_54462_) {
        return 1;
    }

    public BlockState updateShape(BlockState p_54440_, Direction p_54441_, BlockState p_54442_, LevelAccessor p_54443_, BlockPos p_54444_, BlockPos p_54445_) {
        int i = BlockCrystalizedMucus.getDistanceAt(p_54442_) + 1;
        if (i != 1 || (Integer)p_54440_.getValue((Property)DISTANCE) != i) {
            p_54443_.scheduleTick(p_54444_, (Block)this, 1);
        }
        return p_54440_;
    }

    private static BlockState updateDistance(BlockState p_54436_, LevelAccessor p_54437_, BlockPos p_54438_) {
        int i = 7;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)p_54438_, direction);
            i = Math.min(i, BlockCrystalizedMucus.getDistanceAt(p_54437_.getBlockState((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)p_54436_.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState p_54464_) {
        if (p_54464_.is((Block)AMBlockRegistry.BANANA_SLUG_SLIME_BLOCK.get())) {
            return 0;
        }
        return p_54464_.getBlock() instanceof BlockCrystalizedMucus ? (Integer)p_54464_.getValue((Property)DISTANCE) : 7;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54447_) {
        p_54447_.add(new Property[]{DISTANCE, PERSISTENT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_54424_) {
        FluidState fluidstate = p_54424_.getLevel().getFluidState(p_54424_.getClickedPos());
        BlockState blockstate = (BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true));
        return BlockCrystalizedMucus.updateDistance(blockstate, (LevelAccessor)p_54424_.getLevel(), p_54424_.getClickedPos());
    }
}

