/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.net.URI;
import java.util.Objects;
import me.srrapero720.watervision.VisionOverlay;
import me.srrapero720.watervision.client.screens.VisionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class WaterVisionClient {
    public static final int DEF_VOLUME = 100;
    public static final float DEF_SPEED = 1.0f;
    public static final boolean DEF_STRETCH = false;
    public static final float DEF_GAME_FADE_DURATION = 20.0f;
    public static final float DEF_VIDEO_FADE_DURATION = 20.0f;
    public static final boolean DEF_CONTROLS = true;
    public static final boolean DEF_EXIT = true;

    @OnlyIn(value=Dist.CLIENT)
    public static void openScreen(URI uri, int volume, float speed, boolean stretchVideo, float gameFadeDuration, float videoFadeDuration, boolean controls, boolean exit) {
        Minecraft.getInstance().setScreen((Screen)new VisionScreen(uri, volume, speed, stretchVideo, gameFadeDuration, videoFadeDuration, controls, exit));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void closeScreen() {
        if (Minecraft.getInstance().screen instanceof VisionScreen) {
            Minecraft.getInstance().setScreen(null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openOverlay(URI uri) {
        VisionOverlay.uri = uri;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void closeOverlay() {
        VisionOverlay.uri = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void internal$blit(GuiGraphics graphics, ResourceLocation texture, float alpha, int x, int y, int offsetX, int offsetY, int width, int height) {
        float pX1 = x;
        float pX2 = x + width;
        float pY1 = y;
        float pY2 = y + height;
        float pBlitOffset = 0.0f;
        int pMinU = offsetX / width;
        int pMaxU = (offsetX + width) / width;
        int pMinV = offsetY / height;
        int pMaxV = (offsetY + height) / height;
        RenderSystem.enableBlend();
        int tex = Minecraft.getInstance().getTextureManager().getTexture(texture).getId();
        RenderSystem.bindTexture((int)tex);
        RenderSystem.setShaderTexture((int)0, (int)tex);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = graphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, pX1, pY1, 0.0f).setUv((float)pMinU, (float)pMinV);
        bufferbuilder.addVertex(matrix4f, pX1, pY2, 0.0f).setUv((float)pMinU, (float)pMaxV);
        bufferbuilder.addVertex(matrix4f, pX2, pY2, 0.0f).setUv((float)pMaxU, (float)pMaxV);
        bufferbuilder.addVertex(matrix4f, pX2, pY1, 0.0f).setUv((float)pMaxU, (float)pMinV);
        BufferUploader.drawWithShader((MeshData)Objects.requireNonNull(bufferbuilder.build()));
        RenderSystem.disableBlend();
    }
}

