/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision;

import com.mojang.brigadier.CommandDispatcher;
import me.srrapero720.watervision.client.render.TextureWrapper;
import me.srrapero720.watervision.common.commands.VisionCommands;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.api.image.ImageAPI;

@Mod(value="watervision")
public class WaterVision {
    public static final String ID = "watervision";
    public static final Logger LOGGER = LogManager.getLogger((String)"watervision");
    public static final Marker IT = MarkerManager.getMarker((String)"Main");
    public static final ResourceLocation LOADING_ANIM_TEXTURE = ResourceLocation.tryBuild((String)"watervision", (String)"loading_animation");
    private static int ticks = 0;

    public static int getTicks() {
        return ticks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float deltaFrames() {
        return Minecraft.getInstance().isPaused() ? 1.0f : Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class ClientRegistryEvents {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            LOGGER.debug("Client setup...");
            event.enqueueWork(() -> Minecraft.getInstance().getTextureManager().register(LOADING_ANIM_TEXTURE, (AbstractTexture)new TextureWrapper.Renderer(ImageAPI.loadingGif((String)WaterVision.ID))));
        }
    }

    @EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void onCommandsRegister(RegisterCommandsEvent event) {
            VisionCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onClientCommandsRegister(RegisterClientCommandsEvent event) {
            VisionCommands.registerClient((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onLevelTick(ClientTickEvent.Pre event) {
            if (ticks == Integer.MAX_VALUE) {
                ticks = 0;
            }
            ++ticks;
        }
    }
}

