/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;

public class IceSpikesEnderman
extends BaseEnderman {
    public IceSpikesEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 12;
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.MOVEMENT_SPEED, 0.216).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!EndermanOverhaulConfig.spawnIceSpikesEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        return BaseEnderman.checkMonsterSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public boolean playRunAnimWhenAngry() {
        return false;
    }

    @Override
    @Nullable
    public ParticleOptions getCustomParticles() {
        return (ParticleOptions)ModParticleTypes.SNOW.get();
    }

    @Override
    public boolean canPickupBlocks() {
        return false;
    }

    @Override
    public boolean speedUpWhenAngry() {
        return false;
    }

    @Override
    public boolean hasLargeCreepyHitbox() {
        return true;
    }
}

