/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.unusual.blockfactorysbosses.entity.FireAreaEntity;
import net.unusual.blockfactorysbosses.entity.InfernalDragonEntity;
import net.unusual.blockfactorysbosses.entity.PoisonAreaEntity;
import net.unusual.blockfactorysbosses.entity.SoulAreaEntity;
import net.unusual.blockfactorysbosses.entity.SoulShockwaveEntity;
import net.unusual.blockfactorysbosses.entity.SwordWaveEntity;
import net.unusual.blockfactorysbosses.entity.UnderworldKnightEntity;
import net.unusual.blockfactorysbosses.entity.YetiEntity;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class BossesVFXProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        BossesVFXProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                BossesVFXProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    BossesVFXProcedure.mode = mode;
                    BossesVFXProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    BossesVFXProcedure.mode = mode;
                    BossesVFXProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        BossesVFXProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            BossesVFXProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            BossesVFXProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            BossesVFXProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BossesVFXProcedure.execute((Event)event, (LevelAccessor)level, event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double partialTick) {
        BossesVFXProcedure.execute(null, world, partialTick);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double partialTick) {
        block147: {
            double nb = 0.0;
            double lcl_scale = 0.0;
            double i = 0.0;
            double j = 0.0;
            double nx = 0.0;
            double k = 0.0;
            double ny = 0.0;
            double l = 0.0;
            double nz = 0.0;
            double lcl_color = 0.0;
            double lcl_alpha = 0.0;
            if (!(world instanceof ClientLevel)) break block147;
            for (Entity entityiterator : ((ClientLevel)world).entitiesForRendering()) {
                int n;
                int n2;
                int n3;
                block150: {
                    int n4;
                    block149: {
                        int n5;
                        int n6;
                        Monster _datEntI;
                        block148: {
                            int n7;
                            int n8;
                            int n9;
                            Object _datEntI2;
                            Object _datEntI3;
                            if (entityiterator instanceof FireAreaEntity) {
                                int n10;
                                int n11;
                                int n12;
                                if (entityiterator instanceof FireAreaEntity) {
                                    _datEntI3 = (FireAreaEntity)entityiterator;
                                    n12 = (Integer)_datEntI3.getEntityData().get(FireAreaEntity.DATA_living_time);
                                } else {
                                    n12 = 0;
                                }
                                if (n12 > 0) {
                                    if (entityiterator instanceof FireAreaEntity) {
                                        _datEntI2 = (FireAreaEntity)entityiterator;
                                        v1 = ((Integer)_datEntI2.getEntityData().get(FireAreaEntity.DATA_living_time)).intValue();
                                    } else {
                                        v1 = nb = 0.0;
                                    }
                                    if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                                        BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                                        BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                                        BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                                        BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                                        BossesVFXProcedure.end();
                                    }
                                    if (BossesVFXProcedure.target(2)) {
                                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/fireball_impact.png"));
                                        BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x(), entityiterator.getPosition((float)partialTick).y() + 0.05, entityiterator.getPosition((float)partialTick).z(), entityiterator.getViewYRot((float)partialTick), 0.0f, 0.0f, 8.0f, 1.0f, 8.0f, (int)(255.0 * ((nb - partialTick) / 130.0)) << 24 | 0xFF0000 | 0xFF00 | 0xFF);
                                        BossesVFXProcedure.release();
                                    }
                                }
                                if (entityiterator instanceof FireAreaEntity) {
                                    _datEntI3 = (FireAreaEntity)entityiterator;
                                    n11 = (Integer)_datEntI3.getEntityData().get(FireAreaEntity.DATA_living_time);
                                } else {
                                    n11 = 0;
                                }
                                if (n11 <= 120) continue;
                                if (entityiterator instanceof FireAreaEntity) {
                                    _datEntI2 = (FireAreaEntity)entityiterator;
                                    n10 = (Integer)_datEntI2.getEntityData().get(FireAreaEntity.DATA_living_time);
                                } else {
                                    n10 = 0;
                                }
                                nb = n10 - 120;
                                if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, true)) {
                                    for (int index0 = 0; index0 < 90; ++index0) {
                                        for (int index1 = 0; index1 < 45; ++index1) {
                                            k = 255.0 - j / 180.0 * 95.0;
                                            l = 255.0 - (j + 4.0) / 180.0 * 95.0;
                                            BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), -1);
                                            BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), -1);
                                            BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), -1);
                                            BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), -1);
                                            j += 4.0;
                                        }
                                        j = 0.0;
                                        i += 4.0;
                                    }
                                    i = 0.0;
                                    BossesVFXProcedure.end();
                                }
                                if (!BossesVFXProcedure.target(2)) continue;
                                lcl_color = 0.0;
                                lcl_scale = 0.5;
                                lcl_alpha = 61.0;
                                for (int index2 = 0; index2 < 15; ++index2) {
                                    BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x(), entityiterator.getPosition((float)partialTick).y(), entityiterator.getPosition((float)partialTick).z(), 0.0f, 0.0f, 0.0f, (float)((nb - partialTick) / 10.0 * lcl_scale), (float)((nb - partialTick) / 10.0 * lcl_scale), (float)((nb - partialTick) / 10.0 * lcl_scale), (int)lcl_alpha << 24 | (int)(253.0 * (lcl_color / 15.0) + 255.0 * (1.0 - lcl_color / 15.0)) << 16 | (int)(137.0 * (lcl_color / 15.0) + 255.0 * (1.0 - lcl_color / 15.0)) << 8 | (int)(24.0 * (lcl_color / 15.0) + 255.0 * (1.0 - lcl_color / 15.0)));
                                    lcl_color += 1.0;
                                    lcl_alpha -= 4.0;
                                    lcl_scale += 0.6;
                                }
                                BossesVFXProcedure.release();
                                continue;
                            }
                            if (entityiterator instanceof PoisonAreaEntity) {
                                int n13;
                                if (entityiterator instanceof PoisonAreaEntity) {
                                    _datEntI3 = (PoisonAreaEntity)entityiterator;
                                    n13 = (Integer)_datEntI3.getEntityData().get(PoisonAreaEntity.DATA_living_time);
                                } else {
                                    n13 = 0;
                                }
                                if (n13 <= 0) continue;
                                if (entityiterator instanceof PoisonAreaEntity) {
                                    _datEntI2 = (PoisonAreaEntity)entityiterator;
                                    v5 = ((Integer)_datEntI2.getEntityData().get(PoisonAreaEntity.DATA_living_time)).intValue();
                                } else {
                                    v5 = nb = 0.0;
                                }
                                if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                                    BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                                    BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                                    BossesVFXProcedure.end();
                                }
                                if (!BossesVFXProcedure.target(2)) continue;
                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/poison_impact.png"));
                                BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x(), entityiterator.getPosition((float)partialTick).y() + 0.05, entityiterator.getPosition((float)partialTick).z(), entityiterator.getViewYRot((float)partialTick), 0.0f, 0.0f, 8.0f, 1.0f, 8.0f, (int)(255.0 * ((nb - partialTick) / 130.0)) << 24 | 0xFF0000 | 0xFF00 | 0xFF);
                                BossesVFXProcedure.release();
                                continue;
                            }
                            if (entityiterator instanceof SoulAreaEntity) {
                                int n14;
                                int n15;
                                int n16;
                                if (entityiterator instanceof SoulAreaEntity) {
                                    _datEntI3 = (SoulAreaEntity)entityiterator;
                                    n16 = (Integer)_datEntI3.getEntityData().get(SoulAreaEntity.DATA_living_time);
                                } else {
                                    n16 = 0;
                                }
                                if (n16 <= 0) continue;
                                if (entityiterator instanceof SoulAreaEntity) {
                                    _datEntI2 = (SoulAreaEntity)entityiterator;
                                    v7 = ((Integer)_datEntI2.getEntityData().get(SoulAreaEntity.DATA_living_time)).intValue();
                                } else {
                                    v7 = nb = 0.0;
                                }
                                if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                                    BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                                    BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                                    BossesVFXProcedure.end();
                                }
                                if (BossesVFXProcedure.target(2)) {
                                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/soul_area.png"));
                                    BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x(), entityiterator.getPosition((float)partialTick).y() + 0.05, entityiterator.getPosition((float)partialTick).z(), entityiterator.getViewYRot((float)partialTick), 0.0f, 0.0f, 8.0f, 1.0f, 18.74f, (int)(255.0 * ((nb - partialTick) / 40.0)) << 24 | 0xFF0000 | 0xFF00 | 0xFF);
                                    BossesVFXProcedure.release();
                                }
                                if (entityiterator instanceof SoulAreaEntity) {
                                    _datEntI2 = (SoulAreaEntity)entityiterator;
                                    n15 = (Integer)_datEntI2.getEntityData().get(SoulAreaEntity.DATA_living_time);
                                } else {
                                    n15 = 0;
                                }
                                if (n15 <= 30) continue;
                                if (entityiterator instanceof SoulAreaEntity) {
                                    SoulAreaEntity _datEntI4 = (SoulAreaEntity)entityiterator;
                                    n14 = (Integer)_datEntI4.getEntityData().get(SoulAreaEntity.DATA_living_time);
                                } else {
                                    n14 = 0;
                                }
                                nb = n14 - 30;
                                if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, true)) {
                                    for (int index3 = 0; index3 < 90; ++index3) {
                                        for (int index4 = 0; index4 < 45; ++index4) {
                                            k = 255.0 - j / 180.0 * 95.0;
                                            l = 255.0 - (j + 4.0) / 180.0 * 95.0;
                                            BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), -1);
                                            BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), -1);
                                            BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), -1);
                                            BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), -1);
                                            j += 4.0;
                                        }
                                        j = 0.0;
                                        i += 4.0;
                                    }
                                    i = 0.0;
                                    BossesVFXProcedure.end();
                                }
                                if (!BossesVFXProcedure.target(2)) continue;
                                lcl_color = 0.0;
                                lcl_scale = 0.5;
                                lcl_alpha = 61.0;
                                for (int index5 = 0; index5 < 15; ++index5) {
                                    BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x(), entityiterator.getPosition((float)partialTick).y(), entityiterator.getPosition((float)partialTick).z(), 0.0f, 0.0f, 0.0f, (float)((nb - partialTick) / 10.0 * lcl_scale), (float)((nb - partialTick) / 10.0 * lcl_scale), (float)((nb - partialTick) / 10.0 * lcl_scale), (int)lcl_alpha << 24 | (int)(25.0 * (lcl_color / 15.0) + 255.0 * (1.0 - lcl_color / 15.0)) << 16 | (int)(236.0 * (lcl_color / 15.0) + 255.0 * (1.0 - lcl_color / 15.0)) << 8 | (int)(255.0 * (lcl_color / 15.0) + 255.0 * (1.0 - lcl_color / 15.0)));
                                    lcl_color += 1.0;
                                    lcl_alpha -= 4.0;
                                    lcl_scale += 1.2;
                                }
                                BossesVFXProcedure.release();
                                continue;
                            }
                            if (entityiterator instanceof SoulShockwaveEntity) {
                                if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                                    BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                                    BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                                    BossesVFXProcedure.end();
                                }
                                if (!BossesVFXProcedure.target(2)) continue;
                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/soul_shockwave.png"));
                                BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x(), entityiterator.getPosition((float)partialTick).y(), entityiterator.getPosition((float)partialTick).z(), entityiterator.getViewYRot((float)partialTick) + 180.0f, 90.0f, 0.0f, 6.0f, 1.0f, 6.0f, -1);
                                BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x(), entityiterator.getPosition((float)partialTick).y(), entityiterator.getPosition((float)partialTick).z(), entityiterator.getViewYRot((float)partialTick), 90.0f, 0.0f, 6.0f, 1.0f, 6.0f, -1);
                                BossesVFXProcedure.release();
                                continue;
                            }
                            if (entityiterator instanceof SwordWaveEntity) {
                                if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                                    BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                                    BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                                    BossesVFXProcedure.end();
                                }
                                if (!BossesVFXProcedure.target(2)) continue;
                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/soul_shockwave.png"));
                                if (entityiterator instanceof AbstractArrow) {
                                    AbstractArrow arr = (AbstractArrow)entityiterator;
                                    BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x(), entityiterator.getPosition((float)partialTick).y(), entityiterator.getPosition((float)partialTick).z(), -arr.getYRot(), -arr.getXRot(), 0.0f, 6.0f, 1.0f, 6.0f, -1);
                                }
                                BossesVFXProcedure.release();
                                continue;
                            }
                            if (entityiterator instanceof UnderworldKnightEntity) {
                                int n17;
                                int n18;
                                int n19;
                                int n20;
                                if (entityiterator instanceof UnderworldKnightEntity) {
                                    _datEntI3 = (UnderworldKnightEntity)entityiterator;
                                    n20 = (Integer)_datEntI3.getEntityData().get(UnderworldKnightEntity.DATA_attack_phase);
                                } else {
                                    n20 = 0;
                                }
                                if (n20 != 0) continue;
                                if (entityiterator instanceof UnderworldKnightEntity) {
                                    _datEntI2 = (UnderworldKnightEntity)entityiterator;
                                    n19 = (Integer)_datEntI2.getEntityData().get(UnderworldKnightEntity.DATA_attack_animtime);
                                } else {
                                    n19 = 0;
                                }
                                if (n19 <= 10) continue;
                                if (entityiterator instanceof UnderworldKnightEntity) {
                                    UnderworldKnightEntity _datEntI5 = (UnderworldKnightEntity)entityiterator;
                                    n18 = (Integer)_datEntI5.getEntityData().get(UnderworldKnightEntity.DATA_attack_animtime);
                                } else {
                                    n18 = 0;
                                }
                                if (n18 > 30) continue;
                                if (entityiterator instanceof UnderworldKnightEntity) {
                                    _datEntI = (UnderworldKnightEntity)entityiterator;
                                    n17 = (Integer)_datEntI.getEntityData().get(UnderworldKnightEntity.DATA_attack_animtime);
                                } else {
                                    n17 = 0;
                                }
                                nb = n17 - 10;
                                if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                                    BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                                    BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                                    BossesVFXProcedure.end();
                                }
                                if (!BossesVFXProcedure.target(2)) continue;
                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/impact.png"));
                                BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x() + entityiterator.getViewVector((float)partialTick).x() * 4.0, entityiterator.getPosition((float)partialTick).y() + 0.05, entityiterator.getPosition((float)partialTick).z() + entityiterator.getViewVector((float)partialTick).z() * 4.0, 0.0f, 0.0f, 0.0f, (float)(4.0 + 14.0 * (1.0 - (nb - partialTick) / 21.0)), 1.0f, (float)(4.0 + 14.0 * (1.0 - (nb - partialTick) / 21.0)), (int)(255.0 * ((nb - partialTick) / 21.0)) << 24 | 0xBC0000 | 0xFF00 | 0xFA);
                                BossesVFXProcedure.release();
                                continue;
                            }
                            if (entityiterator instanceof InfernalDragonEntity) {
                                int n21;
                                int n22;
                                int n23;
                                int n24;
                                if (entityiterator instanceof InfernalDragonEntity) {
                                    _datEntI3 = (InfernalDragonEntity)entityiterator;
                                    n24 = (Integer)_datEntI3.getEntityData().get(InfernalDragonEntity.DATA_attack_phase);
                                } else {
                                    n24 = 0;
                                }
                                if (n24 != 0) continue;
                                if (entityiterator instanceof InfernalDragonEntity) {
                                    _datEntI2 = (InfernalDragonEntity)entityiterator;
                                    n23 = (Integer)_datEntI2.getEntityData().get(InfernalDragonEntity.DATA_attack_animtime);
                                } else {
                                    n23 = 0;
                                }
                                if (n23 <= 10) continue;
                                if (entityiterator instanceof InfernalDragonEntity) {
                                    InfernalDragonEntity _datEntI6 = (InfernalDragonEntity)entityiterator;
                                    n22 = (Integer)_datEntI6.getEntityData().get(InfernalDragonEntity.DATA_attack_animtime);
                                } else {
                                    n22 = 0;
                                }
                                if (n22 > 21) continue;
                                if (entityiterator instanceof InfernalDragonEntity) {
                                    _datEntI = (InfernalDragonEntity)entityiterator;
                                    n21 = (Integer)_datEntI.getEntityData().get(InfernalDragonEntity.DATA_attack_animtime);
                                } else {
                                    n21 = 0;
                                }
                                nb = n21 - 10;
                                if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                                    BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                                    BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                                    BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                                    BossesVFXProcedure.end();
                                }
                                if (!BossesVFXProcedure.target(2)) continue;
                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/shockwave.png"));
                                BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x() + entityiterator.getViewVector((float)partialTick).x() * 4.0, entityiterator.getPosition((float)partialTick).y() + 0.05, entityiterator.getPosition((float)partialTick).z() + entityiterator.getViewVector((float)partialTick).z() * 4.0, 0.0f, 0.0f, 0.0f, (float)(4.0 + 14.0 * (1.0 - (nb - partialTick) / 11.0)), 1.0f, (float)(4.0 + 14.0 * (1.0 - (nb - partialTick) / 11.0)), (int)(255.0 * ((nb - partialTick) / 11.0)) << 24 | 0xFE0000 | 0x8A00 | 0x5C);
                                BossesVFXProcedure.release();
                                continue;
                            }
                            if (!(entityiterator instanceof YetiEntity)) continue;
                            if (entityiterator instanceof YetiEntity) {
                                _datEntI3 = (YetiEntity)entityiterator;
                                n9 = (Integer)_datEntI3.getEntityData().get(YetiEntity.DATA_attack_phase);
                            } else {
                                n9 = 0;
                            }
                            if (n9 != 2) break block148;
                            if (entityiterator instanceof YetiEntity) {
                                _datEntI2 = (YetiEntity)entityiterator;
                                n8 = (Integer)_datEntI2.getEntityData().get(YetiEntity.DATA_attack_animtime);
                            } else {
                                n8 = 0;
                            }
                            if (n8 <= 0) break block148;
                            if (entityiterator instanceof YetiEntity) {
                                YetiEntity _datEntI7 = (YetiEntity)entityiterator;
                                n7 = (Integer)_datEntI7.getEntityData().get(YetiEntity.DATA_attack_animtime);
                            } else {
                                n7 = 0;
                            }
                            if (n7 < 20) break block149;
                        }
                        if (entityiterator instanceof YetiEntity) {
                            _datEntI = (YetiEntity)entityiterator;
                            n6 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_leap_animtime);
                        } else {
                            n6 = 0;
                        }
                        if (n6 <= 0) break block150;
                        if (entityiterator instanceof YetiEntity) {
                            YetiEntity _datEntI8 = (YetiEntity)entityiterator;
                            n5 = (Integer)_datEntI8.getEntityData().get(YetiEntity.DATA_leap_animtime);
                        } else {
                            n5 = 0;
                        }
                        if (n5 >= 20) break block150;
                    }
                    if (entityiterator instanceof YetiEntity) {
                        YetiEntity _datEntI = (YetiEntity)entityiterator;
                        n4 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_leap_animtime);
                    } else {
                        n4 = 0;
                    }
                    if (n4 > 0) {
                        double d;
                        if (entityiterator instanceof YetiEntity) {
                            _datEntI = (YetiEntity)entityiterator;
                            d = ((Integer)_datEntI.getEntityData().get(YetiEntity.DATA_leap_animtime)).intValue();
                        } else {
                            d = 0.0;
                        }
                        nb = d;
                    } else if (entityiterator instanceof YetiEntity) {
                        _datEntI = (YetiEntity)entityiterator;
                        v25 = ((Integer)_datEntI.getEntityData().get(YetiEntity.DATA_attack_animtime)).intValue();
                    } else {
                        v25 = nb = 0.0;
                    }
                    if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                        BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                        BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                        BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                        BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                        BossesVFXProcedure.end();
                    }
                    if (!BossesVFXProcedure.target(2)) continue;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/shockwave.png"));
                    BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x() + entityiterator.getViewVector((float)partialTick).x() * 4.0, entityiterator.getPosition((float)partialTick).y() + 0.05, entityiterator.getPosition((float)partialTick).z() + entityiterator.getViewVector((float)partialTick).z() * 4.0, 0.0f, 0.0f, 0.0f, (float)(6.0 + 16.0 * (1.0 - (nb - partialTick) / 19.0)), 1.0f, (float)(6.0 + 16.0 * (1.0 - (nb - partialTick) / 19.0)), (int)(255.0 * ((nb - partialTick) / 19.0)) << 24 | 0x730000 | 0xE900 | 0xFF);
                    BossesVFXProcedure.release();
                    continue;
                }
                if (entityiterator instanceof YetiEntity) {
                    YetiEntity _datEntI = (YetiEntity)entityiterator;
                    n3 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_attack_phase);
                } else {
                    n3 = 0;
                }
                if (n3 == 3) {
                    int n25;
                    if (entityiterator instanceof YetiEntity) {
                        YetiEntity _datEntI = (YetiEntity)entityiterator;
                        n25 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_attack_animtime);
                    } else {
                        n25 = 0;
                    }
                    if (n25 > 0) {
                        int n26;
                        if (entityiterator instanceof YetiEntity) {
                            YetiEntity _datEntI = (YetiEntity)entityiterator;
                            n26 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_attack_animtime);
                        } else {
                            n26 = 0;
                        }
                        if (n26 < 19) {
                            int n27;
                            int n28;
                            int n29;
                            if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                                BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                                BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                                BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                                BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                                BossesVFXProcedure.end();
                            }
                            if (!BossesVFXProcedure.target(2)) continue;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/shockwave.png"));
                            VertexBuffer vertexBuffer = BossesVFXProcedure.shape();
                            double d = entityiterator.getPosition((float)partialTick).x() + entityiterator.getViewVector((float)partialTick).x() * 4.0;
                            double d2 = entityiterator.getPosition((float)partialTick).y() + 0.05;
                            double d3 = entityiterator.getPosition((float)partialTick).z() + entityiterator.getViewVector((float)partialTick).z() * 4.0;
                            if (entityiterator instanceof YetiEntity) {
                                YetiEntity _datEntI = (YetiEntity)entityiterator;
                                n29 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_attack_animtime);
                            } else {
                                n29 = 0;
                            }
                            float f = (float)(6.0 + 20.0 * (1.0 - ((double)n29 - partialTick) / 18.0));
                            if (entityiterator instanceof YetiEntity) {
                                YetiEntity _datEntI = (YetiEntity)entityiterator;
                                n28 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_attack_animtime);
                            } else {
                                n28 = 0;
                            }
                            float f2 = (float)(6.0 + 20.0 * (1.0 - ((double)n28 - partialTick) / 18.0));
                            if (entityiterator instanceof YetiEntity) {
                                YetiEntity _datEntI = (YetiEntity)entityiterator;
                                n27 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_attack_animtime);
                            } else {
                                n27 = 0;
                            }
                            BossesVFXProcedure.renderShape(vertexBuffer, d, d2, d3, 0.0f, 0.0f, 0.0f, f, 1.0f, f2, (int)(255.0 * (((double)n27 - partialTick) / 18.0)) << 24 | 0x730000 | 0xE900 | 0xFF);
                            BossesVFXProcedure.release();
                            continue;
                        }
                    }
                }
                if (entityiterator instanceof YetiEntity) {
                    YetiEntity _datEntI = (YetiEntity)entityiterator;
                    n2 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_spawn_animtime);
                } else {
                    n2 = 0;
                }
                if (n2 > 20) {
                    int n30;
                    if (entityiterator instanceof YetiEntity) {
                        YetiEntity _datEntI = (YetiEntity)entityiterator;
                        n30 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_spawn_animtime);
                    } else {
                        n30 = 0;
                    }
                    if (n30 < 59) {
                        int n31;
                        if (entityiterator instanceof YetiEntity) {
                            YetiEntity _datEntI = (YetiEntity)entityiterator;
                            n31 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_spawn_animtime);
                        } else {
                            n31 = 0;
                        }
                        nb = n31 - 20;
                        if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                            BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                            BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                            BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                            BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                            BossesVFXProcedure.end();
                        }
                        if (!BossesVFXProcedure.target(2)) continue;
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/shockwave.png"));
                        BossesVFXProcedure.renderShape(BossesVFXProcedure.shape(), entityiterator.getPosition((float)partialTick).x(), entityiterator.getPosition((float)partialTick).y() + 0.05, entityiterator.getPosition((float)partialTick).z(), 0.0f, 0.0f, 0.0f, (float)(4.0 + 16.0 * (1.0 - (nb - partialTick) / 38.0)), 1.0f, (float)(4.0 + 16.0 * (1.0 - (nb - partialTick) / 38.0)), (int)(255.0 * ((nb - partialTick) / 38.0)) << 24 | 0x730000 | 0xE900 | 0xFF);
                        BossesVFXProcedure.release();
                        continue;
                    }
                }
                if (entityiterator instanceof YetiEntity) {
                    YetiEntity _datEntI = (YetiEntity)entityiterator;
                    n = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                } else {
                    n = 0;
                }
                if (n <= 0) continue;
                nb = 0.0;
                nx = 0.0;
                ny = 0.0;
                nz = 0.0;
                for (int index6 = 0; index6 < 4; ++index6) {
                    if (nb == 0.0) {
                        nx = 0.3;
                        ny = 0.1;
                        nz = -0.3;
                    } else if (nb == 1.0) {
                        nx = -0.4;
                        ny = -0.1;
                        nz = -0.2;
                    } else if (nb == 2.0) {
                        nx = -0.1;
                        ny = 0.08;
                        nz = 0.4;
                    } else {
                        nx = 0.6;
                        ny = -0.08;
                        nz = 0.3;
                    }
                    nb += 1.0;
                    i = 0.0;
                    j = 0.0;
                    if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
                        BossesVFXProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
                        BossesVFXProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
                        BossesVFXProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
                        BossesVFXProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
                        BossesVFXProcedure.end();
                    }
                    if (BossesVFXProcedure.target(2)) {
                        int n32;
                        int n33;
                        int n34;
                        int n35;
                        int n36;
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"block_factorys_bosses:textures/particle/magic_dot.png"));
                        VertexBuffer vertexBuffer = BossesVFXProcedure.shape();
                        double d = entityiterator.getPosition((float)partialTick).x();
                        if (entityiterator instanceof YetiEntity) {
                            YetiEntity _datEntI = (YetiEntity)entityiterator;
                            n36 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n36 = 0;
                        }
                        double d4 = d + nx * (((double)(26 - n36) + partialTick) / 26.0) * 16.0;
                        double d5 = entityiterator.getPosition((float)partialTick).y() + 3.0;
                        if (entityiterator instanceof YetiEntity) {
                            YetiEntity _datEntI = (YetiEntity)entityiterator;
                            n35 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n35 = 0;
                        }
                        double d6 = d5 + ny * (((double)(26 - n35) + partialTick) / 26.0) * 16.0;
                        double d7 = entityiterator.getPosition((float)partialTick).z();
                        if (entityiterator instanceof YetiEntity) {
                            YetiEntity _datEntI = (YetiEntity)entityiterator;
                            n34 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n34 = 0;
                        }
                        double d8 = d7 + nz * (((double)(26 - n34) + partialTick) / 26.0) * 16.0;
                        float f = Minecraft.getInstance().gameRenderer.getMainCamera().getYRot() + 180.0f;
                        float f3 = Minecraft.getInstance().gameRenderer.getMainCamera().getXRot() * -1.0f + 90.0f;
                        if (entityiterator instanceof YetiEntity) {
                            YetiEntity _datEntI = (YetiEntity)entityiterator;
                            n33 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n33 = 0;
                        }
                        float f4 = (float)(((double)n33 - partialTick) / 12.0 * 2.0);
                        if (entityiterator instanceof YetiEntity) {
                            YetiEntity _datEntI = (YetiEntity)entityiterator;
                            n32 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n32 = 0;
                        }
                        BossesVFXProcedure.renderShape(vertexBuffer, d4, d6, d8, f, f3, 0.0f, f4, 1.0f, (float)(((double)n32 - partialTick) / 12.0 * 2.0), -1);
                        BossesVFXProcedure.release();
                    }
                    if (BossesVFXProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, true)) {
                        for (int index7 = 0; index7 < 90; ++index7) {
                            for (int index8 = 0; index8 < 45; ++index8) {
                                k = 255.0 - j / 180.0 * 95.0;
                                l = 255.0 - (j + 4.0) / 180.0 * 95.0;
                                BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), -1);
                                BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), -1);
                                BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), -1);
                                BossesVFXProcedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), -1);
                                j += 4.0;
                            }
                            j = 0.0;
                            i += 4.0;
                        }
                        i = 0.0;
                        BossesVFXProcedure.end();
                    }
                    if (!BossesVFXProcedure.target(2)) continue;
                    lcl_color = 0.0;
                    lcl_scale = 0.1;
                    lcl_alpha = 30.0;
                    for (int index9 = 0; index9 < 6; ++index9) {
                        int n37;
                        int n38;
                        int n39;
                        int n40;
                        int n41;
                        int n42;
                        YetiEntity _datEntI;
                        VertexBuffer vertexBuffer = BossesVFXProcedure.shape();
                        double d = entityiterator.getPosition((float)partialTick).x();
                        if (entityiterator instanceof YetiEntity) {
                            _datEntI = (YetiEntity)entityiterator;
                            n42 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n42 = 0;
                        }
                        double d9 = d + nx * (((double)(26 - n42) + partialTick) / 26.0) * 16.0;
                        double d10 = entityiterator.getPosition((float)partialTick).y() + 3.0;
                        if (entityiterator instanceof YetiEntity) {
                            _datEntI = (YetiEntity)entityiterator;
                            n41 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n41 = 0;
                        }
                        double d11 = d10 + ny * (((double)(26 - n41) + partialTick) / 26.0) * 16.0;
                        double d12 = entityiterator.getPosition((float)partialTick).z();
                        if (entityiterator instanceof YetiEntity) {
                            _datEntI = (YetiEntity)entityiterator;
                            n40 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n40 = 0;
                        }
                        double d13 = d12 + nz * (((double)(26 - n40) + partialTick) / 26.0) * 16.0;
                        if (entityiterator instanceof YetiEntity) {
                            _datEntI = (YetiEntity)entityiterator;
                            n39 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n39 = 0;
                        }
                        float f = (float)(((double)n39 - partialTick) / 12.0 * lcl_scale);
                        if (entityiterator instanceof YetiEntity) {
                            _datEntI = (YetiEntity)entityiterator;
                            n38 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n38 = 0;
                        }
                        float f5 = (float)(((double)n38 - partialTick) / 12.0 * lcl_scale);
                        if (entityiterator instanceof YetiEntity) {
                            _datEntI = (YetiEntity)entityiterator;
                            n37 = (Integer)_datEntI.getEntityData().get(YetiEntity.DATA_hit_animtime);
                        } else {
                            n37 = 0;
                        }
                        BossesVFXProcedure.renderShape(vertexBuffer, d9, d11, d13, 0.0f, 0.0f, 0.0f, f, f5, (float)(((double)n37 - partialTick) / 12.0 * lcl_scale), (int)lcl_alpha << 24 | (int)(0.0 * (lcl_color / 6.0) + 255.0 * (1.0 - lcl_color / 6.0)) << 16 | (int)(150.0 * (lcl_color / 6.0) + 255.0 * (1.0 - lcl_color / 6.0)) << 8 | (int)(255.0 * (lcl_color / 6.0) + 255.0 * (1.0 - lcl_color / 6.0)));
                        lcl_color += 1.0;
                        lcl_alpha -= 5.0;
                        lcl_scale += 0.3;
                    }
                    BossesVFXProcedure.release();
                }
            }
        }
    }
}

