/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.unusual.blockfactorysbosses.entity.InfernalDragonEntity;

public class DragonMoveControl
extends MoveControl {
    private float additionalRot;
    private final int maxTurn;
    private final boolean hoversInPlace;

    public DragonMoveControl(Mob mob, int p_24894_, boolean p_24895_) {
        super(mob);
        this.maxTurn = p_24894_;
        this.hoversInPlace = p_24895_;
    }

    public void tick() {
        if ((Integer)this.mob.getEntityData().get(InfernalDragonEntity.DATA_boss_phase) == -1 || (Integer)this.mob.getEntityData().get(InfernalDragonEntity.DATA_boss_phase) == 2) {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                this.operation = MoveControl.Operation.WAIT;
                this.mob.setNoGravity(true);
                double d0 = this.wantedX - this.mob.getX();
                double d1 = this.wantedY - this.mob.getY();
                double d2 = this.wantedZ - this.mob.getZ();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setYya(0.0f);
                    this.mob.setZza(0.0f);
                    return;
                }
                float f = (float)(Mth.atan2((double)d2, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f;
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f, 90.0f));
                float f1 = this.mob.onGround() ? (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)) : (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED));
                this.mob.setSpeed(f1);
                double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                    float f2 = (float)(-(Mth.atan2((double)d1, (double)d4) * 180.0 / 3.1415927410125732));
                    this.mob.setXRot(this.rotlerp(this.mob.getXRot(), f2, this.maxTurn));
                    this.mob.setYya(d1 > 0.0 ? f1 : -f1);
                }
            } else {
                if (!this.hoversInPlace) {
                    this.mob.setNoGravity(false);
                }
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
            }
        } else if (this.operation == MoveControl.Operation.STRAFE) {
            float f8;
            float f = (float)this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
            float f1 = (float)this.speedModifier * f;
            float f2 = this.strafeForwards;
            float f3 = this.strafeRight;
            float f4 = Mth.sqrt((float)(f2 * f2 + f3 * f3));
            if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            f4 = f1 / f4;
            float f5 = Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            float f6 = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
            if (!this.isWalkable(f7, f8 = f3 * f6 + f2 * f5)) {
                this.strafeForwards = 1.0f;
                this.strafeRight = 0.0f;
            }
            this.mob.setSpeed(f1);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
            this.operation = MoveControl.Operation.WAIT;
        } else if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.operation = MoveControl.Operation.WAIT;
            double d0 = this.wantedX - this.mob.getX();
            double d1 = this.wantedZ - this.mob.getZ();
            double d2 = this.wantedY - this.mob.getY();
            double d3 = d0 * d0 + d2 * d2 + d1 * d1;
            if (d3 < 2.500000277905201E-7) {
                this.mob.setZza(0.0f);
                if (this.additionalRot > 0.0f) {
                    this.additionalRot -= 0.03f;
                }
                return;
            }
            float f9 = (float)(Mth.atan2((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
            if (this.additionalRot < 1.0f) {
                this.additionalRot += 0.1f;
            }
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f9, 5.0f + this.additionalRot * 5.0f));
            this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            BlockPos blockpos = this.mob.blockPosition();
            BlockState blockstate = this.mob.level().getBlockState(blockpos);
            VoxelShape voxelshape = blockstate.getCollisionShape((BlockGetter)this.mob.level(), blockpos);
            if (d2 > (double)this.mob.maxUpStep() && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.mob.getBbWidth()) || !voxelshape.isEmpty() && this.mob.getY() < voxelshape.max(Direction.Axis.Y) + (double)blockpos.getY() && !blockstate.is(BlockTags.DOORS) && !blockstate.is(BlockTags.FENCES)) {
                this.mob.getJumpControl().jump();
                this.operation = MoveControl.Operation.JUMPING;
            }
        } else if (this.operation == MoveControl.Operation.JUMPING) {
            this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            if (this.mob.onGround()) {
                this.operation = MoveControl.Operation.WAIT;
            }
        } else {
            this.mob.setZza(0.0f);
            if (this.additionalRot > 0.0f) {
                this.additionalRot -= 0.03f;
            }
        }
    }

    private boolean isWalkable(float dx, float dz) {
        NodeEvaluator evaluator;
        PathNavigation navigation = this.mob.getNavigation();
        if (navigation != null && (evaluator = navigation.getNodeEvaluator()) != null) {
            BlockPos pos = new BlockPos(Mth.floor((double)(this.mob.getX() + (double)dx)), this.mob.getBlockY(), Mth.floor((double)(this.mob.getZ() + (double)dz)));
            PathType type = evaluator.getPathType(this.mob, pos);
            return type == PathType.WALKABLE;
        }
        return true;
    }
}

