/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.block;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.unusual.blockfactorysbosses.procedures.SoulFlamesTallCandlesProcedure;
import net.unusual.blockfactorysbosses.procedures.TallCandleBlockAddedProcedure;
import net.unusual.blockfactorysbosses.procedures.TallCandlePlacementConditionProcedure;
import net.unusual.blockfactorysbosses.procedures.TallUnderworldCandleDestroyedProcedure;

public class UnderworldTallCandlesBlock
extends Block {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)4);

    public UnderworldTallCandlesBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(1.0f, 10.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 9;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 2) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 3) {
                    return 9;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 4) {
                    return 9;
                }
                return 10;
            }
        }.getLightLevel()).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.block_factorys_bosses.underworld_tall_candles.description_0"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return UnderworldTallCandlesBlock.box((double)3.0, (double)-16.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 3) {
            return UnderworldTallCandlesBlock.box((double)3.0, (double)-16.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        }
        return UnderworldTallCandlesBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)32.0, (double)13.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BLOCKSTATE});
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return TallCandlePlacementConditionProcedure.execute(world, x, y, z, blockstate);
        }
        return super.canSurvive(blockstate, worldIn, pos);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        TallCandleBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(blockstate, world, pos, random);
        LocalPlayer entity = Minecraft.getInstance().player;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        SoulFlamesTallCandlesProcedure.execute((LevelAccessor)world, x, y, z, blockstate);
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        TallUnderworldCandleDestroyedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity);
        return retval;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState blockstate, LivingEntity entity, ItemStack itemstack) {
        super.setPlacedBy(world, pos, blockstate, entity, itemstack);
        TallCandleBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
    }
}

