/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.items.handheld_drill;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.lopyluna.dndesires.content.items.IOnBlockBreak;
import dev.lopyluna.dndesires.content.items.handheld_drill.HandheldDrillRenderer;
import dev.lopyluna.dndesires.register.DesiresItems;
import dev.lopyluna.dndesires.register.DesiresTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class HandheldDrillItem
extends DiggerItem
implements CustomArmPoseItem,
IOnBlockBreak {
    private static boolean mining = false;

    public HandheldDrillItem(Tier tier, Item.Properties properties) {
        super(tier, DesiresTags.BlockTags.MINEABLE_WITH_DRILL.tag, properties);
    }

    @Override
    public void onBlockBreak(ItemStack pStack, LevelAccessor pAccessor, BlockPos pPos, BlockState pState, Player pBreaker) {
        boolean flag;
        if (!DesiresItems.HANDHELD_DRILL.isIn(pStack) || !(pAccessor instanceof Level)) {
            return;
        }
        Level pLevel = (Level)pAccessor;
        if (mining || !this.isValidMine(pState)) {
            return;
        }
        boolean bl = flag = !(pBreaker instanceof FakePlayer);
        boolean playerHeldKey = flag ? !pBreaker.getPersistentData().getBoolean("HandheldDrillKey") : false;
        if (playerHeldKey) {
            return;
        }
        boolean veins = pState.is(DesiresTags.BlockTags.EXCAVATION_DRILL_VEIN_VALID.tag);
        Vec3 vec = pBreaker.getLookAngle();
        mining = true;
        if (veins) {
            VeinMining.findVein((BlockGetter)pLevel, pPos, DesiresTags.BlockTags.EXCAVATION_DRILL_VEIN_VALID.tag, pState.is(DesiresTags.BlockTags.EXCAVATION_DRILL_VEIN_LARGE.tag) ? 32 : 12).destroyBlocks(pLevel, (LivingEntity)pBreaker, (dropPos, item) -> HandheldDrillItem.dropItemFromExcavatedVein(pLevel, pPos, vec, dropPos, item));
        } else if (pBreaker instanceof ServerPlayer) {
            ServerPlayer pSPlayer = (ServerPlayer)pBreaker;
            BoreMining.findBore(1, pPos, pSPlayer).destroyBlocks(pLevel, (LivingEntity)pBreaker, (dropPos, item) -> HandheldDrillItem.dropItemFromExcavatedVein(pLevel, pPos, vec, dropPos, item));
        }
        mining = false;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!BacktankUtil.canAbsorbDamage((LivingEntity)attacker, (int)(HandheldDrillItem.maxUses() * 2))) {
            stack.hurtAndBreak(2, attacker, EquipmentSlot.MAINHAND);
        }
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        if (tool != null) {
            if (!BacktankUtil.canAbsorbDamage((LivingEntity)miningEntity, (int)(HandheldDrillItem.maxUses() * 2)) && !level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f && tool.damagePerBlock() > 0) {
                stack.hurtAndBreak(tool.damagePerBlock(), miningEntity, EquipmentSlot.MAINHAND);
            }
            return true;
        }
        return false;
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return state.is(DesiresTags.BlockTags.MINEABLE_WITH_DRILL.tag) || !state.requiresCorrectToolForDrops() || state.canBeReplaced();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.getItem() != oldStack.getItem();
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)HandheldDrillItem.maxUses());
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)HandheldDrillItem.maxUses());
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)HandheldDrillItem.maxUses());
    }

    private static int maxUses() {
        return (Integer)AllConfigs.server().equipment.maxPotatoCannonShots.get();
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return true;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.swinging) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new HandheldDrillRenderer()));
    }

    public boolean isValidMine(BlockState pState) {
        return pState.is(DesiresTags.BlockTags.EXCAVATION_DRILL_VEIN_VALID.tag) || pState.is(BlockTags.MINEABLE_WITH_PICKAXE);
    }

    public static void dropItemFromExcavatedVein(Level world, BlockPos breakingPos, Vec3 fallDirection, BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.distSqr((Vec3i)breakingPos));
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(world, dropPos.x, dropPos.y, dropPos.z, stack);
        entity.setDeltaMovement(fallDirection.scale((double)(distance / 16.0f)));
        world.addFreshEntity((Entity)entity);
    }

    public static class VeinMining {
        public static final Vein NO_VEIN = new Vein(Collections.emptyList());

        @Nonnull
        public static Vein findVein(@Nullable BlockGetter reader, BlockPos startPos, TagKey<Block> filterTag, int maxBlocks) {
            if (reader == null) {
                return NO_VEIN;
            }
            ArrayList<BlockPos> matchingBlocks = new ArrayList<BlockPos>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
            frontier.add(startPos);
            visited.add(startPos);
            while (!frontier.isEmpty() && matchingBlocks.size() < maxBlocks) {
                BlockState currentState;
                BlockPos currentPos = (BlockPos)frontier.poll();
                if (currentPos == null || !(currentState = reader.getBlockState(currentPos)).is(filterTag) || !((Level)reader).getWorldBorder().isWithinBounds(currentPos)) continue;
                matchingBlocks.add(currentPos);
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            BlockState adjacentState;
                            BlockPos adjacentPos;
                            if (dx == 0 && dy == 0 && dz == 0 || visited.contains(adjacentPos = currentPos.offset(dx, dy, dz)) || !(adjacentState = reader.getBlockState(adjacentPos)).is(filterTag)) continue;
                            visited.add(adjacentPos);
                            frontier.add(adjacentPos);
                        }
                    }
                }
            }
            return new Vein(matchingBlocks);
        }

        public static class Vein
        extends AbstractBlockBreakQueue {
            private final List<BlockPos> ores;

            public Vein(List<BlockPos> ores) {
                this.ores = ores;
            }

            public void destroyBlocks(Level world, ItemStack tool, @Nullable Player player, BiConsumer<BlockPos, ItemStack> dropConsumer) {
                if (player == null) {
                    return;
                }
                this.ores.forEach(this.makeCallbackFor(world, 0.5f, tool, player, dropConsumer));
                player.causeFoodExhaustion((float)this.ores.size() * 0.5f);
            }

            protected Consumer<BlockPos> makeCallbackFor(Level level, float effectChance, ItemStack toDamage, @Nullable Player player, BiConsumer<BlockPos, ItemStack> drop) {
                return pos -> {
                    ItemStack usedTool = toDamage.copy();
                    BlockHelper.destroyBlockAs((Level)level, (BlockPos)pos, (Player)player, (ItemStack)toDamage, (float)effectChance, stack -> drop.accept((BlockPos)pos, (ItemStack)stack));
                    if (player != null && toDamage.isEmpty() && !usedTool.isEmpty()) {
                        EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)usedTool, (InteractionHand)InteractionHand.MAIN_HAND);
                    }
                };
            }
        }
    }

    public static class BoreMining {
        public static VeinMining.Vein findBore(int range, BlockPos initalBlockPos, ServerPlayer player) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            Level level = player.level();
            BlockHitResult traceResult = level.clip(new ClipContext(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(player.getViewVector(1.0f).scale(6.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            if (traceResult.getType() == HitResult.Type.MISS) {
                return VeinMining.NO_VEIN;
            }
            Direction.Axis axis = traceResult.getDirection().getAxis();
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    BlockPos pos2 = BoreMining.expandPos(x, y, axis, initalBlockPos);
                    if (!level.getWorldBorder().isWithinBounds(pos2)) continue;
                    positions.add(pos2);
                }
            }
            return new VeinMining.Vein(positions.stream().filter(pos -> {
                if (pos == initalBlockPos || !level.isLoaded(pos)) {
                    return false;
                }
                BlockState state = level.getBlockState(pos);
                return !state.isAir() && state.getDestroySpeed((BlockGetter)level, pos) != -1.0f;
            }).toList());
        }

        public static BlockPos expandPos(int x, int y, Direction.Axis axis, BlockPos initalBlockPos) {
            return switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> new BlockPos(initalBlockPos.getX(), initalBlockPos.getY() + y, initalBlockPos.getZ() + x);
                case Direction.Axis.Y -> new BlockPos(initalBlockPos.getX() + x, initalBlockPos.getY(), initalBlockPos.getZ() + y);
                case Direction.Axis.Z -> new BlockPos(initalBlockPos.getX() + x, initalBlockPos.getY() + y, initalBlockPos.getZ());
            };
        }
    }
}

